/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors.directedit;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.vm.AutoBeanFactorySource;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.shared.I_CmsAutoBeanFactory;
import org.opencms.gwt.shared.I_CmsContentLoadCollectorInfo;
import org.opencms.gwt.shared.I_CmsEditableDataExtensions;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.editors.Messages;
import org.opencms.workplace.editors.directedit.A_CmsDirectEditProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.editors.directedit.CmsDirectEditParams;
import org.opencms.workplace.editors.directedit.CmsDirectEditPermissions;
import org.opencms.workplace.editors.directedit.CmsDirectEditResourceInfo;
import org.opencms.workplace.editors.directedit.I_CmsDirectEditProvider;
import org.opencms.xml.containerpage.CmsContainerElementBean;

public class CmsAdvancedDirectEditProvider
extends A_CmsDirectEditProvider {
    private static final Log LOG = CmsLog.getLog(CmsAdvancedDirectEditProvider.class);
    protected int m_lastPermissionMode;
    protected boolean m_useIds;
    I_CmsAutoBeanFactory m_editableDataExtensionsFactory = (I_CmsAutoBeanFactory)AutoBeanFactorySource.create(I_CmsAutoBeanFactory.class);
    private Random m_random = new Random();

    public String endDirectEditDisabled() {
        return "";
    }

    public String endDirectEditEnabled() {
        return "<div class=\"oc-editable-end\"></div>\n";
    }

    public synchronized String getRandomId() {
        return "editable_" + Math.abs(this.m_random.nextLong());
    }

    @Override
    public CmsDirectEditResourceInfo getResourceInfo(CmsDirectEditParams params, String resourceName) {
        try {
            boolean locked;
            if (this.m_cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                return CmsDirectEditResourceInfo.INACTIVE;
            }
            if (CmsResource.isTemporaryFileName(resourceName)) {
                return CmsDirectEditResourceInfo.INACTIVE;
            }
            if (!this.m_cms.isInsideCurrentProject(resourceName)) {
                return CmsDirectEditResourceInfo.INACTIVE;
            }
            CmsResource resource = this.m_cms.readResource(resourceName, CmsResourceFilter.ALL);
            if (!OpenCms.getResourceManager().getResourceType(resource.getTypeId()).isDirectEditable() && !resource.isFolder() && CmsStringUtil.isEmptyOrWhitespaceOnly(params.getUploadFolder())) {
                return CmsDirectEditResourceInfo.INACTIVE;
            }
            CmsLock lock = this.m_cms.getLock(resource);
            boolean bl = locked = !lock.isUnlocked() && !lock.isOwnedInProjectBy(this.m_cms.getRequestContext().getCurrentUser(), this.m_cms.getRequestContext().getCurrentProject());
            if (locked) {
                return new CmsDirectEditResourceInfo(CmsDirectEditPermissions.DISABLED, resource, lock);
            }
            return new CmsDirectEditResourceInfo(CmsDirectEditPermissions.ENABLED, resource, lock);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_CALC_EDIT_MODE_FAILED_1", resourceName), (Throwable)e);
            }
            return CmsDirectEditResourceInfo.INACTIVE;
        }
    }

    @Override
    public void insertDirectEditEnd(PageContext context) throws JspException {
        String content;
        switch (this.m_lastPermissionMode) {
            case 1: 
            case 2: {
                content = this.endDirectEditEnabled();
                break;
            }
            default: {
                content = null;
            }
        }
        this.m_lastPermissionMode = 0;
        this.print(context, content);
    }

    @Override
    public void insertDirectEditIncludes(PageContext context, CmsDirectEditParams params) throws JspException {
    }

    @Override
    public void insertDirectEditListMetadata(PageContext context, I_CmsContentLoadCollectorInfo info) throws JspException {
        if (this.m_cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            return;
        }
        I_CmsAutoBeanFactory collectorInfoFactory = (I_CmsAutoBeanFactory)AutoBeanFactorySource.create(I_CmsAutoBeanFactory.class);
        AutoBean<I_CmsContentLoadCollectorInfo> collectorInfoAutoBean = collectorInfoFactory.wrapCollectorInfo(info);
        String serializedCollectorInfo = AutoBeanCodex.encode(collectorInfoAutoBean).getPayload();
        String marker = "<div class='oc-collector-info' style='display: none !important;' data-oc-collector='" + CmsEncoder.escapeXml(serializedCollectorInfo) + "'></div>";
        this.print(context, marker);
    }

    @Override
    public boolean insertDirectEditStart(PageContext context, CmsDirectEditParams params) throws JspException {
        String content;
        CmsDirectEditResourceInfo resourceInfo = this.getResourceInfo(params, params.getResourceName());
        this.m_lastPermissionMode = resourceInfo.getPermissions().getPermission();
        switch (this.m_lastPermissionMode) {
            case 1: 
            case 2: {
                try {
                    CmsJspStandardContextBean contextBean = CmsJspStandardContextBean.getInstance(context.getRequest());
                    CmsJspStandardContextBean.CmsContainerElementWrapper element = contextBean.getElement();
                    if (element != null && ((CmsContainerElementBean)element).getId().equals(resourceInfo.getResource().getStructureId())) {
                        params.m_element = ((CmsContainerElementBean)element).editorHash();
                        params.setContainerElement(element);
                    }
                    content = this.startDirectEditEnabled(params, resourceInfo);
                    break;
                }
                catch (JSONException e) {
                    throw new JspException((Throwable)e);
                }
            }
            default: {
                content = null;
            }
        }
        this.print(context, content);
        return content != null;
    }

    @Override
    public boolean isManual(CmsDirectEditMode mode) {
        return false;
    }

    @Override
    public I_CmsDirectEditProvider newInstance() {
        CmsAdvancedDirectEditProvider result = new CmsAdvancedDirectEditProvider();
        result.m_configurationParameters = this.m_configurationParameters;
        return result;
    }

    public String startDirectEditDisabled(CmsDirectEditParams params, CmsDirectEditResourceInfo resourceInfo) {
        StringBuffer result = new StringBuffer(256);
        result.append("<!-- EDIT BLOCK START (DISABLED): ");
        result.append(params.m_resourceName);
        result.append(" [");
        result.append(resourceInfo.getResource().getState());
        result.append("] ");
        if (!resourceInfo.getLock().isUnlocked()) {
            result.append(" locked ");
            result.append(resourceInfo.getLock().getProject().getName());
        }
        result.append(" -->\n");
        return result.toString();
    }

    public String startDirectEditEnabled(CmsDirectEditParams params, CmsDirectEditResourceInfo resourceInfo) throws JSONException {
        String editLocale = this.m_cms.getRequestContext().getLocale().toString();
        String editId = this.getNextDirectEditId();
        String editNewLink = CmsEncoder.encode(params.getLinkForNew());
        JSONObject editableData = new JSONObject();
        CmsResource resource = resourceInfo.getResource();
        boolean writable = false;
        String uri = this.m_cms.getRequestContext().getUri();
        uri = this.m_cms.getRequestContext().addSiteRoot(uri);
        CmsADEConfigData configData = OpenCms.getADEManager().lookupConfigurationWithCache(this.m_cms, uri);
        if (resource != null) {
            try {
                writable = this.m_cms.hasPermissions(resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.IGNORE_EXPIRATION);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        editableData.put("editId", editId);
        CmsContainerElementBean containerElement = params.getContainerElement();
        if (containerElement != null) {
            editableData.put("ATTR_ELEMENT_ID", containerElement.editorHash());
        }
        editableData.put("structureId", resourceInfo.getResource().getStructureId());
        editableData.put("sitePath", params.getResourceName());
        editableData.put("elementlanguage", editLocale);
        editableData.put("elementname", params.getElement());
        editableData.put("newlink", editNewLink);
        editableData.put("hasResource", resource != null);
        editableData.put("newtitle", this.m_messages.key("GUI_EDITOR_TITLE_NEW_0"));
        editableData.put("unreleaseOrExpired", !resourceInfo.getResource().isReleasedAndNotExpired(System.currentTimeMillis()));
        if (params.getId() != null) {
            editableData.put("contextId", params.getId().toString());
        }
        editableData.put("postCreateHandler", params.getPostCreateHandler());
        CmsUUID viewId = CmsUUID.getNullUUID();
        boolean hasEditHandler = false;
        String typeName = null;
        if (resourceInfo.getResource() != null && resourceInfo.getResource().isFile()) {
            CmsResourceTypeConfig typeConfig;
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resourceInfo.getResource());
            if (type instanceof CmsResourceTypeXmlContent) {
                boolean bl = hasEditHandler = ((CmsResourceTypeXmlContent)type).getEditHandler(this.m_cms) != null;
            }
            if ((typeConfig = configData.getResourceType(typeName = OpenCms.getResourceManager().getResourceType(resourceInfo.getResource()).getTypeName())) != null) {
                viewId = typeConfig.getElementView();
            }
        } else {
            String[] components;
            CmsResourceTypeConfig typeConfig;
            String linkForNew = params.getLinkForNew();
            if (linkForNew != null && (typeConfig = configData.getResourceType(typeName = (components = linkForNew.split("\\|"))[components.length - 1])) != null) {
                viewId = typeConfig.getElementView();
            }
        }
        SitemapDirectEditPermissions sitemapConfigPermissions = configData.getDirectEditPermissions(typeName);
        boolean hasNew = false;
        editableData.put("hasEdit", params.getButtonSelection().isShowEdit() && CmsResourceTypeXmlContent.isXmlContent(resource));
        editableData.put("hasDelete", params.getButtonSelection().isShowDelete() && writable && sitemapConfigPermissions.canEdit());
        editableData.put("elementView", viewId);
        editableData.put("hasEditHandler", hasEditHandler);
        boolean favorites = sitemapConfigPermissions.canFavorite();
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
        CmsMessages messages = Messages.get().getBundle(locale);
        if (this.m_lastPermissionMode == 1 || !writable || !sitemapConfigPermissions.canEdit()) {
            String noEditReason = null;
            noEditReason = sitemapConfigPermissions.canCreate() ? messages.key("GUI_DIRECTEDIT_CAN_ONLY_BE_CREATED_0") : messages.key("GUI_DIRECTEDIT_CANNOT_BE_CREATED_OR_EDITED_0");
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(noEditReason)) {
                editableData.put("noEditReason", noEditReason);
            }
        }
        editableData.put("fav", (Object)favorites);
        AutoBean<I_CmsEditableDataExtensions> extensions = this.m_editableDataExtensionsFactory.createExtensions();
        boolean isUploadType = false;
        List<String> uploadTypes = Arrays.asList(CmsResourceTypeBinary.getStaticTypeName(), CmsResourceTypeImage.getStaticTypeName(), CmsResourceTypePlain.getStaticTypeName());
        if (resource != null && !resource.isFolder()) {
            for (String type : uploadTypes) {
                if (!OpenCms.getResourceManager().matchResourceType(type, resource.getTypeId())) continue;
                isUploadType = true;
                break;
            }
        } else {
            String newLink = params.getLinkForNew();
            if (newLink != null) {
                int pipePos = newLink.lastIndexOf(124);
                String typePart = newLink.substring(pipePos + 1);
                isUploadType = uploadTypes.contains(typePart);
            }
        }
        String uploadFolder = params.getUploadFolder();
        hasNew = params.getButtonSelection().isShowNew();
        if (isUploadType) {
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(uploadFolder) && !"none".equals(uploadFolder)) {
                CmsResource uploadFolderResource = null;
                try {
                    uploadFolderResource = this.m_cms.readResource(uploadFolder, CmsResourceFilter.IGNORE_EXPIRATION);
                    hasNew &= this.m_cms.hasPermissions(uploadFolderResource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.IGNORE_EXPIRATION);
                }
                catch (CmsVfsResourceNotFoundException e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (CmsPermissionViolationException e) {
                    LOG.debug((Object)("hasNew = false for upload folder " + uploadFolder + ", reason: " + e.getLocalizedMessage()), (Throwable)e);
                    hasNew = false;
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    hasNew = false;
                }
            } else {
                hasNew = false;
            }
        } else {
            hasNew &= sitemapConfigPermissions.canCreate();
        }
        ((I_CmsEditableDataExtensions)extensions.as()).setUploadEnabled(isUploadType && this.hasUploadSupport() && params.getUploadFolder() != null);
        ((I_CmsEditableDataExtensions)extensions.as()).setUploadFolder(params.getUploadFolder());
        editableData.put("ext", AutoBeanCodex.encode(extensions).getPayload());
        editableData.put("hasNew", hasNew);
        StringBuffer result = new StringBuffer(512);
        if (this.m_useIds) {
            result.append("<div id=\"" + this.getRandomId() + "\" class='" + "oc-editable" + "' " + "data-oc-editable" + "='").append(editableData.toString()).append("'></div>\n");
        } else {
            result.append("<div class='oc-editable' data-oc-editable='").append(editableData.toString()).append("'></div>\n");
        }
        return result.toString();
    }

    protected boolean hasUploadSupport() {
        return true;
    }

    public static enum SitemapDirectEditPermissions {
        all(true, true, true),
        editAndCreate(true, true, false),
        editOnly(false, true, true),
        none(false, false, false);

        private boolean m_create;
        private boolean m_edit;
        private boolean m_favorite;

        private SitemapDirectEditPermissions(boolean create, boolean edit, boolean favorite) {
            this.m_create = create;
            this.m_edit = edit;
            this.m_favorite = favorite;
        }

        public boolean canCreate() {
            return this.m_create;
        }

        public boolean canEdit() {
            return this.m_edit;
        }

        public boolean canFavorite() {
            return this.m_favorite;
        }
    }
}

