/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors.directedit;

import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.directedit.CmsDirectEditDefaultProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.editors.directedit.CmsDirectEditParams;
import org.opencms.workplace.editors.directedit.CmsDirectEditResourceInfo;
import org.opencms.workplace.editors.directedit.I_CmsDirectEditProvider;

public class CmsDirectEditJQueryProvider
extends CmsDirectEditDefaultProvider {
    protected static final String INCLUDE_FILE_JQUERY = "/system/workplace/editors/jquery_direct_edit_include.txt";
    private String m_closeLink;

    @Override
    public String getDirectEditIncludes(CmsDirectEditParams params) {
        this.m_closeLink = this.getLink(params.getLinkForClose());
        return super.getDirectEditIncludes(params);
    }

    @Override
    public void init(CmsObject cms, CmsDirectEditMode mode, String fileName) {
        if (CmsStringUtil.isEmpty(fileName)) {
            fileName = INCLUDE_FILE_JQUERY;
        }
        super.init(cms, mode, fileName);
    }

    @Override
    public I_CmsDirectEditProvider newInstance() {
        CmsDirectEditJQueryProvider result = new CmsDirectEditJQueryProvider();
        result.m_configurationParameters = this.m_configurationParameters;
        return result;
    }

    @Override
    public String startDirectEditDisabled(CmsDirectEditParams params, CmsDirectEditResourceInfo resourceInfo) {
        return this.appendDirectEditData(params, false);
    }

    @Override
    public String startDirectEditEnabled(CmsDirectEditParams params, CmsDirectEditResourceInfo resourceInfo) {
        return this.appendDirectEditData(params, false);
    }

    @Override
    protected CmsMacroResolver prepareMacroResolverForIncludes(CmsDirectEditParams params) {
        CmsMacroResolver resolver = super.prepareMacroResolverForIncludes(params);
        resolver.addMacro("jquery_flydom", this.readFile("/system/workplace/resources/jquery/packed/jquery.flydom.js"));
        resolver.addMacro("jquery_dimensions", this.readFile("/system/workplace/resources/jquery/packed/jquery.dimensions.js"));
        resolver.addMacro("jquery", this.readFile("/system/workplace/resources/jquery/packed/jquery.js"));
        return resolver;
    }

    private String appendDirectEditData(CmsDirectEditParams params, boolean disabled) {
        StringBuffer result = new StringBuffer(512);
        String editId = this.getNextDirectEditId();
        result.append("\n<script>\n");
        result.append("ocms_de_data['").append(editId).append("']= {\n");
        result.append("\t").append("id: '").append(editId).append("',\n");
        result.append("\t").append("deDisabled: ").append(disabled).append(",\n");
        result.append("\t").append("hasEdit: ").append(params.getButtonSelection().isShowEdit()).append(",\n");
        result.append("\t").append("hasDelete: ").append(params.getButtonSelection().isShowDelete()).append(",\n");
        result.append("\t").append("hasNew: ").append(params.getButtonSelection().isShowNew()).append(",\n");
        result.append("\t").append("resource: '").append(params.getResourceName()).append("',\n");
        result.append("\t").append("editLink: '").append(this.getLink(params.getLinkForEdit())).append("',\n");
        result.append("\t").append("language: '").append(this.m_cms.getRequestContext().getLocale().toString());
        result.append("',\n");
        result.append("\t").append("element: '").append(params.getElement()).append("',\n");
        result.append("\t").append("backlink: '").append(this.m_cms.getRequestContext().getUri()).append("',\n");
        result.append("\t").append("newlink: '").append(CmsEncoder.encode(params.getLinkForNew())).append("',\n");
        result.append("\t").append("closelink: '").append(this.m_closeLink).append("',\n");
        result.append("\t").append("deletelink: '").append(this.getLink(params.getLinkForDelete())).append("',\n");
        if (!disabled) {
            result.append("\t").append("button_edit: '");
            result.append(this.m_messages.key("GUI_EDITOR_FRONTEND_BUTTON_EDIT_0")).append("',\n");
            result.append("\t").append("button_delete: '");
            result.append(this.m_messages.key("GUI_BUTTON_DELETE_0")).append("',\n");
            result.append("\t").append("button_new: '");
            result.append(this.m_messages.key("GUI_BUTTON_NEW_0")).append("',\n");
        } else {
            result.append("\t").append("button_edit: '");
            result.append(this.m_messages.key("GUI_EDITOR_FRONTEND_BUTTON_LOCKED_0")).append("',\n");
            result.append("\t").append("button_delete: '");
            result.append(this.m_messages.key("GUI_EDITOR_FRONTEND_BUTTON_LOCKED_0")).append("',\n");
            result.append("\t").append("button_new: '");
            result.append(this.m_messages.key("GUI_EDITOR_FRONTEND_BUTTON_LOCKED_0")).append("',\n");
        }
        result.append("\t").append("editortitle: '").append(this.m_messages.key("GUI_EDITOR_TITLE_NEW_0"));
        result.append("'\n");
        result.append("};\n");
        result.append("</script>\n");
        result.append("<div id=\"").append(editId).append("\" class=\"ocms_de_norm\">");
        return result.toString();
    }

    private String readFile(String path) {
        String result = (String)CmsVfsMemoryObjectCache.getVfsMemoryObjectCache().getCachedObject(this.m_cms, path);
        if (result == null) {
            try {
                CmsFile file = this.m_cms.readFile(path);
                result = this.getContentAsString(file);
            }
            catch (CmsException e) {
                throw new RuntimeException(e);
            }
        }
        if (result != null) {
            CmsVfsMemoryObjectCache.getVfsMemoryObjectCache().putCachedObject(this.m_cms, path, result);
        }
        return result;
    }
}

