/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceManager;
import org.opencms.workplace.explorer.CmsExplorerTypeAccess;
import org.opencms.workplace.explorer.CmsIconRule;
import org.opencms.workplace.explorer.Messages;

public class CmsExplorerTypeSettings
implements Comparable<CmsExplorerTypeSettings>,
Serializable {
    public static final String ICON_STYLE_DEFAULT_BIG = "oc-icon-24-default";
    public static final String ICON_STYLE_DEFAULT_SMALL = "oc-icon-16-default";
    public static final String ICON_STYLE_MODEL_GROUP_COPY_BIG = "oc-icon-24-modelgroup_copy";
    public static final String ICON_STYLE_MODEL_GROUP_COPY_SMALL = "oc-icon-16-modelgroup_copy";
    public static final String ICON_STYLE_NAV_LEVEL_BIG = "oc-icon-24-navlevel";
    public static final String ICON_STYLE_NAV_LEVEL_SMALL = "oc-icon-16-navlevel";
    public static final int ORDER_VALUE_DEFAULT_START = 100000;
    public static final String ORDER_VALUE_SEPARATOR_DEFAULT = "999999";
    private static final Log LOG = CmsLog.getLog(CmsExplorerTypeSettings.class);
    private static Map<String, Integer> m_defaultViewOrders = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("folder", 50);
            this.put("plain", 200);
            this.put("jsp", 300);
            this.put("htmlredirect", 400);
            this.put("containerpage", 500);
            this.put("imagegallery", 100);
            this.put("downloadgallery", 200);
            this.put("linkgallery", 300);
            this.put("subsitemap", 400);
            this.put("content_folder", 500);
            this.put("formatter_config", 100);
            this.put("xmlvfsbundle", 200);
            this.put("propertyvfsbundle", 300);
            this.put("bundledescriptor", 350);
            this.put("sitemap_config", 400);
            this.put("sitemap_master_config", 500);
            this.put("module_config", 600);
            this.put("elementview", 700);
            this.put("seo_file", 800);
            this.put("containerpage_template", 900);
            this.put("inheritance_config", 1000);
            this.put(CmsResourceTypeXmlContent.getStaticTypeName(), 100);
            this.put("pointer", 200);
            this.put("modelgroup", 100);
        }
    };
    private static final long serialVersionUID = 7014251115525259136L;
    private CmsExplorerTypeAccess m_access;
    private boolean m_addititionalModuleExplorerType = false;
    private boolean m_autoSetNavigation;
    private boolean m_autoSetTitle;
    private String m_bigIcon;
    private String m_bigIconStyle;
    private String m_elementView;
    private boolean m_hasEditOptions = false;
    private String m_icon;
    private Map<String, CmsIconRule> m_iconRules;
    private String m_info;
    private boolean m_isView;
    private String m_key;
    private String m_name;
    private String m_namePattern;
    private Integer m_newResourceOrder = 0;
    private boolean m_creatable = true;
    private List<String> m_properties;
    private boolean m_propertiesEnabled = false;
    private String m_reference;
    private boolean m_showNavigation = false;
    private String m_smallIconStyle;
    private String m_titleKey;
    private Integer m_viewOrder;
    private Set<String> m_requiredOnUpload = new HashSet<String>();

    public CmsExplorerTypeSettings() {
        this.m_access = new CmsExplorerTypeAccess();
        this.m_properties = new ArrayList<String>();
        this.m_iconRules = new HashMap<String, CmsIconRule>();
    }

    public static Integer getDefaultViewOrder(String typeName) {
        return m_defaultViewOrders.get(typeName);
    }

    public void addIconRule(String extension, String icon, String bigIcon, String smallIconStyle, String bigIconStyle) {
        CmsIconRule rule = new CmsIconRule(extension, icon, bigIcon, smallIconStyle, bigIconStyle);
        this.m_iconRules.put(extension, rule);
    }

    public boolean addProperty(String propertyName, String requiredOnUpload) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(propertyName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_PROP_1", propertyName));
            }
            if (Boolean.valueOf(requiredOnUpload).booleanValue()) {
                this.m_requiredOnUpload.add(propertyName);
            }
            return this.m_properties.add(propertyName);
        }
        return false;
    }

    public Object clone() {
        CmsExplorerTypeSettings result = new CmsExplorerTypeSettings();
        result.m_access = this.m_access;
        result.m_addititionalModuleExplorerType = this.m_addititionalModuleExplorerType;
        result.m_autoSetNavigation = this.m_autoSetNavigation;
        result.m_autoSetTitle = this.m_autoSetTitle;
        result.m_bigIcon = this.m_bigIcon;
        result.m_bigIconStyle = this.m_bigIconStyle;
        result.m_elementView = this.m_elementView;
        result.m_hasEditOptions = this.m_hasEditOptions;
        result.m_icon = this.m_icon;
        result.m_info = this.m_info;
        result.m_isView = this.m_isView;
        result.m_key = this.m_key;
        result.m_name = this.m_name;
        result.m_namePattern = this.m_namePattern;
        result.m_newResourceOrder = this.m_newResourceOrder;
        result.m_properties = new ArrayList<String>(this.m_properties);
        result.m_propertiesEnabled = this.m_propertiesEnabled;
        result.m_reference = this.m_reference;
        result.m_showNavigation = this.m_showNavigation;
        result.m_smallIconStyle = this.m_smallIconStyle;
        result.m_titleKey = this.m_titleKey;
        result.m_viewOrder = this.m_viewOrder;
        result.m_iconRules = new HashMap<String, CmsIconRule>();
        for (Map.Entry<String, CmsIconRule> rule : this.m_iconRules.entrySet()) {
            result.m_iconRules.put(rule.getKey(), (CmsIconRule)rule.getValue().clone());
        }
        return result;
    }

    @Override
    public int compareTo(CmsExplorerTypeSettings other) {
        if (other == this) {
            return 0;
        }
        if (other != null) {
            return this.m_newResourceOrder.compareTo(other.m_newResourceOrder);
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CmsExplorerTypeSettings)) {
            return false;
        }
        CmsExplorerTypeSettings other = (CmsExplorerTypeSettings)o;
        return this.getName().equals(other.getName());
    }

    public CmsExplorerTypeAccess getAccess() {
        CmsWorkplaceManager workplaceManager;
        if (this.m_access.isEmpty() && (workplaceManager = OpenCms.getWorkplaceManager()) != null) {
            this.m_access = workplaceManager.getDefaultAccess();
        }
        return this.m_access;
    }

    public String getBigIcon() {
        return this.m_bigIcon;
    }

    public String getBigIconStyle() {
        return this.m_bigIconStyle;
    }

    public String getElementView() {
        return this.m_elementView;
    }

    public String getIcon() {
        return this.m_icon;
    }

    public Map<String, CmsIconRule> getIconRules() {
        return Collections.unmodifiableMap(this.m_iconRules);
    }

    public String getInfo() {
        return this.m_info;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNamePattern() {
        return this.m_namePattern;
    }

    public String getNewResourceOrder() {
        return String.valueOf(this.m_newResourceOrder);
    }

    public String getOriginalIcon() {
        return this.m_icon;
    }

    public List<String> getProperties() {
        return this.m_properties;
    }

    public String getReference() {
        return this.m_reference;
    }

    public String getSmallIconStyle() {
        return this.m_smallIconStyle;
    }

    public String getTitleKey() {
        return this.m_titleKey;
    }

    public Integer getViewOrder(boolean useDefault) {
        Integer defaultViewOrder = CmsExplorerTypeSettings.getDefaultViewOrder(this.m_name);
        Integer result = null;
        if (this.m_viewOrder != null) {
            result = this.m_viewOrder;
        } else if (useDefault) {
            result = defaultViewOrder != null ? defaultViewOrder : Integer.valueOf(9999);
        }
        return result;
    }

    public boolean hasEditOptions() {
        return this.m_hasEditOptions;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isAddititionalModuleExplorerType() {
        return this.m_addititionalModuleExplorerType;
    }

    public boolean isAutoSetNavigation() {
        return this.m_autoSetNavigation;
    }

    public boolean isAutoSetTitle() {
        return this.m_autoSetTitle;
    }

    public boolean isCreatable() {
        return this.m_creatable;
    }

    public boolean isEditable(CmsObject cms, CmsResource resource) {
        if (!cms.getRequestContext().getCurrentProject().isOnlineProject() && OpenCms.getRoleManager().hasRole(cms, CmsRole.ROOT_ADMIN)) {
            return true;
        }
        CmsPermissionSet permissions = this.getAccess().getPermissions(cms, resource);
        return permissions.requiresWritePermission();
    }

    public boolean isPropertiesEnabled() {
        return this.m_propertiesEnabled;
    }

    public boolean isPropertyRequiredOnUpload(String propName) {
        return this.m_requiredOnUpload.contains(propName);
    }

    public boolean isShowNavigation() {
        return this.m_showNavigation;
    }

    public boolean isView() {
        return this.m_isView;
    }

    public void setAccess(CmsExplorerTypeAccess access) {
        this.m_access = access;
    }

    public void setAddititionalModuleExplorerType(boolean addititionalModuleExplorerType) {
        this.m_addititionalModuleExplorerType = addititionalModuleExplorerType;
    }

    public void setAutoSetNavigation(String autoSetNavigation) {
        this.m_autoSetNavigation = Boolean.valueOf(autoSetNavigation);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_AUTO_NAV_1", autoSetNavigation));
        }
    }

    public void setAutoSetTitle(String autoSetTitle) {
        this.m_autoSetTitle = Boolean.valueOf(autoSetTitle);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_AUTO_TITLE_1", autoSetTitle));
        }
    }

    public void setBigIcon(String bigIcon) {
        this.m_bigIcon = bigIcon;
    }

    public void setBigIconStyle(String bigIconStyle) {
        this.m_bigIconStyle = bigIconStyle;
    }

    public void setCreatable(boolean creatable) {
        this.m_creatable = creatable;
    }

    public void setCreatable(String creatable) {
        this.m_creatable = Boolean.parseBoolean(creatable);
    }

    public void setEditOptions() {
        this.m_hasEditOptions = true;
    }

    public void setElementView(String elementView) {
        this.m_elementView = elementView;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting element view to " + elementView));
        }
    }

    public void setIcon(String icon) {
        this.m_icon = icon;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_ICON_1", icon));
        }
    }

    public void setInfo(String info) {
        this.m_info = info;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_INFO_1", info));
        }
    }

    public void setKey(String key) {
        this.m_key = key;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_KEY_1", key));
        }
    }

    public void setName(String name) {
        this.m_name = name;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_NAME_1", name));
        }
    }

    public void setNewResourceOrder(String newResourceOrder) {
        try {
            this.m_newResourceOrder = Integer.valueOf(newResourceOrder);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_NEW_RESOURCE_ORDER_1", newResourceOrder));
            }
        }
        catch (Exception e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            this.m_newResourceOrder = 0;
        }
    }

    public void setProperties(List<String> properties) {
        this.m_properties = properties;
    }

    public void setPropertiesEnabled(boolean enabled) {
        this.m_propertiesEnabled = enabled;
    }

    public void setPropertyDefaults(String enabled, String showNavigation) {
        this.setPropertiesEnabled(Boolean.valueOf(enabled));
        this.setShowNavigation(Boolean.valueOf(showNavigation));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_PROP_DEFAULTS_2", enabled, showNavigation));
        }
    }

    public void setReference(String reference) {
        this.m_reference = reference;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_REFERENCE_1", this.m_reference));
        }
    }

    public void setShowNavigation(boolean navigation) {
        this.m_showNavigation = navigation;
    }

    public void setSmallIconStyle(String smallIconStyle) {
        this.m_smallIconStyle = smallIconStyle;
    }

    public void setTitleKey(String titleKey) {
        this.m_titleKey = titleKey;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_TITLE_KEY_1", titleKey));
        }
    }

    public void setTypeAttributes(String name, String key, String icon) {
        this.setName(name);
        this.setKey(key);
        this.setIcon(icon);
    }

    public void setTypeAttributes(String name, String key, String icon, String bigIcon, String smallIconStyle, String bigIconStyle, String reference, String elementView, String isView, String namePattern, String viewOrder) {
        this.setName(name);
        this.setKey(key);
        this.setIcon(icon);
        this.setBigIcon(bigIcon);
        this.setSmallIconStyle(smallIconStyle);
        this.setBigIconStyle(bigIconStyle);
        this.setReference(reference);
        this.setElementView(elementView);
        try {
            this.m_viewOrder = Integer.valueOf(viewOrder);
        }
        catch (NumberFormatException e) {
            LOG.debug((Object)("Type " + name + " has no or invalid view order:" + viewOrder));
        }
        this.m_isView = Boolean.valueOf(isView);
        this.m_namePattern = namePattern;
    }
}

