/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishList;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.report.Messages;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsFileUtil;
import org.opencms.xml.CmsXmlEntityResolver;
import org.w3c.dom.Document;

public class CmsXmlFileTransformer {
    private static final Log LOG = CmsLog.getLog(CmsXmlFileTransformer.class);
    private CmsObject m_offlineCms;
    private CmsObject m_onlineCms;
    private String m_path;
    private String m_type;
    private byte[] m_xslt;
    private TransformerFactory m_transformerFactory;
    private I_CmsReport m_report;
    private String m_xslName;

    public CmsXmlFileTransformer(CmsObject cms, String path, String type, String xslName, InputStream xslStream, I_CmsReport report) throws CmsException, IOException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ROOT_ADMIN);
        this.m_xslName = xslName;
        this.m_transformerFactory = TransformerFactory.newInstance();
        this.m_offlineCms = OpenCms.initCmsObject(cms);
        this.m_offlineCms.getRequestContext().setSiteRoot("");
        this.m_onlineCms = OpenCms.initCmsObject(cms);
        this.m_onlineCms.getRequestContext().setSiteRoot("");
        this.m_offlineCms.getRequestContext().setCurrentProject(this.getTempfileProject(cms));
        this.m_onlineCms.getRequestContext().setCurrentProject(cms.readProject("Online"));
        this.m_path = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(path);
        this.m_type = type;
        this.m_xslt = CmsFileUtil.readFully(xslStream);
        this.m_report = report;
    }

    public void run() throws CmsException {
        this.m_report.println(this.message("XSL transform: " + this.m_xslName));
        this.m_report.println(this.message("Path: " + this.m_path));
        this.m_report.println(this.message("Type: " + this.m_type));
        try {
            List<CmsResource> resources = this.m_offlineCms.readResources(this.m_path, CmsResourceFilter.ALL.addRequireType(OpenCms.getResourceManager().getResourceType(this.m_type)), true);
            this.processResources(resources);
            OpenCms.getEventManager().fireEvent(5);
        }
        catch (CmsException e) {
            this.m_report.println(e);
            throw e;
        }
    }

    private String getOnlinePath(CmsResource res) throws CmsException {
        return this.m_onlineCms.readResource(res.getStructureId(), CmsResourceFilter.ALL).getRootPath();
    }

    private CmsProject getTempfileProject(CmsObject cms) throws CmsException {
        try {
            return cms.readProject("tempFileProject");
        }
        catch (CmsException e) {
            return cms.createTempfileProject();
        }
    }

    private CmsMessageContainer message(String content) {
        content = CmsXmlFileTransformer.class.getSimpleName() + ": " + content;
        return Messages.get().container("RPT_GENERIC_1", content);
    }

    private boolean needToUpdate(byte[] oldContent, byte[] content) {
        if (content == null) {
            return false;
        }
        return !this.sameXml(oldContent, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResources(List<CmsResource> resources) {
        ArrayList<String> changedPaths = new ArrayList<String>();
        for (CmsResource resource : resources) {
            boolean changed = false;
            CmsResourceState state = resource.getState();
            this.m_report.println(this.message("Processing " + resource.getRootPath()));
            try {
                AutoCloseable c = CmsLockUtil.withLockedResources(this.m_offlineCms, resource);
                try {
                    byte[] newContent;
                    byte[] content;
                    if (state.isNew()) {
                        content = this.readOfflineContent(resource);
                        if (!this.needToUpdate(content, newContent = this.transformContent(content))) continue;
                        changed = true;
                        this.writeContent(resource, newContent);
                        continue;
                    }
                    if (state.isUnchanged()) {
                        if (!resource.getRootPath().equals(this.getOnlinePath(resource))) {
                            this.m_report.println(this.message("Warning: Skipping " + resource.getRootPath() + " because of path inconsistency."));
                            continue;
                        }
                        content = this.readOfflineContent(resource);
                        if (!this.needToUpdate(content, newContent = this.transformContent(content))) continue;
                        changed = true;
                        this.writeContent(resource, newContent);
                        this.publishFile(resource);
                        continue;
                    }
                    if (state.isDeleted()) {
                        this.m_report.println(this.message("Skipping " + resource.getRootPath() + " because it is deleted."));
                        continue;
                    }
                    if (!state.isChanged()) continue;
                    if (!resource.getRootPath().equals(this.getOnlinePath(resource))) {
                        content = this.readOfflineContent(resource);
                        if (this.needToUpdate(content, newContent = this.transformContent(content))) {
                            changed = true;
                            this.writeContent(resource, newContent);
                        }
                        this.m_report.println(this.message("Warning: Not publishing " + resource.getRootPath() + " because it is moved."));
                        continue;
                    }
                    byte[] offlineContent = this.readOfflineContent(resource);
                    byte[] onlineContent = this.readOnlineContent(resource);
                    byte[] newOfflineContent = this.transformContent(offlineContent);
                    byte[] newOnlineContent = this.transformContent(onlineContent);
                    if (!this.needToUpdate(offlineContent, newOfflineContent) && !this.needToUpdate(onlineContent, newOnlineContent)) continue;
                    changed = true;
                    if (newOfflineContent == null) {
                        newOfflineContent = offlineContent;
                    }
                    try {
                        this.writeContent(resource, newOnlineContent);
                        this.publishFile(resource);
                    }
                    finally {
                        if (this.m_offlineCms.getLock(resource).isUnlocked()) {
                            this.m_offlineCms.lockResourceTemporary(resource);
                        }
                        this.writeContent(resource, newOfflineContent);
                    }
                }
                finally {
                    if (c == null) continue;
                    c.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                this.m_report.println(e);
            }
            finally {
                if (!changed) continue;
                changedPaths.add(resource.getRootPath());
            }
        }
        this.m_report.println();
        this.m_report.println(this.message("Summary of changed resources: "));
        this.m_report.println();
        for (String path : changedPaths) {
            this.m_report.println(this.message(path));
        }
    }

    private void publishFile(CmsResource resource) throws CmsException {
        CmsPublishList pubList = OpenCms.getPublishManager().getPublishList(this.m_offlineCms, this.m_offlineCms.readResource(resource.getStructureId(), CmsResourceFilter.ALL), false);
        OpenCms.getPublishManager().publishProject(this.m_offlineCms, this.m_report, pubList);
        OpenCms.getPublishManager().waitWhileRunning();
    }

    private byte[] readOfflineContent(CmsResource res) throws CmsException {
        return this.m_offlineCms.readFile(res).getContents();
    }

    private byte[] readOnlineContent(CmsResource res) throws CmsException {
        return this.m_onlineCms.readFile(this.m_onlineCms.readResource(res.getStructureId(), CmsResourceFilter.ALL)).getContents();
    }

    private boolean sameXml(byte[] xml1, byte[] xml2) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new CmsXmlEntityResolver(this.m_offlineCms));
            Document doc1 = db.parse(new ByteArrayInputStream(xml1));
            doc1.normalizeDocument();
            Document doc2 = db.parse(new ByteArrayInputStream(xml2));
            doc2.normalizeDocument();
            return doc1.isEqualNode(doc2);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.m_report.println(e);
            return false;
        }
    }

    private byte[] transformContent(byte[] content) throws TransformerException {
        Transformer transformer = this.m_transformerFactory.newTransformer(new StreamSource(new ByteArrayInputStream(this.m_xslt)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        transformer.transform(new StreamSource(new ByteArrayInputStream(content)), new StreamResult(baos));
        byte[] result = baos.toByteArray();
        return result;
    }

    private boolean writeContent(CmsResource res, byte[] content) throws CmsException {
        CmsFile file = this.m_offlineCms.readFile(res);
        file.setContents(content);
        this.m_offlineCms.writeFile(file);
        return true;
    }
}

