/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.containerpage.Messages;
import org.opencms.xml.content.CmsDefaultXmlContentHandler;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsHtmlRedirectHandler
extends CmsDefaultXmlContentHandler {
    private static final Log LOG = CmsLog.getLog(CmsHtmlRedirectHandler.class);

    @Override
    public CmsFile prepareForWrite(CmsObject cms, CmsXmlContent content, CmsFile file) throws CmsException {
        CmsFile result;
        block6: {
            result = super.prepareForWrite(cms, content, file);
            try {
                String linkStr = this.getStringValue(cms, content, "Link");
                String typeStr = this.getStringValue(cms, content, "Type");
                if ("sublevel".equals(typeStr)) {
                    Locale locale = OpenCms.getLocaleManager().getDefaultLocale(cms, file);
                    String title = Messages.get().getBundle(locale).key("GUI_REDIRECT_SUBLEVEL_TITLE_0");
                    CmsProperty titleProp = new CmsProperty("Title", title, null);
                    cms.writePropertyObjects(file, Arrays.asList(titleProp));
                    break block6;
                }
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(linkStr)) break block6;
                boolean hasScheme = false;
                try {
                    URI uri = new URI(linkStr);
                    hasScheme = uri.getScheme() != null;
                }
                catch (URISyntaxException e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                if (!hasScheme) {
                    linkStr = cms.getRequestContext().removeSiteRoot(linkStr);
                }
                Locale locale = OpenCms.getLocaleManager().getDefaultLocale(cms, file);
                String title = Messages.get().getBundle(locale).key("GUI_REDIRECT_TITLE_1", linkStr);
                CmsProperty titleProp = new CmsProperty("Title", title, null);
                cms.writePropertyObjects(file, Arrays.asList(titleProp));
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private String getStringValue(CmsObject cms, CmsXmlContent content, String node) {
        I_CmsXmlContentValue val = content.getValue(node, Locale.ENGLISH);
        if (val == null) {
            return null;
        }
        return val.getStringValue(cms);
    }
}

