/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage.mutable;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.mutable.CmsMutableContainer;

public class CmsMutableContainerPage {
    private List<CmsMutableContainer> m_containers = new ArrayList<CmsMutableContainer>();

    public CmsMutableContainerPage(List<CmsMutableContainer> containers) {
        this.m_containers = new ArrayList<CmsMutableContainer>(containers);
    }

    public static CmsMutableContainerPage fromImmutable(CmsContainerPageBean page) {
        List<CmsMutableContainer> containers = page.getContainers().values().stream().map(container -> CmsMutableContainer.fromImmutable(container)).collect(Collectors.toList());
        return new CmsMutableContainerPage(containers);
    }

    public List<CmsMutableContainer> containers() {
        return this.m_containers;
    }

    public List<CmsMutableContainer> containers(String name) {
        return this.m_containers.stream().filter(container -> container.matches(name)).collect(Collectors.toList());
    }

    public CmsMutableContainer exactContainer(String name) {
        return this.m_containers.stream().filter(container -> name.equals(container.getName())).findFirst().orElse(null);
    }

    public CmsMutableContainer firstContainer(String name) {
        return this.m_containers.stream().filter(container -> container.matches(name)).findFirst().orElse(null);
    }

    public CmsContainerPageBean toImmutable() {
        List<CmsContainerBean> containers = this.m_containers.stream().map(cnt -> cnt.toImmutable()).collect(Collectors.toList());
        return new CmsContainerPageBean(containers);
    }
}

