/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.logging.Log;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xerces.parsers.SAXParser;
import org.dom4j.Document;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXsltContext;
import org.opencms.xml.content.Messages;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class CmsVersionTransformer {
    private static final Log LOG = CmsLog.getLog(CmsVersionTransformer.class);
    public static final String XSL_PARAM_TRANSFORMATION_CONTEXT = "context";

    public static Document transformDocumentToCurrentVersion(CmsObject cms, Document document, CmsXmlContentDefinition contentDefinition) {
        String transformation = contentDefinition.getContentHandler().getVersionTransformation();
        if (transformation == null) {
            LOG.warn((Object)("Schema version detected, but no version transformation defined for " + contentDefinition.getSchemaLocation()));
            return document;
        }
        try {
            CmsResource xsltResource = cms.readResource(transformation, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsFile xsltFile = cms.readFile(xsltResource);
            TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
            final ArrayList errors = new ArrayList();
            transformerFactory.setErrorListener(new ErrorListener(){

                @Override
                public void error(TransformerException e) throws TransformerException {
                    errors.add(e);
                    throw e;
                }

                @Override
                public void fatalError(TransformerException e) throws TransformerException {
                    errors.add(e);
                    throw e;
                }

                @Override
                public void warning(TransformerException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            });
            SAXSource transformationSource = new SAXSource(new InputSource(new ByteArrayInputStream(xsltFile.getContents())));
            SAXParser parser = new SAXParser();
            parser.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException e) throws SAXException {
                    errors.add(e);
                    throw e;
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    errors.add(e);
                    throw e;
                }

                @Override
                public void warning(SAXParseException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            });
            transformationSource.setXMLReader((XMLReader)parser);
            Transformer transformer = transformerFactory.newTransformer(transformationSource);
            if (errors.size() > 0) {
                throw (Exception)errors.get(0);
            }
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(CmsXmlUtils.convertDocumentFromDom4jToW3C(document));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            org.w3c.dom.Document targetDoc = builder.newDocument();
            DOMResult target = new DOMResult(targetDoc);
            transformer.setParameter(XSL_PARAM_TRANSFORMATION_CONTEXT, new CmsXsltContext(cms));
            transformer.transform(source, target);
            if (errors.size() > 0) {
                throw (Exception)errors.get(0);
            }
            Document result = CmsXmlUtils.convertDocumentFromW3CToDom4j(targetDoc);
            result.getRootElement().addAttribute("version", "" + contentDefinition.getVersion());
            if (LOG.isDebugEnabled()) {
                try {
                    LOG.debug((Object)("Used XSL transformation " + transformation + "\n----------------------------\nOriginal XML:\n----------------------------\n" + CmsXmlUtils.marshal(document, "UTF-8") + "\n----------------------------\nTransformed XML:\n----------------------------\n" + CmsXmlUtils.marshal(result, "UTF-8")));
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_VERSION_TRANSFORMATION_ERROR_1", transformation), (Throwable)e);
        }
    }
}

