/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.List;
import java.util.Locale;
import org.dom4j.Element;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.json.JSONArray;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.opencms.xml.xml2json.I_CmsJsonFormattableValue;

public class CmsXmlDynamicCategoryValue
extends A_CmsXmlContentValue
implements I_CmsJsonFormattableValue {
    public static final String N_CATEGORY_STRING = "category-string";
    public static final String TYPE_NAME = "OpenCmsDynamicCategory";
    private static String m_schemaDefinition;

    public CmsXmlDynamicCategoryValue() {
    }

    public CmsXmlDynamicCategoryValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        super(document, element, locale, type);
    }

    public CmsXmlDynamicCategoryValue(String name, String minOccurs, String maxOccurs) {
        super(name, minOccurs, maxOccurs);
    }

    @Override
    public I_CmsXmlContentValue createValue(I_CmsXmlDocument document, Element element, Locale locale) {
        return new CmsXmlDynamicCategoryValue(document, element, locale, this);
    }

    @Override
    public Element generateXml(CmsObject cms, I_CmsXmlDocument document, Element root, Locale locale) {
        Element element = root.addElement(this.getName());
        element.addComment("Categories are read dynamically");
        return element;
    }

    @Override
    public String getPlainText(CmsObject cms) {
        return this.getStringValue(cms);
    }

    @Override
    public String getSchemaDefinition() {
        if (m_schemaDefinition == null) {
            m_schemaDefinition = this.readSchemaDefinition("org/opencms/xml/types/XmlDynamicCategoryValue.xsd");
        }
        return m_schemaDefinition;
    }

    @Override
    public String getStringValue(CmsObject cms) throws CmsRuntimeException {
        Element categoryElement = this.categoryStringElem(false);
        if (categoryElement == null) {
            return "";
        }
        return categoryElement.getText();
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isSearchable() {
        return false;
    }

    @Override
    public I_CmsXmlSchemaType newInstance(String name, String minOccurs, String maxOccurs) {
        return new CmsXmlDynamicCategoryValue(name, minOccurs, maxOccurs);
    }

    @Override
    public void setStringValue(CmsObject cms, String value) throws CmsIllegalArgumentException {
        this.categoryStringElem(true).setText(value);
    }

    Element categoryStringElem(boolean create) {
        Element result = this.m_element.element(N_CATEGORY_STRING);
        if (result == null && create) {
            result = this.m_element.addElement(N_CATEGORY_STRING);
            result.detach();
            this.m_element.elements().add(0, result);
        }
        return result;
    }

    @Override
    public Object toJson(CmsObject cms) {
        CmsXmlContent content = (CmsXmlContent)this.getDocument();
        JSONArray array = new JSONArray();
        try {
            CmsFile file = content.getFile();
            List<CmsCategory> categories = CmsCategoryService.getInstance().readResourceCategories(cms, file);
            for (CmsCategory cat : categories) {
                array.put(cat.getPath());
            }
            return array;
        }
        catch (Exception e) {
            return array;
        }
    }
}

