/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Element;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlVfsImageValue
extends CmsXmlVfsFileValue {
    public static final String NODE_SCALE = "scale";
    public static final String PARAM_DESCRIPTION = "description";
    public static final String PARAM_FORMAT = "format";
    public static final String TYPE_NAME_IMAGE = "OpenCmsVfsImage";
    private static String m_schemaDefinition;
    private String m_description;
    private String m_format;
    private Map<String, String[]> m_parameters;
    private String m_scaleOptions;

    public CmsXmlVfsImageValue() {
    }

    public CmsXmlVfsImageValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        super(document, element, locale, type);
    }

    public CmsXmlVfsImageValue(String name, String minOccurs, String maxOccurs) {
        super(name, minOccurs, maxOccurs);
    }

    @Override
    public I_CmsXmlContentValue createValue(I_CmsXmlDocument document, Element element, Locale locale) {
        return new CmsXmlVfsImageValue(document, element, locale, this);
    }

    public String getDescription(CmsObject cms) {
        if (this.m_description == null) {
            if (this.m_element.element(PARAM_DESCRIPTION) != null) {
                this.m_description = this.m_element.element(PARAM_DESCRIPTION).getText();
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_description)) {
                this.m_description = this.getParameterValue(cms, PARAM_DESCRIPTION);
                this.m_description = CmsEncoder.unescape(this.m_description, "UTF-8");
            }
        }
        return this.m_description;
    }

    public String getFormat(CmsObject cms) {
        if (this.m_format == null) {
            if (this.m_element.element(PARAM_FORMAT) != null) {
                this.m_format = this.m_element.element(PARAM_FORMAT).getText();
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_format)) {
                this.m_format = this.getParameterValue(cms, PARAM_FORMAT);
            }
        }
        return this.m_format;
    }

    public String getRequestLink(CmsObject cms) {
        return CmsRequestUtil.getRequestLink(this.getStringValue(cms));
    }

    public String getScaleOptions(CmsObject cms) {
        if (this.m_scaleOptions == null) {
            if (this.m_element.element(NODE_SCALE) != null) {
                this.m_scaleOptions = this.m_element.element(NODE_SCALE).getText();
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_scaleOptions)) {
                this.m_scaleOptions = this.getParameterValue(cms, "__scale");
            }
        }
        return this.m_scaleOptions;
    }

    @Override
    public String getSchemaDefinition() {
        if (m_schemaDefinition == null) {
            m_schemaDefinition = this.readSchemaDefinition("org/opencms/xml/types/XmlVfsImageValue.xsd");
        }
        return m_schemaDefinition;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME_IMAGE;
    }

    @Override
    public I_CmsXmlSchemaType newInstance(String name, String minOccurs, String maxOccurs) {
        return new CmsXmlVfsImageValue(name, minOccurs, maxOccurs);
    }

    public void setDescription(CmsObject cms, String description) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(description)) {
            this.m_description = "";
            if (this.m_element.element(PARAM_DESCRIPTION) != null) {
                this.m_element.remove(this.m_element.element(PARAM_DESCRIPTION));
            }
        } else {
            this.m_description = description;
            description = CmsEncoder.escapeWBlanks(description, "UTF-8");
        }
        this.setParameterValue(cms, PARAM_DESCRIPTION, description);
    }

    public void setFormat(CmsObject cms, String format) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(format)) {
            this.m_format = "";
            if (this.m_element.element(PARAM_FORMAT) != null) {
                this.m_element.remove(this.m_element.element(PARAM_FORMAT));
            }
        } else {
            this.m_format = format;
        }
        this.setParameterValue(cms, PARAM_FORMAT, format);
    }

    public void setScaleOptions(CmsObject cms, String scaleOptions) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(scaleOptions)) {
            this.m_scaleOptions = "";
            if (this.m_element.element(NODE_SCALE) != null) {
                this.m_element.remove(this.m_element.element(NODE_SCALE));
            }
        } else {
            this.m_scaleOptions = scaleOptions;
        }
        this.setParameterValue(cms, "__scale", scaleOptions);
    }

    @Override
    public void setStringValue(CmsObject cms, String value) throws CmsIllegalArgumentException {
        String scale;
        String format;
        super.setStringValue(cms, value);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) {
            return;
        }
        Map<String, String[]> params = this.getParameterMap(value);
        String desc = this.getParameterValue(cms, params, PARAM_DESCRIPTION);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(desc)) {
            desc = CmsEncoder.unescape(desc, "UTF-8");
            this.m_element.addElement(PARAM_DESCRIPTION).addCDATA(desc);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(format = this.getParameterValue(cms, params, PARAM_FORMAT))) {
            this.m_element.addElement(PARAM_FORMAT).addCDATA(format);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(scale = this.getParameterValue(cms, params, "__scale"))) {
            this.m_element.addElement(NODE_SCALE).addCDATA(scale);
        }
        this.m_parameters = null;
        this.m_format = null;
        this.m_description = null;
        this.m_scaleOptions = null;
    }

    private Map<String, String[]> getParameterMap(String url) {
        int pos;
        Map<String, String[]> result = new HashMap<String, String[]>();
        if (CmsStringUtil.isNotEmpty(url) && (pos = url.indexOf("?")) >= 0) {
            result = CmsRequestUtil.createParameterMap(url.substring(pos + 1));
        }
        return result;
    }

    private String getParameterValue(CmsObject cms, Map<String, String[]> parameterMap, String key) {
        String result = null;
        String[] params = parameterMap.get(key);
        if (params != null && params.length > 0) {
            result = params[0];
        }
        if (result == null) {
            return "";
        }
        return result;
    }

    private String getParameterValue(CmsObject cms, String key) {
        if (this.m_parameters == null) {
            this.m_parameters = this.getParameterMap(this.getStringValue(cms));
        }
        return this.getParameterValue(cms, this.m_parameters, key);
    }

    private void setParameterValue(CmsObject cms, String key, String value) {
        if (this.m_parameters == null) {
            this.m_parameters = this.getParameterMap(this.getStringValue(cms));
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value) && this.m_parameters.containsKey(key)) {
            this.m_parameters.remove(key);
        } else if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) {
            this.m_parameters.put(key, new String[]{value});
        }
        String result = CmsRequestUtil.getRequestLink(this.getStringValue(cms));
        result = CmsRequestUtil.appendParameters(result, this.m_parameters, false);
        this.setStringValue(cms, result);
    }
}

