/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json.document;

import java.util.Collections;
import java.util.Locale;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.search.config.CmsSearchConfiguration;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationCommon;
import org.opencms.jsp.search.config.parser.CmsSimpleSearchConfigurationParser;
import org.opencms.jsp.search.config.parser.simplesearch.CmsConfigParserUtils;
import org.opencms.jsp.search.config.parser.simplesearch.CmsConfigurationBean;
import org.opencms.jsp.search.controller.CmsSearchController;
import org.opencms.jsp.search.result.CmsSearchResultWrapper;
import org.opencms.jsp.search.result.I_CmsSearchResourceBean;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchException;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.search.solr.CmsSolrResultList;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.xml2json.CmsJsonRequest;
import org.opencms.xml.xml2json.document.CmsJsonDocumentEmbeddedXmlContent;
import org.opencms.xml.xml2json.document.CmsJsonDocumentXmlContent;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerContext;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerException;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerXmlContent;

public class CmsJsonDocumentList
extends CmsJsonDocumentXmlContent {
    private static final Integer MAX_ROWS = 600;

    public CmsJsonDocumentList(CmsJsonRequest jsonRequest, CmsXmlContent xmlContent) throws Exception {
        super(jsonRequest, xmlContent);
        this.m_throwException = false;
    }

    @Override
    public Object getJson() throws JSONException, CmsException, CmsJsonHandlerException, CmsJsonHandlerXmlContent.PathNotFoundException, Exception {
        super.getJson();
        this.insertJsonList();
        return this.m_json;
    }

    @Override
    protected boolean isLocaleAllRequest() {
        return false;
    }

    @Override
    protected boolean isLocalePathRequest() {
        return false;
    }

    @Override
    protected boolean isLocaleRequest() {
        return true;
    }

    @Override
    protected boolean isShowFallbackLocaleRequest() {
        return true;
    }

    @Override
    protected boolean isShowWrapperRequest() {
        return false;
    }

    private CmsSearchResultWrapper getSearchResult(CmsJsonHandlerContext context) throws JSONException, CmsSearchException {
        CmsConfigurationBean listConfigurationBean = CmsConfigParserUtils.parseListConfiguration(context.getCms(), context.getResource());
        CmsSimpleSearchConfigurationParser searchConfigurationParser = new CmsSimpleSearchConfigurationParser(context.getCms(), listConfigurationBean, "{}");
        Locale locale = CmsLocaleManager.getLocale(this.m_jsonRequest.getParamLocale());
        Locale selectedLocale = OpenCms.getLocaleManager().getBestMatchingLocale(locale, Collections.emptyList(), this.m_xmlContent.getLocales());
        searchConfigurationParser.setSearchLocale(selectedLocale);
        String paramSort = this.m_jsonRequest.getParamSort();
        if (paramSort != null) {
            searchConfigurationParser.setSortOption(paramSort);
        }
        CmsSolrQuery query = searchConfigurationParser.getInitialQuery();
        Integer paramStart = this.m_jsonRequest.getParamStart();
        Integer paramRows = this.m_jsonRequest.getParamRows();
        if (paramStart != null) {
            query.setStart(paramStart);
        }
        if (paramRows != null) {
            query.setRows(paramRows);
        } else {
            query.setRows(MAX_ROWS);
        }
        CmsSearchController searchController = new CmsSearchController(new CmsSearchConfiguration(searchConfigurationParser, context.getCms()));
        searchController.addQueryParts(query, context.getCms());
        I_CmsSearchConfigurationCommon searchConfigurationCommon = searchController.getCommon().getConfig();
        CmsSolrIndex index = OpenCms.getSearchManager().getIndexSolr(searchConfigurationCommon.getSolrIndex());
        CmsSolrResultList solrResultList = index.search(context.getCms(), query, true, null, false, CmsResourceFilter.DEFAULT, searchConfigurationCommon.getMaxReturnedResults());
        return new CmsSearchResultWrapper(searchController, solrResultList, query, context.getCms(), null);
    }

    private void insertJsonList() throws Exception {
        Boolean paramContent = this.m_jsonRequest.getParamContent();
        if (paramContent.booleanValue()) {
            CmsSearchResultWrapper searchResult = this.getSearchResult(this.m_context);
            this.insertJsonListInfo(searchResult);
            this.insertJsonListItems(searchResult);
        }
    }

    private void insertJsonListInfo(CmsSearchResultWrapper searchResult) throws JSONException {
        JSONObject jsonObject = new JSONObject(true);
        jsonObject.put("numFound", searchResult.getNumFound());
        this.m_json.put("listInfo", jsonObject);
    }

    private void insertJsonListItems(CmsSearchResultWrapper searchResult) throws Exception {
        for (I_CmsSearchResourceBean searchResourceBean : searchResult.getSearchResults()) {
            CmsFile file = searchResourceBean.getXmlContent().getFile();
            CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(this.m_context.getCms(), file);
            CmsJsonDocumentEmbeddedXmlContent jsonDocument = new CmsJsonDocumentEmbeddedXmlContent(this.m_jsonRequest, xmlContent);
            this.m_json.append("list", jsonDocument.getJson());
        }
    }
}

