/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json.handler;

import org.apache.commons.logging.Log;
import org.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.xml.xml2json.CmsJsonResult;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerContext;
import org.opencms.xml.xml2json.handler.I_CmsJsonHandler;

public class CmsExceptionSafeHandlerWrapper
implements I_CmsJsonHandler {
    private static final Log LOG = CmsLog.getLog(CmsExceptionSafeHandlerWrapper.class);
    private I_CmsJsonHandler m_handler;

    public CmsExceptionSafeHandlerWrapper(I_CmsJsonHandler handler) {
        this.m_handler = handler;
    }

    @Override
    public double getOrder() {
        return this.m_handler.getOrder();
    }

    @Override
    public boolean matches(CmsJsonHandlerContext context) {
        try {
            return this.m_handler.matches(context);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public CmsJsonResult renderJson(CmsJsonHandlerContext context) {
        try {
            return this.m_handler.renderJson(context);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return new CmsJsonResult(JSONObject.quote((String)e.getLocalizedMessage()), 500);
        }
    }

    public String toString() {
        return this.m_handler.toString();
    }
}

