/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json.handler;

import org.apache.commons.logging.Log;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.xml.xml2json.CmsJsonRequest;
import org.opencms.xml.xml2json.CmsJsonResult;
import org.opencms.xml.xml2json.document.CmsJsonDocumentXmlContent;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerContext;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerException;
import org.opencms.xml.xml2json.handler.I_CmsJsonHandler;

public class CmsJsonHandlerXmlContent
implements I_CmsJsonHandler {
    public static final String PARAM_LOCALE = "locale";
    public static final String PARAM_PATH = "path";
    private static final Log LOG = CmsLog.getLog(CmsJsonHandlerXmlContent.class);

    public static JSONObject empty() {
        try {
            return new JSONObject("{}");
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Override
    public double getOrder() {
        return 100.0;
    }

    @Override
    public boolean matches(CmsJsonHandlerContext context) {
        return CmsResourceTypeXmlContent.isXmlContent(context.getResource()) && !CmsResourceTypeXmlContainerPage.isContainerPage(context.getResource());
    }

    @Override
    public CmsJsonResult renderJson(CmsJsonHandlerContext context) {
        return this.renderJson(context, true);
    }

    public CmsJsonResult renderJson(CmsJsonHandlerContext context, boolean throwError) {
        try {
            CmsJsonRequest jsonRequest = new CmsJsonRequest(context, this);
            jsonRequest.validate();
            if (jsonRequest.hasErrors()) {
                return new CmsJsonResult(jsonRequest.getErrorsAsJson(), 400);
            }
            CmsJsonDocumentXmlContent jsonDocument = new CmsJsonDocumentXmlContent(jsonRequest, context.getContent());
            return new CmsJsonResult(jsonDocument.getJson(), 200);
        }
        catch (JSONException | PathNotFoundException e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            return new CmsJsonResult(e.getLocalizedMessage(), 404);
        }
        catch (CmsJsonHandlerException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            return new CmsJsonResult(e.getLocalizedMessage(), 400);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return new CmsJsonResult(e.getLocalizedMessage(), 500);
        }
    }

    public static class PathNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PathNotFoundException(String string) {
            super(string);
        }
    }
}

