/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsFormatterUtils;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsJsonRendererContainerPage {
    private static final Log LOG = CmsLog.getLog(CmsJsonRendererContainerPage.class);
    private CmsObject m_cms;
    private CmsResource m_page;
    private Predicate<String> m_propFilter;

    public CmsJsonRendererContainerPage(CmsObject cms, CmsResource page, Predicate<String> propertyFilter) {
        this.m_cms = cms;
        this.m_page = page;
        this.m_propFilter = propertyFilter;
    }

    public ElementNode buildTree(CmsContainerPageBean page, String rootPath) {
        HashMap<String, ElementNode> elementsByInstanceId = new HashMap<String, ElementNode>();
        ArrayList<ContainerNode> containerNodes = new ArrayList<ContainerNode>();
        CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfiguration(this.m_cms, rootPath);
        for (CmsContainerBean container : page.getContainers().values()) {
            ContainerNode containerNode = new ContainerNode(container);
            containerNodes.add(containerNode);
            for (CmsContainerElementBean cachedElementBean : container.getElements()) {
                CmsContainerElementBean elementBean = cachedElementBean.clone();
                try {
                    elementBean.initResource(this.m_cms);
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    continue;
                }
                ElementNode elemNode = new ElementNode(elementBean, containerNode);
                if (elementBean.getInstanceId() != null) {
                    elementsByInstanceId.put(elementBean.getInstanceId(), elemNode);
                }
                I_CmsFormatterBean formatter = this.getFormatter(this.m_cms, container, elementBean, adeConfig);
                elementBean.initSettings(this.m_cms, adeConfig, formatter, Locale.ENGLISH, null, new HashMap<String, String>());
                containerNode.add(elemNode);
            }
        }
        ElementNode rootElement = new ElementNode(null, null);
        for (ContainerNode containerNode : containerNodes) {
            ElementNode parentElement;
            CmsContainerBean container = containerNode.getContainer();
            String parentId = container.getParentInstanceId();
            ElementNode elementNode = parentElement = CmsStringUtil.isEmpty(parentId) ? null : (ElementNode)elementsByInstanceId.get(parentId);
            if (parentElement == null) {
                rootElement.add(containerNode);
                continue;
            }
            parentElement.add(containerNode);
        }
        return rootElement;
    }

    public Object renderJson() throws Exception {
        CmsFile file = this.m_cms.readFile(this.m_page);
        CmsXmlContainerPage page = CmsXmlContainerPageFactory.unmarshal(this.m_cms, file);
        CmsContainerPageBean pageBean = page.getContainerPage(this.m_cms);
        ElementNode root = this.buildTree(pageBean, file.getRootPath());
        return this.elementToJson(root);
    }

    JSONObject containerToJson(ContainerNode containerNode) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("name", containerNode.getName());
        result.put("type", containerNode.getType());
        result.put("isDetailOnlyContainer", containerNode.isDetailOnlyContainer());
        result.put("isNestedContainer", containerNode.isNestedContainer());
        result.put("isRootContainer", containerNode.isRootContainer());
        JSONArray elemJson = new JSONArray();
        for (ElementNode elemNode : containerNode.getElements()) {
            elemJson.put(this.elementToJson(elemNode));
        }
        result.put("elements", elemJson);
        return result;
    }

    JSONObject elementToJson(ElementNode elementNode) throws JSONException {
        JSONObject result = new JSONObject();
        if (elementNode.getElement() != null) {
            result.put("path", elementNode.getElement().getResource().getRootPath());
            String formatterKey = CmsFormatterUtils.getFormatterKey(elementNode.getParentContainerNode().getName(), elementNode.getElement());
            result.put("formatterKey", formatterKey);
            JSONObject settings = new JSONObject();
            for (Map.Entry<String, String> entry : elementNode.getElement().getSettings().entrySet()) {
                if (entry.getKey().startsWith("formatterSettings") || entry.getKey().equals("element_instance_id")) continue;
                settings.put(entry.getKey(), entry.getValue());
            }
            result.put("settings", settings);
        }
        JSONArray containers = new JSONArray();
        for (ContainerNode containerNode : elementNode.getContainers().values()) {
            containers.put(this.containerToJson(containerNode));
        }
        result.put("containers", containers);
        return result;
    }

    private I_CmsFormatterBean getFormatter(CmsObject cms, CmsContainerBean container, CmsContainerElementBean elementBean, CmsADEConfigData adeConfig) {
        Collection<I_CmsFormatterBean> formatterList = adeConfig.getCachedFormatters().getFormattersForType(OpenCms.getResourceManager().getResourceType(elementBean.getResource()).getTypeName(), false);
        HashMap<CmsUUID, I_CmsFormatterBean> formatters = new HashMap<CmsUUID, I_CmsFormatterBean>();
        for (I_CmsFormatterBean formatter : formatterList) {
            formatters.put(new CmsUUID(formatter.getId()), formatter);
        }
        Map<String, String> settings = elementBean.getIndividualSettings();
        I_CmsFormatterBean result = null;
        String forKeyWithContainer = settings.get("formatterSettings#" + container.getName());
        String forKeyWithoutContainer = settings.get("formatterSettings#");
        for (String formatterId : new String[]{forKeyWithContainer, forKeyWithoutContainer}) {
            if (!CmsUUID.isValidUUID(formatterId)) continue;
            result = (I_CmsFormatterBean)formatters.get(new CmsUUID(formatterId));
            break;
        }
        CmsUUID elementJspId = elementBean.getFormatterId();
        if (result == null && elementJspId != null) {
            LOG.warn((Object)("Formatter id not found for element " + elementBean.getResource().getRootPath() + "  in " + this.m_page.getRootPath()));
            for (I_CmsFormatterBean bean : formatters.values()) {
                if (!bean.getJspStructureId().equals(elementJspId)) continue;
                result = bean;
                break;
            }
        }
        return result;
    }

    public class ContainerNode {
        private CmsContainerBean m_container;
        private List<ElementNode> m_elements = new ArrayList<ElementNode>();

        public ContainerNode(CmsContainerBean container) {
            this.m_container = container;
        }

        public void add(ElementNode elemNode) {
            this.m_elements.add(elemNode);
        }

        public CmsContainerBean getContainer() {
            return this.m_container;
        }

        public List<ElementNode> getElements() {
            return Collections.unmodifiableList(this.m_elements);
        }

        public String getName() {
            return this.m_container.getName();
        }

        public String getType() {
            return this.m_container.getType();
        }

        public boolean isDetailOnlyContainer() {
            return this.m_container.isDetailOnly();
        }

        public boolean isNestedContainer() {
            return this.m_container.isNestedContainer();
        }

        public boolean isRootContainer() {
            return this.m_container.isRootContainer();
        }
    }

    public class ElementNode {
        private Map<String, ContainerNode> m_containers = new HashMap<String, ContainerNode>();
        private CmsContainerElementBean m_element;
        private ContainerNode m_parentContainerNode;

        public ElementNode(CmsContainerElementBean elementBean, ContainerNode parentContainerNode) {
            this.m_element = elementBean;
            this.m_parentContainerNode = parentContainerNode;
        }

        public void add(ContainerNode containerNode) {
            this.m_containers.put(containerNode.getName(), containerNode);
        }

        public Map<String, ContainerNode> getContainers() {
            return Collections.unmodifiableMap(this.m_containers);
        }

        public CmsContainerElementBean getElement() {
            return this.m_element;
        }

        public ContainerNode getParentContainerNode() {
            return this.m_parentContainerNode;
        }
    }
}

