/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigCacheState;
import org.opencms.ade.configuration.CmsADEConfigDataInternal;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.ade.configuration.CmsElementView;
import org.opencms.ade.configuration.CmsSitemapAttributeEditorConfiguration;
import org.opencms.ade.configuration.I_CmsGlobalConfigurationCache;
import org.opencms.ade.configuration.plugins.CmsSitePlugin;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsResourceState;
import org.opencms.db.generic.Messages;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.CmsWaitHandle;

class CmsConfigurationCache
implements I_CmsGlobalConfigurationCache {
    public static final CmsUUID ID_UPDATE_ALL = CmsUUID.getConstantUUID("all");
    public static final CmsUUID ID_UPDATE_ATTRIBUTE_EDITOR_CONFIGURATIONS = CmsUUID.getConstantUUID("attribute_editor_configurations");
    public static final CmsUUID ID_UPDATE_ELEMENT_VIEWS = CmsUUID.getConstantUUID("elementViews");
    public static final CmsUUID ID_UPDATE_FOLDERTYPES = CmsUUID.getConstantUUID("foldertypes");
    public static final CmsUUID ID_UPDATE_MODULES = CmsUUID.getNullUUID();
    public static final CmsUUID ID_UPDATE_SITE_PLUGINS = CmsUUID.getConstantUUID("site_plugins");
    public static final int TASK_DELAY_MILLIS = 3000;
    public static final String TYPE_SITE_PLUGIN = "site_plugin";
    public static final String TYPE_SITEMAP_MASTER_CONFIG = "sitemap_master_config";
    protected static boolean DEBUG;
    private static final Log LOG;
    private static final String TYPE_ATTRIBUTE_EDITOR_CONFIG = "attr_editor_config";
    protected I_CmsResourceType m_configType;
    protected I_CmsResourceType m_moduleConfigType;
    private CmsObject m_cms;
    private LoadingCache<CmsResource, Boolean> m_detailPageIdCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).maximumSize(30000L).concurrencyLevel(8).build((CacheLoader)new CacheLoader<CmsResource, Boolean>(){

        public Boolean load(CmsResource key) throws Exception {
            if (CmsConfigurationCache.this.m_state == null) {
                return Boolean.FALSE;
            }
            try {
                return CmsConfigurationCache.this.m_state.isDetailPage(CmsConfigurationCache.this.m_cms, key);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return Boolean.FALSE;
            }
        }
    });
    private I_CmsResourceType m_elementViewType;
    private ConcurrentHashMap<CmsUUID, String> m_pathCache = new ConcurrentHashMap();
    private volatile CmsADEConfigCacheState m_state;
    private ScheduledFuture<?> m_taskFuture;
    private LinkedBlockingQueue<Object> m_workQueue = new LinkedBlockingQueue();

    public CmsConfigurationCache(CmsObject cms, I_CmsResourceType configType, I_CmsResourceType moduleConfigType, I_CmsResourceType elementViewType) {
        this.m_cms = cms;
        this.m_configType = configType;
        this.m_moduleConfigType = moduleConfigType;
        this.m_elementViewType = elementViewType;
    }

    public static String getBasePath(String siteConfigFile) {
        if (siteConfigFile.endsWith("/.content/.config")) {
            return CmsResource.getParentFolder(CmsResource.getParentFolder(siteConfigFile));
        }
        return null;
    }

    @Override
    public void clear() {
        this.m_workQueue.add(ID_UPDATE_ALL);
        this.m_detailPageIdCache.invalidateAll();
        this.m_pathCache.clear();
    }

    public String getPathForStructureId(CmsUUID structureId) throws CmsException {
        if (structureId == null) {
            throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_RESOURCE_WITH_ID_1", "null"));
        }
        String rootPath = this.m_pathCache.get(structureId);
        if (rootPath != null) {
            return rootPath;
        }
        CmsResource res = this.m_cms.readResource(structureId);
        this.m_pathCache.put(structureId, res.getRootPath());
        return res.getRootPath();
    }

    public List<CmsDetailPageInfo> getRawDetailPages() {
        return this.m_state.getRawDetailPages();
    }

    public CmsADEConfigCacheState getState() {
        return this.m_state;
    }

    public CmsWaitHandle getWaitHandleForUpdateTask() {
        CmsWaitHandle handle = new CmsWaitHandle(true);
        this.m_workQueue.add(handle);
        return handle;
    }

    public void initialize() {
        if (this.m_taskFuture != null) {
            this.m_taskFuture.cancel(false);
            this.m_taskFuture = null;
        }
        this.m_state = this.readCompleteConfiguration();
        long delay = DEBUG ? 500L : 3000L;
        this.m_taskFuture = OpenCms.getExecutor().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                CmsConfigurationCache.this.performUpdate();
            }
        }, delay, delay, TimeUnit.MILLISECONDS);
    }

    public boolean isDetailPage(CmsObject cms, CmsResource resource) {
        try {
            boolean result = (Boolean)this.m_detailPageIdCache.get((Object)resource);
            if (!result) {
                this.m_detailPageIdCache.invalidate((Object)resource);
            }
            return result;
        }
        catch (ExecutionException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return true;
        }
    }

    public CmsADEConfigCacheState readCompleteConfiguration() {
        long beginTime = System.currentTimeMillis();
        HashMap siteConfigurations = Maps.newHashMap();
        if (this.m_cms.existsResource("/")) {
            try {
                List<CmsResource> configFileCandidates = this.m_cms.readResources("/", CmsResourceFilter.DEFAULT.addRequireType(this.m_configType.getTypeId()));
                CmsLog.INIT.info((Object)(". Reading " + configFileCandidates.size() + " config resources of type: " + this.m_configType.getTypeName() + " from the " + (this.m_cms.getRequestContext().getCurrentProject().isOnlineProject() ? "online" : "offline") + " project."));
                if (OpenCms.getResourceManager().hasResourceType(TYPE_SITEMAP_MASTER_CONFIG)) {
                    List<CmsResource> masterCandidates = this.m_cms.readResources("/", CmsResourceFilter.DEFAULT.addRequireType(OpenCms.getResourceManager().getResourceType(TYPE_SITEMAP_MASTER_CONFIG)));
                    configFileCandidates.addAll((Collection<CmsResource>)masterCandidates);
                }
                for (CmsResource candidate : configFileCandidates) {
                    if (!this.isSitemapConfiguration(candidate.getRootPath(), candidate.getTypeId())) continue;
                    try {
                        CmsConfigurationReader reader = new CmsConfigurationReader(this.m_cms);
                        String basePath = CmsConfigurationCache.getBasePath(candidate.getRootPath());
                        CmsADEConfigDataInternal data = reader.parseSitemapConfiguration(basePath, candidate);
                        siteConfigurations.put(candidate.getStructureId(), data);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error processing sitemap configuration " + candidate.getRootPath() + ": " + e.getLocalizedMessage()), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        CmsLog.INIT.info((Object)(". Reading " + (this.m_cms.getRequestContext().getCurrentProject().isOnlineProject() ? "online" : "offline") + " module configurations."));
        List<CmsADEConfigDataInternal> moduleConfigs = this.loadModuleConfiguration();
        CmsLog.INIT.info((Object)(". Reading " + (this.m_cms.getRequestContext().getCurrentProject().isOnlineProject() ? "online" : "offline") + " element views."));
        Map<CmsUUID, CmsElementView> elementViews = this.loadElementViews();
        Map<CmsUUID, CmsSitePlugin> sitePlugins = this.loadSitePlugins();
        Map<CmsUUID, CmsSitemapAttributeEditorConfiguration> attributeEditorConfigs = this.loadAttributeEditorConfigurations();
        CmsADEConfigCacheState result = new CmsADEConfigCacheState(this.m_cms, siteConfigurations, moduleConfigs, elementViews, sitePlugins, attributeEditorConfigs);
        long endTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("readCompleteConfiguration took " + (endTime - beginTime) + "ms"));
        }
        return result;
    }

    @Override
    public void remove(CmsPublishedResource res) {
        this.remove(res.getStructureId(), res.getRootPath(), res.getType());
    }

    @Override
    public void remove(CmsResource res) {
        this.remove(res.getStructureId(), res.getRootPath(), res.getTypeId());
    }

    @Override
    public void update(CmsPublishedResource res) {
        try {
            this.update(res.getStructureId(), res.getRootPath(), res.getType(), res.getState());
        }
        catch (CmsRuntimeException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void update(CmsResource res) {
        try {
            this.update(res.getStructureId(), res.getRootPath(), res.getTypeId(), res.getState());
        }
        catch (CmsRuntimeException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected boolean isMacroOrFlexFormatter(int type, String rootPath) {
        boolean result = false;
        try {
            I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(type);
            result = ("macro_formatter".equals(resType.getTypeName()) || "flex_formatter".equals(resType.getTypeName())) && CmsResource.getParentFolder(rootPath).endsWith("/.content/.formatters");
        }
        catch (Exception e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected boolean isModuleConfiguration(String rootPath, int type) {
        return type == this.m_moduleConfigType.getTypeId();
    }

    protected boolean isOnline() {
        return this.m_cms.getRequestContext().getCurrentProject().isOnlineProject();
    }

    protected boolean isSitemapConfiguration(String rootPath, int type) {
        if (type == this.m_configType.getTypeId()) {
            return rootPath.endsWith("/.content/.config");
        }
        return OpenCms.getResourceManager().matchResourceType(TYPE_SITEMAP_MASTER_CONFIG, type);
    }

    protected Map<CmsUUID, CmsElementView> loadElementViews() {
        ArrayList<CmsElementView> views = new ArrayList<CmsElementView>();
        if (this.m_cms.existsResource("/")) {
            views.add(CmsElementView.DEFAULT_ELEMENT_VIEW);
            try {
                CmsResourceFilter filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(this.m_elementViewType.getTypeId());
                List<CmsResource> groups = this.m_cms.readResources("/", filter);
                for (CmsResource res : groups) {
                    try {
                        views.add(new CmsElementView(this.m_cms, res));
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            Collections.sort(views, new CmsElementView.ElementViewComparator());
            LinkedHashMap<CmsUUID, CmsElementView> elementViews = new LinkedHashMap<CmsUUID, CmsElementView>();
            for (CmsElementView view : views) {
                elementViews.put(view.getId(), view);
            }
            return elementViews;
        }
        return null;
    }

    protected List<CmsADEConfigDataInternal> loadModuleConfiguration() {
        if (this.m_cms.existsResource("/")) {
            CmsConfigurationReader reader = new CmsConfigurationReader(this.m_cms);
            List<CmsADEConfigDataInternal> moduleConfigs = reader.readModuleConfigurations();
            return moduleConfigs;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performUpdate() {
        block19: {
            ArrayList<CmsWaitHandle> waitHandles = new ArrayList<CmsWaitHandle>();
            try {
                ArrayList work = new ArrayList();
                this.m_workQueue.drainTo(work);
                HashSet<CmsUUID> updateIds = new HashSet<CmsUUID>();
                Iterator iterator = work.iterator();
                while (iterator.hasNext()) {
                    Object item = iterator.next();
                    if (item instanceof CmsUUID) {
                        updateIds.add((CmsUUID)item);
                        continue;
                    }
                    if (!(item instanceof CmsWaitHandle)) continue;
                    waitHandles.add((CmsWaitHandle)item);
                }
                CmsADEConfigCacheState oldState = this.m_state;
                if (updateIds.isEmpty() && oldState != null) break block19;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException item) {
                    // empty catch block
                }
                if (updateIds.contains(ID_UPDATE_ALL) || oldState == null) {
                    this.m_state = this.readCompleteConfiguration();
                } else {
                    boolean updateModules = updateIds.remove(ID_UPDATE_MODULES);
                    boolean updateElementViews = updateIds.remove(ID_UPDATE_ELEMENT_VIEWS);
                    boolean updateSitePlugins = updateIds.remove(ID_UPDATE_SITE_PLUGINS);
                    boolean updateAttributeEditorConfigurations = updateIds.remove(ID_UPDATE_ATTRIBUTE_EDITOR_CONFIGURATIONS);
                    updateIds.remove(ID_UPDATE_FOLDERTYPES);
                    HashMap updateMap = Maps.newHashMap();
                    for (CmsUUID structureId : updateIds) {
                        CmsADEConfigDataInternal sitemapConfig = this.parseSitemapConfiguration(structureId);
                        updateMap.put(structureId, sitemapConfig);
                    }
                    List<CmsADEConfigDataInternal> moduleConfigs = null;
                    if (updateModules) {
                        moduleConfigs = this.loadModuleConfiguration();
                    }
                    Map<CmsUUID, CmsElementView> elementViews = null;
                    if (updateElementViews) {
                        elementViews = this.loadElementViews();
                    }
                    Map<CmsUUID, CmsSitePlugin> sitePlugins = null;
                    if (updateSitePlugins) {
                        sitePlugins = this.loadSitePlugins();
                    }
                    Map<CmsUUID, CmsSitemapAttributeEditorConfiguration> attributeEditorConfigurations = null;
                    if (updateAttributeEditorConfigurations) {
                        attributeEditorConfigurations = this.loadAttributeEditorConfigurations();
                    }
                    this.m_state = oldState.createUpdatedCopy(updateMap, moduleConfigs, elementViews, sitePlugins, attributeEditorConfigurations);
                }
                try {
                    OpenCms.getADEManager().getCache().flushContainerPages(this.m_cms.getRequestContext().getCurrentProject().isOnlineProject());
                }
                catch (Exception e) {
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Could not perform configuration cache update: " + e.getMessage()), (Throwable)e);
            }
            finally {
                for (CmsWaitHandle handle : waitHandles) {
                    handle.release();
                }
            }
        }
    }

    protected void remove(CmsUUID structureId, String rootPath, int type) {
        if (CmsResource.isTemporaryFileName(rootPath)) {
            return;
        }
        this.m_pathCache.remove(structureId);
        if (this.isSitemapConfiguration(rootPath, type)) {
            this.m_workQueue.add(structureId);
        } else if (this.isModuleConfiguration(rootPath, type)) {
            this.m_workQueue.add(ID_UPDATE_MODULES);
        } else if (this.isElementView(type)) {
            this.m_workQueue.add(ID_UPDATE_ELEMENT_VIEWS);
        } else if (OpenCms.getResourceManager().matchResourceType(TYPE_SITE_PLUGIN, type)) {
            this.m_workQueue.add(ID_UPDATE_SITE_PLUGINS);
        } else if (OpenCms.getResourceManager().matchResourceType(TYPE_ATTRIBUTE_EDITOR_CONFIG, type)) {
            this.m_workQueue.add(ID_UPDATE_ATTRIBUTE_EDITOR_CONFIGURATIONS);
        } else if (this.m_state.getFolderTypes().containsKey(rootPath)) {
            this.m_workQueue.add(ID_UPDATE_FOLDERTYPES);
        }
    }

    protected void update(CmsUUID structureId, String rootPath, int type, CmsResourceState resState) {
        if (CmsResource.isTemporaryFileName(rootPath)) {
            return;
        }
        this.m_pathCache.replace(structureId, rootPath);
        if (this.isSitemapConfiguration(rootPath, type)) {
            this.m_workQueue.add(structureId);
        } else if (this.isModuleConfiguration(rootPath, type)) {
            LOG.info((Object)("Changed module configuration file " + rootPath + "(" + structureId + ")"));
            this.m_workQueue.add(ID_UPDATE_MODULES);
        } else if (this.isElementView(type)) {
            this.m_workQueue.add(ID_UPDATE_ELEMENT_VIEWS);
        } else if (OpenCms.getResourceManager().matchResourceType(TYPE_SITE_PLUGIN, type)) {
            this.m_workQueue.add(ID_UPDATE_SITE_PLUGINS);
        } else if (OpenCms.getResourceManager().matchResourceType(TYPE_ATTRIBUTE_EDITOR_CONFIG, type)) {
            this.m_workQueue.add(ID_UPDATE_ATTRIBUTE_EDITOR_CONFIGURATIONS);
        } else if (this.m_state.getFolderTypes().containsKey(rootPath)) {
            this.m_workQueue.add(ID_UPDATE_FOLDERTYPES);
        } else if (this.isMacroOrFlexFormatter(type, rootPath)) {
            try {
                String path = CmsResource.getParentFolder(CmsResource.getParentFolder(rootPath));
                path = CmsStringUtil.joinPaths(path, ".config");
                CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION;
                if (this.m_cms.existsResource(path, filter)) {
                    CmsResource config = this.m_cms.readResource(path, filter);
                    this.m_workQueue.add(config.getStructureId());
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    CmsADEConfigDataInternal parseSitemapConfiguration(CmsUUID id) {
        try {
            CmsResource configResource = this.m_cms.readResource(id);
            if (this.isSitemapConfiguration(configResource.getRootPath(), configResource.getTypeId())) {
                CmsConfigurationReader reader = new CmsConfigurationReader(this.m_cms);
                String basePath = CmsConfigurationCache.getBasePath(configResource.getRootPath());
                CmsADEConfigDataInternal result = reader.parseSitemapConfiguration(basePath, configResource);
                return result;
            }
            LOG.info((Object)("Not a valid sitemap configuration anymore: " + configResource.getRootPath()));
            return null;
        }
        catch (Exception e) {
            if (e instanceof CmsVfsResourceNotFoundException) {
                LOG.info((Object)("Configuration file with ID " + id + " was not found."));
            } else {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return null;
        }
    }

    private boolean isElementView(int type) {
        return type == this.m_elementViewType.getTypeId();
    }

    private Map<CmsUUID, CmsSitemapAttributeEditorConfiguration> loadAttributeEditorConfigurations() {
        HashMap<CmsUUID, CmsSitemapAttributeEditorConfiguration> result = new HashMap<CmsUUID, CmsSitemapAttributeEditorConfiguration>();
        if (OpenCms.getResourceManager().hasResourceType(TYPE_ATTRIBUTE_EDITOR_CONFIG) && this.m_cms.existsResource("/")) {
            try {
                CmsResourceFilter filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(OpenCms.getResourceManager().getResourceType(TYPE_ATTRIBUTE_EDITOR_CONFIG).getTypeId());
                List<CmsResource> configResources = this.m_cms.readResources("/", filter);
                for (CmsResource res : configResources) {
                    try {
                        CmsSitemapAttributeEditorConfiguration config = CmsSitemapAttributeEditorConfiguration.read(this.m_cms, res);
                        if (config == null) continue;
                        result.put(res.getStructureId(), config);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private Map<CmsUUID, CmsSitePlugin> loadSitePlugins() {
        HashMap<CmsUUID, CmsSitePlugin> result = new HashMap<CmsUUID, CmsSitePlugin>();
        if (OpenCms.getResourceManager().hasResourceType(TYPE_SITE_PLUGIN) && this.m_cms.existsResource("/")) {
            try {
                CmsResourceFilter filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(OpenCms.getResourceManager().getResourceType(TYPE_SITE_PLUGIN).getTypeId());
                List<CmsResource> pluginResources = this.m_cms.readResources("/", filter);
                for (CmsResource res : pluginResources) {
                    try {
                        CmsSitePlugin sitePlugin = CmsSitePlugin.read(this.m_cms, res);
                        result.put(res.getStructureId(), sitePlugin);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    static {
        LOG = CmsLog.getLog(CmsConfigurationCache.class);
    }
}

