/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.I_CmsGlobalConfigurationCache;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.urlname.CmsUrlNameMappingEntry;
import org.opencms.db.urlname.CmsUrlNameMappingFilter;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;

public class CmsDetailNameCache
implements I_CmsGlobalConfigurationCache {
    public static final int DELAY_MILLIS = 3000;
    private static final Log LOG = CmsLog.getLog(CmsDetailNameCache.class);
    public static final String ATTR_BYPASS = "bypass-detail-name-cache";
    private Object m_updateLock = new Object();
    private CmsObject m_cms;
    private volatile ConcurrentHashMap<String, CmsUUID> m_detailIdCache = new ConcurrentHashMap();
    private LinkedBlockingQueue<CmsUUID> m_changes = new LinkedBlockingQueue();

    public CmsDetailNameCache(CmsObject cms) {
        this.m_cms = cms;
    }

    @Override
    public void clear() {
        this.markForUpdate(CmsUUID.getNullUUID());
    }

    public CmsUUID getDetailId(String name) {
        return this.m_detailIdCache.get(name);
    }

    public void initialize() {
        OpenCms.getExecutor().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                CmsDetailNameCache.this.checkForUpdates();
            }
        }, 3000L, 3000L, TimeUnit.MILLISECONDS);
        this.reload();
    }

    @Override
    public void remove(CmsPublishedResource pubRes) {
        this.checkIfUpdateIsNeeded(pubRes.getStructureId(), pubRes.getRootPath(), pubRes.getType());
    }

    @Override
    public void remove(CmsResource resource) {
        this.checkIfUpdateIsNeeded(resource.getStructureId(), resource.getRootPath(), resource.getTypeId());
    }

    @Override
    public void update(CmsPublishedResource pubRes) {
        this.checkIfUpdateIsNeeded(pubRes.getStructureId(), pubRes.getRootPath(), pubRes.getType());
    }

    @Override
    public void update(CmsResource resource) {
        this.checkIfUpdateIsNeeded(resource.getStructureId(), resource.getRootPath(), resource.getTypeId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForUpdate() {
        Object object = this.m_updateLock;
        synchronized (object) {
            try {
                this.m_updateLock.wait();
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForUpdates() {
        HashSet updateSet = new HashSet();
        this.m_changes.drainTo(updateSet);
        if (!updateSet.isEmpty()) {
            if (updateSet.contains(CmsUUID.getNullUUID())) {
                LOG.info((Object)"Updating detail name cache: reloading...");
                this.reload();
            } else {
                LOG.info((Object)("Updating detail name cache. Number of changed files: " + updateSet.size()));
                for (CmsUUID id : updateSet) {
                    Set<String> urlNames = this.getUrlNames(id);
                    for (String urlName : urlNames) {
                        this.m_detailIdCache.put(urlName, id);
                    }
                }
            }
        }
        Iterator iterator = this.m_updateLock;
        synchronized (iterator) {
            this.m_updateLock.notifyAll();
        }
    }

    private void checkIfUpdateIsNeeded(CmsUUID structureId, String rootPath, int typeId) {
        try {
            I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(typeId);
            if (resType instanceof CmsResourceTypeXmlContent && !OpenCms.getResourceManager().matchResourceType("containerpage", typeId)) {
                this.markForUpdate(structureId);
            }
        }
        catch (CmsLoaderException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Set<String> getUrlNames(CmsUUID id) {
        try {
            CmsUrlNameMappingFilter filter = CmsUrlNameMappingFilter.ALL.filterStructureId(id);
            Set<String> result = this.m_cms.readUrlNameMappings(filter).stream().map(entry -> entry.getName()).collect(Collectors.toSet());
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    private void markForUpdate(CmsUUID id) {
        this.m_changes.add(id);
    }

    private void reload() {
        ConcurrentHashMap<String, CmsUUID> newMap = new ConcurrentHashMap<String, CmsUUID>();
        try {
            List<CmsUrlNameMappingEntry> mappings = this.m_cms.readUrlNameMappings(CmsUrlNameMappingFilter.ALL);
            LOG.info((Object)("Initializing detail name cache with " + mappings.size() + " entries"));
            for (CmsUrlNameMappingEntry entry : mappings) {
                newMap.put(entry.getName(), entry.getStructureId());
            }
            this.m_detailIdCache = newMap;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

