/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.xml.containerpage.CmsContainerElementBean;

public class CmsFormatterUtils {
    public static Set<String> getAllFormatterKeys(CmsADEConfigData configData, CmsContainerElementBean element) {
        Set<String> result = element.getIndividualSettings().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("formatterSettings#")).map(entry -> (String)entry.getValue()).collect(Collectors.toSet());
        return result;
    }

    public static String getFormatterKey(String containerName, CmsContainerElementBean element) {
        Map<String, String> settings = element.getSettings();
        return CmsFormatterUtils.getFormatterKey(containerName, settings);
    }

    public static String getFormatterKey(String containerName, Map<String, String> settings) {
        String key1 = settings.get("formatterSettings#" + containerName);
        String key2 = settings.get("formatterSettings#");
        for (String key : new String[]{key1, key2}) {
            if (key == null) continue;
            return key;
        }
        return null;
    }

    public static String removeFormatterKey(String containerName, Map<String, String> settings) {
        String result = null;
        for (String mapKey : Arrays.asList("formatterSettings#" + containerName, "formatterSettings#")) {
            if (settings.get(mapKey) == null) continue;
            result = settings.remove(mapKey);
            break;
        }
        for (String mapKey : new ArrayList<String>(settings.keySet())) {
            if (!mapKey.startsWith("formatterSettings#")) continue;
            settings.remove(mapKey);
        }
        return result;
    }
}

