/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.opencms.ade.configuration.formatters.CmsFormatterConfigurationCacheState;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsFunctionAvailability {
    private CmsFormatterConfigurationCacheState m_formatterConfig;
    private Map<CmsUUID, Boolean> m_functionStates = new HashMap<CmsUUID, Boolean>();
    private boolean m_hasWhitelist;

    public CmsFunctionAvailability(CmsFormatterConfigurationCacheState formatterConfig) {
        this.m_formatterConfig = formatterConfig;
    }

    public void add(CmsUUID functionId) {
        I_CmsFormatterBean functionFormatter;
        if (this.m_hasWhitelist && (functionFormatter = this.m_formatterConfig.getFormatters().get(functionId)) != null && functionFormatter.getKey() != null) {
            String key = functionFormatter.getKey();
            Iterator<Map.Entry<CmsUUID, Boolean>> iter = this.m_functionStates.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<CmsUUID, Boolean> entry = iter.next();
                CmsUUID id = entry.getKey();
                I_CmsFormatterBean existingBean = this.m_formatterConfig.getFormatters().get(id);
                if (existingBean == null || !key.equals(existingBean.getKey())) continue;
                iter.remove();
            }
        }
        this.m_hasWhitelist = true;
        this.m_functionStates.put(functionId, Boolean.TRUE);
    }

    public void addAll(Collection<CmsUUID> enabledIds) {
        for (CmsUUID id : enabledIds) {
            this.add(id);
        }
    }

    public boolean checkAvailable(CmsUUID id) {
        Boolean state = this.m_functionStates.get(id);
        if (state != null) {
            return state;
        }
        return !this.m_hasWhitelist;
    }

    public Collection<CmsUUID> getBlacklist() {
        ArrayList<CmsUUID> result = new ArrayList<CmsUUID>();
        for (Map.Entry<CmsUUID, Boolean> entry : this.m_functionStates.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            result.add(entry.getKey());
        }
        Collections.sort(result);
        return result;
    }

    public Collection<CmsUUID> getWhitelist() {
        if (!this.m_hasWhitelist) {
            return null;
        }
        ArrayList<CmsUUID> result = new ArrayList<CmsUUID>();
        for (Map.Entry<CmsUUID, Boolean> entry : this.m_functionStates.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            result.add(entry.getKey());
        }
        Collections.sort(result);
        return result;
    }

    public boolean isDefined() {
        return this.m_hasWhitelist || this.m_functionStates.size() > 0;
    }

    public void remove(CmsUUID functionId) {
        if (this.m_hasWhitelist) {
            this.m_functionStates.remove(functionId);
        } else {
            this.m_functionStates.put(functionId, Boolean.FALSE);
        }
    }

    public void removeAll() {
        this.m_hasWhitelist = true;
        this.m_functionStates.clear();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

