/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration.formatters;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.formatters.CmsSharedSettingKey;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsUUID;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsSettingConfiguration {
    private static final Log LOG = CmsLog.getLog(CmsSettingConfiguration.class);
    private LoadingCache<ImmutableList<CmsUUID>, Map<String, CmsXmlContentProperty>> m_cache = CacheBuilder.newBuilder().concurrencyLevel(4).build((CacheLoader)new CacheLoader<ImmutableList<CmsUUID>, Map<String, CmsXmlContentProperty>>(){

        public Map<String, CmsXmlContentProperty> load(ImmutableList<CmsUUID> sharedSettingOverrides) throws Exception {
            return CmsSettingConfiguration.this.resolveSettings(sharedSettingOverrides);
        }
    });
    private String m_displayType;
    private String m_formatterKey;
    private List<CmsXmlContentProperty> m_listedSettings;
    private Map<CmsUUID, Map<CmsSharedSettingKey, CmsXmlContentProperty>> m_sharedSettingConfigsById;
    private List<CmsUUID> m_sharedSettingsIdsFromFormatter;

    public CmsSettingConfiguration() {
        this.m_listedSettings = new ArrayList<CmsXmlContentProperty>();
        this.m_sharedSettingConfigsById = new HashMap<CmsUUID, Map<CmsSharedSettingKey, CmsXmlContentProperty>>();
        this.m_displayType = null;
        this.m_sharedSettingsIdsFromFormatter = new ArrayList<CmsUUID>();
    }

    public CmsSettingConfiguration(List<CmsXmlContentProperty> listedSettings, Map<CmsUUID, Map<CmsSharedSettingKey, CmsXmlContentProperty>> sharedSettingConfigsById, List<CmsUUID> includeIds, String formatterKey, String displayType) {
        this.m_listedSettings = listedSettings;
        this.m_sharedSettingConfigsById = sharedSettingConfigsById;
        this.m_displayType = displayType;
        this.m_formatterKey = formatterKey;
        this.m_sharedSettingsIdsFromFormatter = new ArrayList<CmsUUID>(includeIds);
    }

    public Map<String, CmsXmlContentProperty> getSettings(ImmutableList<CmsUUID> sharedSettingOverrides) {
        try {
            return (Map)this.m_cache.get(sharedSettingOverrides);
        }
        catch (ExecutionException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private Map<CmsSharedSettingKey, CmsXmlContentProperty> combineSharedSettingDefinitionMaps(List<CmsUUID> ids) {
        HashMap<CmsSharedSettingKey, CmsXmlContentProperty> result = new HashMap<CmsSharedSettingKey, CmsXmlContentProperty>();
        for (CmsUUID settingFileId : ids) {
            Map<CmsSharedSettingKey, CmsXmlContentProperty> sharedSettingsForLevel = this.m_sharedSettingConfigsById.get(settingFileId);
            if (sharedSettingsForLevel != null) {
                result.putAll(sharedSettingsForLevel);
                continue;
            }
            LOG.warn((Object)("Shared setting reference not found: " + settingFileId));
        }
        return result;
    }

    private CmsXmlContentProperty getSharedSetting(Map<CmsSharedSettingKey, CmsXmlContentProperty> map, String includeName) {
        CmsXmlContentProperty result = null;
        if (this.m_formatterKey != null) {
            result = map.get(new CmsSharedSettingKey(includeName, this.m_formatterKey));
        }
        if (result == null) {
            result = map.get(new CmsSharedSettingKey(includeName, null));
        }
        return result;
    }

    private Map<String, CmsXmlContentProperty> resolveSettings(ImmutableList<CmsUUID> overrideSharedSettingsIds) {
        LinkedHashMap<String, CmsXmlContentProperty> result = new LinkedHashMap<String, CmsXmlContentProperty>();
        Map<CmsSharedSettingKey, CmsXmlContentProperty> sharedSettingDefinitions = this.combineSharedSettingDefinitionMaps(this.m_sharedSettingsIdsFromFormatter);
        Map<CmsSharedSettingKey, CmsXmlContentProperty> overrideSettingDefinitions = this.combineSharedSettingDefinitionMaps((List<CmsUUID>)overrideSharedSettingsIds);
        for (CmsXmlContentProperty settingDef : this.m_listedSettings) {
            String includeName = settingDef.getIncludeName(settingDef.getName());
            if (includeName == null) continue;
            CmsXmlContentProperty defaultSetting = this.getSharedSetting(sharedSettingDefinitions, includeName);
            CmsXmlContentProperty overrideSetting = this.getSharedSetting(overrideSettingDefinitions, includeName);
            CmsXmlContentProperty mergedSetting = settingDef;
            if (defaultSetting != null) {
                mergedSetting = mergedSetting.mergeDefaults(defaultSetting);
            }
            if (overrideSetting != null) {
                mergedSetting = overrideSetting.mergeDefaults(mergedSetting);
            }
            if (mergedSetting.getName() == null) continue;
            result.put(mergedSetting.getName(), mergedSetting);
        }
        if (this.m_displayType != null && !result.containsKey("displayType")) {
            CmsXmlContentProperty displayType = new CmsXmlContentProperty("displayType", "string", "hidden", null, null, null, this.m_displayType, null, null, null, null);
            result.put(displayType.getName(), displayType);
        }
        return Collections.unmodifiableMap(result);
    }
}

