/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsSettingTranslator {
    private static final Log LOG = CmsLog.getLog(CmsSettingTranslator.class);
    private CmsADEConfigData m_config;
    private HashMap<String, Map<String, CmsXmlContentProperty>> m_settingsCache = new HashMap();
    private Map<String, Map<String, String>> m_translationMapCache = new HashMap<String, Map<String, String>>();

    public CmsSettingTranslator(CmsADEConfigData config) {
        if (config == null) {
            throw new IllegalArgumentException("Sitemap configuration must  not be null.");
        }
        this.m_config = config;
    }

    public static Map<String, String> parseSettingTranslationMap(String translation) {
        String[] parts;
        if (translation == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String part : parts = translation.split("\\|")) {
            int colonPos = part.indexOf(":");
            if (colonPos == -1) continue;
            String left = part.substring(0, colonPos);
            left = left.trim();
            String right = part.substring(colonPos + 1);
            right = right.trim();
            result.put(right, left);
        }
        return result;
    }

    public Map<String, String> translateSettings(I_CmsFormatterBean formatter, Map<String, String> settings) {
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, CmsXmlContentProperty> settingDefsWithAliases = this.getSettingsForFormatter(formatter.getKeyOrId());
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Object targetKey = key;
            String targetValue = value;
            int underscorePos = key.indexOf("_");
            CmsXmlContentProperty matchingSetting = settingDefsWithAliases.get(key);
            if (matchingSetting != null) {
                targetKey = matchingSetting.getName();
                targetValue = this.translateValue(matchingSetting, value);
            } else if (underscorePos != -1) {
                String beforeUnderscore = key.substring(0, underscorePos);
                String afterUnderscore = key.substring(underscorePos + 1);
                CmsXmlContentProperty nestedSetting = this.getSettingsForFormatter(beforeUnderscore).get(afterUnderscore);
                if (nestedSetting != null) {
                    targetKey = beforeUnderscore + "_" + nestedSetting.getName();
                    targetValue = this.translateValue(nestedSetting, value);
                }
            }
            result.put((String)targetKey, targetValue);
        }
        return result;
    }

    protected Map<String, CmsXmlContentProperty> getSettingsForFormatter(String formatterKey) {
        return this.m_settingsCache.computeIfAbsent(formatterKey, k -> {
            I_CmsFormatterBean formatter = this.m_config.findFormatter((String)k, true);
            if (formatter != null) {
                Map<String, CmsXmlContentProperty> settings = formatter.getSettings(this.m_config);
                HashMap<String, CmsXmlContentProperty> result = new HashMap<String, CmsXmlContentProperty>();
                for (CmsXmlContentProperty settingDef : settings.values()) {
                    ArrayList<String> mapKeys = new ArrayList<String>();
                    mapKeys.add(settingDef.getName());
                    if (settingDef.getAliasName() != null) {
                        for (String item : CmsStringUtil.splitAsList(settingDef.getAliasName(), "|")) {
                            mapKeys.add(item.trim());
                        }
                    }
                    for (String mapKey : mapKeys) {
                        if (mapKey == null || null == result.put(mapKey, settingDef)) continue;
                        LOG.warn((Object)("Setting name collision for formatter " + formatterKey + ", setting " + mapKey));
                    }
                }
                return result;
            }
            return Collections.emptyMap();
        });
    }

    private String translateValue(CmsXmlContentProperty settingDef, String value) {
        if (settingDef.getTranslationStr() == null) {
            return value;
        }
        Map translationMap = this.m_translationMapCache.computeIfAbsent(settingDef.getTranslationStr(), translationStr -> CmsSettingTranslator.parseSettingTranslationMap(translationStr));
        String mappedValue = (String)translationMap.get(value);
        if (mappedValue != null) {
            return mappedValue;
        }
        return value;
    }
}

