/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.detailpage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.util.CmsPath;

public class CmsDetailPageFilter {
    public static final String PREFIX_CATEGORY = "category:";
    private static final Log LOG = CmsLog.getLog(CmsDetailPageFilter.class);
    private CmsObject m_cms;
    private CmsResource m_resource;
    private Set<CmsPath> m_categories;
    private String m_path;

    public CmsDetailPageFilter(CmsObject cms, CmsResource resource) {
        try {
            this.m_cms = OpenCms.initCmsObject(cms);
            this.m_cms.getRequestContext().setSiteRoot("");
            this.m_resource = resource;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public CmsDetailPageFilter(CmsObject cms, String rootPath) {
        try {
            this.m_cms = OpenCms.initCmsObject(cms);
            this.m_cms.getRequestContext().setSiteRoot("");
            this.m_path = rootPath;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public Stream<CmsDetailPageInfo> filterDetailPages(List<CmsDetailPageInfo> infos) {
        ArrayList<CmsDetailPageInfo> infos2 = new ArrayList<CmsDetailPageInfo>(infos);
        Collections.sort(infos2, new Comparator<CmsDetailPageInfo>(){

            @Override
            public int compare(CmsDetailPageInfo a, CmsDetailPageInfo b) {
                return Integer.compare(this.getSortKey(a), this.getSortKey(b));
            }

            private int getSortKey(CmsDetailPageInfo info) {
                boolean qualifierFlag;
                boolean defaultDetailFlag = info.getType().equals("##DEFAULT##");
                boolean bl = qualifierFlag = info.getQualifier() != null;
                if (!defaultDetailFlag) {
                    if (qualifierFlag) {
                        return 0;
                    }
                    return 1;
                }
                if (qualifierFlag) {
                    return 2;
                }
                return 3;
            }
        });
        if (!infos2.stream().anyMatch(detailPage -> detailPage.getQualifier() == null)) {
            if (infos2.size() != 0 && LOG.isWarnEnabled()) {
                LOG.warn((Object)("No unqualified detail page entries found in list - probably a configuration error: " + infos2));
            }
            return Collections.emptyList().stream();
        }
        return infos2.stream().filter(info -> info.getQualifier() == null || this.checkQualifier(info.getQualifier()));
    }

    protected boolean checkQualifier(String qualifier) {
        if (qualifier == null) {
            return true;
        }
        if ((qualifier = qualifier.trim()).startsWith(PREFIX_CATEGORY)) {
            String categoryStr = qualifier.substring(PREFIX_CATEGORY.length());
            CmsPath categoryPath = new CmsPath(categoryStr);
            return this.getCategories().contains(categoryPath);
        }
        LOG.error((Object)("Invalid detail page qualifier: " + qualifier));
        return false;
    }

    protected Set<CmsPath> getCategories() {
        if (this.m_categories == null) {
            this.m_categories = this.readCategories();
        }
        return this.m_categories;
    }

    protected Set<CmsPath> readCategories() {
        try {
            List<CmsCategory> categories;
            if (this.m_resource != null) {
                categories = CmsCategoryService.getInstance().readResourceCategories(this.m_cms, this.m_resource);
            } else {
                CmsResource resource = this.m_cms.readResource(this.m_path, CmsResourceFilter.IGNORE_EXPIRATION);
                categories = CmsCategoryService.getInstance().readResourceCategories(this.m_cms, resource);
            }
            HashSet<CmsPath> result = new HashSet<CmsPath>();
            for (CmsCategory category : categories) {
                result.add(new CmsPath(category.getPath()));
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }
}

