/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsUUID;
import org.opencms.xml.content.I_CmsXmlContentLocation;
import org.opencms.xml.content.I_CmsXmlContentValueLocation;
import org.opencms.xml.types.CmsXmlVfsFileValue;

public class CmsAddContentRestriction {
    public static final CmsAddContentRestriction EMPTY = new CmsAddContentRestriction();
    public static final String N_ENTRY = "Entry";
    public static final String N_RESOURCE = "Resource";
    public static final String N_TITLE = "Title";
    public static final String N_TYPE = "Type";
    public static final String TYPE_NAME = "add_content_replacement";
    private static final Log LOG = CmsLog.getLog(CmsAddContentRestriction.class);
    private Map<String, TypeEntry> m_entries = new HashMap<String, TypeEntry>();

    public CmsAddContentRestriction(Collection<TypeEntry> entries) {
        for (TypeEntry replacer : entries) {
            this.m_entries.put(replacer.getType(), replacer);
        }
    }

    private CmsAddContentRestriction() {
    }

    public static CmsAddContentRestriction read(CmsObject cms, I_CmsXmlContentLocation parent, String nodeName) {
        ArrayList<TypeEntry> entries = new ArrayList<TypeEntry>();
        for (I_CmsXmlContentValueLocation entryLoc : parent.getSubValues(nodeName)) {
            TypeEntry entry = CmsAddContentRestriction.readEntry(cms, entryLoc);
            entries.add(entry);
        }
        return new CmsAddContentRestriction(entries);
    }

    public static TypeEntry readEntry(CmsObject cms, I_CmsXmlContentValueLocation location) {
        String type = location.getSubValue(N_TYPE).getValue().getStringValue(cms).trim();
        HashMap<CmsUUID, String> titleMap = new HashMap<CmsUUID, String>();
        ArrayList<CmsResource> resourceList = new ArrayList<CmsResource>();
        for (I_CmsXmlContentValueLocation entryLoc : location.getSubValues(N_ENTRY)) {
            CmsXmlVfsFileValue resoureValue = (CmsXmlVfsFileValue)entryLoc.getSubValue(N_RESOURCE).getValue();
            CmsResource resource = resoureValue.getLink(cms).getResource();
            if (resource == null) continue;
            resourceList.add(resource);
            I_CmsXmlContentValueLocation titleLoc = entryLoc.getSubValue(N_TITLE);
            if (titleLoc == null) continue;
            String title = titleLoc.getValue().getStringValue(cms);
            titleMap.put(resource.getStructureId(), title);
        }
        return new TypeEntry(type, resourceList, titleMap, location.getValue().getDocument().getFile().getRootPath());
    }

    public List<CmsGallerySearchResult> getResult(CmsObject cms, String type) {
        TypeEntry replacer = this.m_entries.get(type);
        if (replacer == null) {
            return null;
        }
        return replacer.getResults(cms);
    }

    public Set<String> getTypes() {
        return Collections.unmodifiableSet(this.m_entries.keySet());
    }

    public CmsAddContentRestriction merge(CmsAddContentRestriction child) {
        HashMap<String, TypeEntry> combinedMap = new HashMap<String, TypeEntry>();
        combinedMap.putAll(this.m_entries);
        combinedMap.putAll(child.m_entries);
        return new CmsAddContentRestriction(combinedMap.values());
    }

    public static class TypeEntry {
        private String m_origin;
        private Map<CmsUUID, String> m_replacedTitles = new HashMap<CmsUUID, String>();
        private List<CmsResource> m_resources = new ArrayList<CmsResource>();
        private String m_type;

        public TypeEntry(String type, List<CmsResource> resources, Map<CmsUUID, String> titleReplacements, String origin) {
            this.m_type = type;
            this.m_resources = new ArrayList<CmsResource>(resources);
            this.m_replacedTitles = new HashMap<CmsUUID, String>(titleReplacements);
            this.m_origin = origin;
        }

        public String getOrigin() {
            return this.m_origin;
        }

        public List<CmsGallerySearchResult> getResults(CmsObject cms) {
            ArrayList<CmsGallerySearchResult> result = new ArrayList<CmsGallerySearchResult>();
            Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            CmsMacroResolver macroResolver = new CmsMacroResolver();
            macroResolver.setCmsObject(cms);
            macroResolver.setMessages(OpenCms.getWorkplaceManager().getMessages(locale));
            for (CmsResource res : this.m_resources) {
                try {
                    CmsResource currentRes = cms.readResource(res.getStructureId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                    CmsGallerySearchResult singleResult = CmsGallerySearch.searchById(cms, res.getStructureId(), locale);
                    String replacementTitle = this.m_replacedTitles.get(currentRes.getStructureId());
                    if (replacementTitle != null) {
                        replacementTitle = macroResolver.resolveMacros(replacementTitle);
                        singleResult = singleResult.withTitle(replacementTitle);
                    }
                    result.add(singleResult);
                }
                catch (CmsVfsResourceNotFoundException | CmsSecurityException e) {
                    LOG.debug((Object)("filtered resource " + res.getRootPath() + " (" + res.getStructureId() + ")"));
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return result;
        }

        public String getType() {
            return this.m_type;
        }
    }
}

