/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries;

import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.ade.galleries.shared.I_CmsGalleryProviderConstants;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;

public class CmsOpenGallery
extends CmsDialog {
    public CmsOpenGallery(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    public void openGallery() throws Exception {
        Object galleryPath = this.getParamResource();
        if (galleryPath != null && !((String)galleryPath).endsWith("/")) {
            galleryPath = (String)galleryPath + "/";
        }
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        Locale locale = OpenCms.getLocaleManager().getDefaultLocale(this.getCms(), (String)galleryPath);
        params.put("__locale", new String[]{locale.toString()});
        params.put("gallerymode", new String[]{I_CmsGalleryProviderConstants.GalleryMode.view.name()});
        try {
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)galleryPath)) {
                CmsResource galleryFolder = this.getCms().readResource((String)galleryPath);
                galleryPath = this.getCms().getSitePath(galleryFolder);
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        params.put("gallerypath", new String[]{galleryPath});
        params.put("resourcetypes", new String[]{""});
        this.sendForward("/system/workplace/commons/gallery.jsp", params);
    }
}

