/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.ade.configuration.CmsModelPageConfig;
import org.opencms.ade.configuration.CmsModelPageConfigWithoutResource;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.sitemap.CmsVfsSitemapService;
import org.opencms.ade.sitemap.Messages;
import org.opencms.ade.sitemap.shared.CmsModelInfo;
import org.opencms.ade.sitemap.shared.CmsModelPageEntry;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.shared.CmsListInfoBean;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsModelPageHelper {
    private static final Log LOG = CmsLog.getLog(CmsModelPageHelper.class);
    private CmsADEConfigData m_adeConfig;
    private CmsObject m_cms;
    private CmsResource m_rootResource;
    private String m_siteRoot;

    public CmsModelPageHelper(CmsObject cms, CmsResource rootResource) throws CmsException {
        this.m_cms = OpenCms.initCmsObject(cms);
        this.m_cms.getRequestContext().setSiteRoot("");
        this.m_rootResource = rootResource;
        this.m_adeConfig = OpenCms.getADEManager().lookupConfiguration(this.m_cms, rootResource.getRootPath());
        this.m_siteRoot = OpenCms.getSiteManager().getSiteRoot(rootResource.getRootPath());
        if (this.m_siteRoot == null) {
            this.m_siteRoot = "";
        }
    }

    public void addModelPageToSitemapConfiguration(CmsResource sitemapConfig, CmsResource modelPage, boolean disabled) throws CmsException {
        CmsFile sitemapConfigFile = this.m_cms.readFile(sitemapConfig);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, sitemapConfigFile);
        CmsConfigurationReader reader = new CmsConfigurationReader(this.m_cms);
        reader.parseConfiguration(this.m_adeConfig.getBasePath(), content);
        List<CmsModelPageConfigWithoutResource> modelPageConfigs = reader.getModelPageConfigs();
        int i = 0;
        boolean isDefault = false;
        for (CmsModelPageConfigWithoutResource config : modelPageConfigs) {
            if (config.getStructureId().equals(modelPage.getStructureId())) {
                isDefault = config.isDefault();
                break;
            }
            ++i;
        }
        if (i >= modelPageConfigs.size()) {
            content.addValue(this.m_cms, "ModelPage", Locale.ENGLISH, i);
        }
        String prefix = "ModelPage[" + (1 + i) + "]";
        content.getValue(prefix + "/Page", Locale.ENGLISH).setStringValue(this.m_cms, modelPage.getRootPath());
        content.getValue(prefix + "/Disabled", Locale.ENGLISH).setStringValue(this.m_cms, "" + disabled);
        content.getValue(prefix + "/IsDefault", Locale.ENGLISH).setStringValue(this.m_cms, "" + isDefault);
        this.writeSitemapConfig(content, sitemapConfigFile);
    }

    public CmsResource createModelGroupPage(String name, String description, CmsUUID copyId) throws CmsException {
        CmsResource newPage = null;
        CmsResourceTypeConfig config = this.m_adeConfig.getResourceType("modelgroup");
        if (config != null && !config.isDisabled()) {
            if (copyId == null) {
                newPage = config.createNewElement(this.m_cms, this.m_rootResource.getRootPath());
            } else {
                CmsResource copyResource = this.m_cms.readResource(copyId);
                newPage = config.createNewElement(this.m_cms, copyResource, this.m_rootResource.getRootPath());
            }
            this.m_cms.lockResource(newPage);
            CmsProperty titleProp = new CmsProperty("Title", name, null);
            CmsProperty descriptionProp = new CmsProperty("Description", description, null);
            this.m_cms.writePropertyObject(this.m_cms.getSitePath(newPage), titleProp);
            this.m_cms.writePropertyObject(this.m_cms.getSitePath(newPage), descriptionProp);
            this.tryUnlock(newPage);
        }
        return newPage;
    }

    public CmsResource createPageInModelFolder(String name, String description, CmsUUID copyId) throws CmsException {
        CmsResource modelFolder = this.ensureModelFolder(this.m_rootResource);
        String pattern = "templatemodel_%(number).html";
        String newFilePath = OpenCms.getResourceManager().getNameGenerator().getNewFileName(this.m_cms, CmsStringUtil.joinPaths(modelFolder.getRootPath(), pattern), 4);
        CmsProperty titleProp = new CmsProperty("Title", name, null);
        CmsProperty descriptionProp = new CmsProperty("Description", description, null);
        CmsResource newPage = null;
        if (copyId == null) {
            newPage = this.m_cms.createResource(newFilePath, this.getType(CmsResourceTypeXmlContainerPage.getStaticTypeName()), null, Arrays.asList(titleProp, descriptionProp));
        } else {
            CmsResource copyResource = this.m_cms.readResource(copyId);
            this.m_cms.copyResource(copyResource.getRootPath(), newFilePath);
            this.m_cms.writePropertyObject(newFilePath, titleProp);
            this.m_cms.writePropertyObject(newFilePath, descriptionProp);
            newPage = this.m_cms.readResource(newFilePath);
        }
        this.tryUnlock(newPage);
        return newPage;
    }

    public void disableModelPage(CmsResource sitemapConfig, CmsUUID structureId, boolean disabled) throws CmsException {
        I_CmsXmlContentValue value;
        CmsFile sitemapConfigFile = this.m_cms.readFile(sitemapConfig);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, sitemapConfigFile);
        CmsConfigurationReader reader = new CmsConfigurationReader(this.m_cms);
        reader.parseConfiguration(this.m_adeConfig.getBasePath(), content);
        List<CmsModelPageConfigWithoutResource> modelPageConfigs = reader.getModelPageConfigs();
        int i = 0;
        for (CmsModelPageConfigWithoutResource config : modelPageConfigs) {
            if (config.getStructureId().equals(structureId)) break;
            ++i;
        }
        if (i < modelPageConfigs.size()) {
            value = content.getValue("ModelPage", Locale.ENGLISH, i);
        } else {
            value = content.addValue(this.m_cms, "ModelPage", Locale.ENGLISH, i);
            String linkValuePath = value.getPath() + "/ModelPage";
            I_CmsXmlContentValue linkValue = content.hasValue(linkValuePath, Locale.ENGLISH) ? content.getValue(linkValuePath, Locale.ENGLISH) : content.addValue(this.m_cms, linkValuePath, Locale.ENGLISH, 0);
            CmsResource model = this.m_cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            linkValue.setStringValue(this.m_cms, this.m_cms.getSitePath(model));
        }
        String disabledPath = value.getPath() + "/Disabled";
        I_CmsXmlContentValue disabledValue = content.hasValue(disabledPath, Locale.ENGLISH) ? content.getValue(disabledPath, Locale.ENGLISH) : content.addValue(this.m_cms, disabledPath, Locale.ENGLISH, 0);
        disabledValue.setStringValue(this.m_cms, Boolean.toString(disabled));
        this.writeSitemapConfig(content, sitemapConfigFile);
    }

    public CmsResource ensureModelFolder(CmsResource rootResource) throws CmsException {
        String modelFolderPath = CmsStringUtil.joinPaths(this.m_adeConfig.getBasePath(), ".content/.templates");
        try {
            CmsFolder result = this.m_cms.readFolder(modelFolderPath);
            return result;
        }
        catch (CmsVfsResourceNotFoundException e) {
            CmsProperty searchExclude = new CmsProperty("search.exclude", "all", null);
            CmsResource result = this.m_cms.createResource(modelFolderPath, this.getType(CmsResourceTypeFolder.getStaticTypeName()), null, Arrays.asList(searchExclude));
            this.tryUnlock(result);
            return result;
        }
    }

    public List<CmsModelPageEntry> getModelGroups() {
        String modelGroupFolderPath;
        ArrayList<CmsModelPageEntry> result = new ArrayList<CmsModelPageEntry>();
        CmsResourceTypeConfig config = this.m_adeConfig.getResourceType("modelgroup");
        if (config != null && !config.isDisabled() && this.m_cms.existsResource(modelGroupFolderPath = config.getFolderPath(this.m_cms, this.m_adeConfig.getBasePath()))) {
            try {
                Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
                List<CmsResource> modelResources = this.m_cms.readResources(modelGroupFolderPath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(OpenCms.getResourceManager().getResourceType("modelgroup")), false);
                for (CmsResource model : modelResources) {
                    CmsModelPageEntry entry = this.createModelPageEntry(model, false, false, wpLocale);
                    if (entry == null) continue;
                    result.add(entry);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public CmsModelInfo getModelInfo() {
        return new CmsModelInfo(this.getModelPages(), this.getParentModelPages(), this.getModelGroups());
    }

    public List<CmsModelPageEntry> getModelPages() {
        List<CmsModelPageConfig> modelPageConfigs = this.m_adeConfig.getModelPages(true);
        return this.buildModelPageList(modelPageConfigs);
    }

    public List<CmsModelPageEntry> getParentModelPages() {
        CmsADEConfigData adeConfig = this.m_adeConfig.parent();
        if (adeConfig == null || adeConfig.isModuleConfiguration()) {
            return Collections.emptyList();
        }
        List<CmsModelPageConfig> modelPageConfigs = adeConfig.getModelPages();
        return this.buildModelPageList(modelPageConfigs);
    }

    public void removeModelPage(CmsResource sitemapConfig, CmsUUID structureId) throws CmsException {
        CmsFile sitemapConfigFile = this.m_cms.readFile(sitemapConfig);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, sitemapConfigFile);
        CmsConfigurationReader reader = new CmsConfigurationReader(this.m_cms);
        reader.parseConfiguration(this.m_adeConfig.getBasePath(), content);
        List<CmsModelPageConfigWithoutResource> modelPageConfigs = reader.getModelPageConfigs();
        int i = 0;
        for (CmsModelPageConfigWithoutResource config : modelPageConfigs) {
            if (config.getStructureId().equals(structureId)) break;
            ++i;
        }
        if (i < modelPageConfigs.size()) {
            content.removeValue("ModelPage", Locale.ENGLISH, i);
        }
        this.writeSitemapConfig(content, sitemapConfigFile);
    }

    CmsModelPageEntry createModelPageEntry(CmsResource resource, boolean disabled, boolean isDefault, Locale locale) {
        try {
            CmsModelPageEntry result = new CmsModelPageEntry();
            result.setDefault(isDefault);
            result.setDisabled(disabled);
            List<CmsProperty> properties = this.m_cms.readPropertyObjects(resource, false);
            HashMap clientProperties = Maps.newHashMap();
            for (CmsProperty prop : properties) {
                CmsClientProperty clientProp = CmsVfsSitemapService.createClientProperty(prop, false);
                clientProperties.put(prop.getName(), clientProp);
            }
            result.setOwnProperties(clientProperties);
            result.setRootPath(resource.getRootPath());
            if (resource.getRootPath().startsWith(this.m_siteRoot)) {
                CmsObject siteCms = OpenCms.initCmsObject(this.m_cms);
                siteCms.getRequestContext().setSiteRoot(this.m_siteRoot);
                result.setSitePath(siteCms.getSitePath(resource));
            }
            result.setResourceType(OpenCms.getResourceManager().getResourceType(resource).getTypeName());
            result.setStructureId(resource.getStructureId());
            CmsListInfoBean infoBean = CmsVfsService.getPageInfo(this.m_cms, resource);
            CmsProperty descProperty = this.m_cms.readPropertyObject(resource, "Description", false, locale);
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(descProperty.getValue())) {
                infoBean.setSubTitle(descProperty.getValue());
            }
            infoBean.addAdditionalInfo(Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms)).key("GUI_VFS_PATH_0"), result.getSitePath() != null ? result.getSitePath() : result.getRootPath());
            result.setListInfoBean(infoBean);
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    CmsModelInfo setDefaultModelPage(CmsResource configFile, CmsUUID modelId) throws CmsException {
        CmsFile file = this.m_cms.readFile(configFile);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, file);
        Locale locale = this.getLocale(content);
        int defaultValueIndex = -1;
        String defaultModelTarget = null;
        for (I_CmsXmlContentValue value : content.getValues("ModelPage", locale)) {
            I_CmsXmlContentValue linkValue = content.getValue(CmsStringUtil.joinPaths(value.getPath(), "Page"), locale);
            I_CmsXmlContentValue isDefaultValue = content.getValue(CmsStringUtil.joinPaths(value.getPath(), "IsDefault"), locale);
            CmsLink link = ((CmsXmlVfsFileValue)linkValue).getLink(this.m_cms);
            if (link != null && link.getStructureId().equals(modelId)) {
                defaultValueIndex = value.getIndex();
                defaultModelTarget = link.getTarget();
                continue;
            }
            isDefaultValue.setStringValue(this.m_cms, Boolean.FALSE.toString());
        }
        if (defaultValueIndex != -1) {
            content.removeValue("ModelPage", locale, defaultValueIndex);
            content.addValue(this.m_cms, "ModelPage", locale, 0);
            content.getValue("ModelPage[1]/Page", locale).setStringValue(this.m_cms, defaultModelTarget);
            content.getValue("ModelPage[1]/Disabled", locale).setStringValue(this.m_cms, Boolean.FALSE.toString());
            content.getValue("ModelPage[1]/IsDefault", locale).setStringValue(this.m_cms, Boolean.TRUE.toString());
        }
        content.setAutoCorrectionEnabled(true);
        content.correctXmlStructure(this.m_cms);
        file.setContents(content.marshal());
        this.m_cms.writeFile(file);
        OpenCms.getADEManager().waitForCacheUpdate(false);
        this.m_adeConfig = OpenCms.getADEManager().lookupConfiguration(this.m_cms, this.m_rootResource.getRootPath());
        return this.getModelInfo();
    }

    private List<CmsModelPageEntry> buildModelPageList(List<CmsModelPageConfig> modelPageConfigs) {
        ArrayList result = Lists.newArrayList();
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
        for (CmsModelPageConfig config : modelPageConfigs) {
            CmsUUID structureId = config.getResource().getStructureId();
            try {
                CmsResource modelPage = this.m_cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                CmsModelPageEntry entry = this.createModelPageEntry(modelPage, config.isDisabled(), config.isDefault(), wpLocale);
                if (entry == null) continue;
                result.add(entry);
            }
            catch (CmsVfsResourceNotFoundException e) {
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private Locale getLocale(CmsXmlContent content) {
        List<Locale> locales = content.getLocales();
        if (locales.contains(Locale.ENGLISH) || locales.isEmpty()) {
            return Locale.ENGLISH;
        }
        return locales.get(0);
    }

    private I_CmsResourceType getType(String name) throws CmsLoaderException {
        return OpenCms.getResourceManager().getResourceType(name);
    }

    private void tryUnlock(CmsResource resource) {
        try {
            this.m_cms.unlockResource(resource);
        }
        catch (Exception unlockError) {
            LOG.debug((Object)unlockError.getLocalizedMessage(), (Throwable)unlockError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSitemapConfig(CmsXmlContent content, CmsFile sitemapConfigFile) throws CmsXmlException, CmsException {
        content.correctXmlStructure(this.m_cms);
        byte[] contentBytes = content.marshal();
        sitemapConfigFile.setContents(contentBytes);
        try {
            CmsLock lock = this.m_cms.getLock(sitemapConfigFile);
            if (lock.isUnlocked() || !lock.isOwnedBy(this.m_cms.getRequestContext().getCurrentUser())) {
                this.m_cms.lockResourceTemporary(sitemapConfigFile);
            }
            this.m_cms.writeFile(sitemapConfigFile);
        }
        finally {
            this.m_cms.unlockResource(sitemapConfigFile);
        }
    }
}

