/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.upload;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.upload.I_CmsUploadRestriction;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.gwt.shared.CmsUploadRestrictionInfo;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;

public class CmsDefaultUploadRestriction
implements I_CmsUploadRestriction {
    private static final Log LOG = CmsLog.getLog(CmsDefaultUploadRestriction.class);
    private CmsObject m_cms;
    private CmsParameterConfiguration m_config = new CmsParameterConfiguration();

    public static I_CmsUploadRestriction unrestricted() {
        CmsDefaultUploadRestriction result = new CmsDefaultUploadRestriction();
        result.addConfigurationParameter("/", "enabled:true|types:*");
        return result;
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_config.add(paramName, paramValue);
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_config;
    }

    @Override
    public CmsUploadRestrictionInfo getUploadRestrictionInfo(CmsObject cms) {
        if (this.m_cms != null && !OpenCms.getRoleManager().hasRole(cms, CmsRole.ROOT_ADMIN)) {
            CmsUploadRestrictionInfo.Builder builder = new CmsUploadRestrictionInfo.Builder();
            for (Map.Entry<String, String> entry : this.m_config.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!key.startsWith("/")) continue;
                builder.add(key, value);
            }
            return builder.build();
        }
        return new CmsUploadRestrictionInfo.Builder().add("/", "enabled:true|types:*").build();
    }

    @Override
    public void initConfiguration() {
    }

    @Override
    public void setAdminCmsObject(CmsObject adminCms) {
        this.m_cms = adminCms;
    }
}

