/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cmis;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RelationshipTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionListImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.commons.logging.Log;
import org.opencms.cmis.I_CmsPropertyProvider;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.relations.CmsRelationType;

public class CmsCmisTypeManager {
    public static final String DOCUMENT_TYPE_ID = BaseTypeId.CMIS_DOCUMENT.value();
    public static final String FOLDER_TYPE_ID = BaseTypeId.CMIS_FOLDER.value();
    public static final String INHERITED_PREFIX = "opencms-inherited:";
    public static final String POLICY_TYPE_ID = BaseTypeId.CMIS_POLICY.value();
    public static final String PROPERTY_PREFIX = "opencms:";
    public static final String PROPERTY_PREFIX_DYNAMIC = "opencms-dynamic:";
    public static final String PROPERTY_PREFIX_SPECIAL = "opencms-special:";
    public static final String PROPERTY_RESOURCE_TYPE = "opencms-special:resource-type";
    public static final String RELATIONSHIP_TYPE_ID = BaseTypeId.CMIS_RELATIONSHIP.value();
    public static final long UPDATE_INTERVAL = 300000L;
    static final Log LOG = CmsLog.getLog(CmsCmisTypeManager.class);
    private static final String NAMESPACE = "http://opencms.org/opencms-cmis";
    private CmsObject m_adminCms;
    private List<CmsPropertyDefinition> m_cmsPropertyDefinitions;
    private long m_lastUpdate;
    private List<I_CmsPropertyProvider> m_propertyProviders = new ArrayList<I_CmsPropertyProvider>();
    private List<TypeDefinitionContainer> m_typeList;
    private Map<String, TypeDefinitionContainerImpl> m_types;

    public CmsCmisTypeManager(CmsObject adminCms, List<I_CmsPropertyProvider> propertyProviders) throws CmsException {
        this.m_adminCms = adminCms;
        this.m_propertyProviders = propertyProviders;
        this.setup();
    }

    private static void addBasePropertyDefinitions(AbstractTypeDefinition type) {
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:baseTypeId", "Base Type Id", "Base Type Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:objectId", "Object Id", "Object Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:objectTypeId", "Type Id", "Type Id", PropertyType.ID, Cardinality.SINGLE, Updatability.ONCREATE, false, true));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:name", "Name", "Name", PropertyType.STRING, Cardinality.SINGLE, Updatability.READWRITE, false, true));
        type.addPropertyDefinition(CmsCmisTypeManager.queryableAndOrderable(CmsCmisTypeManager.createPropDef("cmis:createdBy", "Created By", "Created By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false)));
        type.addPropertyDefinition(CmsCmisTypeManager.queryableAndOrderable(CmsCmisTypeManager.createPropDef("cmis:creationDate", "Creation Date", "Creation Date", PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, false, false)));
        type.addPropertyDefinition(CmsCmisTypeManager.queryableAndOrderable(CmsCmisTypeManager.createPropDef("cmis:lastModifiedBy", "Last Modified By", "Last Modified By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false)));
        type.addPropertyDefinition(CmsCmisTypeManager.queryableAndOrderable(CmsCmisTypeManager.createPropDef("cmis:lastModificationDate", "Last Modification Date", "Last Modification Date", PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, false, false)));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:changeToken", "Change Token", "Change Token", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
    }

    private static void addDocumentPropertyDefinitions(DocumentTypeDefinitionImpl type) {
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:isImmutable", "Is Immutable", "Is Immutable", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:isLatestVersion", "Is Latest Version", "Is Latest Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:isMajorVersion", "Is Major Version", "Is Major Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:isLatestMajorVersion", "Is Latest Major Version", "Is Latest Major Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:versionLabel", "Version Label", "Version Label", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:versionSeriesId", "Version Series Id", "Version Series Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:isVersionSeriesCheckedOut", "Is Verison Series Checked Out", "Is Verison Series Checked Out", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:versionSeriesCheckedOutId", "Version Series Checked Out Id", "Version Series Checked Out Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:versionSeriesCheckedOutBy", "Version Series Checked Out By", "Version Series Checked Out By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:checkinComment", "Checkin Comment", "Checkin Comment", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:contentStreamLength", "Content Stream Length", "Content Stream Length", PropertyType.INTEGER, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:contentStreamMimeType", "MIME Type", "MIME Type", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:contentStreamFileName", "Filename", "Filename", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:contentStreamId", "Content Stream Id", "Content Stream Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
    }

    private static void addFolderPropertyDefinitions(FolderTypeDefinitionImpl type) {
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:parentId", "Parent Id", "Parent Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:allowedChildObjectTypeIds", "Allowed Child Object Type Ids", "Allowed Child Object Type Ids", PropertyType.ID, Cardinality.MULTI, Updatability.READONLY, false, false));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:path", "Path", "Path", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
    }

    private static void addRelationPropertyDefinitions(RelationshipTypeDefinitionImpl type) {
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:sourceId", "Source", "Source", PropertyType.ID, Cardinality.SINGLE, Updatability.ONCREATE, false, true));
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef("cmis:targetId", "Target", "Target", PropertyType.ID, Cardinality.SINGLE, Updatability.ONCREATE, false, true));
    }

    private static TypeDefinition copyTypeDefintion(TypeDefinition type) {
        return WSConverter.convert((CmisTypeDefinitionType)WSConverter.convert((TypeDefinition)type));
    }

    private static AbstractPropertyDefinition<?> createPropDef(String id, String displayName, String description, PropertyType datatype, Cardinality cardinality, Updatability updateability, boolean inherited, boolean required) {
        PropertyBooleanDefinitionImpl result = null;
        switch (datatype) {
            case BOOLEAN: {
                result = new PropertyBooleanDefinitionImpl();
                break;
            }
            case DATETIME: {
                result = new PropertyDateTimeDefinitionImpl();
                break;
            }
            case DECIMAL: {
                result = new PropertyDecimalDefinitionImpl();
                break;
            }
            case HTML: {
                result = new PropertyHtmlDefinitionImpl();
                break;
            }
            case ID: {
                result = new PropertyIdDefinitionImpl();
                break;
            }
            case INTEGER: {
                result = new PropertyIntegerDefinitionImpl();
                break;
            }
            case STRING: {
                result = new PropertyStringDefinitionImpl();
                break;
            }
            case URI: {
                result = new PropertyUriDefinitionImpl();
                break;
            }
            default: {
                throw new RuntimeException("Unknown datatype! Spec change?");
            }
        }
        result.setId(id);
        result.setLocalName(id);
        result.setDisplayName(displayName);
        result.setDescription(description);
        result.setPropertyType(datatype);
        result.setCardinality(cardinality);
        result.setUpdatability(updateability);
        result.setIsInherited(Boolean.valueOf(inherited));
        result.setIsRequired(Boolean.valueOf(required));
        result.setIsQueryable(Boolean.FALSE);
        result.setIsOrderable(Boolean.FALSE);
        result.setQueryName(id);
        return result;
    }

    private static AbstractPropertyDefinition<?> queryableAndOrderable(AbstractPropertyDefinition<?> propDef) {
        propDef.setIsQueryable(Boolean.TRUE);
        propDef.setIsOrderable(Boolean.TRUE);
        return propDef;
    }

    public List<String> getCmsPropertyNames() {
        this.refresh();
        ArrayList<String> result = new ArrayList<String>();
        for (CmsPropertyDefinition propDef : this.m_cmsPropertyDefinitions) {
            result.add(propDef.getName());
        }
        return result;
    }

    public I_CmsPropertyProvider getPropertyProvider(String key) {
        if (key.startsWith(PROPERTY_PREFIX_DYNAMIC)) {
            key = key.substring(PROPERTY_PREFIX_DYNAMIC.length());
        }
        for (I_CmsPropertyProvider provider : this.m_propertyProviders) {
            if (!provider.getName().equals(key)) continue;
            return provider;
        }
        return null;
    }

    public List<I_CmsPropertyProvider> getPropertyProviders() {
        return Collections.unmodifiableList(this.m_propertyProviders);
    }

    public TypeDefinition getType(String typeId) {
        this.refresh();
        TypeDefinitionContainer tc = (TypeDefinitionContainer)this.m_types.get(typeId);
        if (tc == null) {
            return null;
        }
        return tc.getTypeDefinition();
    }

    public TypeDefinitionList getTypeChildren(String typeId, boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount) {
        int max;
        int skip;
        this.refresh();
        TypeDefinitionListImpl result = new TypeDefinitionListImpl(new ArrayList());
        int n = skip = skipCount == null ? 0 : skipCount.intValue();
        if (skip < 0) {
            skip = 0;
        }
        int n2 = max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        if (max < 1) {
            return result;
        }
        if (typeId == null) {
            if (skip < 1) {
                result.getList().add(CmsCmisTypeManager.copyTypeDefintion(this.m_types.get(FOLDER_TYPE_ID).getTypeDefinition()));
                --max;
            }
            if (skip < 2 && max > 0) {
                result.getList().add(CmsCmisTypeManager.copyTypeDefintion(this.m_types.get(DOCUMENT_TYPE_ID).getTypeDefinition()));
                --max;
            }
            result.setHasMoreItems(Boolean.valueOf(result.getList().size() + skip < 2));
            result.setNumItems(BigInteger.valueOf(2L));
        } else {
            TypeDefinitionContainer tc = (TypeDefinitionContainer)this.m_types.get(typeId);
            if (tc == null || tc.getChildren() == null) {
                return result;
            }
            for (TypeDefinitionContainer child : tc.getChildren()) {
                if (skip > 0) {
                    --skip;
                    continue;
                }
                result.getList().add(CmsCmisTypeManager.copyTypeDefintion(child.getTypeDefinition()));
                if (--max != 0) continue;
                break;
            }
            result.setHasMoreItems(Boolean.valueOf(result.getList().size() + skip < tc.getChildren().size()));
            result.setNumItems(BigInteger.valueOf(tc.getChildren().size()));
        }
        if (!includePropertyDefinitions) {
            for (TypeDefinition type : result.getList()) {
                type.getPropertyDefinitions().clear();
            }
        }
        return result;
    }

    public TypeDefinition getTypeDefinition(String typeId) {
        this.refresh();
        TypeDefinitionContainer tc = (TypeDefinitionContainer)this.m_types.get(typeId);
        if (tc == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        return CmsCmisTypeManager.copyTypeDefintion(tc.getTypeDefinition());
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String typeId, BigInteger depth, boolean includePropertyDefinitions) {
        int d;
        this.refresh();
        ArrayList<TypeDefinitionContainer> result = new ArrayList<TypeDefinitionContainer>();
        int n = d = depth == null ? -1 : depth.intValue();
        if (d == 0) {
            throw new CmisInvalidArgumentException("Depth must not be 0!");
        }
        if (typeId == null) {
            result.add(this.getTypeDescendants(d, (TypeDefinitionContainer)this.m_types.get(FOLDER_TYPE_ID), includePropertyDefinitions));
            result.add(this.getTypeDescendants(d, (TypeDefinitionContainer)this.m_types.get(DOCUMENT_TYPE_ID), includePropertyDefinitions));
            result.add(this.getTypeDescendants(d, (TypeDefinitionContainer)this.m_types.get(RELATIONSHIP_TYPE_ID), includePropertyDefinitions));
        } else {
            TypeDefinitionContainer tc = (TypeDefinitionContainer)this.m_types.get(typeId);
            if (tc != null) {
                result.add(this.getTypeDescendants(d, tc, includePropertyDefinitions));
            }
        }
        return result;
    }

    PropertyDefinition<?> createOpenCmsPropertyDefinition(CmsPropertyDefinition cmsDef) {
        return CmsCmisTypeManager.createPropDef(PROPERTY_PREFIX + cmsDef.getName(), cmsDef.getName(), cmsDef.getName(), PropertyType.STRING, Cardinality.SINGLE, Updatability.READWRITE, false, false);
    }

    void setup() throws CmsException {
        this.m_types = new HashMap<String, TypeDefinitionContainerImpl>();
        this.m_typeList = new ArrayList<TypeDefinitionContainer>();
        this.m_cmsPropertyDefinitions = this.m_adminCms.readAllPropertyDefinitions();
        FolderTypeDefinitionImpl folderType = new FolderTypeDefinitionImpl();
        folderType.setBaseTypeId(BaseTypeId.CMIS_FOLDER);
        folderType.setIsControllableAcl(Boolean.TRUE);
        folderType.setIsControllablePolicy(Boolean.FALSE);
        folderType.setIsCreatable(Boolean.TRUE);
        folderType.setDescription("Folder");
        folderType.setDisplayName("Folder");
        folderType.setIsFileable(Boolean.TRUE);
        folderType.setIsFulltextIndexed(Boolean.FALSE);
        folderType.setIsIncludedInSupertypeQuery(Boolean.TRUE);
        folderType.setLocalName("Folder");
        folderType.setLocalNamespace(NAMESPACE);
        folderType.setIsQueryable(Boolean.TRUE);
        folderType.setQueryName("cmis:folder");
        folderType.setId(FOLDER_TYPE_ID);
        CmsCmisTypeManager.addBasePropertyDefinitions((AbstractTypeDefinition)folderType);
        CmsCmisTypeManager.addFolderPropertyDefinitions(folderType);
        this.addCmsPropertyDefinitions((AbstractTypeDefinition)folderType);
        this.addProviderPropertyDefinitions((AbstractTypeDefinition)folderType);
        this.addTypeInternal((AbstractTypeDefinition)folderType);
        DocumentTypeDefinitionImpl documentType = new DocumentTypeDefinitionImpl();
        documentType.setBaseTypeId(BaseTypeId.CMIS_DOCUMENT);
        documentType.setIsControllableAcl(Boolean.TRUE);
        documentType.setIsControllablePolicy(Boolean.FALSE);
        documentType.setIsCreatable(Boolean.TRUE);
        documentType.setDescription("Document");
        documentType.setDisplayName("Document");
        documentType.setIsFileable(Boolean.TRUE);
        documentType.setIsFulltextIndexed(Boolean.FALSE);
        documentType.setIsIncludedInSupertypeQuery(Boolean.TRUE);
        documentType.setLocalName("Document");
        documentType.setLocalNamespace(NAMESPACE);
        documentType.setIsQueryable(Boolean.TRUE);
        documentType.setQueryName("cmis:document");
        documentType.setId(DOCUMENT_TYPE_ID);
        documentType.setIsVersionable(Boolean.FALSE);
        documentType.setContentStreamAllowed(ContentStreamAllowed.REQUIRED);
        CmsCmisTypeManager.addBasePropertyDefinitions((AbstractTypeDefinition)documentType);
        CmsCmisTypeManager.addDocumentPropertyDefinitions(documentType);
        this.addCmsPropertyDefinitions((AbstractTypeDefinition)documentType);
        this.addProviderPropertyDefinitions((AbstractTypeDefinition)documentType);
        this.addTypeInternal((AbstractTypeDefinition)documentType);
        RelationshipTypeDefinitionImpl relationshipType = new RelationshipTypeDefinitionImpl();
        relationshipType.setBaseTypeId(BaseTypeId.CMIS_RELATIONSHIP);
        relationshipType.setIsControllableAcl(Boolean.FALSE);
        relationshipType.setIsControllablePolicy(Boolean.FALSE);
        relationshipType.setIsCreatable(Boolean.FALSE);
        relationshipType.setDescription("Relationship");
        relationshipType.setDisplayName("Relationship");
        relationshipType.setIsFileable(Boolean.FALSE);
        relationshipType.setIsIncludedInSupertypeQuery(Boolean.TRUE);
        relationshipType.setLocalName("Relationship");
        relationshipType.setLocalNamespace(NAMESPACE);
        relationshipType.setIsQueryable(Boolean.FALSE);
        relationshipType.setQueryName("cmis:relationship");
        relationshipType.setId(RELATIONSHIP_TYPE_ID);
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("cmis:document");
        typeList.add("cmis:folder");
        relationshipType.setAllowedSourceTypes(typeList);
        relationshipType.setAllowedTargetTypes(typeList);
        CmsCmisTypeManager.addBasePropertyDefinitions((AbstractTypeDefinition)relationshipType);
        CmsCmisTypeManager.addRelationPropertyDefinitions(relationshipType);
        this.addTypeInternal((AbstractTypeDefinition)relationshipType);
        for (CmsRelationType relType : CmsRelationType.getAll()) {
            this.createRelationshipType(relType);
        }
        this.m_lastUpdate = System.currentTimeMillis();
    }

    private void addCmsPropertyDefinitions(AbstractTypeDefinition type) {
        for (CmsPropertyDefinition propDef : this.m_cmsPropertyDefinitions) {
            type.addPropertyDefinition(this.createOpenCmsPropertyDefinition(propDef));
            type.addPropertyDefinition(CmsCmisTypeManager.createPropDef(INHERITED_PREFIX + propDef.getName(), propDef.getName(), propDef.getName(), PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        }
        type.addPropertyDefinition(CmsCmisTypeManager.createPropDef(PROPERTY_RESOURCE_TYPE, "Resource type", "Resource type", PropertyType.STRING, Cardinality.SINGLE, Updatability.ONCREATE, false, true));
    }

    private void addProviderPropertyDefinitions(AbstractTypeDefinition type) {
        for (I_CmsPropertyProvider provider : this.m_propertyProviders) {
            type.addPropertyDefinition(CmsCmisTypeManager.createPropDef(PROPERTY_PREFIX_DYNAMIC + provider.getName(), provider.getName(), provider.getName(), PropertyType.STRING, Cardinality.SINGLE, provider.isWritable() ? Updatability.READWRITE : Updatability.READONLY, false, false));
        }
    }

    private boolean addType(TypeDefinition type) {
        if (type == null) {
            return false;
        }
        if (type.getBaseTypeId() == null) {
            return false;
        }
        TypeDefinition baseType = null;
        if (type.getBaseTypeId() == BaseTypeId.CMIS_DOCUMENT) {
            baseType = CmsCmisTypeManager.copyTypeDefintion(this.m_types.get(DOCUMENT_TYPE_ID).getTypeDefinition());
        } else if (type.getBaseTypeId() == BaseTypeId.CMIS_FOLDER) {
            baseType = CmsCmisTypeManager.copyTypeDefintion(this.m_types.get(FOLDER_TYPE_ID).getTypeDefinition());
        } else if (type.getBaseTypeId() == BaseTypeId.CMIS_RELATIONSHIP) {
            baseType = CmsCmisTypeManager.copyTypeDefintion(this.m_types.get(RELATIONSHIP_TYPE_ID).getTypeDefinition());
        } else if (type.getBaseTypeId() == BaseTypeId.CMIS_POLICY) {
            baseType = CmsCmisTypeManager.copyTypeDefintion(this.m_types.get(POLICY_TYPE_ID).getTypeDefinition());
        } else {
            return false;
        }
        AbstractTypeDefinition newType = (AbstractTypeDefinition)CmsCmisTypeManager.copyTypeDefintion(type);
        for (PropertyDefinition propDef : baseType.getPropertyDefinitions().values()) {
            ((AbstractPropertyDefinition)propDef).setIsInherited(Boolean.TRUE);
            newType.addPropertyDefinition(propDef);
        }
        this.addTypeInternal(newType);
        return true;
    }

    private void addTypeInternal(AbstractTypeDefinition type) {
        TypeDefinitionContainerImpl tdc;
        if (type == null) {
            return;
        }
        if (this.m_types.containsKey(type.getId())) {
            return;
        }
        TypeDefinitionContainerImpl tc = new TypeDefinitionContainerImpl();
        tc.setTypeDefinition((TypeDefinition)type);
        if (type.getParentTypeId() != null && (tdc = this.m_types.get(type.getParentTypeId())) != null) {
            if (tdc.getChildren() == null) {
                tdc.setChildren(new ArrayList());
            }
            tdc.getChildren().add(tc);
        }
        this.m_types.put(type.getId(), tc);
        this.m_typeList.add((TypeDefinitionContainer)tc);
    }

    private void createRelationshipType(CmsRelationType relType) {
        RelationshipTypeDefinitionImpl relationshipType = new RelationshipTypeDefinitionImpl();
        relationshipType.setBaseTypeId(BaseTypeId.CMIS_RELATIONSHIP);
        relationshipType.setParentTypeId(RELATIONSHIP_TYPE_ID);
        relationshipType.setIsControllableAcl(Boolean.FALSE);
        relationshipType.setIsControllablePolicy(Boolean.FALSE);
        relationshipType.setIsCreatable(Boolean.valueOf(!relType.isDefinedInContent()));
        relationshipType.setDescription(relType.getName());
        relationshipType.setDisplayName(relType.getName());
        relationshipType.setIsFileable(Boolean.FALSE);
        relationshipType.setIsIncludedInSupertypeQuery(Boolean.TRUE);
        relationshipType.setLocalName(relType.getName());
        relationshipType.setLocalNamespace(NAMESPACE);
        relationshipType.setIsQueryable(Boolean.FALSE);
        String id = PROPERTY_PREFIX + relType.getName().toUpperCase();
        relationshipType.setQueryName(id);
        relationshipType.setId(id);
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("cmis:document");
        typeList.add("cmis:folder");
        relationshipType.setAllowedSourceTypes(typeList);
        relationshipType.setAllowedTargetTypes(typeList);
        this.addType((TypeDefinition)relationshipType);
    }

    private TypeDefinitionContainer getTypeDescendants(int depth, TypeDefinitionContainer tc, boolean includePropertyDefinitions) {
        TypeDefinitionContainerImpl result = new TypeDefinitionContainerImpl();
        TypeDefinition type = CmsCmisTypeManager.copyTypeDefintion(tc.getTypeDefinition());
        if (!includePropertyDefinitions) {
            type.getPropertyDefinitions().clear();
        }
        result.setTypeDefinition(type);
        if (depth != 0 && tc.getChildren() != null) {
            result.setChildren(new ArrayList());
            for (TypeDefinitionContainer tdc : tc.getChildren()) {
                result.getChildren().add(this.getTypeDescendants(depth < 0 ? -1 : depth - 1, tdc, includePropertyDefinitions));
            }
        }
        return result;
    }

    private synchronized void refresh() {
        try {
            long now = System.currentTimeMillis();
            if (now - this.m_lastUpdate > 300000L) {
                this.setup();
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

