/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.dom4j.Element;
import org.opencms.util.CmsStringUtil;

public class CmsParameterConfiguration
extends AbstractMap<String, String>
implements Serializable {
    public static final CmsParameterConfiguration EMPTY_PARAMETERS = new CmsParameterConfiguration(Collections.emptyMap(), Collections.emptyMap());
    private static final long serialVersionUID = 294679648036460877L;
    private transient Map<String, Serializable> m_configurationObjects;
    private Map<String, String> m_configurationStrings;

    public CmsParameterConfiguration() {
        this(new TreeMap<String, String>(), new TreeMap<String, Serializable>());
    }

    public CmsParameterConfiguration(InputStream in) throws IOException {
        this();
        this.load(in);
    }

    public CmsParameterConfiguration(Map<String, String> configuration) {
        this();
        for (String key : configuration.keySet()) {
            String value = configuration.get(key);
            this.add(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsParameterConfiguration(String file) throws IOException {
        this();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.load(in);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private CmsParameterConfiguration(Map<String, String> strings, Map<String, Serializable> objects) {
        this.m_configurationStrings = strings;
        this.m_configurationObjects = objects;
    }

    public static CmsParameterConfiguration unmodifiableVersion(CmsParameterConfiguration original) {
        return new CmsParameterConfiguration(Collections.unmodifiableMap(original.m_configurationStrings), original.m_configurationObjects);
    }

    protected static int countPreceding(String line, int index, char ch) {
        int i;
        for (i = index - 1; i >= 0 && line.charAt(i) == ch; --i) {
        }
        return index - 1 - i;
    }

    protected static boolean endsWithSlash(String line) {
        if (!line.endsWith("\\")) {
            return false;
        }
        return CmsParameterConfiguration.countPreceding(line, line.length() - 1, '\\') % 2 == 0;
    }

    protected static String unescape(String value) {
        value = CmsStringUtil.substitute(value, "\\,", ",");
        value = CmsStringUtil.substitute(value, "\\=", "=");
        value = CmsStringUtil.substitute(value, "\\\\", "\\");
        return value;
    }

    public void add(String key, String value) {
        this.add(key, value, false);
    }

    public Element appendToXml(Element parentNode) {
        return this.appendToXml(parentNode, null);
    }

    public Element appendToXml(Element parentNode, List<String> parametersToIgnore) {
        for (Map.Entry<String, Serializable> entry : this.m_configurationObjects.entrySet()) {
            String name = entry.getKey();
            if (parametersToIgnore != null && parametersToIgnore.contains(name)) continue;
            Serializable value = entry.getValue();
            if (value instanceof List) {
                List values = (List)((Object)value);
                for (String strValue : values) {
                    Element paramNode = parentNode.addElement("param");
                    paramNode.addAttribute("name", name);
                    paramNode.addText(strValue);
                }
                continue;
            }
            String strValue = this.get(name);
            Element paramNode = parentNode.addElement("param");
            paramNode.addAttribute("name", name);
            paramNode.addText(strValue);
        }
        return parentNode;
    }

    @Override
    public void clear() {
        this.m_configurationStrings.clear();
        this.m_configurationObjects.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_configurationStrings.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m_configurationStrings.containsValue(value) || this.m_configurationObjects.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.m_configurationStrings.entrySet();
    }

    @Override
    public String get(Object key) {
        return this.m_configurationStrings.get(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Serializable value = this.m_configurationObjects.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            Boolean b = Boolean.valueOf((String)((Object)value));
            this.m_configurationObjects.put(key, b);
            return b;
        }
        return defaultValue;
    }

    public int getInteger(String key, int defaultValue) {
        Serializable value = this.m_configurationObjects.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            Integer i = Integer.valueOf((String)((Object)value));
            this.m_configurationObjects.put(key, i);
            return i;
        }
        return defaultValue;
    }

    public List<String> getList(String key) {
        return this.getList(key, null);
    }

    public List<String> getList(String key, List<String> defaultValue) {
        Serializable value = this.m_configurationObjects.get(key);
        if (value instanceof List) {
            List result = (List)((Object)value);
            return new ArrayList<String>(result);
        }
        if (value instanceof String) {
            ArrayList<String> values = new ArrayList<String>(1);
            values.add((String)((Object)value));
            this.m_configurationObjects.put(key, values);
            return values;
        }
        if (defaultValue == null) {
            return new ArrayList<String>();
        }
        return defaultValue;
    }

    public Object getObject(String key) {
        return this.m_configurationObjects.get(key);
    }

    public Properties getPrefixedProperties(String keyPrefix) {
        Properties props = new Properties();
        if (null == keyPrefix) {
            return props;
        }
        String dotTerminatedKeyPrefix = keyPrefix + (keyPrefix.endsWith(".") ? "" : ".");
        for (Map.Entry<String, String> e : this.entrySet()) {
            String key = e.getKey();
            if (null == key || !key.startsWith(dotTerminatedKeyPrefix)) continue;
            String subKey = key.substring(dotTerminatedKeyPrefix.length());
            props.put(subKey, e.getValue());
        }
        return props;
    }

    public String getString(String key, String defaultValue) {
        String result = this.get(key);
        return result == null ? defaultValue : result;
    }

    @Override
    public int hashCode() {
        return this.m_configurationStrings.hashCode();
    }

    @Override
    public Set<String> keySet() {
        return this.m_configurationStrings.keySet();
    }

    public void load(InputStream input) throws IOException {
        ParameterReader reader = null;
        try {
            reader = new ParameterReader(new InputStreamReader(input, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException ex) {
            reader = new ParameterReader(new InputStreamReader(input));
        }
        String line;
        while ((line = reader.readParameter()) != null) {
            int equalSign = line.indexOf(61);
            if (equalSign <= 0) continue;
            String key = line.substring(0, equalSign).trim();
            String value = line.substring(equalSign + 1).trim();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) continue;
            this.add(key, value, true);
        }
        return;
    }

    @Override
    public String put(String key, String value) {
        String result = this.remove(key);
        this.add(key, value, false);
        return result;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> other) {
        for (String string : other.keySet()) {
            Object o;
            boolean tokenize = false;
            if (other instanceof CmsParameterConfiguration && (o = ((CmsParameterConfiguration)other).getObject(string)) instanceof List) {
                tokenize = true;
            }
            this.add(string, other.get(string), tokenize);
        }
    }

    @Override
    public String remove(Object key) {
        String result = this.m_configurationStrings.remove(key);
        this.m_configurationObjects.remove(key);
        return result;
    }

    @Override
    public String toString() {
        return this.m_configurationStrings.toString();
    }

    @Override
    public Collection<String> values() {
        return this.m_configurationStrings.values();
    }

    private void add(String key, String value, boolean tokenize) {
        if (tokenize && value.indexOf(",") > 0) {
            ParameterTokenizer tokenizer = new ParameterTokenizer(value);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                this.addInternal(key, CmsParameterConfiguration.unescape(token));
            }
        } else if (tokenize) {
            this.addInternal(key, CmsParameterConfiguration.unescape(value));
        } else {
            this.addInternal(key, value);
        }
    }

    private void addInternal(String key, String value) {
        Serializable currentObj = this.m_configurationObjects.get(key);
        String currentStr = this.get(key);
        if (currentObj instanceof String) {
            ArrayList<String> values = new ArrayList<String>(2);
            values.add(currentStr);
            values.add(value);
            this.m_configurationObjects.put(key, values);
            this.m_configurationStrings.put(key, currentStr + "," + value);
        } else if (currentObj instanceof List) {
            List list = (List)((Object)currentObj);
            list.add(value);
            this.m_configurationStrings.put(key, currentStr + "," + value);
        } else {
            this.m_configurationObjects.put(key, (Serializable)((Object)value));
            this.m_configurationStrings.put(key, value);
        }
    }

    protected static class ParameterReader
    extends LineNumberReader {
        public ParameterReader(Reader reader) {
            super(reader);
        }

        public String readParameter() throws IOException {
            StringBuffer buffer = new StringBuffer();
            String line = this.readLine();
            while (line != null) {
                if ((line = line.trim()).length() != 0 && line.charAt(0) != '#') {
                    if (CmsParameterConfiguration.endsWithSlash(line)) {
                        line = line.substring(0, line.length() - 1);
                        buffer.append(line);
                    } else {
                        buffer.append(line);
                        return buffer.toString();
                    }
                }
                line = this.readLine();
            }
            return null;
        }
    }

    protected static class ParameterTokenizer
    extends StringTokenizer {
        static final String COMMA = ",";

        public ParameterTokenizer(String string) {
            super(string, COMMA);
        }

        @Override
        public String nextToken() {
            StringBuffer buffer = new StringBuffer();
            while (this.hasMoreTokens()) {
                String token = super.nextToken();
                if (CmsParameterConfiguration.endsWithSlash(token)) {
                    buffer.append(token.substring(0, token.length() - 1));
                    buffer.append(COMMA);
                    continue;
                }
                buffer.append(token);
                break;
            }
            return buffer.toString().trim();
        }
    }
}

