/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.digester3.Digester;
import org.dom4j.Element;
import org.opencms.configuration.A_CmsXmlConfiguration;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.Messages;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.scheduler.CmsScheduleManager;
import org.opencms.scheduler.CmsScheduledJobInfo;

public class CmsSchedulerConfiguration
extends A_CmsXmlConfiguration {
    public static final String CONFIGURATION_DTD_NAME = "opencms-scheduler.dtd";
    public static final String DEFAULT_XML_FILE_NAME = "opencms-scheduler.xml";
    public static final String N_ACTIVE = "active";
    public static final String N_CLASS = "class";
    public static final String N_CONTEXT = "context";
    public static final String N_CRONEXPRESSION = "cronexpression";
    public static final String N_ENCODING = "encoding";
    public static final String N_JOB = "job";
    public static final String N_LOCALE = "locale";
    public static final String N_PARAMETERS = "parameters";
    public static final String N_PROJECT = "project";
    public static final String N_REMOTEADDR = "remoteaddr";
    public static final String N_REQUESTEDURI = "requesteduri";
    public static final String N_REUSEINSTANCE = "reuseinstance";
    public static final String N_SCHEDULER = "scheduler";
    public static final String N_SITEROOT = "siteroot";
    public static final String N_USERNAME = "user";
    private List<CmsScheduledJobInfo> m_configuredJobs;
    private CmsScheduleManager m_scheduleManager;

    public void addJobFromConfiguration(CmsScheduledJobInfo jobInfo) {
        this.m_configuredJobs.add(jobInfo);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SCHEDULER_CONFIG_JOB_3", jobInfo.getJobName(), jobInfo.getClassName(), jobInfo.getContextInfo().getUserName()));
        }
    }

    public void addScheduleManager() {
        this.m_scheduleManager = new CmsScheduleManager(this.m_configuredJobs);
    }

    @Override
    public void addXmlDigesterRules(Digester digester) {
        digester.addCallMethod("*/scheduler", "addScheduleManager");
        digester.addObjectCreate("*/scheduler/job", CmsScheduledJobInfo.class);
        digester.addBeanPropertySetter("*/scheduler/job/name", "jobName");
        digester.addBeanPropertySetter("*/scheduler/job/class", "className");
        digester.addBeanPropertySetter("*/scheduler/job/cronexpression", "cronExpression");
        digester.addBeanPropertySetter("*/scheduler/job/reuseinstance", "reuseInstance");
        digester.addBeanPropertySetter("*/scheduler/job/active", N_ACTIVE);
        digester.addSetNext("*/scheduler/job", "addJobFromConfiguration");
        digester.addObjectCreate("*/scheduler/job/context", CmsContextInfo.class);
        digester.addBeanPropertySetter("*/scheduler/job/context/user", "userName");
        digester.addBeanPropertySetter("*/scheduler/job/context/project", "projectName");
        digester.addBeanPropertySetter("*/scheduler/job/context/siteroot", "siteRoot");
        digester.addBeanPropertySetter("*/scheduler/job/context/requesteduri", "requestedUri");
        digester.addBeanPropertySetter("*/scheduler/job/context/locale", "localeName");
        digester.addBeanPropertySetter("*/scheduler/job/context/encoding");
        digester.addBeanPropertySetter("*/scheduler/job/context/remoteaddr", "remoteAddr");
        digester.addSetNext("*/scheduler/job/context", "setContextInfo");
        digester.addCallMethod("*/param", "addConfigurationParameter", 2);
        digester.addCallParam("*/param", 0, "name");
        digester.addCallParam("*/param", 1);
    }

    @Override
    public Element generateXml(Element parent) {
        Element schedulerElement = parent.addElement(N_SCHEDULER);
        if (OpenCms.getRunLevel() >= 3) {
            this.m_configuredJobs = OpenCms.getScheduleManager().getJobs();
        }
        for (CmsScheduledJobInfo jobInfo : this.m_configuredJobs) {
            Element jobElement = schedulerElement.addElement(N_JOB);
            jobElement.addElement("name").addText(jobInfo.getJobName());
            jobElement.addElement(N_CLASS).addText(jobInfo.getClassName());
            jobElement.addElement(N_REUSEINSTANCE).addText(String.valueOf(jobInfo.isReuseInstance()));
            jobElement.addElement(N_ACTIVE).addText(String.valueOf(jobInfo.isActive()));
            jobElement.addElement(N_CRONEXPRESSION).addCDATA(jobInfo.getCronExpression());
            Element contextElement = jobElement.addElement(N_CONTEXT);
            contextElement.addElement(N_USERNAME).setText(jobInfo.getContextInfo().getUserName());
            contextElement.addElement(N_PROJECT).setText(jobInfo.getContextInfo().getProjectName());
            contextElement.addElement(N_SITEROOT).setText(jobInfo.getContextInfo().getSiteRoot());
            contextElement.addElement(N_REQUESTEDURI).setText(jobInfo.getContextInfo().getRequestedUri());
            contextElement.addElement(N_LOCALE).setText(jobInfo.getContextInfo().getLocaleName());
            contextElement.addElement(N_ENCODING).setText(jobInfo.getContextInfo().getEncoding());
            contextElement.addElement(N_REMOTEADDR).setText(jobInfo.getContextInfo().getRemoteAddr());
            CmsParameterConfiguration jobParameters = jobInfo.getConfiguration();
            if (jobParameters == null || jobParameters.size() <= 0) continue;
            Element parameterElement = jobElement.addElement(N_PARAMETERS);
            jobParameters.appendToXml(parameterElement);
        }
        return schedulerElement;
    }

    @Override
    public String getDtdFilename() {
        return CONFIGURATION_DTD_NAME;
    }

    public CmsScheduleManager getScheduleManager() {
        return this.m_scheduleManager;
    }

    @Override
    protected void initMembers() {
        this.setXmlFileName(DEFAULT_XML_FILE_NAME);
        this.m_configuredJobs = new ArrayList<CmsScheduledJobInfo>();
    }
}

