/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CmsSetNextRule
extends Rule {
    private static final Log LOG = CmsLog.getLog(CmsSetNextRule.class);
    protected String m_bodyText;
    protected String m_methodName;
    protected int m_paramCount;
    protected Class<?>[] m_paramTypes;
    protected boolean m_useExactMatch;
    private int m_targetOffset = 0;

    public CmsSetNextRule(String methodName, Class<?> clazz) {
        this(methodName, new Class[]{clazz});
    }

    public CmsSetNextRule(String methodName, Class<?>[] clazzes) {
        this.m_methodName = methodName;
        this.m_paramCount = clazzes.length + 1;
        this.m_paramTypes = new Class[this.m_paramCount];
        this.m_paramTypes[0] = CmsObject.class;
        System.arraycopy(clazzes, 0, this.m_paramTypes, 1, clazzes.length);
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        if (this.m_paramCount > 0) {
            Object[] parameters = new Object[this.m_paramCount];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = null;
            }
            this.getDigester().pushParams(parameters);
        }
    }

    public void body(String namespace, String name, String bodyText) throws Exception {
        if (this.m_paramCount == 0) {
            this.m_bodyText = bodyText.trim();
        }
    }

    public void end(String namespace, String name) throws Exception {
        Object parent = this.getDigester().peek(1);
        Object child = this.getDigester().peek(0);
        Object[] parameters = null;
        if (this.m_paramCount > 0) {
            parameters = this.getDigester().popParams();
            if (LOG.isTraceEnabled()) {
                int size = parameters.length;
                for (int i = 0; i < size; ++i) {
                    LOG.trace((Object)("[SetNextRuleWithParams](" + i + ")" + parameters[i]));
                }
            }
            if (this.m_paramCount == 1 && parameters[0] == null) {
                return;
            }
        } else if (this.m_paramTypes.length != 0) {
            if (this.m_bodyText == null) {
                return;
            }
            parameters = new Object[]{this.m_bodyText};
            if (this.m_paramTypes.length == 0) {
                this.m_paramTypes = new Class[1];
                this.m_paramTypes[0] = String.class;
            }
        } else {
            parameters = new Object[]{};
        }
        Object[] paramValues = new Object[this.m_paramTypes.length];
        Class<?> propertyClass = child.getClass();
        for (int i = 0; i < this.m_paramTypes.length; ++i) {
            if (this.m_paramTypes[i] == propertyClass) {
                paramValues[i] = child;
                continue;
            }
            if (parameters[i] == null || parameters[i] instanceof String && !String.class.isAssignableFrom(this.m_paramTypes[i])) {
                if (parameters[i] == null) {
                    paramValues[i] = null;
                    continue;
                }
                paramValues[i] = ConvertUtils.convert((String)((String)parameters[i]), this.m_paramTypes[i]);
                continue;
            }
            paramValues[i] = parameters[i];
        }
        if (parent == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("[SetNextRuleWithParams]{");
            sb.append(this.getDigester().getMatch());
            sb.append("} Call target is null (");
            sb.append("targetOffset=");
            sb.append(this.m_targetOffset);
            sb.append(",stackdepth=");
            sb.append(this.getDigester().getCount());
            sb.append(")");
            throw new SAXException(sb.toString());
        }
        if (LOG.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("[SetNextRuleWithParams]{");
            sb.append(this.getDigester().getMatch());
            sb.append("} Call ");
            sb.append(parent.getClass().getName());
            sb.append(".");
            sb.append(this.m_methodName);
            sb.append("(");
            for (int i = 0; i < paramValues.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                if (paramValues[i] == null) {
                    sb.append("null");
                } else {
                    sb.append(paramValues[i].toString());
                }
                sb.append("/");
                if (this.m_paramTypes[i] == null) {
                    sb.append("null");
                    continue;
                }
                sb.append(this.m_paramTypes[i].getName());
            }
            sb.append(")");
            LOG.debug((Object)sb.toString());
        }
        Object result = null;
        result = this.m_useExactMatch ? MethodUtils.invokeExactMethod((Object)parent, (String)this.m_methodName, (Object[])paramValues, (Class[])this.m_paramTypes) : MethodUtils.invokeMethod((Object)parent, (String)this.m_methodName, (Object[])paramValues, (Class[])this.m_paramTypes);
        this.processMethodCallResult(result);
    }

    public void finish(String namespace, String name) throws Exception {
        String dummy = name;
        dummy = namespace;
        this.m_bodyText = dummy = null;
    }

    public boolean getUseExactMatch() {
        return this.m_useExactMatch;
    }

    public void setDigester(Digester aDigester) {
        aDigester.setLogger(CmsLog.getLog(aDigester.getClass()));
        super.setDigester(aDigester);
    }

    public void setUseExactMatch(boolean useExactMatch) {
        this.m_useExactMatch = useExactMatch;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CallMethodRule[");
        sb.append("methodName=");
        sb.append(this.m_methodName);
        sb.append(", paramCount=");
        sb.append(this.m_paramCount);
        sb.append(", paramTypes={");
        if (this.m_paramTypes != null) {
            for (int i = 0; i < this.m_paramTypes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.m_paramTypes[i].getName());
            }
        }
        sb.append("}");
        sb.append("]");
        return sb.toString();
    }

    protected void processMethodCallResult(Object result) {
        if (result != null) {
            // empty if block
        }
    }
}

