/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.digester3.CallMethodRule;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.NodeCreateRule;
import org.apache.commons.digester3.ObjectCreateRule;
import org.apache.commons.digester3.Rule;
import org.opencms.configuration.A_CmsXmlConfiguration;
import org.opencms.configuration.I_CmsXmlConfigurationWithUpdateHandler;
import org.opencms.configuration.Messages;
import org.opencms.file.CmsObject;
import org.opencms.letsencrypt.CmsLetsEncryptConfiguration;
import org.opencms.letsencrypt.CmsSiteConfigToLetsEncryptConfigConverter;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.CmsLogReport;
import org.opencms.site.CmsAlternativeSiteRootMapping;
import org.opencms.site.CmsSSLMode;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteManagerImpl;
import org.opencms.site.CmsSiteMatcher;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;

public class CmsSitesConfiguration
extends A_CmsXmlConfiguration
implements I_CmsXmlConfigurationWithUpdateHandler {
    public static final String A_ERROR = "error";
    public static final String A_ERROR_PAGE = "errorPage";
    public static final String A_EXCLUSIVE = "exclusive";
    public static final String A_OFFSET = "offset";
    public static final String A_POSITION = "position";
    public static final String A_REDIRECT = "redirect";
    public static final String A_SERVER = "server";
    public static final String A_SSL = "sslmode";
    public static final String A_SUBSITE_SELECTION = "subsiteSelection";
    public static final String A_TITLE = "title";
    public static final String A_USE_PERMANENT_REDIRECTS = "usePermanentRedirects";
    public static final String A_WEBSERVER = "webserver";
    public static final String CONFIGURATION_DTD_NAME = "opencms-sites.dtd";
    public static final String DEFAULT_XML_FILE_NAME = "opencms-sites.xml";
    public static final String N_ALIAS = "alias";
    public static final String N_DEFAULT_URI = "default-uri";
    public static final String N_OLD_STYLE_SECURE_SERVER = "oldStyleSecureServer";
    public static final String N_PARAMETERS = "parameters";
    public static final String N_SECURE = "secure";
    public static final String N_SHARED_FOLDER = "shared-folder";
    public static final String N_SITES = "sites";
    public static final String N_WEBSERVERSCRIPTING = "webserver-scripting";
    public static final String N_WEBSERVERSCRIPTING_CONFIGTEMPLATE = "configtemplate";
    public static final String N_WEBSERVERSCRIPTING_FILENAMEPREFIX = "filenameprefix";
    public static final String N_WEBSERVERSCRIPTING_LOGGINGDIR = "loggingdir";
    public static final String N_WEBSERVERSCRIPTING_SECURETEMPLATE = "securetemplate";
    public static final String N_WEBSERVERSCRIPTING_TARGETPATH = "targetpath";
    public static final String N_WEBSERVERSCRIPTING_WEBSERVERSCRIPT = "webserverscript";
    public static final String N_WORKPLACE_SERVER = "workplace-server";
    private CmsObject m_adminCms;
    private CmsSiteManagerImpl m_siteManager;
    private ScheduledFuture<?> m_updateFuture;

    @Override
    public void addXmlDigesterRules(final Digester digester) {
        digester.addObjectCreate("*/sites", CmsSiteManagerImpl.class);
        digester.addCallMethod("*/sites/workplace-server", "addWorkplaceServer", 2);
        digester.addCallParam("*/sites/workplace-server", 0);
        digester.addCallParam("*/sites/workplace-server", 1, A_SSL);
        digester.addCallMethod("*/sites/default-uri", "setDefaultUri", 0);
        digester.addCallMethod("*/sites/oldStyleSecureServer", "setOldStyleSecureServerAllowed", 0);
        String configApachePath = "*/sites/webserver-scripting";
        digester.addCallMethod(configApachePath, "setWebServerScripting", 6);
        digester.addCallParam(configApachePath + "/webserverscript", 0);
        digester.addCallParam(configApachePath + "/targetpath", 1);
        digester.addCallParam(configApachePath + "/configtemplate", 2);
        digester.addCallParam(configApachePath + "/securetemplate", 3);
        digester.addCallParam(configApachePath + "/filenameprefix", 4);
        digester.addCallParam(configApachePath + "/loggingdir", 5);
        digester.addSetNext("*/sites", "setSiteManager");
        String siteXpath = "*/sites/site";
        digester.addRule(siteXpath, (Rule)new CallMethodRule("addSiteInternally", 15, new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, SortedMap.class, List.class, Optional.class}){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                super.begin(namespace, name, attributes);
                this.getDigester().peekParams()[12] = new TreeMap();
                this.getDigester().peekParams()[13] = new ArrayList();
                this.getDigester().peekParams()[14] = Optional.empty();
            }
        });
        digester.addCallParam(siteXpath, 0, A_SERVER);
        digester.addCallParam(siteXpath, 1, "uri");
        digester.addCallParam(siteXpath, 2, A_TITLE);
        digester.addCallParam(siteXpath, 3, A_POSITION);
        digester.addCallParam(siteXpath, 4, A_ERROR_PAGE);
        digester.addCallParam(siteXpath, 5, A_WEBSERVER);
        digester.addCallParam(siteXpath, 6, A_SSL);
        digester.addCallParam("*/sites/site/secure", 7, A_SERVER);
        digester.addCallParam("*/sites/site/secure", 8, A_EXCLUSIVE);
        digester.addCallParam("*/sites/site/secure", 9, A_ERROR);
        digester.addCallParam("*/sites/site/secure", 10, A_USE_PERMANENT_REDIRECTS);
        digester.addCallParam(siteXpath, 11, A_SUBSITE_SELECTION);
        digester.addRule(siteXpath + "/parameters", (Rule)new ObjectCreateRule(TreeMap.class){

            public void end(String namespace, String name) throws Exception {
                this.getDigester().peekParams()[12] = this.getDigester().peek();
                super.end(namespace, name);
            }
        });
        digester.addCallMethod(siteXpath + "/parameters/param", "put", 2);
        digester.addCallParam(siteXpath + "/parameters/param", 0, "name");
        digester.addCallParam(siteXpath + "/parameters/param", 1);
        digester.addRule("*/sites/site/alias", new Rule(){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                String server = attributes.getValue(CmsSitesConfiguration.A_SERVER);
                String redirect = attributes.getValue(CmsSitesConfiguration.A_REDIRECT);
                String offset = attributes.getValue(CmsSitesConfiguration.A_OFFSET);
                CmsSiteMatcher matcher = CmsSiteManagerImpl.createAliasSiteMatcher(server, redirect, offset);
                Object[] params = this.getDigester().peekParams();
                ((ArrayList)params[13]).add(matcher);
            }
        });
        try {
            digester.addRule("*/sites/site/alternative-site-root", (Rule)new NodeCreateRule(){

                public void end(String namespace, String name) throws Exception {
                    Element elem = (Element)digester.peek();
                    String uri = elem.getAttribute("uri");
                    String titlePrefix = elem.getAttribute("title-suffix");
                    NodeList nodes = elem.getElementsByTagName("path");
                    ArrayList<String> paths = new ArrayList<String>();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Element pathElem = (Element)nodes.item(i);
                        String path = pathElem.getTextContent().trim();
                        paths.add(path);
                    }
                    CmsAlternativeSiteRootMapping mapping = new CmsAlternativeSiteRootMapping(uri, paths, titlePrefix);
                    this.getDigester().peekParams()[14] = Optional.of(mapping);
                    super.end(namespace, name);
                }
            });
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        digester.addCallMethod("*/sites/shared-folder", "setSharedFolder", 0);
    }

    @Override
    public org.dom4j.Element generateXml(org.dom4j.Element parent) {
        org.dom4j.Element sitesElement = parent.addElement(N_SITES);
        if (OpenCms.getRunLevel() >= 3) {
            this.m_siteManager = OpenCms.getSiteManager();
        }
        Map<String, CmsSSLMode> workplaceMap = this.m_siteManager.getWorkplaceServersMap();
        for (String server : workplaceMap.keySet()) {
            org.dom4j.Element workplaceElement = sitesElement.addElement(N_WORKPLACE_SERVER).addText(server);
            workplaceElement.addAttribute(A_SSL, workplaceMap.get(server).getXMLValue());
        }
        sitesElement.addElement(N_DEFAULT_URI).addText(this.m_siteManager.getDefaultUri());
        String sharedFolder = this.m_siteManager.getSharedFolder();
        if (sharedFolder != null) {
            sitesElement.addElement(N_SHARED_FOLDER).addText(sharedFolder);
        }
        String oldStyleSecureAllowed = String.valueOf(this.m_siteManager.isOldStyleSecureServerAllowed());
        sitesElement.addElement(N_OLD_STYLE_SECURE_SERVER).addText(oldStyleSecureAllowed);
        if (this.m_siteManager.isConfigurableWebServer()) {
            org.dom4j.Element configServer = sitesElement.addElement(N_WEBSERVERSCRIPTING);
            Map<String, String> configServerMap = this.m_siteManager.getWebServerConfig();
            configServer.addElement(N_WEBSERVERSCRIPTING_WEBSERVERSCRIPT).addText(configServerMap.get(N_WEBSERVERSCRIPTING_WEBSERVERSCRIPT));
            configServer.addElement(N_WEBSERVERSCRIPTING_TARGETPATH).addText(configServerMap.get(N_WEBSERVERSCRIPTING_TARGETPATH));
            configServer.addElement(N_WEBSERVERSCRIPTING_CONFIGTEMPLATE).addText(configServerMap.get(N_WEBSERVERSCRIPTING_CONFIGTEMPLATE));
            configServer.addElement(N_WEBSERVERSCRIPTING_SECURETEMPLATE).addText(configServerMap.get(N_WEBSERVERSCRIPTING_SECURETEMPLATE));
            configServer.addElement(N_WEBSERVERSCRIPTING_FILENAMEPREFIX).addText(configServerMap.get(N_WEBSERVERSCRIPTING_FILENAMEPREFIX));
            configServer.addElement(N_WEBSERVERSCRIPTING_LOGGINGDIR).addText(configServerMap.get(N_WEBSERVERSCRIPTING_LOGGINGDIR));
        }
        for (CmsSite site : new HashSet<CmsSite>(this.m_siteManager.getSites().values())) {
            org.dom4j.Element siteElement = sitesElement.addElement("site");
            siteElement.addAttribute(A_SERVER, site.getSiteMatcher().toString());
            siteElement.addAttribute("uri", site.getSiteRoot().concat("/"));
            siteElement.addAttribute(A_TITLE, site.getTitle());
            siteElement.addAttribute(A_POSITION, Float.toString(site.getPosition()));
            siteElement.addAttribute(A_ERROR_PAGE, site.getErrorPage());
            siteElement.addAttribute(A_WEBSERVER, String.valueOf(site.isWebserver()));
            siteElement.addAttribute(A_SSL, site.getSSLMode().getXMLValue());
            siteElement.addAttribute(A_SUBSITE_SELECTION, "" + site.isSubsiteSelectionEnabled());
            if (site.hasSecureServer()) {
                org.dom4j.Element secureElem = siteElement.addElement(N_SECURE);
                secureElem.addAttribute(A_SERVER, site.getSecureUrl());
                secureElem.addAttribute(A_EXCLUSIVE, String.valueOf(site.isExclusiveUrl()));
                secureElem.addAttribute(A_ERROR, String.valueOf(site.isExclusiveError()));
                if (site.usesPermanentRedirects()) {
                    secureElem.addAttribute(A_USE_PERMANENT_REDIRECTS, Boolean.TRUE.toString());
                }
            }
            if (site.getParameters() != null && !site.getParameters().isEmpty()) {
                org.dom4j.Element parametersElem = siteElement.addElement(N_PARAMETERS);
                for (Map.Entry<String, String> entry : site.getParameters().entrySet()) {
                    org.dom4j.Element paramElem = parametersElem.addElement("param");
                    paramElem.addAttribute("name", entry.getKey());
                    paramElem.addText(entry.getValue());
                }
            }
            for (CmsSiteMatcher matcher : site.getAliases()) {
                org.dom4j.Element aliasElement = siteElement.addElement(N_ALIAS);
                aliasElement.addAttribute(A_SERVER, matcher.getUrl());
                CmsSiteMatcher.RedirectMode redirectMode = matcher.getRedirectMode();
                String redirectModeStr = null;
                switch (redirectMode) {
                    case permanent: {
                        redirectModeStr = "permanent";
                        break;
                    }
                    case temporary: {
                        redirectModeStr = "true";
                        break;
                    }
                    default: {
                        redirectModeStr = "false";
                    }
                }
                aliasElement.addAttribute(A_REDIRECT, redirectModeStr);
                if (matcher.getTimeOffset() == 0L) continue;
                aliasElement.addAttribute(A_OFFSET, "" + matcher.getTimeOffset() / 1000L);
            }
            Optional<CmsAlternativeSiteRootMapping> altSiteRoot = site.getAlternativeSiteRootMapping();
            if (!altSiteRoot.isPresent()) continue;
            altSiteRoot.get().appendXml(siteElement);
        }
        return sitesElement;
    }

    @Override
    public String getDtdFilename() {
        return CONFIGURATION_DTD_NAME;
    }

    public CmsSiteManagerImpl getSiteManager() {
        return this.m_siteManager;
    }

    @Override
    public synchronized void handleUpdate() throws Exception {
        final CmsLetsEncryptConfiguration config = OpenCms.getLetsEncryptConfig();
        if (config != null && config.isValidAndEnabled() && config.getTrigger() == CmsLetsEncryptConfiguration.Trigger.siteConfig) {
            if (this.m_updateFuture != null) {
                this.m_updateFuture.cancel(false);
                this.m_updateFuture = null;
            }
            this.m_updateFuture = OpenCms.getExecutor().schedule(new Runnable(){

                @Override
                public void run() {
                    CmsSitesConfiguration.this.m_updateFuture = null;
                    CmsLogReport report = new CmsLogReport(Locale.ENGLISH, CmsSiteConfigToLetsEncryptConfigConverter.class);
                    CmsSiteConfigToLetsEncryptConfigConverter converter = new CmsSiteConfigToLetsEncryptConfigConverter(config);
                    converter.run(report, OpenCms.getSiteManager());
                }
            }, 5L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void setCmsObject(CmsObject cms) {
        this.m_adminCms = cms;
    }

    public void setSiteManager(CmsSiteManagerImpl siteManager) {
        this.m_siteManager = siteManager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SITE_CONFIG_FINISHED_0"));
        }
    }

    @Override
    protected void initMembers() {
        this.setXmlFileName(DEFAULT_XML_FILE_NAME);
    }
}

