/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.NodeCreateRule;
import org.apache.commons.digester3.Rule;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.opencms.ade.detailpage.CmsDefaultDetailPageHandler;
import org.opencms.ade.detailpage.I_CmsDetailPageHandler;
import org.opencms.configuration.A_CmsXmlConfiguration;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.CmsRemoteShellConfiguration;
import org.opencms.configuration.Messages;
import org.opencms.crypto.CmsAESTextEncryption;
import org.opencms.crypto.I_CmsTextEncryption;
import org.opencms.db.CmsCacheSettings;
import org.opencms.db.CmsDefaultUsers;
import org.opencms.db.CmsLoginManager;
import org.opencms.db.CmsSubscriptionManager;
import org.opencms.db.I_CmsDbContextFactory;
import org.opencms.flex.CmsFlexCacheConfiguration;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.userdata.CmsUserDataRequestManager;
import org.opencms.letsencrypt.CmsLetsEncryptConfiguration;
import org.opencms.mail.CmsMailHost;
import org.opencms.mail.CmsMailSettings;
import org.opencms.main.CmsDefaultSessionStorageProvider;
import org.opencms.main.CmsEventManager;
import org.opencms.main.CmsHttpAuthenticationSettings;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsServletContainerSettings;
import org.opencms.main.I_CmsRequestHandler;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.main.I_CmsSessionStorageProvider;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryMonitorConfiguration;
import org.opencms.publish.CmsPublishManager;
import org.opencms.security.CmsDefaultAuthorizationHandler;
import org.opencms.security.CmsDefaultCredentialsResolver;
import org.opencms.security.CmsDefaultValidationHandler;
import org.opencms.security.I_CmsAuthorizationHandler;
import org.opencms.security.I_CmsCredentialsResolver;
import org.opencms.security.I_CmsPasswordHandler;
import org.opencms.security.I_CmsValidationHandler;
import org.opencms.security.twofactor.CmsTwoFactorAuthenticationConfig;
import org.opencms.util.CmsStringUtil;
import org.opencms.workflow.CmsDefaultWorkflowManager;
import org.opencms.workflow.I_CmsWorkflowManager;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsADECacheSettings;
import org.opencms.xml.xml2json.I_CmsApiAuthorizationHandler;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class CmsSystemConfiguration
extends A_CmsXmlConfiguration {
    public static final String A_DELETED = "deleted";
    public static final String A_ERROR = "error";
    public static final String A_ERROR_PAGE = "errorPage";
    public static final String A_ID = "id";
    public static final String A_EXCLUSIVE = "exclusive";
    public static final String A_MAILFROM = "mailfrom";
    public static final String A_LOCALIZATION_MODE = "localizationMode";
    public static final String A_MAXVISITED = "maxvisited";
    public static final String A_OFFLINE = "offline";
    public static final String A_ONLINE = "online";
    public static final String A_POOLNAME = "poolname";
    public static final String A_SECURITY = "security";
    public static final String CONFIGURATION_DTD_NAME = "opencms-system.dtd";
    public static final UserSessionMode DEFAULT_USER_SESSION_MODE = UserSessionMode.standard;
    public static final String DEFAULT_XML_FILE_NAME = "opencms-system.xml";
    public static final String N_ADE = "ade";
    public static final String N_ADE_CACHE = "ade-cache";
    public static final String N_API_AUTHORIZATION = "api-authorization";
    public static final String N_API_AUTHORIZATIONS = "api-authorizations";
    public static final String N_AUTHORIZATIONHANDLER = "authorizationhandler";
    public static final String N_AVGCACHEBYTES = "avgcachebytes";
    public static final String N_BROWSER_BASED = "browser-based";
    public static final String N_CACHE_ENABLED = "cache-enabled";
    public static final String N_CACHE_OFFLINE = "cache-offline";
    public static final String N_CLASS = "class";
    public static final String N_CONFIGURATION = "configuration";
    public static final String N_CONTAINERPAGES = "containerpages";
    public static final String N_CONTENT_NOTIFICATION = "content-notification";
    public static final String N_DEFAULT_CONTENT_ENCODING = "defaultcontentencoding";
    public static final String N_DEFAULTUSERS = "defaultusers";
    public static final String N_DETAIL_PAGE_HANDLER = "detail-page-handler";
    public static final String N_DEVICESELECTOR = "device-selector";
    public static final String N_DIGESTTYPE = "digest-type";
    public static final String N_DISABLEMINUTES = "disableMinutes";
    public static final String N_DOCUMENTS = "documents";
    public static final String N_EMAIL_INTERVAL = "email-interval";
    public static final String N_EMAIL_RECEIVER = "email-receiver";
    public static final String N_EMAIL_SENDER = "email-sender";
    public static final String N_ENABLESCURITY = "enableSecurity";
    public static final String N_ENCRYPTION = "encryption";
    public static final String N_EVENTMANAGER = "eventmanager";
    public static final String N_EVENTS = "events";
    public static final String N_FLEXCACHE = "flexcache";
    public static final String N_FORM_BASED = "form-based";
    public static final String N_GROUP_ADMINISTRATORS = "group-administrators";
    public static final String N_GROUP_GUESTS = "group-guests";
    public static final String N_GROUP_PROJECTMANAGERS = "group-projectmanagers";
    public static final String N_GROUP_USERS = "group-users";
    public static final String N_GROUPCONTAINERS = "groupcontainers";
    public static final String N_HISTORYSIZE = "history-size";
    public static final String N_HTTP_AUTHENTICATION = "http-authentication";
    public static final String N_I18N = "internationalization";
    public static final String N_KEYGENERATOR = "keygenerator";
    public static final String N_LOCALE = "locale";
    public static final String N_LOCALEHANDLER = "localehandler";
    public static final String N_LOCALESCONFIGURED = "localesconfigured";
    public static final String N_LOCALESDEFAULT = "localesdefault";
    public static final String N_LOG_INTERVAL = "log-interval";
    public static final String N_LOGINMANAGER = "loginmanager";
    public static final String N_LOGOUT_URI = "logoutUri";
    public static final String N_MAIL = "mail";
    public static final String N_MAILFROM = "mailfrom";
    public static final String N_MAILHOST = "mailhost";
    public static final String N_MAXBADATTEMPTS = "maxBadAttempts";
    public static final String N_MAXCACHEBYTES = "maxcachebytes";
    public static final String N_MAXENTRYBYTES = "maxentrybytes";
    public static final String N_MAXKEYS = "maxkeys";
    public static final String N_MAXUSAGE_PERCENT = "maxusagepercent";
    public static final String N_MEMORYMONITOR = "memorymonitor";
    public static final String N_NOTIFICATION_PROJECT = "notification-project";
    public static final String N_NOTIFICATION_TIME = "notification-time";
    public static final String N_PARAMETERS = "parameters";
    public static final String N_PASSWORD_CHANGE_INTERVAL = "passwordChangeInterval";
    public static final String N_PASSWORDENCODING = "encoding";
    public static final String N_PASSWORDHANDLER = "passwordhandler";
    public static final String N_PERMISSIONHANDLER = "permissionhandler";
    public static final String N_PREVENTRESPONSEFLUSH = "prevent-response-flush";
    public static final String N_PUBLISH_LIST_REMOVE_MODE = "publish-list-remove-mode";
    public static final String N_PUBLISHMANAGER = "publishmanager";
    public static final String N_QUEUEPERSISTANCE = "queue-persistance";
    public static final String N_QUEUESHUTDOWNTIME = "queue-shutdowntime";
    public static final String N_RECEIVER = "receiver";
    public static final String N_RELEASETAGSAFTEREND = "release-tags-after-end";
    public static final String N_REQUESTERRORPAGEATTRIBUTE = "request-error-page-attribute";
    public static final String N_REQUESTHANDLER = "requesthandler";
    public static final String N_REQUESTHANDLERS = "requesthandlers";
    public static final String N_RESOURCEINIT = "resourceinit";
    public static final String N_RESOURCEINITHANDLER = "resourceinithandler";
    public static final String N_RESTRICT_DETAIL_CONTENTS = "restrict-detail-contents";
    public static final String N_RESULTCACHE = "resultcache";
    public static final String N_RUNTIMECLASSES = "runtimeclasses";
    public static final String N_RUNTIMEINFO = "runtimeinfo";
    public static final String N_RUNTIMEPROPERTIES = "runtimeproperties";
    public static final String N_SAX_IMPL_SYSTEM_PROPERTIES = "sax-impl-system-properties";
    public static final String N_SERVLETCONTAINERSETTINGS = "servletcontainer-settings";
    public static final String N_SESSION_STORAGEPROVIDER = "session-storageprovider";
    public static final String N_SITEMAP = "sitemap";
    public static final String N_SITEMAP_CACHE = "sitemap-cache";
    public static final String N_SIZE_ACLS = "size-accesscontrollists";
    public static final String N_SIZE_CONTAINERPAGE_OFFLINE = "size-containerpage-offline";
    public static final String N_SIZE_CONTAINERPAGE_ONLINE = "size-containerpage-online";
    public static final String N_SIZE_GROUPS = "size-groups";
    public static final String N_SIZE_ORGUNITS = "size-orgunits";
    public static final String N_SIZE_PERMISSIONS = "size-permissions";
    public static final String N_SIZE_PROJECTRESOURCES = "size-projectresources";
    public static final String N_SIZE_PROJECTS = "size-projects";
    public static final String N_SIZE_PROPERTIES = "size-properties";
    public static final String N_SIZE_PROPERTYLISTS = "size-propertylists";
    public static final String N_SIZE_RESOURCELISTS = "size-resourcelists";
    public static final String N_SIZE_RESOURCES = "size-resources";
    public static final String N_SIZE_ROLES = "size-roles";
    public static final String N_SIZE_USERGROUPS = "size-usergroups";
    public static final String N_SIZE_USERS = "size-users";
    public static final String N_SUBSCRIPTIONMANAGER = "subscriptionmanager";
    public static final String N_SYSTEM = "system";
    public static final String N_TEXT_ENCRYPTION = "text-encryption";
    public static final String N_TIMEZONE = "timezone";
    public static final String N_TOKEN_LIFETIME = "tokenLifetime";
    public static final String N_USER_ADMIN = "user-admin";
    public static final String N_USER_DATA_CHECK_INTERVAL = "userDataCheckInterval";
    public static final String N_USER_DELETEDRESOURCE = "user-deletedresource";
    public static final String N_USER_EXPORT = "user-export";
    public static final String N_USER_GUEST = "user-guest";
    public static final String N_VALIDATIONHANDLER = "validationhandler";
    public static final String N_VERSIONHISTORY = "versionhistory";
    public static final String N_WARNING_INTERVAL = "warning-interval";
    public static final String N_WEBSERVERSCRIPTING = "webserver-scripting";
    public static final String N_WEBSERVERSCRIPTING_CONFIGTEMPLATE = "configtemplate";
    public static final String N_WEBSERVERSCRIPTING_FILENAMEPREFIX = "filenameprefix";
    public static final String N_WEBSERVERSCRIPTING_LOGGINGDIR = "loggingdir";
    public static final String N_WEBSERVERSCRIPTING_SECURETEMPLATE = "securetemplate";
    public static final String N_WEBSERVERSCRIPTING_TARGETPATH = "targetpath";
    public static final String N_WEBSERVERSCRIPTING_WEBSERVERSCRIPT = "webserverscript";
    public static final String N_WORKFLOW = "workflow";
    private static final Log LOG = CmsLog.getLog(CmsSystemConfiguration.class);
    private static final String N_AUTO_CLEANUP_HISTORY_ENTRIES = "auto-cleanup-history-entries";
    private static final String N_CREDENTIALS_RESOLVER = "credentials-resolver";
    private static final String N_MAX_INACTIVE_TIME = "maxInactiveTime";
    private static final String N_REQUIRE_ORGUNIT = "requireOrgUnit";
    private static final String N_REUSE_ELEMENTS = "reuse-elements";
    private static final String N_SHELL_SERVER = "shell-server";
    private static final String N_TWO_FACTOR_AUTHENTICATION = "two-factor-authentication";
    private static final String N_USER_SESSION_MODE = "user-session-mode";
    private CmsADECacheSettings m_adeCacheSettings;
    private String m_adeConfiguration;
    private Map<String, String> m_adeParameters = new LinkedHashMap<String, String>();
    private Map<String, I_CmsApiAuthorizationHandler> m_apiAuthorizationMap = new HashMap<String, I_CmsApiAuthorizationHandler>();
    private List<ApiAuthorizationConfig> m_apiAuthorizations = new ArrayList<ApiAuthorizationConfig>();
    private Map<String, String> m_authHandlerParams = new HashMap<String, String>();
    private String m_authorizationHandler;
    private CmsCacheSettings m_cacheSettings;
    private CmsDefaultUsers m_cmsDefaultUsers;
    private CmsFlexCacheConfiguration m_cmsFlexCacheConfiguration;
    private CmsMemoryMonitorConfiguration m_cmsMemoryMonitorConfiguration;
    private I_CmsCredentialsResolver m_credentialsResolver;
    private String m_credentialsResolverClass;
    private String m_defaultContentEncoding;
    private I_CmsDetailPageHandler m_detailPageHandler = new CmsDefaultDetailPageHandler();
    private CmsEventManager m_eventManager;
    private boolean m_historyEnabled;
    private int m_historyVersions;
    private int m_historyVersionsAfterDeletion;
    private CmsHttpAuthenticationSettings m_httpAuthenticationSettings;
    private CmsLetsEncryptConfiguration m_letsEncryptConfig;
    private CmsLocaleManager m_localeManager;
    private CmsLoginManager m_loginManager;
    private CmsMailSettings m_mailSettings;
    private String m_notificationProject;
    private Integer m_notificationTime;
    private I_CmsPasswordHandler m_passwordHandler;
    private String m_permissionHandler;
    private String m_publishListRemoveMode;
    private CmsPublishManager m_publishManager;
    private List<I_CmsRequestHandler> m_requestHandlers;
    private List<I_CmsResourceInit> m_resourceInitHandlers;
    private String m_restrictDetailContents;
    private I_CmsDbContextFactory m_runtimeInfoFactory;
    private Map<String, String> m_runtimeProperties;
    private boolean m_saxImplProperties;
    private String m_sessionStorageProvider;
    private CmsRemoteShellConfiguration m_shellServerOptions;
    private CmsSubscriptionManager m_subscriptionManager;
    private int m_tempFileProjectId;
    private Map<String, I_CmsTextEncryption> m_textEncryptions = new LinkedHashMap<String, I_CmsTextEncryption>();
    private CmsTwoFactorAuthenticationConfig m_twoFactorConfig;
    private CmsUserDataRequestManager m_userDataRequestManager;
    private UserSessionMode m_userSessionMode;
    private String m_validationHandler;
    private I_CmsWorkflowManager m_workflowManager;

    public void addAdeParameter(String name, String value) {
        this.m_adeParameters.put(name, value);
    }

    public void addAuthorizationHandlerParam(String name, String value) {
        this.m_authHandlerParams.put(name, value);
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_runtimeProperties.put(paramName, paramValue);
    }

    public void addEventManager(String clazz) {
        try {
            this.m_eventManager = (CmsEventManager)Class.forName(clazz).newInstance();
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EVENTMANAGER_CLASS_SUCCESS_1", this.m_eventManager));
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("INIT_EVENTMANAGER_CLASS_INVALID_1", clazz), t);
            return;
        }
    }

    public void addRequestHandler(String clazz, CmsParameterConfiguration params) {
        Object handler;
        try {
            handler = Class.forName(clazz).newInstance();
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INIT_REQUEST_HANDLER_FAILURE_1", clazz), t);
            return;
        }
        if (handler instanceof I_CmsRequestHandler) {
            ((I_CmsRequestHandler)handler).initParameters(params);
            this.m_requestHandlers.add((I_CmsRequestHandler)handler);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_REQUEST_HANDLER_SUCCESS_1", clazz));
            }
        } else if (CmsLog.INIT.isErrorEnabled()) {
            CmsLog.INIT.error((Object)Messages.get().getBundle().key("INIT_REQUEST_HANDLER_INVALID_1", clazz));
        }
    }

    public void addResourceInitHandler(String clazz, CmsParameterConfiguration params) throws CmsConfigurationException {
        Object initClass;
        try {
            initClass = Class.forName(clazz).newInstance();
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_RESOURCE_INIT_CLASS_INVALID_1", clazz), t);
            return;
        }
        if (initClass instanceof I_CmsResourceInit) {
            ((I_CmsResourceInit)initClass).initParameters(params);
            this.m_resourceInitHandlers.add((I_CmsResourceInit)initClass);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_RESOURCE_INIT_SUCCESS_1", clazz));
            }
        } else if (CmsLog.INIT.isErrorEnabled()) {
            CmsLog.INIT.error((Object)Messages.get().getBundle().key("INIT_RESOURCE_INIT_INVALID_CLASS_1", clazz));
        }
    }

    @Override
    public void addXmlDigesterRules(final Digester digester) {
        digester.addCallMethod("*/system", "initializeFinished");
        digester.addObjectCreate("*/system/internationalization", CmsLocaleManager.class);
        digester.addSetNext("*/system/internationalization", "setLocaleManager");
        digester.addObjectCreate("*/system/internationalization/localehandler", CmsConfigurationException.class.getName(), N_CLASS);
        digester.addSetNext("*/system/internationalization/localehandler", "setLocaleHandler");
        digester.addCallMethod("*/system/internationalization/localesconfigured/locale", "addAvailableLocale", 0);
        digester.addCallMethod("*/system/internationalization/localesdefault/locale", "addDefaultLocale", 0);
        digester.addCallMethod("*/system/internationalization/timezone", "setTimeZone", 0);
        digester.addCallMethod("*/system/internationalization/reuse-elements", "setReuseElements", 0);
        digester.addCallMethod("*/system/versionhistory", "setHistorySettings", 3);
        digester.addCallParam("*/system/versionhistory", 0, "enabled");
        digester.addCallParam("*/system/versionhistory", 1, "count");
        digester.addCallParam("*/system/versionhistory", 2, A_DELETED);
        digester.addObjectCreate("*/system/mail", CmsMailSettings.class);
        digester.addCallMethod("*/system/mail/mailfrom", "setMailFromDefault", 0);
        digester.addSetNext("*/system/mail", "setMailSettings");
        digester.addCallMethod("*/system/mail/mailhost", "addMailHost", 9);
        digester.addCallParam("*/system/mail/mailhost", 0, "name");
        digester.addCallParam("*/system/mail/mailhost", 1, "port");
        digester.addCallParam("*/system/mail/mailhost", 2, "order");
        digester.addCallParam("*/system/mail/mailhost", 3, "protocol");
        digester.addCallParam("*/system/mail/mailhost", 4, A_SECURITY);
        digester.addCallParam("*/system/mail/mailhost", 5, "user");
        digester.addCallParam("*/system/mail/mailhost", 6, "password");
        digester.addCallParam("*/system/mail/mailhost", 7, A_ID);
        digester.addCallParam("*/system/mail/mailhost", 8, "mailfrom");
        digester.addCallMethod("*/system/events/eventmanager", "addEventManager", 1);
        digester.addCallParam("*/system/events/eventmanager", 0, N_CLASS);
        final CmsParameterConfiguration[] resourceHandlerParams = new CmsParameterConfiguration[]{null};
        digester.addRule("*/system/resourceinit/resourceinithandler", new Rule(){
            private String m_class;

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                this.m_class = attributes.getValue(CmsSystemConfiguration.N_CLASS);
                resourceHandlerParams[0] = new CmsParameterConfiguration();
            }

            public void end(String namespace, String name) throws Exception {
                CmsSystemConfiguration.this.addResourceInitHandler(this.m_class, resourceHandlerParams[0]);
            }
        });
        digester.addRule("*/system/resourceinit/resourceinithandler/param", new Rule(){
            private String m_name;
            private String m_value;

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                this.m_name = attributes.getValue("name");
                this.m_value = null;
            }

            public void body(String namespace, String name, String text) throws Exception {
                this.m_value = text;
            }

            public void end(String namespace, String name) throws Exception {
                resourceHandlerParams[0].add(this.m_name, this.m_value);
            }
        });
        final CmsParameterConfiguration[] requestHandlerParams = new CmsParameterConfiguration[]{null};
        digester.addRule("*/system/requesthandlers/requesthandler/param", new Rule(){
            private String m_name;
            private String m_value;

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                this.m_name = attributes.getValue("name");
                this.m_value = null;
            }

            public void body(String namespace, String name, String text) throws Exception {
                this.m_value = text;
            }

            public void end(String namespace, String name) throws Exception {
                requestHandlerParams[0].add(this.m_name, this.m_value);
            }
        });
        digester.addRule("*/system/requesthandlers/requesthandler", new Rule(){
            private String m_class;

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                this.m_class = attributes.getValue(CmsSystemConfiguration.N_CLASS);
                requestHandlerParams[0] = new CmsParameterConfiguration();
            }

            public void end(String namespace, String name) throws Exception {
                CmsSystemConfiguration.this.addRequestHandler(this.m_class, requestHandlerParams[0]);
            }
        });
        digester.addObjectCreate("*/system/passwordhandler", CmsConfigurationException.class.getName(), N_CLASS);
        digester.addCallMethod("*/system/passwordhandler", "initConfiguration");
        digester.addBeanPropertySetter("*/system/passwordhandler/encoding", "inputEncoding");
        digester.addBeanPropertySetter("*/system/passwordhandler/digest-type", "digestType");
        digester.addSetNext("*/system/passwordhandler", "setPasswordHandler");
        digester.addCallMethod("*/param", "addConfigurationParameter", 2);
        digester.addCallParam("*/param", 0, "name");
        digester.addCallParam("*/param", 1);
        digester.addCallMethod("*/system/validationhandler", "setValidationHandler", 1);
        digester.addCallParam("*/system/validationhandler", 0, N_CLASS);
        digester.addCallMethod("*/loginmanager", "setLoginManager", 9);
        digester.addCallParam("*/loginmanager/disableMinutes", 0);
        digester.addCallParam("*/loginmanager/maxBadAttempts", 1);
        digester.addCallParam("*/loginmanager/enableSecurity", 2);
        digester.addCallParam("*/loginmanager/tokenLifetime", 3);
        digester.addCallParam("*/loginmanager/maxInactiveTime", 4);
        digester.addCallParam("*/loginmanager/passwordChangeInterval", 5);
        digester.addCallParam("*/loginmanager/userDataCheckInterval", 6);
        digester.addCallParam("*/loginmanager/requireOrgUnit", 7);
        digester.addCallParam("*/loginmanager/logoutUri", 8);
        try {
            digester.addRule("*/two-factor-authentication", (Rule)new NodeCreateRule(){

                public void end(String namespace, String name) throws Exception {
                    Element elem = (Element)digester.pop();
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    org.w3c.dom.Document doc = dbf.newDocumentBuilder().newDocument();
                    doc.appendChild(doc.importNode(elem, true));
                    Document dom4jDoc = CmsXmlUtils.convertDocumentFromW3CToDom4j(doc);
                    CmsSystemConfiguration.this.m_twoFactorConfig = new CmsTwoFactorAuthenticationConfig(dom4jDoc.getRootElement());
                }
            });
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        digester.addCallMethod("*/system/sax-impl-system-properties", "setUseSaxImplSystemProperties", 1);
        digester.addCallParam("*/system/sax-impl-system-properties", 0);
        digester.addCallMethod("*/system/runtimeproperties/param", "addConfigurationParameter", 2);
        digester.addCallParam("*/system/runtimeproperties/param", 0, "name");
        digester.addCallParam("*/system/runtimeproperties/param", 1);
        digester.addCallMethod("*/system/runtimeclasses/runtimeinfo", "setRuntimeInfoFactory", 1);
        digester.addCallParam("*/system/runtimeclasses/runtimeinfo", 0, N_CLASS);
        digester.addCallMethod("*/system/defaultusers", "setCmsDefaultUsers", 7);
        digester.addCallParam("*/system/defaultusers/user-admin", 0);
        digester.addCallParam("*/system/defaultusers/user-guest", 1);
        digester.addCallParam("*/system/defaultusers/user-export", 2);
        digester.addCallParam("*/system/defaultusers/user-deletedresource", 3);
        digester.addCallParam("*/system/defaultusers/group-administrators", 4);
        digester.addCallParam("*/system/defaultusers/group-users", 5);
        digester.addCallParam("*/system/defaultusers/group-guests", 6);
        digester.addCallMethod("*/system/defaultcontentencoding", "setDefaultContentEncoding", 1);
        digester.addCallParam("*/system/defaultcontentencoding", 0);
        digester.addObjectCreate("*/system/memorymonitor", CmsMemoryMonitorConfiguration.class);
        digester.addCallMethod("*/system/memorymonitor", "initialize", 5);
        digester.addCallParam("*/system/memorymonitor", 0, N_CLASS);
        digester.addCallParam("*/system/memorymonitor/maxusagepercent", 1);
        digester.addCallParam("*/system/memorymonitor/log-interval", 2);
        digester.addCallParam("*/system/memorymonitor/email-interval", 3);
        digester.addCallParam("*/system/memorymonitor/warning-interval", 4);
        digester.addCallMethod("*/system/memorymonitor/email-sender", "setEmailSender", 0);
        digester.addCallMethod("*/system/memorymonitor/email-receiver/receiver", "addEmailReceiver", 0);
        digester.addSetNext("*/system/memorymonitor", "setCmsMemoryMonitorConfiguration");
        digester.addObjectCreate("*/system/flexcache", CmsFlexCacheConfiguration.class);
        digester.addCallMethod("*/system/flexcache", "initialize", 6);
        digester.addCallParam("*/system/flexcache/cache-enabled", 0);
        digester.addCallParam("*/system/flexcache/cache-offline", 1);
        digester.addCallParam("*/system/flexcache/maxcachebytes", 2);
        digester.addCallParam("*/system/flexcache/avgcachebytes", 3);
        digester.addCallParam("*/system/flexcache/maxentrybytes", 4);
        digester.addCallParam("*/system/flexcache/maxkeys", 5);
        digester.addCallMethod("*/system/flexcache/device-selector", "setDeviceSelectorConfiguration", 1);
        digester.addCallParam("*/system/flexcache/device-selector", 0, N_CLASS);
        digester.addSetNext("*/system/flexcache", "setCmsFlexCacheConfiguration");
        digester.addObjectCreate("*/system/http-authentication", CmsHttpAuthenticationSettings.class);
        digester.addCallMethod("*/system/http-authentication/browser-based", "setUseBrowserBasedHttpAuthentication", 0);
        digester.addCallMethod("*/system/http-authentication/form-based", "setFormBasedHttpAuthenticationUri", 0);
        digester.addSetNext("*/system/http-authentication", "setHttpAuthenticationSettings");
        digester.addObjectCreate("*/system/resultcache", CmsCacheSettings.class);
        digester.addCallMethod("*/system/resultcache/keygenerator", "setCacheKeyGenerator", 0);
        digester.addCallMethod("*/system/resultcache/size-users", "setUserCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-groups", "setGroupCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-orgunits", "setOrgUnitCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-usergroups", "setUserGroupsCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-projects", "setProjectCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-projectresources", "setProjectResourcesCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-resources", "setResourceCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-roles", "setRolesCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-resourcelists", "setResourcelistCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-properties", "setPropertyCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-propertylists", "setPropertyListsCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-accesscontrollists", "setAclCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-permissions", "setPermissionCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-containerpage-offline", "setContainerPageOfflineSize", 0);
        digester.addCallMethod("*/system/resultcache/size-containerpage-online", "setContainerPageOnlineSize", 0);
        digester.addSetNext("*/system/resultcache", "setCacheSettings");
        digester.addCallMethod("*/system/content-notification/notification-time", "setNotificationTime", 1);
        digester.addCallParam("*/system/content-notification/notification-time", 0);
        digester.addCallMethod("*/system/content-notification/notification-project", "setNotificationProject", 1);
        digester.addCallParam("*/system/content-notification/notification-project", 0);
        digester.addCallMethod("*/system/authorizationhandler", "setAuthorizationHandler", 1);
        digester.addCallParam("*/system/authorizationhandler", 0, N_CLASS);
        digester.addCallMethod("*/system/authorizationhandler/parameters/param", "addAuthorizationHandlerParam", 2);
        digester.addCallParam("*/system/authorizationhandler/parameters/param", 0, "name");
        digester.addCallParam("*/system/authorizationhandler/parameters/param", 1);
        String apiAuthPath = "*/system/api-authorizations/api-authorization";
        digester.addRule(apiAuthPath, new Rule(){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                digester.push((Object)new ApiAuthorizationConfig());
            }

            public void end(String namespace, String name) throws Exception {
                ApiAuthorizationConfig config = (ApiAuthorizationConfig)digester.pop();
                CmsSystemConfiguration.this.addApiAuthorization(config);
            }
        });
        String namePath = apiAuthPath + "/name";
        digester.addCallMethod(namePath, "setName", 1);
        digester.addCallParam(namePath, 0);
        String classNamePath = apiAuthPath + "/class";
        digester.addCallMethod(classNamePath, "setClassName", 1);
        digester.addCallParam(classNamePath, 0);
        String paramPath = apiAuthPath + "/param";
        digester.addCallMethod(paramPath, "setParam", 2);
        digester.addCallParam(paramPath, 0, "name");
        digester.addCallParam(paramPath, 1);
        digester.addObjectCreate("*/system/publishmanager", CmsPublishManager.class);
        digester.addCallMethod("*/system/publishmanager/history-size", "setPublishHistorySize", 0);
        digester.addCallMethod("*/system/publishmanager/queue-persistance", "setPublishQueuePersistance", 0);
        digester.addCallMethod("*/system/publishmanager/queue-shutdowntime", "setPublishQueueShutdowntime", 0);
        digester.addCallMethod("*/system/publishmanager/auto-cleanup-history-entries", "setAutoCleanupHistoryEntries", 0);
        digester.addSetNext("*/system/publishmanager", "setPublishManager");
        digester.addCallMethod("*/system/session-storageprovider", "setSessionStorageProvider", 1);
        digester.addCallParam("*/system/session-storageprovider", 0, N_CLASS);
        digester.addCallMethod("*/system/permissionhandler", "setPermissionHandler", 1);
        digester.addCallParam("*/system/permissionhandler", 0, N_CLASS);
        digester.addCallMethod("*/system/servletcontainer-settings/prevent-response-flush", "setPreventResponseFlush", 0);
        digester.addCallMethod("*/system/servletcontainer-settings/release-tags-after-end", "setReleaseTagsAfterEnd", 0);
        digester.addCallMethod("*/system/servletcontainer-settings/request-error-page-attribute", "setRequestErrorPageAttribute", 0);
        digester.addCallMethod("*/system/servletcontainer-settings", "setServletContainerSettingsMode", 1);
        digester.addCallParam("*/system/servletcontainer-settings", 0, "mode");
        String adeCachePath = "*/system/ade/ade-cache";
        digester.addObjectCreate(adeCachePath, CmsADECacheSettings.class);
        digester.addCallMethod(adeCachePath + "/containerpages", "setContainerPageOfflineSize", 1);
        digester.addCallParam(adeCachePath + "/containerpages", 0, A_OFFLINE);
        digester.addCallMethod(adeCachePath + "/containerpages", "setContainerPageOnlineSize", 1);
        digester.addCallParam(adeCachePath + "/containerpages", 0, A_ONLINE);
        digester.addCallMethod(adeCachePath + "/groupcontainers", "setGroupContainerOfflineSize", 1);
        digester.addCallParam(adeCachePath + "/groupcontainers", 0, A_OFFLINE);
        digester.addCallMethod(adeCachePath + "/groupcontainers", "setGroupContainerOnlineSize", 1);
        digester.addCallParam(adeCachePath + "/groupcontainers", 0, A_ONLINE);
        digester.addSetNext(adeCachePath, "setAdeCacheSettings");
        String adeParamPath = "*/system/ade/parameters/param";
        digester.addCallMethod(adeParamPath, "addAdeParameter", 2);
        digester.addCallParam(adeParamPath, 0, "name");
        digester.addCallParam(adeParamPath, 1);
        digester.addObjectCreate("*/system/subscriptionmanager", CmsSubscriptionManager.class);
        digester.addCallMethod("*/system/subscriptionmanager", "setEnabled", 1);
        digester.addCallParam("*/system/subscriptionmanager", 0, "enabled");
        digester.addCallMethod("*/system/subscriptionmanager", "setPoolName", 1);
        digester.addCallParam("*/system/subscriptionmanager", 0, A_POOLNAME);
        digester.addCallMethod("*/system/subscriptionmanager", "setMaxVisitedCount", 1);
        digester.addCallParam("*/system/subscriptionmanager", 0, A_MAXVISITED);
        digester.addSetNext("*/system/subscriptionmanager", "setSubscriptionManager");
        digester.addCallMethod("*/system/publish-list-remove-mode", "setPublishListRemoveMode", 1);
        digester.addCallParam("*/system/publish-list-remove-mode", 0, "mode");
        String workflowXpath = "*/system/workflow";
        digester.addObjectCreate(workflowXpath, CmsDefaultWorkflowManager.class.getName(), N_CLASS);
        digester.addObjectCreate(workflowXpath + "/parameters", LinkedHashMap.class);
        digester.addCallMethod(workflowXpath + "/parameters/param", "put", 2);
        digester.addCallParam(workflowXpath + "/parameters/param", 0, "name");
        digester.addCallParam(workflowXpath + "/parameters/param", 1);
        digester.addSetNext(workflowXpath + "/parameters", "setParameters");
        digester.addSetNext(workflowXpath, "setWorkflowManager");
        CmsLetsEncryptConfiguration.CONFIG_HELPER.addRules(digester);
        digester.addSetNext(CmsLetsEncryptConfiguration.CONFIG_HELPER.getBasePath(), "setLetsEncryptConfig");
        digester.addRule("*/system/encryption/text-encryption", new Rule(){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                String className = attributes.getValue(CmsSystemConfiguration.N_CLASS);
                String instanceName = attributes.getValue("name");
                I_CmsTextEncryption encrypter = (I_CmsTextEncryption)Class.forName(className).newInstance();
                encrypter.setName(instanceName);
                digester.push((Object)encrypter);
            }

            public void end(String namespace, String name) throws Exception {
                I_CmsTextEncryption encrypter = (I_CmsTextEncryption)digester.pop();
                CmsSystemConfiguration.this.m_textEncryptions.put(encrypter.getName(), encrypter);
            }
        });
        digester.addRule("*/system", new Rule(){

            public void end(String namespace, String name) throws Exception {
                if (CmsSystemConfiguration.this.m_textEncryptions.get("default") == null) {
                    CmsAESTextEncryption defaultEncryption = new CmsAESTextEncryption();
                    defaultEncryption.setName("default");
                    defaultEncryption.addConfigurationParameter("secret", RandomStringUtils.randomAlphanumeric((int)24));
                    CmsSystemConfiguration.this.m_textEncryptions.put("default", defaultEncryption);
                }
            }
        });
        String userSessionPath = "*/system/user-session-mode";
        digester.addCallMethod(userSessionPath, "setUserSessionMode", 0);
        String credentialsResolverPath = "*/system/credentials-resolver";
        digester.addCallMethod(credentialsResolverPath, "setCredentialsResolver", 0);
        digester.addCallMethod("*/system/restrict-detail-contents", "setRestrictDetailContents", 1);
        digester.addCallParam("*/system/restrict-detail-contents", 0);
        String shellServerPath = "*/system/shell-server";
        digester.addCallMethod(shellServerPath, "setShellServerOptions", 2);
        digester.addCallParam(shellServerPath, 0, "enabled");
        digester.addCallParam(shellServerPath, 1, "port");
        String detailPageHandlerPath = "*/system/detail-page-handler";
        digester.addObjectCreate(detailPageHandlerPath, CmsDefaultDetailPageHandler.class.getName(), N_CLASS);
        digester.addSetNext(detailPageHandlerPath, "setDetailPageHandler");
        String userdataPath = "*/system/userdata";
        CmsUserDataRequestManager.addDigesterRules(digester, userdataPath);
        digester.addSetNext(userdataPath, "setUserDataRequestManager");
    }

    @Override
    public org.dom4j.Element generateXml(org.dom4j.Element parent) {
        I_CmsWorkflowManager workflowMan;
        CmsServletContainerSettings servletContainerSettings;
        Object config;
        org.dom4j.Element systemElement = parent.addElement(N_SYSTEM);
        if (OpenCms.getRunLevel() >= 3) {
            this.m_localeManager = OpenCms.getLocaleManager();
            this.m_mailSettings = OpenCms.getSystemInfo().getMailSettings();
            this.m_historyEnabled = OpenCms.getSystemInfo().isHistoryEnabled();
            this.m_historyVersions = OpenCms.getSystemInfo().getHistoryVersions();
            this.m_historyVersionsAfterDeletion = OpenCms.getSystemInfo().getHistoryVersionsAfterDeletion();
            this.m_loginManager = OpenCms.getLoginManager();
        }
        org.dom4j.Element i18nElement = systemElement.addElement(N_I18N);
        i18nElement.addElement(N_LOCALEHANDLER).addAttribute(N_CLASS, this.m_localeManager.getLocaleHandler().getClass().getName());
        org.dom4j.Element localesElement = i18nElement.addElement(N_LOCALESCONFIGURED);
        Iterator<Locale> loc = this.m_localeManager.getAvailableLocales().iterator();
        while (loc.hasNext()) {
            localesElement.addElement(N_LOCALE).addText(loc.next().toString());
        }
        localesElement = i18nElement.addElement(N_LOCALESDEFAULT);
        loc = this.m_localeManager.getDefaultLocales().iterator();
        while (loc.hasNext()) {
            localesElement.addElement(N_LOCALE).setText(loc.next().toString());
        }
        i18nElement.addElement(N_TIMEZONE).setText(this.m_localeManager.getTimeZone().getID());
        if (null != this.m_localeManager.getReuseElementsStr()) {
            i18nElement.addElement(N_REUSE_ELEMENTS).setText(this.m_localeManager.getReuseElementsStr());
        }
        org.dom4j.Element mailElement = systemElement.addElement(N_MAIL);
        mailElement.addElement("mailfrom").setText(this.m_mailSettings.getMailFromDefault());
        for (CmsMailHost host : this.m_mailSettings.getMailHosts()) {
            org.dom4j.Element hostElement = mailElement.addElement(N_MAILHOST).addAttribute(A_ID, host.getId()).addAttribute("name", host.getHostname()).addAttribute("port", Integer.toString(host.getPort())).addAttribute("order", host.getOrder().toString()).addAttribute("protocol", host.getProtocol()).addAttribute(A_SECURITY, host.getSecurity()).addAttribute("mailfrom", host.getMailfrom());
            if (!host.isAuthenticating()) continue;
            hostElement.addAttribute("user", host.getUsername()).addAttribute("password", host.getPassword());
        }
        org.dom4j.Element eventsElement = systemElement.addElement(N_EVENTS);
        org.dom4j.Element eventManagerElement = eventsElement.addElement(N_EVENTMANAGER);
        eventManagerElement.addAttribute(N_CLASS, this.m_eventManager.getClass().getName());
        org.dom4j.Element historyElement = systemElement.addElement(N_VERSIONHISTORY);
        historyElement.addAttribute("enabled", String.valueOf(this.m_historyEnabled));
        historyElement.addAttribute("count", Integer.valueOf(this.m_historyVersions).toString());
        historyElement.addAttribute(A_DELETED, Integer.valueOf(this.m_historyVersionsAfterDeletion).toString());
        org.dom4j.Element resourceinitElement = systemElement.addElement(N_RESOURCEINIT);
        for (I_CmsResourceInit handler : this.m_resourceInitHandlers) {
            org.dom4j.Element handlerElement = resourceinitElement.addElement(N_RESOURCEINITHANDLER);
            handlerElement.addAttribute(N_CLASS, handler.getClass().getName());
            CmsParameterConfiguration config2 = handler.getConfiguration();
            if (config2 == null) continue;
            for (String key : config2.keySet()) {
                handlerElement.addElement("param").addAttribute("name", key).addText(config2.get(key));
            }
        }
        org.dom4j.Element requesthandlersElement = systemElement.addElement(N_REQUESTHANDLERS);
        for (I_CmsRequestHandler handler : this.m_requestHandlers) {
            org.dom4j.Element handlerElement = requesthandlersElement.addElement(N_REQUESTHANDLER);
            handlerElement.addAttribute(N_CLASS, handler.getClass().getName());
            CmsParameterConfiguration config3 = handler.getConfiguration();
            if (config3 == null) continue;
            for (String key : config3.keySet()) {
                handlerElement.addElement("param").addAttribute("name", key).addText(config3.get(key));
            }
        }
        org.dom4j.Element passwordhandlerElement = systemElement.addElement(N_PASSWORDHANDLER).addAttribute(N_CLASS, this.m_passwordHandler.getClass().getName());
        passwordhandlerElement.addElement(N_PASSWORDENCODING).addText(this.m_passwordHandler.getInputEncoding());
        passwordhandlerElement.addElement(N_DIGESTTYPE).addText(this.m_passwordHandler.getDigestType());
        CmsParameterConfiguration handlerParameters = this.m_passwordHandler.getConfiguration();
        if (handlerParameters != null) {
            handlerParameters.appendToXml(passwordhandlerElement);
        }
        if (this.m_validationHandler != null) {
            org.dom4j.Element valHandlerElem = systemElement.addElement(N_VALIDATIONHANDLER);
            valHandlerElem.addAttribute(N_CLASS, this.m_validationHandler);
        }
        if (this.m_loginManager != null) {
            org.dom4j.Element managerElement = systemElement.addElement(N_LOGINMANAGER);
            managerElement.addElement(N_DISABLEMINUTES).addText(String.valueOf(this.m_loginManager.getDisableMinutes()));
            managerElement.addElement(N_MAXBADATTEMPTS).addText(String.valueOf(this.m_loginManager.getMaxBadAttempts()));
            managerElement.addElement(N_ENABLESCURITY).addText(String.valueOf(this.m_loginManager.isEnableSecurity()));
            String tokenLifetimeStr = this.m_loginManager.getTokenLifetimeStr();
            if (tokenLifetimeStr != null) {
                managerElement.addElement(N_TOKEN_LIFETIME).addText(tokenLifetimeStr);
            }
            if (this.m_loginManager.getMaxInactive() != null) {
                managerElement.addElement(N_MAX_INACTIVE_TIME).addText(this.m_loginManager.getMaxInactive());
            }
            if (this.m_loginManager.getPasswordChangeIntervalStr() != null) {
                managerElement.addElement(N_PASSWORD_CHANGE_INTERVAL).addText(this.m_loginManager.getPasswordChangeIntervalStr());
            }
            if (this.m_loginManager.getUserDataCheckIntervalStr() != null) {
                managerElement.addElement(N_USER_DATA_CHECK_INTERVAL).addText(this.m_loginManager.getUserDataCheckIntervalStr());
            }
            if (this.m_loginManager.isOrgUnitRequired()) {
                managerElement.addElement(N_REQUIRE_ORGUNIT).addText("true");
            }
            if (this.m_loginManager.getLogoutUri() != null) {
                managerElement.addElement(N_LOGOUT_URI).addText(this.m_loginManager.getLogoutUri());
            }
        }
        if (this.m_twoFactorConfig != null) {
            systemElement.add(this.m_twoFactorConfig.getConfigElement());
        }
        org.dom4j.Element saxImpl = systemElement.addElement(N_SAX_IMPL_SYSTEM_PROPERTIES);
        saxImpl.setText(String.valueOf(this.m_saxImplProperties));
        org.dom4j.Element runtimepropertiesElement = systemElement.addElement(N_RUNTIMEPROPERTIES);
        if (this.m_runtimeProperties != null) {
            ArrayList<String> sortedRuntimeProperties = new ArrayList<String>(this.m_runtimeProperties.keySet());
            Collections.sort(sortedRuntimeProperties);
            for (String key : sortedRuntimeProperties) {
                runtimepropertiesElement.addElement("param").addAttribute("name", key).addText(this.m_runtimeProperties.get(key));
            }
        }
        org.dom4j.Element runtimeinfoElement = systemElement.addElement(N_RUNTIMECLASSES);
        org.dom4j.Element runtimeinfofactoryElement = runtimeinfoElement.addElement(N_RUNTIMEINFO);
        runtimeinfofactoryElement.addAttribute(N_CLASS, this.getRuntimeInfoFactory().getClass().getName());
        org.dom4j.Element defaultusersElement = systemElement.addElement(N_DEFAULTUSERS);
        defaultusersElement.addElement(N_USER_ADMIN).addText(this.m_cmsDefaultUsers.getUserAdmin());
        defaultusersElement.addElement(N_USER_GUEST).addText(this.m_cmsDefaultUsers.getUserGuest());
        defaultusersElement.addElement(N_USER_EXPORT).addText(this.m_cmsDefaultUsers.getUserExport());
        if (!this.m_cmsDefaultUsers.getUserDeletedResource().equals(this.m_cmsDefaultUsers.getUserAdmin())) {
            defaultusersElement.addElement(N_USER_DELETEDRESOURCE).addText(this.m_cmsDefaultUsers.getUserDeletedResource());
        }
        defaultusersElement.addElement(N_GROUP_ADMINISTRATORS).addText(this.m_cmsDefaultUsers.getGroupAdministrators());
        defaultusersElement.addElement(N_GROUP_USERS).addText(this.m_cmsDefaultUsers.getGroupUsers());
        defaultusersElement.addElement(N_GROUP_GUESTS).addText(this.m_cmsDefaultUsers.getGroupGuests());
        systemElement.addElement(N_DEFAULT_CONTENT_ENCODING).addText(this.getDefaultContentEncoding());
        if (this.m_cmsMemoryMonitorConfiguration != null) {
            List<String> emailReceiver;
            org.dom4j.Element memorymonitorElement = systemElement.addElement(N_MEMORYMONITOR);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_cmsMemoryMonitorConfiguration.getClassName())) {
                memorymonitorElement.addAttribute(N_CLASS, this.m_cmsMemoryMonitorConfiguration.getClassName());
            }
            memorymonitorElement.addElement(N_MAXUSAGE_PERCENT).addText(String.valueOf(this.m_cmsMemoryMonitorConfiguration.getMaxUsagePercent()));
            memorymonitorElement.addElement(N_LOG_INTERVAL).addText(String.valueOf(this.m_cmsMemoryMonitorConfiguration.getLogInterval()));
            if (this.m_cmsMemoryMonitorConfiguration.getEmailInterval() >= 0) {
                memorymonitorElement.addElement(N_EMAIL_INTERVAL).addText(String.valueOf(this.m_cmsMemoryMonitorConfiguration.getEmailInterval()));
            }
            memorymonitorElement.addElement(N_WARNING_INTERVAL).addText(String.valueOf(this.m_cmsMemoryMonitorConfiguration.getWarningInterval()));
            if (this.m_cmsMemoryMonitorConfiguration.getEmailSender() != null) {
                memorymonitorElement.addElement(N_EMAIL_SENDER).addText(this.m_cmsMemoryMonitorConfiguration.getEmailSender());
            }
            if (!(emailReceiver = this.m_cmsMemoryMonitorConfiguration.getEmailReceiver()).isEmpty()) {
                org.dom4j.Element emailreceiverElement = memorymonitorElement.addElement(N_EMAIL_RECEIVER);
                Iterator<String> iter = emailReceiver.iterator();
                while (iter.hasNext()) {
                    emailreceiverElement.addElement(N_RECEIVER).addText(iter.next());
                }
            }
        }
        org.dom4j.Element flexcacheElement = systemElement.addElement(N_FLEXCACHE);
        flexcacheElement.addElement(N_CACHE_ENABLED).addText(String.valueOf(this.m_cmsFlexCacheConfiguration.isCacheEnabled()));
        flexcacheElement.addElement(N_CACHE_OFFLINE).addText(String.valueOf(this.m_cmsFlexCacheConfiguration.isCacheOffline()));
        flexcacheElement.addElement(N_MAXCACHEBYTES).addText(String.valueOf(this.m_cmsFlexCacheConfiguration.getMaxCacheBytes()));
        flexcacheElement.addElement(N_AVGCACHEBYTES).addText(String.valueOf(this.m_cmsFlexCacheConfiguration.getAvgCacheBytes()));
        flexcacheElement.addElement(N_MAXENTRYBYTES).addText(String.valueOf(this.m_cmsFlexCacheConfiguration.getMaxEntryBytes()));
        flexcacheElement.addElement(N_MAXKEYS).addText(String.valueOf(this.m_cmsFlexCacheConfiguration.getMaxKeys()));
        if (this.m_cmsFlexCacheConfiguration.getDeviceSelectorConfiguration() != null) {
            org.dom4j.Element flexcacheDeviceSelectorElement = flexcacheElement.addElement(N_DEVICESELECTOR);
            flexcacheDeviceSelectorElement.addAttribute(N_CLASS, this.m_cmsFlexCacheConfiguration.getDeviceSelectorConfiguration());
        }
        org.dom4j.Element httpAuthenticationElement = systemElement.addElement(N_HTTP_AUTHENTICATION);
        httpAuthenticationElement.addElement(N_BROWSER_BASED).setText(this.m_httpAuthenticationSettings.getConfigBrowserBasedAuthentication());
        if (this.m_httpAuthenticationSettings.getFormBasedHttpAuthenticationUri() != null) {
            httpAuthenticationElement.addElement(N_FORM_BASED).setText(this.m_httpAuthenticationSettings.getFormBasedHttpAuthenticationUri());
        }
        org.dom4j.Element cacheElement = systemElement.addElement(N_RESULTCACHE);
        cacheElement.addElement(N_KEYGENERATOR).setText(this.m_cacheSettings.getCacheKeyGenerator());
        cacheElement.addElement(N_SIZE_USERS).setText(Integer.toString(this.m_cacheSettings.getUserCacheSize()));
        cacheElement.addElement(N_SIZE_GROUPS).setText(Integer.toString(this.m_cacheSettings.getGroupCacheSize()));
        if (this.m_cacheSettings.getConfiguredOrgUnitCacheSize() > -1) {
            cacheElement.addElement(N_SIZE_ORGUNITS).setText(Integer.toString(this.m_cacheSettings.getConfiguredOrgUnitCacheSize()));
        }
        cacheElement.addElement(N_SIZE_USERGROUPS).setText(Integer.toString(this.m_cacheSettings.getUserGroupsCacheSize()));
        cacheElement.addElement(N_SIZE_PROJECTS).setText(Integer.toString(this.m_cacheSettings.getProjectCacheSize()));
        if (this.m_cacheSettings.getConfiguredProjectResourcesCacheSize() > -1) {
            cacheElement.addElement(N_SIZE_PROJECTRESOURCES).setText(Integer.toString(this.m_cacheSettings.getConfiguredProjectResourcesCacheSize()));
        }
        cacheElement.addElement(N_SIZE_RESOURCES).setText(Integer.toString(this.m_cacheSettings.getResourceCacheSize()));
        if (this.m_cacheSettings.getConfiguredRolesCacheSize() > -1) {
            cacheElement.addElement(N_SIZE_ROLES).setText(Integer.toString(this.m_cacheSettings.getConfiguredRolesCacheSize()));
        }
        cacheElement.addElement(N_SIZE_RESOURCELISTS).setText(Integer.toString(this.m_cacheSettings.getResourcelistCacheSize()));
        cacheElement.addElement(N_SIZE_PROPERTIES).setText(Integer.toString(this.m_cacheSettings.getPropertyCacheSize()));
        if (this.m_cacheSettings.getConfiguredPropertyListsCacheSize() > -1) {
            cacheElement.addElement(N_SIZE_PROPERTYLISTS).setText(Integer.toString(this.m_cacheSettings.getConfiguredPropertyListsCacheSize()));
        }
        cacheElement.addElement(N_SIZE_ACLS).setText(Integer.toString(this.m_cacheSettings.getAclCacheSize()));
        cacheElement.addElement(N_SIZE_PERMISSIONS).setText(Integer.toString(this.m_cacheSettings.getPermissionCacheSize()));
        if (this.m_notificationTime != null || this.m_notificationProject != null) {
            org.dom4j.Element notificationElement = systemElement.addElement(N_CONTENT_NOTIFICATION);
            if (this.m_notificationTime != null) {
                notificationElement.addElement(N_NOTIFICATION_TIME).setText(this.m_notificationTime.toString());
            }
            if (this.m_notificationProject != null) {
                notificationElement.addElement(N_NOTIFICATION_PROJECT).setText(this.m_notificationProject);
            }
        }
        if (this.m_authorizationHandler != null) {
            org.dom4j.Element authorizationHandlerElem = systemElement.addElement(N_AUTHORIZATIONHANDLER);
            authorizationHandlerElem.addAttribute(N_CLASS, this.m_authorizationHandler);
        }
        if (this.m_apiAuthorizations.size() > 0) {
            org.dom4j.Element authsElement = systemElement.addElement(N_API_AUTHORIZATIONS);
            for (ApiAuthorizationConfig apiAuth : this.m_apiAuthorizations) {
                apiAuth.fillXml(authsElement.addElement(N_API_AUTHORIZATION));
            }
        }
        org.dom4j.Element encryptionElement = systemElement.addElement(N_ENCRYPTION);
        for (I_CmsTextEncryption encrypter : this.m_textEncryptions.values()) {
            org.dom4j.Element textEncryption = encryptionElement.addElement(N_TEXT_ENCRYPTION);
            textEncryption.addAttribute(N_CLASS, encrypter.getClass().getName());
            textEncryption.addAttribute("name", encrypter.getName());
            config = encrypter.getConfiguration();
            for (Map.Entry<String, String> entry : ((CmsParameterConfiguration)config).entrySet()) {
                textEncryption.addElement("param").addAttribute("name", entry.getKey()).addText(entry.getValue());
            }
        }
        if (this.m_publishManager != null) {
            org.dom4j.Element pubHistElement = systemElement.addElement(N_PUBLISHMANAGER);
            pubHistElement.addElement(N_HISTORYSIZE).setText(String.valueOf(this.m_publishManager.getPublishHistorySize()));
            pubHistElement.addElement(N_QUEUEPERSISTANCE).setText(String.valueOf(this.m_publishManager.isPublishQueuePersistanceEnabled()));
            pubHistElement.addElement(N_QUEUESHUTDOWNTIME).setText(String.valueOf(this.m_publishManager.getPublishQueueShutdowntime()));
            pubHistElement.addElement(N_AUTO_CLEANUP_HISTORY_ENTRIES).setText(String.valueOf(this.m_publishManager.isAutoCleanupHistoryEntries()));
        }
        if (this.m_sessionStorageProvider != null) {
            org.dom4j.Element sessionStorageProviderElem = systemElement.addElement(N_SESSION_STORAGEPROVIDER);
            sessionStorageProviderElem.addAttribute(N_CLASS, this.m_sessionStorageProvider);
        }
        if (this.m_permissionHandler != null) {
            org.dom4j.Element permissionHandlerElem = systemElement.addElement(N_PERMISSIONHANDLER);
            permissionHandlerElem.addAttribute(N_CLASS, this.m_permissionHandler);
        }
        if (!(servletContainerSettings = OpenCms.getSystemInfo().getServletContainerSettings()).getMode().isNone()) {
            org.dom4j.Element servletContainerSettingsElem = systemElement.addElement(N_SERVLETCONTAINERSETTINGS);
            servletContainerSettingsElem.addAttribute("mode", servletContainerSettings.getMode().getMode());
            if (!servletContainerSettings.getMode().isAuto()) {
                servletContainerSettingsElem.addElement(N_PREVENTRESPONSEFLUSH).addText("" + servletContainerSettings.isPreventResponseFlush());
                servletContainerSettingsElem.addElement(N_RELEASETAGSAFTEREND).addText("" + servletContainerSettings.isReleaseTagsAfterEnd());
            }
            if (servletContainerSettings.getRequestErrorPageAttribute() != null) {
                servletContainerSettingsElem.addElement(N_REQUESTERRORPAGEATTRIBUTE).addText(servletContainerSettings.getRequestErrorPageAttribute());
            }
        }
        if (this.getAdeConfiguration() != null || this.getAdeCacheSettings() != null || !this.m_adeParameters.isEmpty()) {
            org.dom4j.Element adeElem = systemElement.addElement(N_ADE);
            if (this.getAdeConfiguration() != null) {
                adeElem.addElement(N_CONFIGURATION).addAttribute(N_CLASS, this.getAdeConfiguration());
            }
            if (!this.m_adeParameters.isEmpty()) {
                org.dom4j.Element paramsElement = adeElem.addElement(N_PARAMETERS);
                for (Map.Entry entry : this.m_adeParameters.entrySet()) {
                    String name = (String)entry.getKey();
                    String string = (String)entry.getValue();
                    org.dom4j.Element paramElement = paramsElement.addElement("param");
                    paramElement.addAttribute("name", name);
                    paramElement.setText(string);
                }
            }
            if (this.getAdeCacheSettings() != null) {
                org.dom4j.Element cacheElem = adeElem.addElement(N_ADE_CACHE);
                org.dom4j.Element cntPageCacheElem = cacheElem.addElement(N_CONTAINERPAGES);
                cntPageCacheElem.addAttribute(A_OFFLINE, "" + this.getAdeCacheSettings().getContainerPageOfflineSize());
                cntPageCacheElem.addAttribute(A_ONLINE, "" + this.getAdeCacheSettings().getContainerPageOnlineSize());
                org.dom4j.Element element = cacheElem.addElement(N_GROUPCONTAINERS);
                element.addAttribute(A_OFFLINE, "" + this.getAdeCacheSettings().getGroupContainerOfflineSize());
                element.addAttribute(A_ONLINE, "" + this.getAdeCacheSettings().getGroupContainerOnlineSize());
            }
        }
        if (this.getSubscriptionManager() != null) {
            org.dom4j.Element subscrManElem = systemElement.addElement(N_SUBSCRIPTIONMANAGER);
            subscrManElem.addAttribute("enabled", Boolean.toString(this.getSubscriptionManager().isEnabled()));
            subscrManElem.addAttribute(A_POOLNAME, this.getSubscriptionManager().getPoolName());
            subscrManElem.addAttribute(A_MAXVISITED, String.valueOf(this.getSubscriptionManager().getMaxVisitedCount()));
        }
        if ((workflowMan = this.getWorkflowManager()) != null) {
            org.dom4j.Element workflowElem = systemElement.addElement(N_WORKFLOW);
            workflowElem.addAttribute(N_CLASS, workflowMan.getClass().getName());
            Map<String, String> parameters = workflowMan.getParameters();
            org.dom4j.Element element = workflowElem.addElement(N_PARAMETERS);
            for (Map.Entry entry : parameters.entrySet()) {
                org.dom4j.Element paramElem = element.addElement("param");
                paramElem.addAttribute("name", (String)entry.getKey());
                paramElem.addText((String)entry.getValue());
            }
        }
        if (this.m_userSessionMode != null) {
            org.dom4j.Element userSessionElem = systemElement.addElement(N_USER_SESSION_MODE);
            userSessionElem.setText(this.m_userSessionMode.toString());
        }
        if (this.m_credentialsResolverClass != null) {
            systemElement.addElement(N_CREDENTIALS_RESOLVER).setText(this.m_credentialsResolverClass);
        }
        if (this.m_publishListRemoveMode != null) {
            systemElement.addElement(N_PUBLISH_LIST_REMOVE_MODE).addAttribute("mode", this.m_publishListRemoveMode);
        }
        if (this.m_detailPageHandler != null) {
            org.dom4j.Element handlerElement = systemElement.addElement(N_DETAIL_PAGE_HANDLER).addAttribute(N_CLASS, this.m_detailPageHandler.getClass().getName());
            config = this.m_detailPageHandler.getConfiguration();
            if (config != null) {
                for (String key : ((CmsParameterConfiguration)config).keySet()) {
                    handlerElement.addElement("param").addAttribute("name", key).addText(((CmsParameterConfiguration)config).get(key));
                }
            }
        }
        if (this.m_restrictDetailContents != null) {
            org.dom4j.Element restrictDetailContentsElem = systemElement.addElement(N_RESTRICT_DETAIL_CONTENTS);
            restrictDetailContentsElem.addText(this.m_restrictDetailContents);
        }
        if (this.m_shellServerOptions != null) {
            systemElement.addElement(N_SHELL_SERVER).addAttribute("enabled", "" + this.m_shellServerOptions.isEnabled()).addAttribute("port", "" + this.m_shellServerOptions.getPort());
        }
        CmsLetsEncryptConfiguration.CONFIG_HELPER.generateXml(systemElement, this.m_letsEncryptConfig);
        if (this.m_userDataRequestManager != null) {
            this.m_userDataRequestManager.appendToXml(systemElement);
        }
        return systemElement;
    }

    public CmsADECacheSettings getAdeCacheSettings() {
        return this.m_adeCacheSettings;
    }

    public String getAdeConfiguration() {
        return this.m_adeConfiguration;
    }

    public Map<String, String> getAdeParameters() {
        return this.m_adeParameters;
    }

    public Map<String, I_CmsApiAuthorizationHandler> getApiAuthorizations() {
        return this.m_apiAuthorizationMap;
    }

    public I_CmsAuthorizationHandler getAuthorizationHandler() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_authorizationHandler)) {
            return new CmsDefaultAuthorizationHandler();
        }
        try {
            I_CmsAuthorizationHandler authorizationHandler = (I_CmsAuthorizationHandler)Class.forName(this.m_authorizationHandler).newInstance();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("INIT_AUTHORIZATION_HANDLER_CLASS_SUCCESS_1", this.m_authorizationHandler));
            }
            authorizationHandler.setParameters(new HashMap<String, String>(this.m_authHandlerParams));
            return authorizationHandler;
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("INIT_AUTHORIZATION_HANDLER_CLASS_INVALID_1", this.m_authorizationHandler), t);
            return new CmsDefaultAuthorizationHandler();
        }
    }

    public CmsCacheSettings getCacheSettings() {
        return this.m_cacheSettings;
    }

    public CmsDefaultUsers getCmsDefaultUsers() {
        return this.m_cmsDefaultUsers;
    }

    public CmsFlexCacheConfiguration getCmsFlexCacheConfiguration() {
        return this.m_cmsFlexCacheConfiguration;
    }

    public CmsMemoryMonitorConfiguration getCmsMemoryMonitorConfiguration() {
        return this.m_cmsMemoryMonitorConfiguration;
    }

    public I_CmsCredentialsResolver getCredentialsResolver() {
        if (this.m_credentialsResolver == null) {
            this.m_credentialsResolver = new CmsDefaultCredentialsResolver();
        }
        return this.m_credentialsResolver;
    }

    public String getCredentialsResolverClass() {
        return this.m_credentialsResolverClass;
    }

    public String getDefaultContentEncoding() {
        return this.m_defaultContentEncoding;
    }

    public I_CmsDetailPageHandler getDetailPageHandler() {
        return this.m_detailPageHandler;
    }

    @Override
    public String getDtdFilename() {
        return CONFIGURATION_DTD_NAME;
    }

    public CmsEventManager getEventManager() {
        return this.m_eventManager;
    }

    public int getHistoryVersions() {
        return this.m_historyVersions;
    }

    public int getHistoryVersionsAfterDeletion() {
        return this.m_historyVersionsAfterDeletion;
    }

    public CmsHttpAuthenticationSettings getHttpAuthenticationSettings() {
        return this.m_httpAuthenticationSettings;
    }

    public CmsLetsEncryptConfiguration getLetsEncryptConfig() {
        return this.m_letsEncryptConfig;
    }

    public CmsLocaleManager getLocaleManager() {
        return this.m_localeManager;
    }

    public CmsLoginManager getLoginManager() {
        if (this.m_loginManager == null) {
            this.m_loginManager = new CmsLoginManager(15, 3, false, null, null, null, null, false, null);
        }
        return this.m_loginManager;
    }

    public CmsMailSettings getMailSettings() {
        return this.m_mailSettings;
    }

    public String getNotificationProject() {
        return this.m_notificationProject;
    }

    public int getNotificationTime() {
        if (this.m_notificationTime != null) {
            return this.m_notificationTime;
        }
        return -1;
    }

    public I_CmsPasswordHandler getPasswordHandler() {
        return this.m_passwordHandler;
    }

    public String getPermissionHandler() {
        return this.m_permissionHandler;
    }

    public CmsPublishManager.PublishListRemoveMode getPublishListRemoveMode() {
        try {
            return CmsPublishManager.PublishListRemoveMode.valueOf(StringUtils.trim((String)this.m_publishListRemoveMode));
        }
        catch (Exception e) {
            return CmsPublishManager.PublishListRemoveMode.allUsers;
        }
    }

    public String getPublishListRemoveModeStr() {
        return this.m_publishListRemoveMode;
    }

    public CmsPublishManager getPublishManager() {
        if (this.m_publishManager == null) {
            this.m_publishManager = new CmsPublishManager(100, false, 1);
        }
        return this.m_publishManager;
    }

    public List<I_CmsRequestHandler> getRequestHandlers() {
        return this.m_requestHandlers;
    }

    public List<I_CmsResourceInit> getResourceInitHandlers() {
        return this.m_resourceInitHandlers;
    }

    public I_CmsDbContextFactory getRuntimeInfoFactory() {
        return this.m_runtimeInfoFactory;
    }

    public Map<String, String> getRuntimeProperties() {
        return this.m_runtimeProperties;
    }

    public I_CmsSessionStorageProvider getSessionStorageProvider() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_sessionStorageProvider)) {
            return new CmsDefaultSessionStorageProvider();
        }
        try {
            I_CmsSessionStorageProvider sessionCacheProvider = (I_CmsSessionStorageProvider)Class.forName(this.m_sessionStorageProvider).newInstance();
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SESSION_STORAGEPROVIDER_SUCCESS_1", this.m_sessionStorageProvider));
            }
            return sessionCacheProvider;
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INIT_SESSION_STORAGEPROVIDER_FAILURE_1", this.m_sessionStorageProvider), t);
            return new CmsDefaultSessionStorageProvider();
        }
    }

    public CmsRemoteShellConfiguration getShellServerOptions() {
        return this.m_shellServerOptions;
    }

    public CmsSubscriptionManager getSubscriptionManager() {
        if (this.m_subscriptionManager == null) {
            this.m_subscriptionManager = new CmsSubscriptionManager();
        }
        return this.m_subscriptionManager;
    }

    public int getTempFileProjectId() {
        return this.m_tempFileProjectId;
    }

    public Map<String, I_CmsTextEncryption> getTextEncryptions() {
        return Collections.unmodifiableMap(this.m_textEncryptions);
    }

    public CmsTwoFactorAuthenticationConfig getTwoFactorAuthenticationConfig() {
        return this.m_twoFactorConfig;
    }

    public CmsUserDataRequestManager getUserDataRequestManager() {
        return this.m_userDataRequestManager;
    }

    public UserSessionMode getUserSessionMode(boolean useDefault) {
        if (this.m_userSessionMode != null) {
            return this.m_userSessionMode;
        }
        if (useDefault) {
            return DEFAULT_USER_SESSION_MODE;
        }
        return null;
    }

    public I_CmsValidationHandler getValidationHandler() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_validationHandler)) {
            return new CmsDefaultValidationHandler();
        }
        try {
            I_CmsValidationHandler validationHandler = (I_CmsValidationHandler)Class.forName(this.m_validationHandler).newInstance();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("INIT_VALIDATION_HANDLER_CLASS_SUCCESS_1", this.m_validationHandler));
            }
            return validationHandler;
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("INIT_VALIDATION_HANDLER_CLASS_INVALID_1", this.m_validationHandler), t);
            return new CmsDefaultValidationHandler();
        }
    }

    public I_CmsWorkflowManager getWorkflowManager() {
        return this.m_workflowManager;
    }

    public void initializeFinished() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SYSTEM_CONFIG_FINISHED_0"));
        }
    }

    public boolean isHistoryEnabled() {
        return this.m_historyEnabled;
    }

    public boolean isRestrictDetailContents() {
        return this.m_restrictDetailContents == null || Boolean.parseBoolean(this.m_restrictDetailContents.trim());
    }

    public void setAdeCacheSettings(CmsADECacheSettings settings) {
        this.m_adeCacheSettings = settings;
    }

    public void setAdeConfiguration(String className) {
        this.m_adeConfiguration = className;
    }

    public void setAuthorizationHandler(String authorizationHandlerClass) {
        this.m_authorizationHandler = authorizationHandlerClass;
    }

    public void setCacheSettings(CmsCacheSettings settings) {
        this.m_cacheSettings = settings;
    }

    public void setCmsDefaultUsers(String userAdmin, String userGuest, String userExport, String userDeletedResource, String groupAdministrators, String groupUsers, String groupGuests) {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_CHECKING_DEFAULT_USER_NAMES_0"));
        }
        this.m_cmsDefaultUsers = new CmsDefaultUsers(userAdmin, userGuest, userExport, userDeletedResource, groupAdministrators, groupUsers, groupGuests);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADMIN_USER_1", this.m_cmsDefaultUsers.getUserAdmin()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_GUEST_USER_1", this.m_cmsDefaultUsers.getUserGuest()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_USER_1", this.m_cmsDefaultUsers.getUserExport()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DELETED_RESOURCE_USER_1", this.m_cmsDefaultUsers.getUserDeletedResource()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADMIN_GROUP_1", this.m_cmsDefaultUsers.getGroupAdministrators()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_USERS_GROUP_1", this.m_cmsDefaultUsers.getGroupUsers()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_GUESTS_GROUP_1", this.m_cmsDefaultUsers.getGroupGuests()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DEFAULT_USER_NAMES_INITIALIZED_0"));
        }
    }

    public void setCmsFlexCacheConfiguration(CmsFlexCacheConfiguration flexCacheConfiguration) {
        this.m_cmsFlexCacheConfiguration = flexCacheConfiguration;
    }

    public void setCmsMemoryMonitorConfiguration(CmsMemoryMonitorConfiguration cmsMemoryMonitorConfiguration) {
        this.m_cmsMemoryMonitorConfiguration = cmsMemoryMonitorConfiguration;
    }

    public void setCredentialsResolver(String className) throws Exception {
        String originalClassName = className;
        className = className.trim();
        Class<?> resolverClass = Class.forName(className);
        this.m_credentialsResolver = (I_CmsCredentialsResolver)resolverClass.newInstance();
        this.m_credentialsResolverClass = originalClassName;
    }

    public void setDefaultContentEncoding(String defaultContentEncoding) {
        this.m_defaultContentEncoding = defaultContentEncoding;
    }

    public void setDetailPageHandler(I_CmsDetailPageHandler handler) {
        this.m_detailPageHandler = handler;
    }

    public void setHistorySettings(String historyEnabled, String historyVersions, String historyVersionsAfterDeletion) {
        this.m_historyEnabled = Boolean.valueOf(historyEnabled);
        this.m_historyVersions = Integer.valueOf(historyVersions);
        this.m_historyVersionsAfterDeletion = Integer.valueOf(historyVersionsAfterDeletion);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_HISTORY_SETTINGS_3", this.m_historyEnabled, this.m_historyVersions, this.m_historyVersionsAfterDeletion));
        }
    }

    public void setHttpAuthenticationSettings(CmsHttpAuthenticationSettings httpAuthenticationSettings) {
        this.m_httpAuthenticationSettings = httpAuthenticationSettings;
    }

    public void setLetsEncryptConfig(CmsLetsEncryptConfiguration letsEncryptConfig) {
        this.m_letsEncryptConfig = letsEncryptConfig;
    }

    public void setLocaleManager(CmsLocaleManager localeManager) {
        this.m_localeManager = localeManager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_CONFIG_I18N_FINISHED_0"));
        }
    }

    public void setLoginManager(String disableMinutesStr, String maxBadAttemptsStr, String enableSecurityStr, String tokenLifetime, String maxInactive, String passwordChangeInterval, String userDataCheckInterval, String requireOrgUnitStr, String logoutUri) {
        int maxBadAttempts;
        int disableMinutes;
        try {
            disableMinutes = Integer.valueOf(disableMinutesStr);
        }
        catch (NumberFormatException e) {
            disableMinutes = 15;
        }
        try {
            maxBadAttempts = Integer.valueOf(maxBadAttemptsStr);
        }
        catch (NumberFormatException e) {
            maxBadAttempts = 3;
        }
        boolean enableSecurity = Boolean.valueOf(enableSecurityStr);
        boolean requireOrgUnit = Boolean.valueOf(requireOrgUnitStr);
        this.m_loginManager = new CmsLoginManager(disableMinutes, maxBadAttempts, enableSecurity, tokenLifetime, maxInactive, passwordChangeInterval, userDataCheckInterval, requireOrgUnit, logoutUri);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOGINMANAGER_3", disableMinutes, maxBadAttempts, enableSecurity));
        }
    }

    public void setMailSettings(CmsMailSettings mailSettings) {
        this.m_mailSettings = mailSettings;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_MAIL_SETTINGS_1", mailSettings));
        }
    }

    public void setNotificationProject(String notificationProject) {
        this.m_notificationProject = notificationProject;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_NOTIFICATION_PROJECT_1", this.m_notificationProject));
        }
    }

    public void setNotificationTime(String notificationTime) {
        try {
            this.m_notificationTime = Integer.valueOf(notificationTime);
        }
        catch (Throwable t) {
            this.m_notificationTime = -1;
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_NOTIFICATION_TIME_1", this.m_notificationTime));
        }
    }

    public void setPasswordHandler(I_CmsPasswordHandler passwordHandler) {
        this.m_passwordHandler = passwordHandler;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_PWD_HANDLER_SUCCESS_1", passwordHandler.getClass().getName()));
        }
    }

    public void setPermissionHandler(String permissionHandler) {
        this.m_permissionHandler = permissionHandler;
    }

    public void setPreventResponseFlush(String configValue) {
        OpenCms.getSystemInfo().getServletContainerSettings().setPreventResponseFlush(Boolean.valueOf(configValue));
    }

    public void setPublishListRemoveMode(String removeMode) {
        this.m_publishListRemoveMode = removeMode;
    }

    public void setPublishManager(CmsPublishManager publishManager) {
        this.m_publishManager = publishManager;
    }

    public void setReleaseTagsAfterEnd(String configValue) {
        OpenCms.getSystemInfo().getServletContainerSettings().setReleaseTagsAfterEnd(Boolean.valueOf(configValue));
    }

    public void setRequestErrorPageAttribute(String configValue) {
        OpenCms.getSystemInfo().getServletContainerSettings().setRequestErrorPageAttribute(configValue);
    }

    public void setRestrictDetailContents(String restrictDetailContents) {
        this.m_restrictDetailContents = restrictDetailContents;
    }

    public void setRuntimeInfoFactory(String className) {
        Object objectInstance;
        try {
            objectInstance = Class.forName(className).newInstance();
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_CLASS_INIT_FAILURE_1", className), t);
            return;
        }
        if (objectInstance instanceof I_CmsDbContextFactory) {
            this.m_runtimeInfoFactory = (I_CmsDbContextFactory)objectInstance;
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_RUNTIME_INFO_FACTORY_SUCCESS_1", className));
            }
        } else if (CmsLog.INIT.isFatalEnabled()) {
            CmsLog.INIT.fatal((Object)Messages.get().getBundle().key("INIT_RUNTIME_INFO_FACTORY_FAILURE_1", className));
        }
    }

    public void setServletContainerSettingsMode(String configValue) {
        OpenCms.getSystemInfo().getServletContainerSettings().setMode(configValue);
    }

    public void setSessionStorageProvider(String sessionStorageProviderClass) {
        this.m_sessionStorageProvider = sessionStorageProviderClass;
    }

    public void setShellServerOptions(String enabled, String portStr) {
        int port;
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            port = 1101;
        }
        this.m_shellServerOptions = new CmsRemoteShellConfiguration(Boolean.parseBoolean(enabled), port);
    }

    public void setSubscriptionManager(CmsSubscriptionManager subscriptionManager) {
        this.m_subscriptionManager = subscriptionManager;
    }

    public void setTempFileProjectId(String tempFileProjectId) {
        try {
            this.m_tempFileProjectId = Integer.valueOf(tempFileProjectId);
        }
        catch (Throwable t) {
            this.m_tempFileProjectId = -1;
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_TEMPFILE_PROJECT_ID_1", this.m_tempFileProjectId));
        }
    }

    public void setUserDataRequestManager(CmsUserDataRequestManager manager) {
        this.m_userDataRequestManager = manager;
    }

    public void setUserSessionMode(String userSessionMode) {
        if (userSessionMode == null || this.m_userSessionMode != null) {
            throw new IllegalStateException("Can't set user session mode to " + userSessionMode);
        }
        this.m_userSessionMode = UserSessionMode.valueOf(userSessionMode);
    }

    public void setUseSaxImplSystemProperties(String enabled) {
        this.m_saxImplProperties = Boolean.parseBoolean(enabled);
    }

    public void setValidationHandler(String validationHandlerClass) {
        this.m_validationHandler = validationHandlerClass;
    }

    public void setWorkflowManager(I_CmsWorkflowManager workflowManager) {
        this.m_workflowManager = workflowManager;
    }

    public boolean useSaxImplSystemProperties() {
        return this.m_saxImplProperties;
    }

    protected void addApiAuthorization(ApiAuthorizationConfig config) {
        this.m_apiAuthorizations.add(config);
        try {
            Class<?> cls = Class.forName(config.getClassName(), false, this.getClass().getClassLoader());
            I_CmsApiAuthorizationHandler handler = (I_CmsApiAuthorizationHandler)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            handler.setParameters(config.getParams());
            this.m_apiAuthorizationMap.put(config.getName(), handler);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    protected void initMembers() {
        this.setXmlFileName(DEFAULT_XML_FILE_NAME);
        this.m_historyEnabled = true;
        this.m_historyVersions = 10;
        this.m_historyVersionsAfterDeletion = -1;
        this.m_resourceInitHandlers = new ArrayList<I_CmsResourceInit>();
        this.m_requestHandlers = new ArrayList<I_CmsRequestHandler>();
        this.m_runtimeProperties = new HashMap<String, String>();
        this.m_eventManager = new CmsEventManager();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SYSTEM_CONFIG_INIT_0"));
        }
    }

    public static class ApiAuthorizationConfig {
        private String m_class;
        private String m_name;
        private CmsParameterConfiguration m_params = new CmsParameterConfiguration();

        public void fillXml(org.dom4j.Element element) {
            element.addElement("name").addText(this.getName());
            element.addElement(CmsSystemConfiguration.N_CLASS).addText(this.getClassName());
            for (Map.Entry<String, String> entry : this.m_params.entrySet()) {
                org.dom4j.Element paramElem = element.addElement("param");
                paramElem.addAttribute("name", entry.getKey());
                paramElem.addText(entry.getValue());
            }
        }

        public String getClassName() {
            return this.m_class;
        }

        public String getName() {
            return this.m_name;
        }

        public CmsParameterConfiguration getParams() {
            return this.m_params;
        }

        public void setClassName(String class1) {
            this.m_class = class1;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public void setParam(String key, String value) {
            this.m_params.put(key, value);
        }
    }

    public static enum UserSessionMode {
        single,
        standard;

    }
}

