/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.digester3.CallMethodRule;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.dom4j.Element;
import org.opencms.ade.containerpage.shared.CmsCntPageData;
import org.opencms.ade.upload.I_CmsUploadRestriction;
import org.opencms.ade.upload.I_CmsVirusScanner;
import org.opencms.configuration.A_CmsXmlConfiguration;
import org.opencms.configuration.CmsAdditionalLogFolderConfig;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.CmsSetNextRule;
import org.opencms.configuration.Messages;
import org.opencms.configuration.preferences.I_CmsPreference;
import org.opencms.db.CmsExportPoint;
import org.opencms.file.types.CmsResourceTypeSubsitemapContentFolder;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsRfsFileViewer;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsAccountInfo;
import org.opencms.workplace.CmsWorkplaceManager;
import org.opencms.workplace.CmsWorkplaceUserInfoBlock;
import org.opencms.workplace.CmsWorkplaceUserInfoEntry;
import org.opencms.workplace.CmsWorkplaceUserInfoManager;
import org.opencms.workplace.I_CmsDialogHandler;
import org.opencms.workplace.editors.I_CmsEditorCssHandler;
import org.opencms.workplace.editors.I_CmsPreEditorActionDefinition;
import org.opencms.workplace.editors.directedit.I_CmsDirectEditProvider;
import org.opencms.workplace.explorer.CmsExplorerTypeAccess;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsIconRule;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.CmsToolRootHandler;
import org.xml.sax.Attributes;

public class CmsWorkplaceConfiguration
extends A_CmsXmlConfiguration {
    public static final String A_ADD_INFO_KEY = "addinfo-key";
    public static final String A_AUTOSETNAVIGATION = "autosetnavigation";
    public static final String A_AUTOSETTITLE = "autosettitle";
    public static final String A_BIGICON = "bigicon";
    public static final String A_BIGICONSTYLE = "bigiconstyle";
    public static final String A_CREATABLE = "creatable";
    public static final String A_DESCRIPTION = "description";
    public static final String A_DISPLAY_BY_REPOSITORY = "displayByRepository";
    public static final String A_DISPLAY_COLLAPSED = "displayCollapsed";
    public static final String A_EDITABLE = "editable";
    public static final String A_ERROR = "error";
    public static final String A_EXTENSION = "extension";
    public static final String A_FIELD = "field";
    public static final String A_INFO = "info";
    public static final String A_ISVIEW = "isview";
    public static final String A_NAME_PATTERN = "name-pattern";
    public static final String A_NICE_NAME = "nice-name";
    public static final String A_OPTIONAL = "optional";
    public static final String A_PAGE = "page";
    public static final String A_PARAMS = "params";
    public static final String A_PARENT = "parent";
    public static final String A_PATH = "path";
    public static final String A_PERMISSIONS = "permissions";
    public static final String A_PRINCIPAL = "principal";
    public static final String A_REFERENCE = "reference";
    public static final String A_REPLACE = "replace";
    public static final String A_RULE = "rule";
    public static final String A_RULE_REGEX = "rule-regex";
    public static final String A_RULES = "rules";
    public static final String A_SHOWNAVIGATION = "shownavigation";
    public static final String A_SMALLICONSTYLE = "smalliconstyle";
    public static final String A_TAB = "tab";
    public static final String A_TARGET = "target";
    public static final String A_VIEW_ORDER = "view-order";
    public static final String A_WIDGET = "widget";
    public static final String A_WIDGET_CONFIG = "widget-config";
    public static final String CONFIGURATION_DTD_NAME = "opencms-workplace.dtd";
    public static final String DEFAULT_XML_FILE_NAME = "opencms-workplace.xml";
    public static final String N_ACACIA_UNLOCK = "acacia-unlock";
    public static final String N_ACCESSCONTROL = "accesscontrol";
    public static final String N_ACCESSENTRY = "accessentry";
    public static final String N_ACCOUNTINFO = "account-info";
    public static final String N_ACCOUNTINFOS = "account-infos";
    public static final String N_ALLOW_ELEMENT_AUTHOR_TO_WORK_IN_GALLERIES = "allow-element-author-to-work-in-galleries";
    public static final String N_ALLOWBROKENRELATIONS = "allowbrokenrelations";
    public static final String N_AUTOLOCK = "autolock";
    public static final String N_BACKGROUNDCOLOR = "background-color";
    public static final String N_BUTTONSTYLE = "buttonstyle";
    public static final String N_CATEGORYDISPLAYOPTIONS = "categorydisplayoptions";
    public static final String N_CATEGORYFOLDER = "categoryfolder";
    public static final String N_COLOR = "color";
    public static final String N_DATECREATED = "show-datecreated";
    public static final String N_DATEEXPIRED = "show-dateexpired";
    public static final String N_DATELASTMODIFIED = "show-datelastmodified";
    public static final String N_DATERELEASED = "show-datereleased";
    public static final String N_DEFAULTACCESSCONTROL = "defaultaccesscontrol";
    public static final String N_DEFAULTLOCALE = "defaultlocale";
    public static final String N_DEFAULTPREFERENCES = "default-preferences";
    public static final String N_DEFAULTPROPERTIES = "defaultproperties";
    public static final String N_DEFAULTPROPERTIESONSTRUCTURE = "defaultpropertiesonstructure";
    public static final String N_DEFAULTPROPERTY = "defaultproperty";
    public static final String N_DIALOGHANDLER = "dialoghandler";
    public static final String N_DIALOGHANDLERS = "dialoghandlers";
    public static final String N_DIALOGSDEFAULTSETTINGS = "dialogs-defaultsettings";
    public static final String N_DIALOGSPREFERENCES = "dialogs-preferences";
    public static final String N_DIRECTEDITPROVIDER = "directeditprovider";
    public static final String N_DIRECTEDITSTYLE = "directeditstyle";
    public static final String N_DIRECTPUBLISH = "directpublish";
    public static final String N_EDITOPTIONS = "editoptions";
    public static final String N_EDITOR = "editor";
    public static final String N_EDITORACTION = "editoraction";
    public static final String N_EDITORCSSHANDLER = "editorcsshandler";
    public static final String N_EDITORCSSHANDLERS = "editorcsshandlers";
    public static final String N_EDITORGENERALOPTIONS = "editors-generaloptions";
    public static final String N_EDITORHANDLER = "editorhandler";
    public static final String N_EDITORPRECONDITION = "editorprecondition";
    public static final String N_EDITORPRECONDITIONS = "editorpreconditions";
    public static final String N_EDITORPREFERENCES = "editors-preferences";
    public static final String N_EDITORPREFERREDEDITORS = "editors-preferrededitors";
    public static final String N_ELEMENT_DELETE_MODE = "element-delete-mode";
    public static final String N_ENABLEADVANCEDPROPERTYTABS = "enableadvancedpropertytabs";
    public static final String N_ENABLED = "enabled";
    public static final String N_ENABLEUSERMGMT = "enableusermanagement";
    public static final String N_ENTRIES = "entries";
    public static final String N_ENTRY = "entry";
    public static final String N_ENTRYOPTIONS = "entryoptions";
    public static final String N_EXCLUDEPATTERN = "exclude-pattern";
    public static final String N_EXPANDPERMISSIONSINHERITED = "expand-permissionsinherited";
    public static final String N_EXPANDPERMISSIONSUSER = "expand-permissionsuser";
    public static final String N_EXPLORERDISPLAYOPTIONS = "explorer-displayoptions";
    public static final String N_EXPLORERGENERALOPTIONS = "explorer-generaloptions";
    public static final String N_EXPLORERPREFERENCES = "explorer-preferences";
    public static final String N_EXPLORERTYPE = "explorertype";
    public static final String N_EXPLORERTYPES = "explorertypes";
    public static final String N_FILECOPY = "filecopy";
    public static final String N_FILEDELETION = "filedeletion";
    public static final String N_FILEENCODING = "fileEncoding";
    public static final String N_FILEPATH = "filePath";
    public static final String N_FOLDER = "folder";
    public static final String N_FOLDERCOPY = "foldercopy";
    public static final String N_GALLERIESPREFERENCES = "galleries-preferences";
    public static final String N_GALLERY_DEFAULT_SCOPE = "gallery-default-scope";
    public static final String N_GROUP_TRANSLATION = "group-translation";
    public static final String N_HELPTEXT = "helptext";
    public static final String N_ICONRULE = "iconrule";
    public static final String N_ICONRULES = "iconrules";
    public static final String N_INFOBLOCK = "info-block";
    public static final String N_ISLOGFILE = "isLogfile";
    public static final String N_KEEP_ALIVE = "keep-alive";
    public static final String N_KEY = "key";
    public static final String N_LABELEDFOLDERS = "labeledfolders";
    public static final String N_LISTALLPROJECTS = "listallprojects";
    public static final String N_LOCALE = "locale";
    public static final String N_LOCALIZEDFOLDERS = "localizedfolders";
    public static final String N_LOCKEDBY = "show-lockedby";
    public static final String N_MAXUPLOADSIZE = "maxfileuploadsize";
    public static final String N_NAVTEXT = "show-navtext";
    public static final String N_NEWFOLDERCREATEINDEXPAGE = "newfolder-createindexpage";
    public static final String N_NEWFOLDEREDITPROPERTIES = "newfolder-editproperties";
    public static final String N_NEWRESOURCE = "newresource";
    public static final String N_PERMISSIONS = "show-permissions";
    public static final String N_PERMISSIONSINHERITONFOLDER = "permissions-inheritonfolder";
    public static final String N_POSTUPLOADHANDLER = "postuploadhandler";
    public static final String N_PREFERENCE = "preference";
    public static final String N_PREFERENCE_TAB = "preference-tab";
    public static final String N_PROJECT = "project";
    public static final String N_PUBLISHBUTTONAPPEARANCE = "publishbuttonappearance";
    public static final String N_PUBLISHNOTIFICATION = "publishnotification";
    public static final String N_PUBLISHRELATEDRESOURCES = "publishrelatedresources";
    public static final String N_REPORTTYPE = "reporttype";
    public static final String N_REPOSITORY_FOLDER = "repositoryfolder";
    public static final String N_RESTRICTEXPLORERVIEW = "restrictexplorerview";
    public static final String N_RFSFILEVIEWESETTINGS = "rfsfileviewsettings";
    public static final String N_ROOT = "root";
    public static final String N_ROOTPATH = "rootPath";
    public static final String N_ROOTS = "roots";
    public static final String N_SEARCHINDEXNAME = "searchindex-name";
    public static final String N_SEARCHVIEWSTYLE = "searchview-style";
    public static final String N_SEPARATOR = "separator";
    public static final String N_SHOWEXPORTSETTINGS = "showexportsettings";
    public static final String N_SHOWFILEUPLOADBUTTON = "show-fileuploadbutton";
    public static final String N_SHOWLOCK = "showlock";
    public static final String N_SHOWMESSAGES = "showmessages";
    public static final String N_SHOWUPLOADTYPEDIALOG = "show-uploadtypedialog";
    public static final String N_SIZE = "show-size";
    public static final String N_STARTGALLERIES = "startgalleries";
    public static final String N_STARTGALLERY = "startgallery";
    public static final String N_STATE = "show-state";
    public static final String N_SUBSITEMAP_CREATION_MODE = "subsitemap-creation-mode";
    public static final String N_SYNCHRONIZATION = "synchronization";
    public static final String N_TEXT = "text";
    public static final String N_TITLE = "show-title";
    public static final String N_TOOLMANAGER = "tool-manager";
    public static final String N_TYPE = "show-type";
    public static final String N_UPLOAD_RESTRICTION = "upload-restriction";
    public static final String N_UPLOADAPPLET = "uploadapplet";
    public static final String N_URI = "uri";
    public static final String N_USER_LISTS = "user-lists";
    public static final String N_USERCREATED = "show-usercreated";
    public static final String N_USERINFO = "user-info";
    public static final String N_USERINFOS = "user-infos";
    public static final String N_USERLASTMODIFIED = "show-userlastmodified";
    public static final String N_VIRUS_SCANNER = "virus-scanner";
    public static final String N_WINDOWSIZE = "windowSize";
    public static final String N_WORKPLACE = "workplace";
    public static final String N_WORKPLACEGENERALOPTIONS = "workplace-generaloptions";
    public static final String N_WORKPLACEPREFERENCES = "workplace-preferences";
    public static final String N_WORKPLACESEARCH = "workplace-search";
    public static final String N_WORKPLACESTARTUPSETTINGS = "workplace-startupsettings";
    public static final String N_WORKPLACEVIEW = "workplaceview";
    public static final String N_XMLCONTENTAUTOCORRECTION = "xmlcontentautocorrection";
    private static final String A_ELEMENTVIEW = "elementview";
    private static final String A_REQUIRED_ON_UPLOAD = "requiredOnUpload";
    private static final String N_SITEMAP_CONFIG_EDIT_ROLE = "sitemap-config-edit-role";
    private static final String N_USE_FORMATTER_KEYS_FOR_NEW_SITES = "use-formatter-keys-for-new-sites";
    private CmsWorkplaceManager m_workplaceManager;

    public static void addExplorerTypeXmlRules(Digester digester) {
        digester.addObjectCreate("*/explorertype", CmsExplorerTypeSettings.class);
        digester.addSetNext("*/explorertype", "addExplorerTypeSetting");
        digester.addCallMethod("*/explorertype", "setTypeAttributes", 11);
        digester.addCallParam("*/explorertype", 0, "name");
        digester.addCallParam("*/explorertype", 1, N_KEY);
        digester.addCallParam("*/explorertype", 2, "icon");
        digester.addCallParam("*/explorertype", 3, A_BIGICON);
        digester.addCallParam("*/explorertype", 4, A_SMALLICONSTYLE);
        digester.addCallParam("*/explorertype", 5, A_BIGICONSTYLE);
        digester.addCallParam("*/explorertype", 6, A_REFERENCE);
        digester.addCallParam("*/explorertype", 7, A_ELEMENTVIEW);
        digester.addCallParam("*/explorertype", 8, A_ISVIEW);
        digester.addCallParam("*/explorertype", 9, A_NAME_PATTERN);
        digester.addCallParam("*/explorertype", 10, A_VIEW_ORDER);
        digester.addCallMethod("*/explorertype/iconrules/iconrule", "addIconRule", 5);
        digester.addCallParam("*/explorertype/iconrules/iconrule", 0, A_EXTENSION);
        digester.addCallParam("*/explorertype/iconrules/iconrule", 1, "icon");
        digester.addCallParam("*/explorertype/iconrules/iconrule", 2, A_BIGICON);
        digester.addCallParam("*/explorertype/iconrules/iconrule", 3, A_SMALLICONSTYLE);
        digester.addCallParam("*/explorertype/iconrules/iconrule", 4, A_BIGICONSTYLE);
        digester.addCallMethod("*/explorertype/newresource", "setCreatable", 1);
        digester.addCallParam("*/explorertype/newresource", 0, A_CREATABLE);
        digester.addCallMethod("*/explorertype/newresource", "setNewResourceOrder", 1);
        digester.addCallParam("*/explorertype/newresource", 0, "order");
        digester.addCallMethod("*/explorertype/newresource", "setAutoSetNavigation", 1);
        digester.addCallParam("*/explorertype/newresource", 0, A_AUTOSETNAVIGATION);
        digester.addCallMethod("*/explorertype/newresource", "setAutoSetTitle", 1);
        digester.addCallParam("*/explorertype/newresource", 0, A_AUTOSETTITLE);
        digester.addCallMethod("*/explorertype/newresource", "setInfo", 1);
        digester.addCallParam("*/explorertype/newresource", 0, A_INFO);
        digester.addCallMethod("*/explorertype/newresource", "setTitleKey", 1);
        digester.addCallParam("*/explorertype/newresource", 0, N_KEY);
        digester.addObjectCreate("*/explorertype/accesscontrol", CmsExplorerTypeAccess.class);
        digester.addSetNext("*/explorertype/accesscontrol", "setAccess");
        digester.addCallMethod("*/explorertype/accesscontrol/accessentry", "addAccessEntry", 2);
        digester.addCallParam("*/explorertype/accesscontrol/accessentry", 0, A_PRINCIPAL);
        digester.addCallParam("*/explorertype/accesscontrol/accessentry", 1, A_PERMISSIONS);
        digester.addCallMethod("*/explorertype/editoptions/defaultproperties", "setPropertyDefaults", 2);
        digester.addCallParam("*/explorertype/editoptions/defaultproperties", 0, N_ENABLED);
        digester.addCallParam("*/explorertype/editoptions/defaultproperties", 1, A_SHOWNAVIGATION);
        digester.addCallMethod("*/explorertype/editoptions/defaultproperties/property", "addProperty", 2);
        digester.addCallParam("*/explorertype/editoptions/defaultproperties/property", 0, "name");
        digester.addCallParam("*/explorertype/editoptions/defaultproperties/property", 1, A_REQUIRED_ON_UPLOAD);
        digester.addCallMethod("*/explorertype/editoptions/defaultproperties/defaultproperty", "addProperty", 2);
        digester.addCallParam("*/explorertype/editoptions/defaultproperties/defaultproperty", 0, "name");
        digester.addCallParam("*/explorertype/editoptions/defaultproperties/defaultproperty", 1, A_REQUIRED_ON_UPLOAD);
        digester.addCallMethod("*/explorertype/editoptions", "setEditOptions");
    }

    public static void generateExplorerTypesXml(Element startNode, List<CmsExplorerTypeSettings> explorerTypes, boolean module) {
        CmsExplorerTypeAccess defaultAccess = null;
        if (OpenCms.getWorkplaceManager() != null) {
            defaultAccess = OpenCms.getWorkplaceManager().getDefaultAccess();
        }
        for (CmsExplorerTypeSettings settings : explorerTypes) {
            Map<String, CmsIconRule> iconRules;
            if (settings.isAddititionalModuleExplorerType() != module) continue;
            Element explorerTypeElement = startNode.addElement(N_EXPLORERTYPE);
            explorerTypeElement.addAttribute("name", settings.getName());
            explorerTypeElement.addAttribute(N_KEY, settings.getKey());
            String originalIcon = settings.getOriginalIcon();
            if (CmsStringUtil.isNotEmpty(originalIcon)) {
                explorerTypeElement.addAttribute("icon", settings.getOriginalIcon());
            }
            if (CmsStringUtil.isNotEmpty(settings.getBigIcon())) {
                explorerTypeElement.addAttribute(A_BIGICON, settings.getBigIcon());
            }
            if (CmsStringUtil.isNotEmpty(settings.getSmallIconStyle())) {
                explorerTypeElement.addAttribute(A_SMALLICONSTYLE, settings.getSmallIconStyle());
            }
            if (CmsStringUtil.isNotEmpty(settings.getBigIconStyle())) {
                explorerTypeElement.addAttribute(A_BIGICONSTYLE, settings.getBigIconStyle());
            }
            if (settings.getReference() != null) {
                explorerTypeElement.addAttribute(A_REFERENCE, settings.getReference());
            }
            if (settings.getElementView() != null) {
                explorerTypeElement.addAttribute(A_ELEMENTVIEW, settings.getElementView());
            }
            if (settings.isView()) {
                explorerTypeElement.addAttribute(A_ISVIEW, "true");
            }
            if (settings.getNamePattern() != null) {
                explorerTypeElement.addAttribute(A_NAME_PATTERN, settings.getNamePattern());
            }
            if (settings.getViewOrder(false) != null) {
                explorerTypeElement.addAttribute(A_VIEW_ORDER, "" + settings.getViewOrder(false));
            }
            Element newResElement = explorerTypeElement.addElement(N_NEWRESOURCE);
            newResElement.addAttribute(A_CREATABLE, String.valueOf(settings.isCreatable()));
            newResElement.addAttribute("order", settings.getNewResourceOrder());
            newResElement.addAttribute(A_AUTOSETNAVIGATION, String.valueOf(settings.isAutoSetNavigation()));
            newResElement.addAttribute(A_AUTOSETTITLE, String.valueOf(settings.isAutoSetTitle()));
            newResElement.addAttribute(A_INFO, settings.getInfo());
            newResElement.addAttribute(N_KEY, settings.getTitleKey());
            CmsExplorerTypeAccess access = settings.getAccess();
            if (access != defaultAccess) {
                ArrayList<String> accessEntries = new ArrayList<String>(access.getAccessEntries().keySet());
                Collections.sort(accessEntries);
                if (accessEntries.size() > 0) {
                    Element accessControlElement = explorerTypeElement.addElement(N_ACCESSCONTROL);
                    for (String key : accessEntries) {
                        String value = settings.getAccess().getAccessEntries().get(key);
                        Element accessEntryElement = accessControlElement.addElement(N_ACCESSENTRY);
                        accessEntryElement.addAttribute(A_PRINCIPAL, key);
                        accessEntryElement.addAttribute(A_PERMISSIONS, value);
                    }
                }
            }
            if (settings.hasEditOptions()) {
                Element editOptionsElement = explorerTypeElement.addElement(N_EDITOPTIONS);
                Element defaultPropertiesElement = editOptionsElement.addElement(N_DEFAULTPROPERTIES);
                defaultPropertiesElement.addAttribute(N_ENABLED, String.valueOf(settings.isPropertiesEnabled()));
                defaultPropertiesElement.addAttribute(A_SHOWNAVIGATION, String.valueOf(settings.isShowNavigation()));
                Iterator<String> m = settings.getProperties().iterator();
                while (m.hasNext()) {
                    Element propElem = defaultPropertiesElement.addElement(N_DEFAULTPROPERTY);
                    String propName = m.next();
                    if (settings.isPropertyRequiredOnUpload(propName)) {
                        propElem.addAttribute(A_REQUIRED_ON_UPLOAD, "true");
                    }
                    propElem.addAttribute("name", propName);
                }
            }
            if ((iconRules = settings.getIconRules()) == null || iconRules.isEmpty()) continue;
            Element iconRulesElem = explorerTypeElement.addElement(N_ICONRULES);
            for (Map.Entry<String, CmsIconRule> entry : iconRules.entrySet()) {
                CmsIconRule rule = entry.getValue();
                Element ruleElem = iconRulesElem.addElement(N_ICONRULE);
                String icon = rule.getIcon();
                String bigIcon = rule.getBigIcon();
                String extension = rule.getExtension();
                ruleElem.addAttribute(A_EXTENSION, extension);
                if (icon != null) {
                    ruleElem.addAttribute("icon", icon);
                }
                if (bigIcon != null) {
                    ruleElem.addAttribute(A_BIGICON, bigIcon);
                }
                if (rule.getSmallIconStyle() != null) {
                    ruleElem.addAttribute(A_SMALLICONSTYLE, rule.getSmallIconStyle());
                }
                if (rule.getBigIconStyle() == null) continue;
                ruleElem.addAttribute(A_BIGICONSTYLE, rule.getBigIconStyle());
            }
        }
    }

    @Override
    public void addXmlDigesterRules(final Digester digester) {
        digester.addCallMethod("*/workplace", "initializeFinished");
        digester.addCallMethod("*/param", "addConfigurationParameter", 2);
        digester.addCallParam("*/param", 0, "name");
        digester.addCallParam("*/param", 1);
        digester.addObjectCreate("*/workplace", CmsWorkplaceManager.class);
        digester.addSetNext("*/workplace", "setWorkplaceManager");
        String path = "*/workplace/keep-alive";
        digester.addCallMethod(path, "setKeepAlive", 0);
        digester.addCallMethod("*/workplace/synchronization/exclude-pattern", "addSynchronizeExcludePattern", 0);
        digester.addCallMethod("*/workplace/gallery-default-scope", "setGalleryDefaultScope", 0);
        digester.addCallMethod("*/workplace/element-delete-mode", "setElementDeleteMode", 0);
        digester.addCallMethod("*/workplace/user-lists", "setUserListMode", 1);
        digester.addCallParam("*/workplace/user-lists", 0, "mode");
        digester.addCallMethod("*/workplace/defaultlocale", "setDefaultLocale", 0);
        digester.addCallMethod("*/workplace/defaultpropertiesonstructure", "setDefaultPropertiesOnStructure", 0);
        digester.addCallMethod("*/workplace/enableadvancedpropertytabs", "setEnableAdvancedPropertyTabs", 0);
        digester.addCallMethod("*/workplace/categoryfolder", "setCategoryFolder", 0);
        digester.addCallMethod("*/workplace/categorydisplayoptions", "setCategoryDisplayOptions", 2);
        digester.addCallParam("*/workplace/categorydisplayoptions", 0, A_DISPLAY_BY_REPOSITORY);
        digester.addCallParam("*/workplace/categorydisplayoptions", 1, A_DISPLAY_COLLAPSED);
        digester.addCallMethod("*/workplace/group-translation", "setGroupTranslationClass", 1);
        digester.addCallParam("*/workplace/group-translation", 0, "class");
        digester.addObjectCreate("*/workplace/dialoghandlers/dialoghandler", CmsConfigurationException.class.getName(), "class");
        digester.addSetNext("*/workplace/dialoghandlers/dialoghandler", "addDialogHandler");
        digester.addCallMethod("*/workplace/dialoghandlers/dialoghandler", "initConfiguration");
        digester.addObjectCreate("*/workplace/editorhandler", CmsConfigurationException.class.getName(), "class");
        digester.addSetNext("*/workplace/editorhandler", "setEditorHandler");
        digester.addObjectCreate("*/workplace/postuploadhandler", "class", CmsConfigurationException.class);
        digester.addSetNext("*/workplace/postuploadhandler", "setPostUploadHandler");
        digester.addObjectCreate("*/workplace/editoraction", CmsConfigurationException.class.getName(), "class");
        digester.addSetNext("*/workplace/editoraction", "setEditorAction");
        digester.addCallMethod("*/workplace/editorcsshandlers/editorcsshandler", "addEditorCssHandler", 1);
        digester.addCallParam("*/workplace/editorcsshandlers/editorcsshandler", 0, "class");
        digester.addObjectCreate("*/workplace/editorpreconditions/editorprecondition", CmsConfigurationException.class.getName(), "class");
        digester.addSetNext("*/workplace/editorpreconditions/editorprecondition", "addPreEditorConditionDefinition");
        digester.addCallMethod("*/workplace/editorpreconditions/editorprecondition", "setResourceTypeName", 1);
        digester.addCallParam("*/workplace/editorpreconditions/editorprecondition", 0, "name");
        digester.addCallMethod("*/workplace/editorpreconditions/editorprecondition", "initConfiguration");
        digester.addObjectCreate("*/workplace/directeditprovider", CmsConfigurationException.class.getName(), "class");
        digester.addCallMethod("*/workplace/directeditprovider", "initConfiguration");
        digester.addSetNext("*/workplace/directeditprovider", "setDirectEditProvider");
        digester.addCallMethod("*/workplace/exportpoints/exportpoint", "addExportPoint", 2);
        digester.addCallParam("*/workplace/exportpoints/exportpoint", 0, N_URI);
        digester.addCallParam("*/workplace/exportpoints/exportpoint", 1, "destination");
        digester.addCallMethod("*/workplace/autolock", "setAutoLock", 0);
        digester.addCallMethod("*/workplace/acacia-unlock", "setAcaciaUnlock", 0);
        digester.addCallMethod("*/workplace/xmlcontentautocorrection", "setXmlContentAutoCorrect", 0);
        digester.addCallMethod("*/workplace/enableusermanagement", "setUserManagementEnabled", 0);
        digester.addCallMethod("*/workplace/maxfileuploadsize", "setFileMaxUploadSize", 0);
        digester.addCallMethod("*/workplace/labeledfolders/resource", "addLabeledFolder", 1);
        digester.addCallParam("*/workplace/labeledfolders/resource", 0, N_URI);
        digester.addObjectCreate("*/workplace/repositoryfolder", CmsConfigurationException.class.getName(), "class");
        digester.addSetNext("*/workplace/repositoryfolder", "setRepositoryFolderHandler");
        digester.addCallMethod("*/workplace/localizedfolders/resource", "addLocalizedFolder", 1);
        digester.addCallParam("*/workplace/localizedfolders/resource", 0, N_URI);
        String xPathPrefix = "*/rfsfileviewsettings";
        digester.addObjectCreate(xPathPrefix, CmsRfsFileViewer.class);
        digester.addBeanPropertySetter(xPathPrefix + "/rootPath");
        digester.addBeanPropertySetter(xPathPrefix + "/filePath");
        digester.addBeanPropertySetter(xPathPrefix + "/enabled");
        digester.addBeanPropertySetter(xPathPrefix + "/fileEncoding");
        digester.addBeanPropertySetter(xPathPrefix + "/isLogfile");
        digester.addBeanPropertySetter(xPathPrefix + "/windowSize");
        digester.addRule(xPathPrefix, (Rule)new CmsSetNextRule("setFileViewSettings", CmsRfsFileViewer.class));
        digester.addRule("*/workplace/upload-restriction", new Rule(){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                String className = attributes.getValue("class");
                Class<I_CmsUploadRestriction> cls = Class.forName(className, false, ((Object)((Object)this)).getClass().getClassLoader()).asSubclass(I_CmsUploadRestriction.class);
                digester.push((Object)cls.newInstance());
            }

            public void end(String namespace, String name) throws Exception {
                I_CmsUploadRestriction restriction = (I_CmsUploadRestriction)digester.pop();
                ((CmsWorkplaceManager)digester.peek()).setUploadRestriction(restriction);
            }
        });
        digester.addRule("*/workplace/virus-scanner", new Rule(){
            private boolean m_enabled;

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                String className = attributes.getValue("class");
                this.m_enabled = false;
                if (className != null) {
                    this.m_enabled = Boolean.parseBoolean(attributes.getValue(CmsWorkplaceConfiguration.N_ENABLED));
                    Class<I_CmsVirusScanner> cls = Class.forName(className, false, ((Object)((Object)this)).getClass().getClassLoader()).asSubclass(I_CmsVirusScanner.class);
                    digester.push((Object)cls.newInstance());
                }
            }

            public void end(String namespace, String name) throws Exception {
                if (digester.peek() instanceof I_CmsVirusScanner) {
                    I_CmsVirusScanner scanner = (I_CmsVirusScanner)digester.pop();
                    scanner.initConfiguration();
                    CmsWorkplaceManager wpMan = (CmsWorkplaceManager)digester.peek();
                    wpMan.setVirusScanner(scanner);
                    wpMan.setVirusScannerEnabled(this.m_enabled);
                }
            }
        });
        CmsWorkplaceConfiguration.addExplorerTypeXmlRules(digester);
        this.addDefaultAccessControlRules(digester);
        this.addUserInfoRules(digester);
        this.addAccountInfoRules(digester);
        this.addDefaultPreferencesRules(digester);
        this.addToolManagerRules(digester);
        CmsAdditionalLogFolderConfig.ADD_LOG_FOLDER_HELPER.addRules(digester);
        digester.addSetNext(CmsAdditionalLogFolderConfig.ADD_LOG_FOLDER_HELPER.getBasePath(), "setAdditionalLogFolderConfiguration");
        digester.addRule("*/workplace/use-formatter-keys-for-new-sites", new Rule(){

            public void body(String namespace, String name, String text) throws Exception {
                CmsResourceTypeSubsitemapContentFolder.setEnableNewPageFormatByDefault(Boolean.parseBoolean(text));
            }
        });
        digester.addRule("*/workplace/sitemap-config-edit-role", new Rule(){

            public void body(String namespace, String name, String text) throws Exception {
                CmsWorkplaceManager wpManager = (CmsWorkplaceManager)digester.peek();
                wpManager.setSitemapConfigEditRole(text);
            }
        });
        digester.addRule("*/workplace/allow-element-author-to-work-in-galleries", new Rule(){

            public void body(String namespace, String name, String text) throws Exception {
                CmsWorkplaceManager wpManager = (CmsWorkplaceManager)digester.peek();
                wpManager.setAllowElementAuthorToWorkInGalleries(Boolean.valueOf(text));
            }
        });
    }

    @Override
    public Element generateXml(Element parent) {
        CmsCntPageData.ElementDeleteMode deleteMode;
        String defaultScope;
        Boolean keepAlive;
        List<CmsAccountInfo> accountInfos;
        String filePath;
        String groupTranslationClass;
        Element workplaceElement = parent.addElement(N_WORKPLACE);
        workplaceElement.addElement(N_DEFAULTLOCALE).setText(this.m_workplaceManager.getDefaultLocale().toString());
        Element localizedElement = workplaceElement.addElement(N_LOCALIZEDFOLDERS);
        Iterator<String> localizedIterator = this.m_workplaceManager.getLocalizedFolders().iterator();
        while (localizedIterator.hasNext()) {
            localizedElement.addElement("resource").addAttribute(N_URI, localizedIterator.next());
        }
        Element dialogElement = workplaceElement.addElement(N_DIALOGHANDLERS);
        Map<String, I_CmsDialogHandler> dialogs = this.m_workplaceManager.getDialogHandler();
        Object[] keys = dialogs.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (int j = 0; j < keys.length; ++j) {
            Object name = keys[j];
            Element element = dialogElement.addElement(N_DIALOGHANDLER).addAttribute("class", dialogs.get(name).getClass().getName());
            I_CmsDialogHandler daialogHandlerConfig = dialogs.get(name);
            CmsParameterConfiguration handlerConfig = daialogHandlerConfig.getConfiguration();
            if (handlerConfig == null) continue;
            handlerConfig.appendToXml(element);
        }
        workplaceElement.addElement(N_EDITORHANDLER).addAttribute("class", this.m_workplaceManager.getEditorHandler().getClass().getName());
        workplaceElement.addElement(N_EDITORACTION).addAttribute("class", this.m_workplaceManager.getEditorActionHandler().getClass().getName());
        if (this.m_workplaceManager.getPostUploadHandler() != null) {
            workplaceElement.addElement(N_POSTUPLOADHANDLER).addAttribute("class", this.m_workplaceManager.getPostUploadHandler().getClass().getName());
        }
        if (this.m_workplaceManager.getEditorCssHandlers().size() > 0) {
            Element editorCssHandlers = workplaceElement.addElement(N_EDITORCSSHANDLERS);
            for (I_CmsEditorCssHandler i_CmsEditorCssHandler : this.m_workplaceManager.getEditorCssHandlers()) {
                Element handler = editorCssHandlers.addElement(N_EDITORCSSHANDLER);
                handler.addAttribute("class", i_CmsEditorCssHandler.getClass().getName());
            }
        }
        if (this.m_workplaceManager.getPreEditorConditionDefinitions().size() > 0) {
            Element editorPreActions = workplaceElement.addElement(N_EDITORPRECONDITIONS);
            for (I_CmsPreEditorActionDefinition i_CmsPreEditorActionDefinition : this.m_workplaceManager.getPreEditorConditionDefinitions()) {
                Element action = editorPreActions.addElement(N_EDITORPRECONDITION);
                action.addAttribute("name", i_CmsPreEditorActionDefinition.getResourceTypeName());
                action.addAttribute("class", i_CmsPreEditorActionDefinition.getClass().getName());
                CmsParameterConfiguration config = i_CmsPreEditorActionDefinition.getConfiguration();
                if (config == null || config.size() <= 0) continue;
                config.appendToXml(action);
            }
        }
        I_CmsDirectEditProvider deProvider = this.m_workplaceManager.getDirectEditProvider();
        Element deProviderNode = workplaceElement.addElement(N_DIRECTEDITPROVIDER).addAttribute("class", deProvider.getClass().getName());
        CmsParameterConfiguration cmsParameterConfiguration = deProvider.getConfiguration();
        if (cmsParameterConfiguration != null) {
            cmsParameterConfiguration.appendToXml(deProviderNode);
        }
        Element resourceloadersElement = workplaceElement.addElement("exportpoints");
        Set<CmsExportPoint> points = this.m_workplaceManager.getExportPoints();
        for (CmsExportPoint point : points) {
            resourceloadersElement.addElement("exportpoint").addAttribute(N_URI, point.getUri()).addAttribute("destination", point.getConfiguredDestination());
        }
        workplaceElement.addElement(N_AUTOLOCK).setText(String.valueOf(this.m_workplaceManager.autoLockResources()));
        String acaciaUnlock = this.m_workplaceManager.getAcaciaUnlock();
        if (acaciaUnlock != null) {
            workplaceElement.addElement(N_ACACIA_UNLOCK).setText(acaciaUnlock);
        }
        workplaceElement.addElement(N_XMLCONTENTAUTOCORRECTION).setText(String.valueOf(this.m_workplaceManager.isXmlContentAutoCorrect()));
        workplaceElement.addElement(N_ENABLEUSERMGMT).setText(String.valueOf(this.m_workplaceManager.showUserGroupIcon()));
        workplaceElement.addElement(N_DEFAULTPROPERTIESONSTRUCTURE).setText(String.valueOf(this.m_workplaceManager.isDefaultPropertiesOnStructure()));
        workplaceElement.addElement(N_ENABLEADVANCEDPROPERTYTABS).setText(String.valueOf(this.m_workplaceManager.isEnableAdvancedPropertyTabs()));
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_workplaceManager.getCategoryFolder()) && !"/.categories/".equals(this.m_workplaceManager.getCategoryFolder())) {
            workplaceElement.addElement(N_CATEGORYFOLDER).setText(String.valueOf(this.m_workplaceManager.getCategoryFolder()));
        }
        if (this.m_workplaceManager.isDisplayCategoriesByRepository() || this.m_workplaceManager.isDisplayCategorySelectionCollapsed()) {
            Element categoryDisplayOptions = workplaceElement.addElement(N_CATEGORYDISPLAYOPTIONS);
            if (this.m_workplaceManager.isDisplayCategoriesByRepository()) {
                categoryDisplayOptions.addAttribute(A_DISPLAY_BY_REPOSITORY, "true");
            }
            if (this.m_workplaceManager.isDisplayCategorySelectionCollapsed()) {
                categoryDisplayOptions.addAttribute(A_DISPLAY_COLLAPSED, "true");
            }
        }
        if ((groupTranslationClass = this.m_workplaceManager.getGroupTranslationClass()) != null) {
            Element groupTranslationElement = workplaceElement.addElement(N_GROUP_TRANSLATION);
            groupTranslationElement.addAttribute("class", groupTranslationClass);
        }
        workplaceElement.addElement(N_MAXUPLOADSIZE).setText(String.valueOf(this.m_workplaceManager.getFileMaxUploadSize()));
        Element labeledElement = workplaceElement.addElement(N_LABELEDFOLDERS);
        Iterator<String> sitesFolders = this.m_workplaceManager.getLabelSiteFolders().iterator();
        while (sitesFolders.hasNext()) {
            labeledElement.addElement("resource").addAttribute(N_URI, sitesFolders.next());
        }
        workplaceElement.addElement(N_REPOSITORY_FOLDER).addAttribute("class", this.m_workplaceManager.getRepositoryFolderHandler().getClass().getName());
        CmsRfsFileViewer viewSettings = this.m_workplaceManager.getFileViewSettings();
        Element fileViewElement = workplaceElement.addElement(N_RFSFILEVIEWESETTINGS);
        String rootPath = viewSettings.getRootPath();
        if (rootPath != null) {
            fileViewElement.addElement(N_ROOTPATH).setText(rootPath);
        }
        if ((filePath = viewSettings.getFilePath()) != null) {
            fileViewElement.addElement(N_FILEPATH).setText(filePath);
        }
        fileViewElement.addElement(N_ENABLED).setText(String.valueOf(viewSettings.isEnabled()));
        fileViewElement.addElement(N_FILEENCODING).setText(viewSettings.getFileEncoding());
        fileViewElement.addElement(N_ISLOGFILE).setText(String.valueOf(viewSettings.getIsLogfile()));
        fileViewElement.addElement(N_WINDOWSIZE).setText(String.valueOf(viewSettings.getWindowSize()));
        Element explorerTypesElement = workplaceElement.addElement(N_EXPLORERTYPES);
        List<CmsExplorerTypeSettings> explorerTypes = this.m_workplaceManager.getWorkplaceExplorerTypeSettings();
        CmsWorkplaceConfiguration.generateExplorerTypesXml(explorerTypesElement, explorerTypes, false);
        Element defaultAccessControlElement = explorerTypesElement.addElement(N_DEFAULTACCESSCONTROL);
        ArrayList<String> accessEntries = new ArrayList<String>();
        CmsExplorerTypeAccess access = this.m_workplaceManager.getDefaultAccess();
        Iterator<String> iter = access.getAccessEntries().keySet().iterator();
        while (iter.hasNext()) {
            accessEntries.add(iter.next());
        }
        Collections.sort(accessEntries);
        if (accessEntries.size() > 0) {
            Element accessControlElement = defaultAccessControlElement.addElement(N_ACCESSCONTROL);
            for (String string : accessEntries) {
                String string2 = this.m_workplaceManager.getDefaultAccess().getAccessEntries().get(string);
                Element accessEntryElement = accessControlElement.addElement(N_ACCESSENTRY);
                accessEntryElement.addAttribute(A_PRINCIPAL, string);
                accessEntryElement.addAttribute(A_PERMISSIONS, string2);
            }
        }
        if (this.m_workplaceManager.getUserInfoManager() != null) {
            Element userInfosElement = workplaceElement.addElement(N_USERINFOS);
            for (CmsWorkplaceUserInfoBlock cmsWorkplaceUserInfoBlock : this.m_workplaceManager.getUserInfoManager().getBlocks()) {
                Element element = userInfosElement.addElement(N_INFOBLOCK);
                element.addAttribute("name", cmsWorkplaceUserInfoBlock.getTitle());
                for (CmsWorkplaceUserInfoEntry entry : cmsWorkplaceUserInfoBlock.getEntries()) {
                    Element userInfoElement = element.addElement(N_USERINFO);
                    userInfoElement.addAttribute(N_KEY, entry.getKey());
                    if (entry.getType() != null) {
                        userInfoElement.addAttribute("type", entry.getType());
                    }
                    if (entry.getWidget() != null) {
                        userInfoElement.addAttribute(A_WIDGET, entry.getWidget());
                    }
                    if (entry.getParams() != null) {
                        userInfoElement.addAttribute(A_PARAMS, entry.getParams());
                    }
                    if (entry.getOptional() == null) continue;
                    userInfoElement.addAttribute(A_OPTIONAL, entry.getOptional());
                }
            }
        }
        if ((accountInfos = this.m_workplaceManager.getConfiguredAccountInfos()) != null) {
            Element infosElement = workplaceElement.addElement(N_ACCOUNTINFOS);
            for (CmsAccountInfo cmsAccountInfo : accountInfos) {
                Element infoElement = infosElement.addElement(N_ACCOUNTINFO);
                infoElement.addAttribute(A_FIELD, cmsAccountInfo.getField().name());
                if (cmsAccountInfo.isAdditionalInfo()) {
                    infoElement.addAttribute(A_ADD_INFO_KEY, cmsAccountInfo.getAddInfoKey());
                }
                infoElement.addAttribute(A_EDITABLE, Boolean.toString(cmsAccountInfo.isEditable()));
            }
        }
        Element defaultPreferences = workplaceElement.addElement(N_DEFAULTPREFERENCES);
        ImmutableListMultimap immutableListMultimap = Multimaps.index(this.m_workplaceManager.getDefaultUserSettings().getPreferences().values(), (Function)new Function<I_CmsPreference, String>(){

            public String apply(I_CmsPreference input) {
                return input.getTab();
            }
        });
        for (String tabName : new String[]{"basic", "extended", "hidden"}) {
            Element preferenceTab = defaultPreferences.addElement(N_PREFERENCE_TAB).addAttribute("name", tabName);
            for (I_CmsPreference pref : immutableListMultimap.get((Object)tabName)) {
                Element elem = pref.createConfigurationItem();
                if (elem == null) continue;
                preferenceTab.add(elem);
            }
        }
        Element element = workplaceElement.addElement(N_TOOLMANAGER);
        Element rootsElement = element.addElement(N_ROOTS);
        for (CmsToolRootHandler root : this.m_workplaceManager.getToolManager().getToolRoots()) {
            Element rootElement = rootsElement.addElement(N_ROOT);
            rootElement.addElement(N_KEY).addText(root.getKey());
            rootElement.addElement(N_URI).addText(root.getUri());
            rootElement.addElement("name").addText(root.getName());
            rootElement.addElement(N_HELPTEXT).addText(root.getHelpText());
        }
        String userListsMode = this.m_workplaceManager.getUserListModeString();
        if (userListsMode != null) {
            Element userListsElem = workplaceElement.addElement(N_USER_LISTS);
            userListsElem.addAttribute("mode", userListsMode);
        }
        if ((keepAlive = this.m_workplaceManager.isKeepAlive(false)) != null) {
            workplaceElement.addElement(N_KEEP_ALIVE).setText(keepAlive.toString());
        }
        if ((defaultScope = this.m_workplaceManager.getGalleryDefaultScopeString()) != null) {
            workplaceElement.addElement(N_GALLERY_DEFAULT_SCOPE).setText(defaultScope);
        }
        if ((deleteMode = this.m_workplaceManager.getElementDeleteMode()) != null) {
            workplaceElement.addElement(N_ELEMENT_DELETE_MODE).setText(deleteMode.name());
        }
        CmsAdditionalLogFolderConfig.ADD_LOG_FOLDER_HELPER.generateXml(workplaceElement, this.m_workplaceManager.getAdditionalLogFolderConfiguration());
        boolean useKeysForNewSites = CmsResourceTypeSubsitemapContentFolder.isEnableNewPageFormatByDefault();
        workplaceElement.addElement(N_USE_FORMATTER_KEYS_FOR_NEW_SITES).setText("" + useKeysForNewSites);
        I_CmsUploadRestriction restriction = this.m_workplaceManager.getUploadRestriction();
        Element uploadRestrictionElem = workplaceElement.addElement(N_UPLOAD_RESTRICTION);
        uploadRestrictionElem.addAttribute("class", restriction.getClass().getName());
        restriction.getConfiguration().appendToXml(uploadRestrictionElem);
        I_CmsVirusScanner virusScanner = this.m_workplaceManager.getVirusScanner();
        Element virusScannerElem = workplaceElement.addElement(N_VIRUS_SCANNER);
        boolean enabled = false;
        if (virusScanner != null) {
            virusScannerElem.addAttribute("class", virusScanner.getClass().getName());
            enabled = this.m_workplaceManager.isVirusScannerEnabled();
            virusScanner.getConfiguration().appendToXml(virusScannerElem);
        }
        virusScannerElem.addAttribute(N_ENABLED, "" + enabled);
        String sitemapConfigEditRole = this.m_workplaceManager.getSitemapConfigEditRole();
        if (sitemapConfigEditRole != null) {
            workplaceElement.addElement(N_SITEMAP_CONFIG_EDIT_ROLE).addText(sitemapConfigEditRole);
        }
        boolean allowElementAuthorToWorkInGalleries = this.m_workplaceManager.isAllowElementAuthorToWorkInGalleries();
        workplaceElement.addElement(N_ALLOW_ELEMENT_AUTHOR_TO_WORK_IN_GALLERIES).addText("" + allowElementAuthorToWorkInGalleries);
        return workplaceElement;
    }

    @Override
    public String getDtdFilename() {
        return CONFIGURATION_DTD_NAME;
    }

    public CmsWorkplaceManager getWorkplaceManager() {
        return this.m_workplaceManager;
    }

    public void initializeFinished() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_FINISHED_0"));
        }
    }

    public void setWorkplaceManager(CmsWorkplaceManager manager) {
        this.m_workplaceManager = manager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_INIT_FINISHED_0"));
        }
    }

    protected void addAccountInfoRules(Digester digester) {
        String rulePath = "*/account-infos/account-info";
        digester.addCallMethod(rulePath, "addAccountInfo", 3);
        digester.addCallParam(rulePath, 0, A_FIELD);
        digester.addCallParam(rulePath, 1, A_ADD_INFO_KEY);
        digester.addCallParam(rulePath, 2, A_EDITABLE);
    }

    protected void addDefaultAccessControlRules(Digester digester) {
        digester.addObjectCreate("*/workplace/explorertypes/defaultaccesscontrol/accesscontrol", CmsExplorerTypeAccess.class);
        digester.addSetNext("*/workplace/explorertypes/defaultaccesscontrol/accesscontrol", "setDefaultAccess");
        digester.addCallMethod("*/workplace/explorertypes/defaultaccesscontrol/accesscontrol/accessentry", "addAccessEntry", 2);
        digester.addCallParam("*/workplace/explorertypes/defaultaccesscontrol/accesscontrol/accessentry", 0, A_PRINCIPAL);
        digester.addCallParam("*/workplace/explorertypes/defaultaccesscontrol/accesscontrol/accessentry", 1, A_PERMISSIONS);
    }

    protected void addDefaultPreferencesRules(Digester digester) {
        digester.addObjectCreate("*/workplace/default-preferences", CmsDefaultUserSettings.class);
        digester.addSetNext("*/workplace/default-preferences", "setDefaultUserSettings");
        String xPathPrefix = "*/workplace/default-preferences/workplace-preferences/workplace-generaloptions";
        digester.addCallMethod(xPathPrefix + "/buttonstyle", "setWorkplaceButtonStyle", 0);
        digester.addCallMethod(xPathPrefix + "/reporttype", "setWorkplaceReportType", 0);
        digester.addCallMethod(xPathPrefix + "/uploadapplet", "setUploadVariant", 0);
        digester.addCallMethod(xPathPrefix + "/listallprojects", "setListAllProjects", 0);
        digester.addCallMethod(xPathPrefix + "/publishnotification", "setShowPublishNotification", 0);
        digester.addCallMethod(xPathPrefix + "/publishbuttonappearance", "setPublishButtonAppearance", 0);
        digester.addCallMethod(xPathPrefix + "/show-fileuploadbutton", "setShowFileUploadButton", 0);
        digester.addCallMethod(xPathPrefix + "/allowbrokenrelations", "setAllowBrokenRelations", 0);
        digester.addCallMethod(xPathPrefix + "/publishrelatedresources", "setPublishRelatedResourcesMode", 0);
        digester.addCallMethod(xPathPrefix + "/newfolder-editproperties", "setNewFolderEditProperties", 0);
        digester.addCallMethod(xPathPrefix + "/newfolder-createindexpage", "setNewFolderCreateIndexPage", 0);
        digester.addCallMethod(xPathPrefix + "/show-uploadtypedialog", "setShowUploadTypeDialog", 0);
        digester.addCallMethod(xPathPrefix + "/subsitemap-creation-mode", "setSubsitemapCreationMode", 0);
        xPathPrefix = "*/workplace/default-preferences/workplace-preferences/workplace-startupsettings";
        digester.addCallMethod(xPathPrefix + "/locale", "setLocale", 0);
        digester.addCallMethod(xPathPrefix + "/project", "setStartProject", 0);
        digester.addCallMethod(xPathPrefix + "/workplaceview", "setStartView", 0);
        digester.addCallMethod(xPathPrefix + "/folder", "setStartFolder", 0);
        digester.addCallMethod(xPathPrefix + "/site", "setStartSite", 0);
        digester.addCallMethod(xPathPrefix + "/restrictexplorerview", "setRestrictExplorerView", 0);
        xPathPrefix = "*/workplace/default-preferences/workplace-preferences/workplace-search";
        digester.addCallMethod(xPathPrefix + "/searchindex-name", "setWorkplaceSearchIndexName", 0);
        digester.addCallMethod(xPathPrefix + "/searchview-style", "setWorkplaceSearchViewStyle", 0);
        xPathPrefix = "*/workplace/default-preferences/explorer-preferences/explorer-generaloptions";
        digester.addCallMethod(xPathPrefix + "/buttonstyle", "setExplorerButtonStyle", 0);
        digester.addCallMethod(xPathPrefix + "/entries", "setExplorerFileEntries", 0);
        digester.addCallMethod(xPathPrefix + "/entryoptions", "setExplorerFileEntryOptions", 0);
        xPathPrefix = "*/workplace/default-preferences/explorer-preferences/explorer-displayoptions";
        digester.addCallMethod(xPathPrefix + "/show-title", "setShowExplorerFileTitle", 0);
        digester.addCallMethod(xPathPrefix + "/show-navtext", "setShowExplorerFileNavText", 0);
        digester.addCallMethod(xPathPrefix + "/show-type", "setShowExplorerFileType", 0);
        digester.addCallMethod(xPathPrefix + "/show-datelastmodified", "setShowExplorerFileDateLastModified", 0);
        digester.addCallMethod(xPathPrefix + "/show-datecreated", "setShowExplorerFileDateCreated", 0);
        digester.addCallMethod(xPathPrefix + "/show-lockedby", "setShowExplorerFileLockedBy", 0);
        digester.addCallMethod(xPathPrefix + "/show-permissions", "setShowExplorerFilePermissions", 0);
        digester.addCallMethod(xPathPrefix + "/show-size", "setShowExplorerFileSize", 0);
        digester.addCallMethod(xPathPrefix + "/show-state", "setShowExplorerFileState", 0);
        digester.addCallMethod(xPathPrefix + "/show-userlastmodified", "setShowExplorerFileUserLastModified", 0);
        digester.addCallMethod(xPathPrefix + "/show-usercreated", "setShowExplorerFileUserCreated", 0);
        digester.addCallMethod(xPathPrefix + "/show-datereleased", "setShowExplorerFileDateReleased", 0);
        digester.addCallMethod(xPathPrefix + "/show-dateexpired", "setShowExplorerFileDateExpired", 0);
        xPathPrefix = "*/workplace/default-preferences/dialogs-preferences/dialogs-defaultsettings";
        digester.addCallMethod(xPathPrefix + "/filecopy", "setDialogCopyFileMode", 0);
        digester.addCallMethod(xPathPrefix + "/foldercopy", "setDialogCopyFolderMode", 0);
        digester.addCallMethod(xPathPrefix + "/filedeletion", "setDialogDeleteFileMode", 0);
        digester.addCallMethod(xPathPrefix + "/directpublish", "setDialogPublishSiblings", 0);
        digester.addCallMethod(xPathPrefix + "/showlock", "setShowLockDialog", 0);
        digester.addCallMethod(xPathPrefix + "/showexportsettings", "setShowExportSettingsDialog", 0);
        digester.addCallMethod(xPathPrefix + "/permissions-inheritonfolder", "setDialogPermissionsInheritOnFolder", 0);
        digester.addCallMethod(xPathPrefix + "/expand-permissionsinherited", "setDialogExpandInheritedPermissions", 0);
        digester.addCallMethod(xPathPrefix + "/expand-permissionsuser", "setDialogExpandUserPermissions", 0);
        xPathPrefix = "*/workplace/default-preferences/editors-preferences/editors-generaloptions";
        digester.addCallMethod(xPathPrefix + "/buttonstyle", "setEditorButtonStyle", 0);
        digester.addCallMethod(xPathPrefix + "/directeditstyle", "setDirectEditButtonStyle", 0);
        xPathPrefix = "*/workplace/default-preferences/editors-preferences/editors-preferrededitors";
        digester.addCallMethod(xPathPrefix + "/editor", "setPreferredEditor", 2);
        digester.addCallParam(xPathPrefix + "/editor", 0, "type");
        digester.addCallParam(xPathPrefix + "/editor", 1, "value");
        xPathPrefix = "*/workplace/default-preferences/galleries-preferences/startgalleries";
        digester.addCallMethod(xPathPrefix + "/startgallery", "setStartGallery", 2);
        digester.addCallParam(xPathPrefix + "/startgallery", 0, "type");
        digester.addCallParam(xPathPrefix + "/startgallery", 1, A_PATH);
        digester.addRule("*/workplace/default-preferences/preference-tab", new Rule(){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                this.getDigester().push((Object)attributes.getValue("name"));
            }

            public void end(String namespace, String name) throws Exception {
                this.getDigester().pop();
            }
        });
        String prefPath = "*/workplace/default-preferences/preference-tab/preference";
        digester.addRule(prefPath, (Rule)new CallMethodRule(1, "addPreference", 9));
        digester.addCallParam(prefPath, 0, "name");
        digester.addCallParam(prefPath, 1, "value");
        digester.addCallParam(prefPath, 2, A_WIDGET);
        digester.addCallParam(prefPath, 3, A_WIDGET_CONFIG);
        digester.addCallParam(prefPath, 4, A_NICE_NAME);
        digester.addCallParam(prefPath, 5, A_DESCRIPTION);
        digester.addCallParam(prefPath, 6, A_RULE_REGEX);
        digester.addCallParam(prefPath, 7, A_ERROR);
        digester.addCallParam(prefPath, 8, 0);
    }

    protected void addToolManagerRules(Digester digester) {
        Object rulePath = "*/tool-manager";
        digester.addObjectCreate((String)rulePath, CmsToolManager.class);
        digester.addSetNext((String)rulePath, "setToolManager");
        rulePath = (String)rulePath + "/roots/root";
        digester.addObjectCreate((String)rulePath, CmsToolRootHandler.class);
        digester.addSetNext((String)rulePath, "addToolRoot");
        digester.addBeanPropertySetter((String)rulePath + "/key");
        digester.addBeanPropertySetter((String)rulePath + "/uri");
        digester.addBeanPropertySetter((String)rulePath + "/name");
        digester.addBeanPropertySetter((String)rulePath + "/helptext", "helpText");
    }

    protected void addUserInfoRules(Digester digester) {
        Object rulePath = "*/user-infos";
        digester.addObjectCreate((String)rulePath, CmsWorkplaceUserInfoManager.class);
        digester.addSetNext((String)rulePath, "setUserInfoManager");
        rulePath = (String)rulePath + "/info-block";
        digester.addObjectCreate((String)rulePath, CmsWorkplaceUserInfoBlock.class);
        digester.addCallMethod((String)rulePath, "setTitle", 1);
        digester.addCallParam((String)rulePath, 0, "name");
        digester.addCallMethod((String)rulePath + "/user-info", "addEntry", 5);
        digester.addCallParam((String)rulePath + "/user-info", 0, N_KEY);
        digester.addCallParam((String)rulePath + "/user-info", 1, "type");
        digester.addCallParam((String)rulePath + "/user-info", 2, A_WIDGET);
        digester.addCallParam((String)rulePath + "/user-info", 3, A_PARAMS);
        digester.addCallParam((String)rulePath + "/user-info", 4, A_OPTIONAL);
        digester.addSetNext((String)rulePath, "addBlock");
    }

    @Override
    protected void initMembers() {
        this.setXmlFileName(DEFAULT_XML_FILE_NAME);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_INIT_0"));
        }
    }
}

