/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration.preferences;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.configuration.preferences.CmsBuiltinPreference;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsProjectPreference
extends CmsBuiltinPreference {
    private static final String NICE_NAME = "%(key.GUI_PREF_STARTUP_PROJECT_0)";
    private static final Log LOG = CmsLog.getLog(CmsProjectPreference.class);

    public CmsProjectPreference(String name) {
        super(name);
        this.m_basic = false;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition() {
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", null, null, null, null, null, NICE_NAME, null, null, null);
        return prop;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition(CmsObject cms) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", "select_notnull", this.getProjectSelectOptions(cms, locale), null, null, null, NICE_NAME, null, null, null);
        return prop;
    }

    /*
     * WARNING - void declaration
     */
    private String getProjectSelectOptions(CmsObject cms, Locale locale) {
        List<Object> allProjects;
        try {
            String ouFqn = "";
            CmsUserSettings settings = new CmsUserSettings(cms);
            if (!settings.getListAllProjects()) {
                ouFqn = cms.getRequestContext().getCurrentUser().getOuFqn();
            }
            allProjects = OpenCms.getOrgUnitManager().getAllAccessibleProjects(cms, ouFqn, settings.getListAllProjects());
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            allProjects = Collections.emptyList();
        }
        boolean singleOu = true;
        String ouFqn = null;
        for (CmsProject cmsProject : allProjects) {
            if (cmsProject.isOnlineProject()) continue;
            if (ouFqn == null) {
                ouFqn = cmsProject.getOuFqn();
            }
            if (ouFqn.equals(cmsProject.getOuFqn())) continue;
            singleOu = false;
            break;
        }
        boolean bl = false;
        StringBuffer resultBuffer = new StringBuffer();
        int n = allProjects.size();
        for (int i = 0; i < n; ++i) {
            void var7_11;
            CmsProject project = (CmsProject)allProjects.get(i);
            Object projectName = project.getSimpleName();
            if (!singleOu && !project.isOnlineProject()) {
                try {
                    projectName = (String)projectName + " - " + OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, project.getOuFqn()).getDisplayName(locale);
                }
                catch (CmsException e) {
                    projectName = (String)projectName + " - " + project.getOuFqn();
                }
            }
            if (var7_11 != false) {
                resultBuffer.append("|");
            }
            ++var7_11;
            resultBuffer.append(project.getName()).append(":").append((String)projectName);
        }
        return resultBuffer.toString();
    }
}

