/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import com.google.common.base.Objects;
import java.util.regex.Pattern;
import org.opencms.gwt.shared.alias.CmsAliasMode;
import org.opencms.util.CmsUUID;

public class CmsAlias {
    public static final Pattern ALIAS_PATTERN = Pattern.compile("(?:/[a-zA-Z0-9-_\\.!~\\*\\'\\(\\)]+)+");
    protected String m_aliasPath;
    protected CmsAliasMode m_mode;
    protected String m_siteRoot;
    protected CmsUUID m_structureId;

    public CmsAlias(CmsUUID structureId, String siteRoot, String aliasPath, CmsAliasMode mode) {
        this.m_aliasPath = aliasPath;
        this.m_structureId = structureId;
        this.m_siteRoot = siteRoot;
        this.m_mode = mode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CmsAlias)) {
            return false;
        }
        CmsAlias otherAlias = (CmsAlias)other;
        return Objects.equal((Object)this.m_aliasPath, (Object)otherAlias.m_aliasPath) && Objects.equal((Object)this.m_siteRoot, (Object)otherAlias.m_siteRoot) && Objects.equal((Object)this.m_structureId, (Object)otherAlias.m_structureId) && Objects.equal((Object)((Object)this.m_mode), (Object)((Object)otherAlias.m_mode));
    }

    public String getAliasPath() {
        return this.m_aliasPath;
    }

    public CmsAliasMode getMode() {
        return this.m_mode;
    }

    public String getSiteRoot() {
        return this.m_siteRoot;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.m_aliasPath, this.m_siteRoot, this.m_mode, this.m_structureId});
    }

    public boolean isPermanentRedirect() {
        return this.m_mode.equals((Object)CmsAliasMode.permanentRedirect);
    }

    public boolean isRedirect() {
        return this.m_mode.equals((Object)CmsAliasMode.permanentRedirect) || this.m_mode.equals((Object)CmsAliasMode.redirect);
    }
}

