/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import org.opencms.db.Messages;
import org.opencms.main.CmsRuntimeException;
import org.opencms.util.CmsStringUtil;

public class CmsDefaultUsers {
    protected static final String DEFAULT_GROUP_ADMINISTRATORS = "Administrators";
    protected static final String DEFAULT_GROUP_GUESTS = "Guests";
    protected static final String DEFAULT_GROUP_USERS = "Users";
    protected static final String DEFAULT_USER_ADMIN = "Admin";
    protected static final String DEFAULT_USER_DELETED_RESOURCE = "Admin";
    protected static final String DEFAULT_USER_EXPORT = "Export";
    protected static final String DEFAULT_USER_GUEST = "Guest";
    private String m_groupAdministrators;
    private String m_groupGuests;
    private String m_groupUsers;
    private String m_userAdmin;
    private String m_userDeletedResource;
    private String m_userExport;
    private String m_userGuest;

    public CmsDefaultUsers() {
        this.m_userAdmin = "Admin";
        this.m_userGuest = DEFAULT_USER_GUEST;
        this.m_userExport = DEFAULT_USER_EXPORT;
        this.m_userDeletedResource = "Admin";
        this.m_groupAdministrators = DEFAULT_GROUP_ADMINISTRATORS;
        this.m_groupUsers = DEFAULT_GROUP_USERS;
        this.m_groupGuests = DEFAULT_GROUP_GUESTS;
    }

    public CmsDefaultUsers(String userAdmin, String userGuest, String userExport, String userDeletedResource, String groupAdministrators, String groupUsers, String groupGuests) {
        this.init(userAdmin, userGuest, userExport, userDeletedResource, groupAdministrators, groupUsers, groupGuests);
    }

    public String getGroupAdministrators() {
        return this.m_groupAdministrators;
    }

    public String getGroupGuests() {
        return this.m_groupGuests;
    }

    @Deprecated
    public String getGroupProjectmanagers() {
        return "Projectmanagers";
    }

    public String getGroupUsers() {
        return this.m_groupUsers;
    }

    public String getUserAdmin() {
        return this.m_userAdmin;
    }

    public String getUserDeletedResource() {
        return this.m_userDeletedResource;
    }

    public String getUserExport() {
        return this.m_userExport;
    }

    public String getUserGuest() {
        return this.m_userGuest;
    }

    public boolean isDefaultGroup(String groupName) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(groupName)) {
            return false;
        }
        boolean isDefault = this.m_groupAdministrators.equals(groupName);
        isDefault = isDefault || this.m_groupGuests.equals(groupName);
        isDefault = isDefault || this.m_groupUsers.equals(groupName);
        isDefault = isDefault || groupName.equals("/" + this.m_groupAdministrators);
        isDefault = isDefault || groupName.equals("/" + this.m_groupGuests);
        isDefault = isDefault || groupName.endsWith("/" + this.m_groupUsers);
        return isDefault;
    }

    public boolean isDefaultUser(String userName) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(userName)) {
            return false;
        }
        boolean isDefault = this.m_userAdmin.equals(userName);
        isDefault = isDefault || this.m_userGuest.equals(userName);
        isDefault = isDefault || this.m_userExport.equals(userName);
        isDefault = isDefault || this.m_userDeletedResource.equals(userName);
        isDefault = isDefault || userName.equals("/" + this.m_userAdmin);
        isDefault = isDefault || userName.equals("/" + this.m_userGuest);
        isDefault = isDefault || userName.equals("/" + this.m_userExport);
        isDefault = isDefault || userName.equals("/" + this.m_userDeletedResource);
        return isDefault;
    }

    public boolean isGroupGuests(String groupName) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(groupName)) {
            return false;
        }
        return this.m_groupGuests.equals(groupName) || groupName.endsWith("/" + this.m_groupGuests);
    }

    public boolean isUserAdmin(String userName) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(userName)) {
            return false;
        }
        return this.m_userAdmin.equals(userName);
    }

    public boolean isUserExport(String userName) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(userName)) {
            return false;
        }
        return this.m_userExport.equals(userName);
    }

    public boolean isUserGuest(String userName) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(userName)) {
            return false;
        }
        return this.m_userGuest.equals(userName);
    }

    protected void init(String userAdmin, String userGuest, String userExport, String userDeletedResource, String groupAdministrators, String groupUsers, String groupGuests) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(userAdmin) || CmsStringUtil.isEmptyOrWhitespaceOnly(userGuest) || CmsStringUtil.isEmptyOrWhitespaceOnly(userExport) || CmsStringUtil.isEmptyOrWhitespaceOnly(groupAdministrators) || CmsStringUtil.isEmptyOrWhitespaceOnly(groupUsers) || CmsStringUtil.isEmptyOrWhitespaceOnly(groupGuests)) {
            throw new CmsRuntimeException(Messages.get().container("ERR_USER_GROUP_NAMES_EMPTY_0"));
        }
        this.m_userAdmin = userAdmin.trim();
        this.m_userGuest = userGuest.trim();
        this.m_userExport = userExport.trim();
        this.m_userDeletedResource = CmsStringUtil.isEmptyOrWhitespaceOnly(userDeletedResource) ? userAdmin : userDeletedResource.trim();
        this.m_groupAdministrators = groupAdministrators.trim();
        this.m_groupUsers = groupUsers.trim();
        this.m_groupGuests = groupGuests.trim();
    }
}

