/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.opencms.db.Messages;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.ui.components.CmsRichTextArea;

public class CmsLoginMessage {
    private static final Log LOG = CmsLog.getLog(CmsLoginMessage.class);
    public static final long DEFAULT_TIME_END = new GregorianCalendar(2039, 11, 31).getTimeInMillis();
    public static final long DEFAULT_TIME_START = new GregorianCalendar(2000, 0, 1).getTimeInMillis();
    private boolean m_enabled;
    private boolean m_frozen;
    private boolean m_loginForbidden;
    private String m_message;
    private long m_timeEnd;
    private long m_timeStart;

    public CmsLoginMessage() {
        this.m_timeStart = DEFAULT_TIME_START;
        this.m_timeEnd = DEFAULT_TIME_END;
    }

    public CmsLoginMessage(long timeStart, long timeEnd, String message, boolean loginForbidden) {
        this.setTimeStart(timeStart);
        this.setTimeEnd(timeEnd);
        this.m_enabled = true;
        this.setMessage(message);
        this.m_loginForbidden = loginForbidden;
    }

    public CmsLoginMessage(String message, boolean loginForbidden) {
        this(DEFAULT_TIME_START, DEFAULT_TIME_END, message, loginForbidden);
    }

    public Object clone() {
        CmsLoginMessage result = new CmsLoginMessage();
        result.m_timeStart = this.m_timeStart;
        result.m_timeEnd = this.m_timeEnd;
        result.m_loginForbidden = this.m_loginForbidden;
        result.m_message = this.m_message;
        result.m_enabled = this.m_enabled;
        return result;
    }

    public String getMessage() {
        return this.m_message;
    }

    public long getTimeEnd() {
        return this.m_timeEnd;
    }

    public long getTimeStart() {
        return this.m_timeStart;
    }

    public boolean isActive() {
        if (!this.m_enabled) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        return currentTime > this.m_timeStart && currentTime < this.m_timeEnd;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public boolean isLoginCurrentlyForbidden() {
        return this.m_loginForbidden && this.isActive();
    }

    public boolean isLoginForbidden() {
        return this.m_loginForbidden;
    }

    public void setEnabled(boolean enabled) {
        this.checkFrozen();
        this.m_enabled = enabled;
    }

    public void setLoginForbidden(boolean loginForbidden) {
        this.checkFrozen();
        this.m_loginForbidden = loginForbidden;
    }

    public void setMessage(String message) {
        this.checkFrozen();
        if (this.isEnabled() && message == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_LOGIN_MESSAGE_BAD_MESSAGE_0"));
        }
        this.m_message = CmsRichTextArea.cleanHtml(message, true);
    }

    public void setTimeEnd(long timeEnd) {
        this.checkFrozen();
        if (timeEnd < 0L) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_LOGIN_MESSAGE_BAD_TIME_1", timeEnd));
        }
        if (timeEnd == 0L) {
            timeEnd = DEFAULT_TIME_END;
        }
        if (this.m_timeStart > 0L && timeEnd <= this.m_timeStart) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_LOGIN_MESSAGE_BAD_END_TIME_0"));
        }
        this.m_timeEnd = timeEnd;
    }

    public void setTimeStart(long timeStart) {
        this.checkFrozen();
        if (timeStart < 0L) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_LOGIN_MESSAGE_BAD_TIME_1", timeStart));
        }
        if (timeStart == 0L) {
            timeStart = DEFAULT_TIME_START;
        }
        this.m_timeStart = timeStart;
    }

    protected void checkFrozen() throws CmsRuntimeException {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_LOGIN_MESSAGE_FROZEN_0"));
        }
    }

    protected void setFrozen() {
        this.m_frozen = true;
    }
}

