/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.generic;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsDbConsistencyException;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsResourceState;
import org.opencms.db.I_CmsDriver;
import org.opencms.db.I_CmsHistoryDriver;
import org.opencms.db.I_CmsVfsDriver;
import org.opencms.db.generic.CmsSqlManager;
import org.opencms.db.generic.Messages;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.CmsHistoryFile;
import org.opencms.file.history.CmsHistoryFolder;
import org.opencms.file.history.CmsHistoryPrincipal;
import org.opencms.file.history.CmsHistoryProject;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsHistoryDriver
implements I_CmsDriver,
I_CmsHistoryDriver {
    private static final Log LOG = CmsLog.getLog(CmsHistoryDriver.class);
    protected CmsDriverManager m_driverManager;
    protected CmsSqlManager m_sqlManager;

    @Override
    public CmsPropertyDefinition createPropertyDefinition(CmsDbContext dbc, String name, CmsPropertyDefinition.CmsPropertyType type) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROPERTYDEF_CREATE_HISTORY");
            stmt.setString(1, new CmsUUID().toString());
            stmt.setString(2, name);
            stmt.setInt(3, type.getMode());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
        return this.readPropertyDefinition(dbc, name);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int deleteEntries(CmsDbContext dbc, I_CmsHistoryResource resource, int versionsToKeep, long time) throws CmsDataAccessException {
        block22: {
            block21: {
                block20: {
                    block19: {
                        conn = null;
                        stmt = null;
                        res = null;
                        conn = this.m_sqlManager.getConnection(dbc);
                        maxVersion = -1;
                        stmt = this.m_sqlManager.getPreparedStatement(conn, "C_STRUCTURE_HISTORY_MAXVER");
                        stmt.setString(1, resource.getStructureId().toString());
                        res = stmt.executeQuery();
                        noHistoryStructure = false;
                        if (res.next()) {
                            maxVersion = res.getInt(1);
                            noHistoryStructure |= res.wasNull();
                            while (res.next()) {
                            }
                            break block19;
                        }
                        this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                        this.internalCleanup(dbc, resource);
                        var11_11 = 0;
                        this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                        return var11_11;
                    }
                    this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                    if (time >= 0L) {
                        maxVersionByTime = -1;
                        conn = this.m_sqlManager.getConnection(dbc);
                        stmt = this.m_sqlManager.getPreparedStatement(conn, "C_STRUCTURE_HISTORY_MAXVER_BYTIME");
                        stmt.setString(1, resource.getStructureId().toString());
                        stmt.setLong(2, time);
                        res = stmt.executeQuery();
                        if (res.next()) {
                            maxVersionByTime = res.getInt(1);
                            while (res.next()) {
                            }
                        }
                        this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                        if (maxVersionByTime > 0) {
                            versionsToKeep = versionsToKeep < 0 ? maxVersion - maxVersionByTime : Math.min(versionsToKeep, maxVersion - maxVersionByTime);
                        }
                    }
                    structureVersions = 0;
                    conn = this.m_sqlManager.getConnection(dbc);
                    if (noHistoryStructure) ** GOTO lbl86
                    if (versionsToKeep != -1 && maxVersion - versionsToKeep > 0) break block20;
                    this.internalCleanup(dbc, resource);
                    var12_13 = 0;
                    this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                    return var12_13;
                }
                minStrPublishTagToKeep = -1;
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_HISTORY_READ_MAXTAG_FOR_VERSION");
                stmt.setString(1, resource.getStructureId().toString());
                stmt.setInt(2, 1 + maxVersion - versionsToKeep);
                res = stmt.executeQuery();
                if (res.next()) {
                    minStrPublishTagToKeep = res.getInt(1);
                    while (res.next()) {
                    }
                    break block21;
                }
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                this.internalCleanup(dbc, resource);
                var13_15 = 0;
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                return var13_15;
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
            if (minStrPublishTagToKeep >= 1) break block22;
            this.internalCleanup(dbc, resource);
            var13_16 = 0;
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
            return var13_16;
        }
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROPERTIES_HISTORY_DELETE");
            stmt.setString(1, resource.getStructureId().toString());
            stmt.setInt(2, ++minStrPublishTagToKeep);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, null, stmt, null);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_STRUCTURE_HISTORY_DELETE");
            stmt.setString(1, resource.getStructureId().toString());
            stmt.setInt(2, minStrPublishTagToKeep);
            structureVersions = stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, null, stmt, null);
lbl86:
            // 2 sources

            minResPublishTagToKeep = -1;
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_HISTORY_READ_MIN_USED_TAG");
            stmt.setString(1, resource.getResourceId().toString());
            res = stmt.executeQuery();
            if (res.next()) {
                minResPublishTagToKeep = res.getInt(1);
                if (res.wasNull()) {
                    minResPublishTagToKeep = 0x7FFFFFFF;
                }
                while (res.next()) {
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_HISTORY_DELETE");
            stmt.setString(1, resource.getResourceId().toString());
            stmt.setInt(2, minResPublishTagToKeep);
            resourceVersions = stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, null, stmt, null);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_CONTENT_HISTORY_DELETE");
            stmt.setString(1, resource.getResourceId().toString());
            stmt.setInt(2, minResPublishTagToKeep);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
            this.internalCleanup(dbc, resource);
            var14_18 = Math.max(structureVersions, resourceVersions);
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
            return var14_18;
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable var15_19) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw var15_19;
            }
        }
    }

    @Override
    public void deletePropertyDefinition(CmsDbContext dbc, CmsPropertyDefinition metadef) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            if (this.internalCountProperties(dbc, metadef, CmsProject.ONLINE_PROJECT_ID) != 0 || this.internalCountProperties(dbc, metadef, CmsUUID.getOpenCmsUUID()) != 0) {
                throw new CmsDbConsistencyException(Messages.get().container("ERR_ERROR_DELETING_PROPERTYDEF_1", metadef.getName()));
            }
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROPERTYDEF_DELETE_HISTORY");
            stmt.setString(1, metadef.getId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void destroy() throws Throwable {
        this.m_sqlManager = null;
        this.m_driverManager = null;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_DRIVER_1", this.getClass().getName()));
        }
    }

    @Override
    public List<I_CmsHistoryResource> getAllDeletedEntries(CmsDbContext dbc) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        HashMap<CmsUUID, Integer> tmpEntrieis = new HashMap<CmsUUID, Integer>();
        ArrayList<I_CmsHistoryResource> entries = new ArrayList<I_CmsHistoryResource>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_STRUCTURE_HISTORY_READ_DELETED");
            res = stmt.executeQuery();
            while (res.next()) {
                CmsUUID structureId = new CmsUUID(res.getString(1));
                int version = res.getInt(2);
                tmpEntrieis.put(structureId, version);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        for (Map.Entry entry : tmpEntrieis.entrySet()) {
            entries.add(this.readResource(dbc, (CmsUUID)entry.getKey(), (Integer)entry.getValue()));
        }
        return entries;
    }

    @Override
    public List<I_CmsHistoryResource> getAllNotDeletedEntries(CmsDbContext dbc) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        HashMap<CmsUUID, Integer> tmpEntrieis = new HashMap<CmsUUID, Integer>();
        ArrayList<I_CmsHistoryResource> entries = new ArrayList<I_CmsHistoryResource>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_STRUCTURE_HISTORY_READ_NOTDELETED");
            res = stmt.executeQuery();
            while (res.next()) {
                CmsUUID structureId = new CmsUUID(res.getString(1));
                int version = res.getInt(2);
                tmpEntrieis.put(structureId, version);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        for (Map.Entry entry : tmpEntrieis.entrySet()) {
            entries.add(this.readResource(dbc, (CmsUUID)entry.getKey(), (Integer)entry.getValue()));
        }
        return entries;
    }

    @Override
    public CmsSqlManager getSqlManager() {
        return this.m_sqlManager;
    }

    @Override
    public void init(CmsDbContext dbc, CmsConfigurationManager configurationManager, List<String> successiveDrivers, CmsDriverManager driverManager) {
        CmsParameterConfiguration configuration = configurationManager.getConfiguration();
        String poolUrl = configuration.get("db.history.pool") != null ? configuration.get("db.history.pool").toString() : configuration.get("db.backup.pool").toString();
        String classname = configuration.get("db.history.sqlmanager") != null ? configuration.get("db.history.sqlmanager").toString() : configuration.get("db.backup.sqlmanager").toString();
        this.m_sqlManager = this.initSqlManager(classname);
        this.m_sqlManager.init(0, poolUrl);
        this.m_driverManager = driverManager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ASSIGNED_POOL_1", poolUrl));
        }
        if (successiveDrivers != null && !successiveDrivers.isEmpty() && LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_SUCCESSIVE_DRIVERS_UNSUPPORTED_1", this.getClass().getName()));
        }
    }

    @Override
    public CmsSqlManager initSqlManager(String classname) {
        return CmsSqlManager.getInstance(classname);
    }

    @Override
    public List<I_CmsHistoryResource> readAllAvailableVersions(CmsDbContext dbc, CmsUUID structureId) throws CmsDataAccessException {
        ResultSet res = null;
        ArrayList<I_CmsHistoryResource> result = new ArrayList<I_CmsHistoryResource>();
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            I_CmsHistoryResource histRes;
            conn = this.m_sqlManager.getConnection(dbc);
            ArrayList<I_CmsHistoryResource> historyResources = new ArrayList<I_CmsHistoryResource>();
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_HISTORY_READ_ALL_VERSIONS");
            stmt.setString(1, structureId.toString());
            res = stmt.executeQuery();
            while (res.next()) {
                historyResources.add(this.internalCreateResource(res));
            }
            this.m_sqlManager.closeAll(dbc, null, stmt, res);
            if (!historyResources.isEmpty()) {
                I_CmsHistoryResource histRes2 = (I_CmsHistoryResource)historyResources.get(0);
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_HISTORY_READ_NEW_VERSIONS");
                stmt.setString(1, histRes2.getResourceId().toString());
                stmt.setInt(2, histRes2.getPublishTag());
                res = stmt.executeQuery();
                I_CmsHistoryResource lastHistRes = histRes2;
                while (res.next()) {
                    int resVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_VERSION"));
                    if (resVersion == lastHistRes.getResourceVersion()) continue;
                    I_CmsHistoryResource newHistRes = this.internalMergeResource(histRes2, res, 0);
                    result.add(0, newHistRes);
                    lastHistRes = newHistRes;
                }
                this.m_sqlManager.closeAll(dbc, null, stmt, res);
            }
            for (int i = 0; i < historyResources.size(); ++i) {
                I_CmsHistoryResource histRes3 = (I_CmsHistoryResource)historyResources.get(i);
                result.add(histRes3);
                if (i >= historyResources.size() - 1) continue;
                I_CmsHistoryResource histRes2 = (I_CmsHistoryResource)historyResources.get(i + 1);
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_HISTORY_READ_BTW_VERSIONS");
                stmt.setString(1, histRes3.getResourceId().toString());
                stmt.setInt(2, histRes2.getPublishTag());
                stmt.setInt(3, histRes3.getPublishTag());
                res = stmt.executeQuery();
                int pos = result.size();
                I_CmsHistoryResource lastHistRes = histRes2;
                while (res.next()) {
                    int resVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_VERSION"));
                    if (resVersion == lastHistRes.getResourceVersion()) continue;
                    I_CmsHistoryResource newHistRes = this.internalMergeResource(histRes2, res, 0);
                    result.add(pos, newHistRes);
                    lastHistRes = newHistRes;
                }
                this.m_sqlManager.closeAll(dbc, null, stmt, res);
            }
            if (!result.isEmpty() && (histRes = (I_CmsHistoryResource)result.get(result.size() - 1)).getVersion() > 1) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_HISTORY_READ_OLD_VERSIONS");
                stmt.setString(1, histRes.getResourceId().toString());
                stmt.setInt(2, histRes.getPublishTag());
                res = stmt.executeQuery();
                int offset = histRes.getStructureVersion() > 0 ? 1 : 0;
                I_CmsHistoryResource lastHistRes = histRes;
                while (res.next()) {
                    I_CmsHistoryResource newHistRes = this.internalMergeResource(histRes, res, offset);
                    if (newHistRes.getResourceVersion() != lastHistRes.getResourceVersion()) {
                        if (offset == 1) {
                            if (histRes != lastHistRes) {
                                result.add(lastHistRes);
                            }
                        } else {
                            result.add(newHistRes);
                        }
                    }
                    lastHistRes = newHistRes;
                }
                if (offset == 1 && lastHistRes != histRes) {
                    result.add(lastHistRes);
                }
                this.m_sqlManager.closeAll(dbc, null, stmt, res);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public byte[] readContent(CmsDbContext dbc, CmsUUID resourceId, int publishTag) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        byte[] content = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_HISTORY_READ_CONTENT");
            stmt.setString(1, resourceId.toString());
            stmt.setInt(2, publishTag);
            stmt.setInt(3, publishTag);
            res = stmt.executeQuery();
            if (res.next()) {
                content = this.m_sqlManager.getBytes(res, this.m_sqlManager.readQuery("C_RESOURCES_FILE_CONTENT"));
                while (res.next()) {
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return content;
    }

    @Override
    public List<I_CmsHistoryResource> readDeletedResources(CmsDbContext dbc, CmsUUID structureId, CmsUUID userId) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        ArrayList<I_CmsHistoryResource> result = new ArrayList<I_CmsHistoryResource>();
        ArrayList<I_CmsHistoryResource> tmpHistRes = new ArrayList<I_CmsHistoryResource>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = userId == null ? this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_HISTORY_READ_DELETED") : this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_HISTORY_READ_DELETED_RESTRICTED");
            stmt.setString(1, structureId.toString());
            if (userId != null) {
                stmt.setString(2, userId.toString());
            }
            res = stmt.executeQuery();
            while (res.next()) {
                tmpHistRes.add(this.internalCreateResource(res));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        I_CmsVfsDriver vfsDriver = this.m_driverManager.getVfsDriver(dbc);
        for (I_CmsHistoryResource histRes : tmpHistRes) {
            if (vfsDriver.validateStructureIdExists(dbc, dbc.currentProject().getUuid(), histRes.getStructureId())) continue;
            result.add(histRes);
        }
        if (!result.isEmpty() || dbc.getRequestContext() == null || dbc.getRequestContext().getAttribute("ATTR_RESOURCE_NAME") == null) {
            return result;
        }
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = userId == null ? this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_HISTORY_READ_DELETED_NAME") : this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_HISTORY_READ_DELETED_NAME_RESTRICTED");
            String path = dbc.getRequestContext().getAttribute("ATTR_RESOURCE_NAME").toString();
            stmt.setString(1, path + "%");
            stmt.setString(2, path);
            if (userId != null) {
                stmt.setString(3, userId.toString());
            }
            res = stmt.executeQuery();
            tmpHistRes.clear();
            while (res.next()) {
                tmpHistRes.add(this.internalCreateResource(res));
            }
        }
        catch (SQLException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
        }
        finally {
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        for (I_CmsHistoryResource histRes : tmpHistRes) {
            if (vfsDriver.validateStructureIdExists(dbc, dbc.currentProject().getUuid(), histRes.getStructureId())) continue;
            result.add(histRes);
        }
        return result;
    }

    @Override
    public int readLastVersion(CmsDbContext dbc, CmsUUID structureId) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet res = null;
        int lastVersion = 0;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_STRUCTURE_HISTORY_MAXVER");
            stmt.setString(1, structureId.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                lastVersion = res.getInt(1);
                while (res.next()) {
                }
            } else {
                lastVersion = 0;
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return lastVersion;
    }

    @Override
    public int readMaxPublishTag(CmsDbContext dbc, CmsUUID resourceId) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet res = null;
        int result = 0;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_READ_MAX_PUBLISH_TAG");
            stmt.setString(1, resourceId.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                result = res.getInt(1);
                while (res.next()) {
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readNextPublishTag(CmsDbContext dbc) {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet res = null;
        int projectPublishTag = 1;
        int resourcePublishTag = 1;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_HISTORY_MAXTAG");
            res = stmt.executeQuery();
            if (res.next()) {
                projectPublishTag = res.getInt(1) + 1;
                while (res.next()) {
                }
            }
            this.m_sqlManager.closeAll(dbc, null, stmt, res);
        }
        catch (SQLException exc) {
            try {
                LOG.error((Object)Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)exc);
                this.m_sqlManager.closeAll(dbc, null, stmt, res);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, null, stmt, res);
                throw throwable;
            }
        }
        try {
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_HISTORY_MAXTAG");
            res = stmt.executeQuery();
            if (res.next()) {
                resourcePublishTag = res.getInt(1) + 1;
                while (res.next()) {
                }
            }
        }
        catch (SQLException exc) {
            LOG.error((Object)Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)exc);
        }
        finally {
            this.m_sqlManager.closeAll(dbc, null, stmt, res);
        }
        if (resourcePublishTag > projectPublishTag) {
            projectPublishTag = resourcePublishTag;
        }
        try {
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_CONTENT_PUBLISH_MAXTAG");
            res = stmt.executeQuery();
            if (res.next()) {
                resourcePublishTag = res.getInt(1) + 1;
                while (res.next()) {
                }
            }
        }
        catch (SQLException exc) {
            LOG.error((Object)Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)exc);
        }
        finally {
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        if (resourcePublishTag > projectPublishTag) {
            projectPublishTag = resourcePublishTag;
        }
        return projectPublishTag;
    }

    @Override
    public CmsHistoryPrincipal readPrincipal(CmsDbContext dbc, CmsUUID principalId) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        CmsHistoryPrincipal historyPrincipal = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_HISTORY_PRINCIPAL_READ");
            stmt.setString(1, principalId.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                String userName = res.getString(this.m_sqlManager.readQuery("C_PRINCIPALS_HISTORY_NAME"));
                String ou = CmsOrganizationalUnit.removeLeadingSeparator(res.getString(this.m_sqlManager.readQuery("C_PRINCIPALS_HISTORY_OU")));
                historyPrincipal = new CmsHistoryPrincipal(principalId, ou + userName, res.getString(this.m_sqlManager.readQuery("C_PRINCIPALS_HISTORY_DESCRIPTION")), res.getString(this.m_sqlManager.readQuery("C_PRINCIPALS_HISTORY_EMAIL")), res.getString(this.m_sqlManager.readQuery("C_PRINCIPALS_HISTORY_TYPE")), new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_PRINCIPALS_HISTORY_USERDELETED"))), res.getLong(this.m_sqlManager.readQuery("C_PRINCIPALS_HISTORY_DATEDELETED")));
                while (res.next()) {
                }
            } else {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_HISTORY_PRINCIPAL_NOT_FOUND_1", principalId));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return historyPrincipal;
    }

    @Override
    public CmsHistoryProject readProject(CmsDbContext dbc, CmsUUID projectId) throws CmsDataAccessException {
        int tmpTag;
        PreparedStatement stmt = null;
        CmsHistoryProject project = null;
        ResultSet res = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_HISTORY_READ_BYID");
            stmt.setString(1, projectId.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                tmpTag = res.getInt(this.m_sqlManager.readQuery("C_PROJECTS_PUBLISH_TAG_0"));
                project = this.internalCreateProject(res, null);
                while (res.next()) {
                }
            } else {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_HISTORY_PROJECT_WITH_ID_1", projectId));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        List<String> projectresources = this.readProjectResources(dbc, tmpTag);
        project.setProjectResources(projectresources);
        return project;
    }

    @Override
    public CmsHistoryProject readProject(CmsDbContext dbc, int publishTag) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        CmsHistoryProject project = null;
        ResultSet res = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_HISTORY_READ");
            stmt.setInt(1, publishTag);
            res = stmt.executeQuery();
            if (res.next()) {
                project = this.internalCreateProject(res, null);
                while (res.next()) {
                }
            } else {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_HISTORY_PROJECT_WITH_TAG_ID_1", publishTag));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        List<String> projectresources = this.readProjectResources(dbc, publishTag);
        project.setProjectResources(projectresources);
        return project;
    }

    @Override
    public List<String> readProjectResources(CmsDbContext dbc, int publishTag) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet res = null;
        ArrayList<String> projectResources = new ArrayList<String>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTRESOURCES_HISTORY_READ");
            stmt.setInt(1, publishTag);
            res = stmt.executeQuery();
            while (res.next()) {
                projectResources.add(res.getString("RESOURCE_PATH"));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return projectResources;
    }

    @Override
    public List<CmsHistoryProject> readProjects(CmsDbContext dbc) throws CmsDataAccessException {
        ArrayList<CmsHistoryProject> projects = new ArrayList<CmsHistoryProject>();
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        HashMap<Integer, CmsHistoryProject> tmpProjects = new HashMap<Integer, CmsHistoryProject>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_HISTORY_READ_ALL");
            res = stmt.executeQuery();
            int max = 300;
            for (int i = 0; res.next() && i < max; ++i) {
                tmpProjects.put(res.getInt("PUBLISH_TAG"), this.internalCreateProject(res, null));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        for (Map.Entry entry : tmpProjects.entrySet()) {
            List<String> resources = this.readProjectResources(dbc, (Integer)entry.getKey());
            ((CmsHistoryProject)entry.getValue()).setProjectResources(resources);
            projects.add((CmsHistoryProject)entry.getValue());
        }
        return projects;
    }

    @Override
    public List<CmsProperty> readProperties(CmsDbContext dbc, I_CmsHistoryResource resource) throws CmsDataAccessException {
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        HashMap<String, CmsProperty> propertyMap = new HashMap<String, CmsProperty>();
        try {
            int mappingType;
            String propertyValue;
            String propertyKey;
            conn = this.m_sqlManager.getConnection(dbc);
            int pubTag = -1;
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROPERTIES_HISTORY_READ_PUBTAG");
            stmt.setString(1, resource.getStructureId().toString());
            stmt.setInt(2, resource.getPublishTag());
            res = stmt.executeQuery();
            if (res.next()) {
                pubTag = res.getInt(1);
                while (res.next()) {
                }
            }
            this.m_sqlManager.closeAll(dbc, null, stmt, res);
            if (pubTag > 0) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROPERTIES_HISTORY_READALL_STR");
                stmt.setString(1, resource.getStructureId().toString());
                stmt.setInt(2, pubTag);
                res = stmt.executeQuery();
                while (res.next()) {
                    propertyKey = res.getString(1);
                    propertyValue = res.getString(2);
                    mappingType = res.getInt(3);
                    this.internalAddToPropMap(propertyMap, resource, propertyKey, propertyValue, mappingType);
                }
                this.m_sqlManager.closeAll(dbc, null, stmt, res);
            }
            if (pubTag != resource.getPublishTag()) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROPERTIES_HISTORY_READALL_RES");
                stmt.setString(1, resource.getStructureId().toString());
                stmt.setInt(2, resource.getPublishTag());
                res = stmt.executeQuery();
                while (res.next()) {
                    propertyKey = res.getString(1);
                    propertyValue = res.getString(2);
                    mappingType = res.getInt(3);
                    this.internalAddToPropMap(propertyMap, resource, propertyKey, propertyValue, mappingType);
                }
                this.m_sqlManager.closeAll(dbc, null, stmt, res);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return new ArrayList<CmsProperty>(propertyMap.values());
    }

    @Override
    public CmsPropertyDefinition readPropertyDefinition(CmsDbContext dbc, String name) throws CmsDataAccessException {
        CmsPropertyDefinition propDef = null;
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROPERTYDEF_READ_HISTORY");
            stmt.setString(1, name);
            res = stmt.executeQuery();
            if (res.next()) {
                propDef = new CmsPropertyDefinition(new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_PROPERTYDEF_ID"))), res.getString(this.m_sqlManager.readQuery("C_PROPERTYDEF_NAME")), CmsPropertyDefinition.CmsPropertyType.valueOf(res.getInt(this.m_sqlManager.readQuery("C_PROPERTYDEF_TYPE"))));
                while (res.next()) {
                }
            } else {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_PROPERTYDEF_WITH_NAME_1", name));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return propDef;
    }

    @Override
    public int readPublishTag(CmsDbContext dbc, long maxdate) throws CmsDataAccessException {
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        int maxVersion = 0;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_HISTORY_READ_TAG_FOR_DATE");
            stmt.setLong(1, maxdate);
            res = stmt.executeQuery();
            if (res.next()) {
                maxVersion = res.getInt(1);
                while (res.next()) {
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return maxVersion;
    }

    @Override
    public I_CmsHistoryResource readResource(CmsDbContext dbc, CmsUUID structureId, int version) throws CmsDataAccessException {
        I_CmsHistoryResource resource = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_HISTORY_READ_VERSION");
            stmt.setString(1, structureId.toString());
            stmt.setInt(2, version);
            res = stmt.executeQuery();
            if (res.next()) {
                resource = this.internalCreateResource(res);
                while (res.next()) {
                }
            } else {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_HISTORY_FILE_NOT_FOUND_1", structureId));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return resource;
    }

    @Override
    public void setDriverManager(CmsDriverManager driverManager) {
        this.m_driverManager = driverManager;
    }

    @Override
    public void setSqlManager(org.opencms.db.CmsSqlManager sqlManager) {
        this.m_sqlManager = (CmsSqlManager)sqlManager;
    }

    @Override
    public void writePrincipal(CmsDbContext dbc, I_CmsPrincipal principal) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            this.readPrincipal(dbc, principal.getId());
            return;
        }
        catch (CmsDbEntryNotFoundException cmsDbEntryNotFoundException) {
            try {
                conn = this.m_sqlManager.getConnection(dbc);
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_HISTORY_PRINCIPAL_CREATE");
                stmt.setString(1, principal.getId().toString());
                stmt.setString(2, principal.getSimpleName());
                String desc = principal.getDescription();
                desc = CmsStringUtil.isEmptyOrWhitespaceOnly(desc) ? "-" : desc;
                stmt.setString(3, desc);
                stmt.setString(4, "/" + principal.getOuFqn());
                if (principal instanceof CmsUser) {
                    String email = ((CmsUser)principal).getEmail();
                    email = CmsStringUtil.isEmptyOrWhitespaceOnly(email) ? "-" : email;
                    stmt.setString(5, email);
                    stmt.setString(6, "USER");
                } else {
                    stmt.setString(5, "-");
                    stmt.setString(6, "GROUP");
                }
                stmt.setString(7, dbc.currentUser().getId().toString());
                stmt.setLong(8, System.currentTimeMillis());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
            }
            catch (SQLException e) {
                try {
                    throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                    throw throwable;
                }
            }
            return;
        }
    }

    @Override
    public void writeProject(CmsDbContext dbc, int publishTag, long publishDate) throws CmsDataAccessException {
        CmsProject currentProject = dbc.currentProject();
        CmsUser currentUser = dbc.currentUser();
        List<String> projectresources = this.m_driverManager.getProjectDriver(dbc).readProjectResources(dbc, currentProject);
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_HISTORY_CREATE");
            stmt.setInt(1, publishTag);
            stmt.setString(2, currentProject.getUuid().toString());
            stmt.setString(3, currentProject.getSimpleName());
            stmt.setLong(4, publishDate);
            stmt.setString(5, currentUser.getId().toString());
            stmt.setString(6, currentProject.getOwnerId().toString());
            stmt.setString(7, currentProject.getGroupId().toString());
            stmt.setString(8, currentProject.getManagerGroupId().toString());
            stmt.setString(9, currentProject.getDescription());
            stmt.setLong(10, currentProject.getDateCreated());
            stmt.setInt(11, currentProject.getType().getMode());
            stmt.setString(12, "/" + currentProject.getOuFqn());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, null, stmt, null);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTRESOURCES_HISTORY_CREATE");
            Iterator<String> i = projectresources.iterator();
            while (i.hasNext()) {
                stmt.setInt(1, publishTag);
                stmt.setString(2, currentProject.getUuid().toString());
                stmt.setString(3, i.next());
                stmt.executeUpdate();
                stmt.clearParameters();
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void writeProperties(CmsDbContext dbc, CmsResource resource, List<CmsProperty> properties, int publishTag) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        HashMap<CmsProperty, CmsPropertyDefinition> propDefs = new HashMap<CmsProperty, CmsPropertyDefinition>();
        try {
            for (CmsProperty property : properties) {
                CmsPropertyDefinition propDef = null;
                try {
                    propDef = this.readPropertyDefinition(dbc, property.getName());
                }
                catch (CmsDbEntryNotFoundException e) {
                    propDef = this.createPropertyDefinition(dbc, property.getName(), CmsPropertyDefinition.TYPE_NORMAL);
                }
                propDefs.put(property, propDef);
            }
        }
        catch (CmsDataAccessException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
        }
        finally {
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            block13: for (Map.Entry entry : propDefs.entrySet()) {
                for (int i = 0; i < 2; ++i) {
                    CmsUUID id;
                    int mappingType;
                    String value;
                    if (i == 0) {
                        value = ((CmsProperty)entry.getKey()).getStructureValue();
                        mappingType = 1;
                        id = resource.getStructureId();
                        if (CmsStringUtil.isEmpty(value)) {
                            continue;
                        }
                    } else {
                        value = ((CmsProperty)entry.getKey()).getResourceValue();
                        mappingType = 2;
                        id = resource.getResourceId();
                        if (CmsStringUtil.isEmpty(value)) continue block13;
                    }
                    stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROPERTIES_HISTORY_CREATE");
                    stmt.setString(1, resource.getStructureId().toString());
                    stmt.setString(2, ((CmsPropertyDefinition)entry.getValue()).getId().toString());
                    stmt.setString(3, id.toString());
                    stmt.setInt(4, mappingType);
                    stmt.setString(5, this.m_sqlManager.validateEmpty(value));
                    stmt.setInt(6, publishTag);
                    stmt.executeUpdate();
                    this.m_sqlManager.closeAll(dbc, null, stmt, null);
                }
            }
        }
        catch (SQLException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
        }
        finally {
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
    }

    @Override
    public void writeResource(CmsDbContext dbc, CmsResource resource, List<CmsProperty> properties, int publishTag) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            boolean valResource = this.internalValidateResource(dbc, resource, publishTag);
            int sibCount = resource.getSiblingCount();
            if (resource.getState().isDeleted()) {
                if (resource instanceof CmsFile && !valResource) {
                    if (sibCount < 2) {
                        this.m_driverManager.getVfsDriver(dbc).createOnlineContent(dbc, resource.getResourceId(), ((CmsFile)resource).getContents(), publishTag, false, true);
                    } else {
                        Set changedAndDeleted = (Set)dbc.getAttribute("changedAndDeleted");
                        if (changedAndDeleted == null || !changedAndDeleted.contains(resource.getResourceId())) {
                            this.m_driverManager.getVfsDriver(dbc).createOnlineContent(dbc, resource.getResourceId(), ((CmsFile)resource).getContents(), publishTag, true, false);
                        }
                    }
                }
                this.m_driverManager.getVfsDriver(dbc).publishVersions(dbc, resource, !valResource);
            }
            Map<String, Integer> versions = this.m_driverManager.getVfsDriver(dbc).readVersions(dbc, CmsProject.ONLINE_PROJECT_ID, resource.getResourceId(), resource.getStructureId());
            int structureVersion = versions.get("structure");
            int resourceVersion = versions.get("resource");
            CmsUUID parentId = CmsUUID.getNullUUID();
            CmsFolder parent = this.m_driverManager.getVfsDriver(dbc).readParentFolder(dbc, CmsProject.ONLINE_PROJECT_ID, resource.getStructureId());
            if (parent != null) {
                parentId = parent.getStructureId();
            }
            conn = this.m_sqlManager.getConnection(dbc);
            if (!valResource) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_HISTORY_WRITE");
                stmt.setString(1, resource.getResourceId().toString());
                stmt.setInt(2, resource.getTypeId());
                stmt.setInt(3, resource.getFlags());
                stmt.setLong(4, resource.getDateCreated());
                stmt.setString(5, resource.getUserCreated().toString());
                stmt.setLong(6, resource.getDateLastModified());
                stmt.setString(7, resource.getUserLastModified().toString());
                stmt.setInt(8, resource.getState().getState());
                stmt.setInt(9, resource.getLength());
                stmt.setLong(10, resource.getDateContent());
                stmt.setString(11, dbc.currentProject().getUuid().toString());
                stmt.setInt(12, resource.getSiblingCount());
                stmt.setInt(13, resourceVersion);
                stmt.setInt(14, publishTag);
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            }
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_STRUCTURE_HISTORY_WRITE");
            stmt.setString(1, resource.getStructureId().toString());
            stmt.setString(2, resource.getResourceId().toString());
            stmt.setString(3, resource.getRootPath());
            stmt.setInt(4, resource.getState().getState());
            stmt.setLong(5, resource.getDateReleased());
            stmt.setLong(6, resource.getDateExpired());
            stmt.setInt(7, structureVersion);
            stmt.setString(8, parentId.toString());
            stmt.setInt(9, publishTag);
            stmt.setInt(10, resource.getVersion());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
        this.writeProperties(dbc, resource, properties, publishTag);
    }

    protected void internalAddToPropMap(Map<String, CmsProperty> propertyMap, I_CmsHistoryResource resource, String propertyKey, String propertyValue, int mappingType) throws CmsDbConsistencyException {
        block9: {
            CmsProperty property;
            block8: {
                property = propertyMap.get(propertyKey);
                if (property == null) break block8;
                switch (mappingType) {
                    case 1: {
                        property.setStructureValue(propertyValue);
                        break block9;
                    }
                    case 2: {
                        property.setResourceValue(propertyValue);
                        break block9;
                    }
                    default: {
                        throw new CmsDbConsistencyException(Messages.get().container("ERR_UNKNOWN_PROPERTY_VALUE_MAPPING_3", resource.getRootPath(), mappingType, propertyKey));
                    }
                }
            }
            property = new CmsProperty();
            property.setName(propertyKey);
            switch (mappingType) {
                case 1: {
                    property.setStructureValue(propertyValue);
                    property.setResourceValue(null);
                    break;
                }
                case 2: {
                    property.setStructureValue(null);
                    property.setResourceValue(propertyValue);
                    break;
                }
                default: {
                    throw new CmsDbConsistencyException(Messages.get().container("ERR_UNKNOWN_PROPERTY_VALUE_MAPPING_3", resource.getRootPath(), mappingType, propertyKey));
                }
            }
            propertyMap.put(propertyKey, property);
        }
    }

    protected void internalCleanup(CmsDbContext dbc, I_CmsHistoryResource resource) throws CmsDataAccessException {
        boolean isFolderAndNoVersionLeft;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        HashMap<CmsUUID, Integer> tmpSubResources = new HashMap<CmsUUID, Integer>();
        boolean bl = isFolderAndNoVersionLeft = resource.getRootPath().endsWith("/") && this.readLastVersion(dbc, resource.getStructureId()) == 0;
        if (isFolderAndNoVersionLeft) {
            try {
                conn = this.m_sqlManager.getConnection(dbc);
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_STRUCTURE_HISTORY_READ_SUBRESOURCES");
                stmt.setString(1, resource.getStructureId().toString());
                res = stmt.executeQuery();
                while (res.next()) {
                    CmsUUID structureId = new CmsUUID(res.getString(1));
                    int version = res.getInt(2);
                    tmpSubResources.put(structureId, version);
                }
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
            }
            catch (SQLException e) {
                try {
                    throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                    throw throwable;
                }
            }
        }
        for (Map.Entry entry : tmpSubResources.entrySet()) {
            I_CmsHistoryResource histResource = this.readResource(dbc, (CmsUUID)entry.getKey(), (Integer)entry.getValue());
            this.deleteEntries(dbc, histResource, 0, -1L);
        }
    }

    protected int internalCountProperties(CmsDbContext dbc, CmsPropertyDefinition metadef, CmsUUID projectId) throws CmsDataAccessException {
        int returnValue;
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_PROPERTIES_READALL_COUNT");
            stmt.setString(1, metadef.getId().toString());
            res = stmt.executeQuery();
            if (res.next()) {
                returnValue = res.getInt(1);
                while (res.next()) {
                }
            } else {
                throw new CmsDbConsistencyException(Messages.get().container("ERR_NO_PROPERTIES_FOR_PROPERTYDEF_1", metadef.getName()));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return returnValue;
    }

    protected CmsHistoryProject internalCreateProject(ResultSet res, List<String> resources) throws SQLException {
        String ou = CmsOrganizationalUnit.removeLeadingSeparator(res.getString(this.m_sqlManager.readQuery("C_PROJECTS_PROJECT_OU_0")));
        CmsUUID publishedById = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_PROJECT_PUBLISHED_BY_0")));
        CmsUUID userId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_PROJECTS_USER_ID_0")));
        return new CmsHistoryProject(res.getInt(this.m_sqlManager.readQuery("C_PROJECTS_PUBLISH_TAG_0")), new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_PROJECTS_PROJECT_ID_0"))), ou + res.getString(this.m_sqlManager.readQuery("C_PROJECTS_PROJECT_NAME_0")), res.getString(this.m_sqlManager.readQuery("C_PROJECTS_PROJECT_DESCRIPTION_0")), userId, new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_PROJECTS_GROUP_ID_0"))), new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_PROJECTS_MANAGERGROUP_ID_0"))), res.getLong(this.m_sqlManager.readQuery("C_PROJECTS_DATE_CREATED_0")), CmsProject.CmsProjectType.valueOf(res.getInt(this.m_sqlManager.readQuery("C_PROJECTS_PROJECT_TYPE_0"))), res.getLong(this.m_sqlManager.readQuery("C_PROJECT_PUBLISHDATE_0")), publishedById, resources);
    }

    protected I_CmsHistoryResource internalCreateResource(ResultSet res) throws SQLException {
        int resourceVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_VERSION"));
        int structureVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_VERSION"));
        int tagId = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_PUBLISH_TAG"));
        CmsUUID structureId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_ID")));
        CmsUUID resourceId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_ID")));
        String resourcePath = res.getString(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_PATH"));
        int resourceType = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_TYPE"));
        int resourceFlags = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_FLAGS"));
        CmsUUID projectLastModified = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_PROJECT_LASTMODIFIED")));
        int state = Math.max(res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STATE")), res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_STATE")));
        long dateCreated = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_CREATED"));
        long dateLastModified = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_LASTMODIFIED"));
        long dateReleased = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_RELEASED"));
        long dateExpired = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_EXPIRED"));
        int resourceSize = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_SIZE"));
        CmsUUID userLastModified = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_USER_LASTMODIFIED")));
        CmsUUID userCreated = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_USER_CREATED")));
        CmsUUID parentId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_HISTORY_PARENTID")));
        long dateContent = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_CONTENT"));
        boolean isFolder = resourcePath.endsWith("/");
        if (isFolder) {
            return new CmsHistoryFolder(tagId, structureId, resourceId, resourcePath, resourceType, resourceFlags, projectLastModified, CmsResourceState.valueOf(state), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, resourceVersion + structureVersion, parentId, resourceVersion, structureVersion);
        }
        return new CmsHistoryFile(tagId, structureId, resourceId, resourcePath, resourceType, resourceFlags, projectLastModified, CmsResourceState.valueOf(state), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, resourceSize, dateContent, resourceVersion + structureVersion, parentId, null, resourceVersion, structureVersion);
    }

    protected I_CmsHistoryResource internalMergeResource(I_CmsHistoryResource histRes, ResultSet res, int versionOffset) throws SQLException {
        int resourceVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_VERSION"));
        int structureVersion = histRes.getStructureVersion() - versionOffset;
        int tagId = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_PUBLISH_TAG"));
        CmsUUID structureId = histRes.getStructureId();
        CmsUUID resourceId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_ID")));
        int resourceType = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_TYPE"));
        int resourceFlags = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_FLAGS"));
        CmsUUID projectLastModified = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_PROJECT_LASTMODIFIED")));
        int state = histRes.getState().getState();
        long dateCreated = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_CREATED"));
        long dateLastModified = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_LASTMODIFIED"));
        long dateReleased = histRes.getDateReleased();
        long dateExpired = histRes.getDateExpired();
        int resourceSize = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_SIZE"));
        CmsUUID userLastModified = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_USER_LASTMODIFIED")));
        CmsUUID userCreated = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_USER_CREATED")));
        String resourcePath = histRes.getRootPath();
        CmsUUID parentId = histRes.getParentId();
        long dateContent = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_CONTENT"));
        if (histRes.isFolder()) {
            return new CmsHistoryFolder(tagId, structureId, resourceId, resourcePath, resourceType, resourceFlags, projectLastModified, CmsResourceState.valueOf(state), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, resourceVersion + structureVersion, parentId, resourceVersion, structureVersion);
        }
        return new CmsHistoryFile(tagId, structureId, resourceId, resourcePath, resourceType, resourceFlags, projectLastModified, CmsResourceState.valueOf(state), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, resourceSize, dateContent, resourceVersion + structureVersion, parentId, null, resourceVersion, structureVersion);
    }

    protected boolean internalValidateResource(CmsDbContext dbc, CmsResource resource, int publishTag) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        boolean exists = false;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_HISTORY_EXISTS_RESOURCE");
            stmt.setString(1, resource.getResourceId().toString());
            stmt.setInt(2, publishTag);
            res = stmt.executeQuery();
            exists = res.next();
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return exists;
    }
}

