/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opencms.util.CmsUUID;

public class CmsPublishHistoryCleanupFilter {
    private List<CmsUUID> m_exceptions = new ArrayList<CmsUUID>();
    private CmsUUID m_historyId = null;
    private Mode m_mode;

    private CmsPublishHistoryCleanupFilter() {
    }

    public static CmsPublishHistoryCleanupFilter allUnreferencedExcept(List<CmsUUID> exceptions) {
        CmsPublishHistoryCleanupFilter result = new CmsPublishHistoryCleanupFilter();
        result.m_mode = Mode.allUnreferenced;
        result.m_exceptions.addAll(exceptions);
        return result;
    }

    public static CmsPublishHistoryCleanupFilter forHistoryId(CmsUUID publishJobId) {
        CmsPublishHistoryCleanupFilter result = new CmsPublishHistoryCleanupFilter();
        result.m_mode = Mode.single;
        result.m_historyId = publishJobId;
        return result;
    }

    public List<CmsUUID> getExceptions() {
        return Collections.unmodifiableList(this.m_exceptions);
    }

    public CmsUUID getHistoryId() {
        return this.m_historyId;
    }

    public Mode getMode() {
        return this.m_mode;
    }

    public static enum Mode {
        allUnreferenced,
        single;

    }
}

