/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.generic;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.List;
import org.opencms.db.CmsCompositeQueryFragment;
import org.opencms.db.CmsDbUtil;
import org.opencms.db.CmsPagingQuery;
import org.opencms.db.CmsSelectQuery;
import org.opencms.db.CmsSimpleQueryFragment;
import org.opencms.db.CmsSqlBooleanClause;
import org.opencms.db.CmsStatementBuilder;
import org.opencms.db.I_CmsQueryFragment;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsUserSearchParameters;
import org.opencms.i18n.CmsEncoder;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsUserQueryBuilder {
    public CmsPair<String, List<Object>> createUserQuery(CmsUserSearchParameters searchParams, boolean countOnly) {
        CmsSelectQuery select = new CmsSelectQuery();
        CmsSelectQuery.TableAlias users = select.addTable(this.tabUsers(), "usr");
        if (countOnly) {
            select.addColumn("COUNT(" + users.column(this.colId()) + ")");
        } else {
            String[] columns;
            for (String columnName : columns = new String[]{this.colId(), this.colName(), this.colPassword(), this.colFirstName(), this.colLastName(), this.colEmail(), this.colLastLogin(), this.colFlags(), this.colOu(), this.colDateCreated()}) {
                select.addColumn(users.column(columnName));
            }
        }
        CmsOrganizationalUnit orgUnit = searchParams.getOrganizationalUnit();
        boolean recursive = searchParams.recursiveOrgUnits();
        if (orgUnit != null) {
            this.addOrgUnitCondition(select, users, orgUnit, recursive);
        }
        if (searchParams.isFilterCore()) {
            select.addCondition(this.createCoreCondition(users));
        }
        this.addEmailCondition(select, users, searchParams.getEmail());
        this.addAllowedOuCondition(select, users, searchParams.getAllowedOus());
        this.addFlagCondition(select, users, searchParams.getFlags(), searchParams.keepCoreUsers());
        if (orgUnit != null) {
            this.addWebuserCondition(select, orgUnit, users);
        }
        this.addSearchFilterCondition(select, users, searchParams);
        this.addGroupCondition(select, users, searchParams);
        if (countOnly) {
            CmsStatementBuilder builder = new CmsStatementBuilder();
            select.visit(builder);
            return CmsPair.create(builder.getQuery(), builder.getParameters());
        }
        this.addSorting(select, users, searchParams);
        return this.makePaged(select, searchParams);
    }

    protected void addAllowedOuCondition(CmsSelectQuery select, CmsSelectQuery.TableAlias users, List<CmsOrganizationalUnit> allowedOus) {
        if (allowedOus != null && !allowedOus.isEmpty()) {
            CmsCompositeQueryFragment ouCondition = new CmsCompositeQueryFragment();
            ouCondition.setPrefix("(");
            ouCondition.setSuffix(")");
            ouCondition.setSeparator(" OR ");
            for (CmsOrganizationalUnit ou : allowedOus) {
                String ouName = CmsStringUtil.joinPaths("/", ou.getName());
                ouCondition.add(new CmsSimpleQueryFragment(users.column(this.colOu()) + " = ? ", ouName));
            }
            select.addCondition(ouCondition);
        }
    }

    protected void addEmailCondition(CmsSelectQuery select, CmsSelectQuery.TableAlias users, String email) {
        if (email != null) {
            CmsSimpleQueryFragment condition = new CmsSimpleQueryFragment(users.column(this.colEmail()) + " = ? ", email);
            select.addCondition(condition);
        }
    }

    protected void addFlagCondition(CmsSelectQuery select, CmsSelectQuery.TableAlias users, int flags, boolean allowCore) {
        if (flags != 0) {
            I_CmsQueryFragment condition = this.createFlagCondition(users, flags);
            if (allowCore) {
                I_CmsQueryFragment coreCondition = this.createCoreCondition(users);
                select.addCondition(CmsSqlBooleanClause.makeOr(condition, coreCondition));
            } else {
                select.addCondition(condition);
            }
        }
    }

    protected void addGroupCondition(CmsSelectQuery select, CmsSelectQuery.TableAlias users, CmsUserSearchParameters searchParams) {
        Collection<CmsGroup> notAnyGroups;
        Collection<CmsGroup> anyGroups;
        CmsGroup notGroup;
        CmsGroup group = searchParams.getGroup();
        if (group != null) {
            CmsUUID groupId = group.getId();
            CmsSelectQuery.TableAlias groupUsers = select.addTable(this.tabGroupUsers(), "groupusrs");
            select.addCondition(new CmsSimpleQueryFragment(groupUsers.column(this.colGroupUserGroupId()) + " = ? ", groupId.toString()));
            select.addCondition(new CmsSimpleQueryFragment(groupUsers.column(this.colGroupUserUserId()) + " = " + users.column(this.colId()), new Object[0]));
            if (searchParams.isFilterByGroupOu()) {
                select.addCondition(new CmsSimpleQueryFragment(users.column(this.colOu()) + " = ? ", group.getOuFqn()));
            }
        }
        if ((notGroup = searchParams.getNotGroup()) != null) {
            CmsSimpleQueryFragment notGroupCondition = new CmsSimpleQueryFragment("NOT EXISTS (SELECT " + this.getGroupUserSubqueryColumns() + " FROM " + this.tabGroupUsers() + " GU WHERE GU." + this.colGroupUserUserId() + " = " + users.column(this.colId()) + " AND GU." + this.colGroupUserGroupId() + " = ?)", notGroup.getId().toString());
            select.addCondition(notGroupCondition);
        }
        if ((anyGroups = searchParams.getAnyGroups()) != null && !anyGroups.isEmpty()) {
            CmsCompositeQueryFragment groupClause = new CmsCompositeQueryFragment();
            groupClause.setSeparator(" OR ");
            groupClause.setPrefix("(");
            groupClause.setSuffix(")");
            for (CmsGroup cmsGroup : anyGroups) {
                groupClause.add(new CmsSimpleQueryFragment("GU." + this.colGroupUserGroupId() + " = ?", cmsGroup.getId().toString()));
            }
            CmsCompositeQueryFragment existsClause = new CmsCompositeQueryFragment();
            existsClause.add(new CmsSimpleQueryFragment("EXISTS (SELECT " + this.getGroupUserSubqueryColumns() + " FROM " + this.tabGroupUsers() + " GU WHERE GU." + this.colGroupUserUserId() + " = " + users.column(this.colId()) + " AND ", new Object[0]));
            existsClause.add(groupClause);
            existsClause.add(new CmsSimpleQueryFragment(" ) ", new Object[0]));
            select.addCondition(existsClause);
        }
        if ((notAnyGroups = searchParams.getNotAnyGroups()) != null && !notAnyGroups.isEmpty()) {
            CmsCompositeQueryFragment groupClause = new CmsCompositeQueryFragment();
            groupClause.setPrefix("(");
            groupClause.setSuffix(")");
            groupClause.setSeparator(" OR ");
            for (CmsGroup grp : notAnyGroups) {
                groupClause.add(new CmsSimpleQueryFragment("GU." + this.colGroupUserGroupId() + " = ?", grp.getId().toString()));
            }
            CmsCompositeQueryFragment cmsCompositeQueryFragment = new CmsCompositeQueryFragment();
            cmsCompositeQueryFragment.add(new CmsSimpleQueryFragment("NOT EXISTS (SELECT " + this.getGroupUserSubqueryColumns() + " FROM " + this.tabGroupUsers() + " GU WHERE GU." + this.colGroupUserUserId() + " = " + users.column(this.colId()) + " AND ", new Object[0]));
            cmsCompositeQueryFragment.add(groupClause);
            cmsCompositeQueryFragment.add(new CmsSimpleQueryFragment(" ) ", new Object[0]));
            select.addCondition(cmsCompositeQueryFragment);
        }
    }

    protected void addOrgUnitCondition(CmsSelectQuery select, CmsSelectQuery.TableAlias users, CmsOrganizationalUnit orgUnit, boolean recursive) {
        String ouName = orgUnit.getName();
        String pattern = "/" + ouName;
        if (recursive) {
            pattern = pattern + "%";
        }
        select.addCondition(CmsDbUtil.columnLike(users.column(this.colOu()), pattern));
    }

    protected void addSearchFilterCondition(CmsSelectQuery select, CmsSelectQuery.TableAlias users, CmsUserSearchParameters searchParams) {
        Object searchFilter = searchParams.getSearchFilter();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)searchFilter)) {
            boolean caseInsensitive;
            boolean bl = caseInsensitive = !searchParams.isCaseSensitive();
            if (caseInsensitive) {
                searchFilter = ((String)searchFilter).toLowerCase();
            }
            CmsCompositeQueryFragment searchCondition = new CmsCompositeQueryFragment();
            searchCondition.setSeparator(" OR ");
            searchCondition.setPrefix("(");
            searchCondition.setSuffix(")");
            String patternExprTemplate = this.generateConcat("COALESCE(%1$s, '')", "' '", "COALESCE(%2$s, '')", "' '", "COALESCE(%3$s, '')");
            patternExprTemplate = this.wrapLower(patternExprTemplate, caseInsensitive);
            String patternExpr = String.format(patternExprTemplate, users.column(this.colName()), users.column(this.colFirstName()), users.column(this.colLastName()));
            String like = " LIKE ? ESCAPE '!' ";
            String matchExpr = patternExpr + like;
            searchFilter = "%" + CmsEncoder.escapeSqlLikePattern((String)searchFilter, '!') + "%";
            searchCondition.add(new CmsSimpleQueryFragment(matchExpr, searchFilter));
            for (CmsUserSearchParameters.SearchKey key : searchParams.getSearchKeys()) {
                switch (key) {
                    case email: {
                        searchCondition.add(new CmsSimpleQueryFragment(this.wrapLower(users.column(this.colEmail()), caseInsensitive) + like, searchFilter));
                        break;
                    }
                    case orgUnit: {
                        searchCondition.add(new CmsSimpleQueryFragment(this.wrapLower(users.column(this.colOu()), caseInsensitive) + like, searchFilter));
                        break;
                    }
                }
            }
            select.addCondition(searchCondition);
        }
    }

    protected void addSorting(CmsSelectQuery select, CmsSelectQuery.TableAlias users, CmsUserSearchParameters searchParams) {
        boolean ascending = searchParams.isAscending();
        Object ordering = this.getSortExpression(users, searchParams);
        ordering = ascending ? (String)ordering + " ASC" : (String)ordering + " DESC";
        select.setOrdering((String)ordering);
    }

    protected void addWebuserCondition(CmsSelectQuery select, CmsOrganizationalUnit orgUnit, CmsSelectQuery.TableAlias users) {
        String webuserConditionTemplate = orgUnit.hasFlagWebuser() ? "( %1$s >= 32768 AND %1$s < 65536 )" : "( %1$s < 32768 OR %1$s >= 65536 )";
        String webuserCondition = String.format(webuserConditionTemplate, users.column(this.colFlags()));
        select.addCondition(webuserCondition, new Object[0]);
    }

    protected String colDateCreated() {
        return "USER_DATECREATED";
    }

    protected String colEmail() {
        return "USER_EMAIL";
    }

    protected String colFirstName() {
        return "USER_FIRSTNAME";
    }

    protected String colFlags() {
        return "USER_FLAGS";
    }

    protected String colGroupUserGroupId() {
        return "GROUP_ID";
    }

    protected String colGroupUserUserId() {
        return "USER_ID";
    }

    protected String colId() {
        return "USER_ID";
    }

    protected String colLastLogin() {
        return "USER_LASTLOGIN";
    }

    protected String colLastName() {
        return "USER_LASTNAME";
    }

    protected String colName() {
        return "USER_NAME";
    }

    protected String colOu() {
        return "USER_OU";
    }

    protected String colPassword() {
        return "USER_PASSWORD";
    }

    protected I_CmsQueryFragment createCoreCondition(CmsSelectQuery.TableAlias users) {
        return new CmsSimpleQueryFragment(users.column(this.colFlags()) + " <= 65536", new Object[0]);
    }

    protected I_CmsQueryFragment createFlagCondition(CmsSelectQuery.TableAlias users, int flags) {
        return new CmsSimpleQueryFragment(users.column(this.colFlags()) + " & ? = ? ", flags, flags);
    }

    protected String generateConcat(String ... expressions) {
        return "CONCAT(" + Joiner.on((String)", ").join((Object[])expressions) + ")";
    }

    protected String generateTrim(String expression) {
        return "TRIM(" + expression + ")";
    }

    protected String getGroupUserSubqueryColumns() {
        return "*";
    }

    protected String getSortExpression(CmsSelectQuery.TableAlias users, CmsUserSearchParameters searchParams) {
        CmsUserSearchParameters.SortKey sortKey = searchParams.getSortKey();
        String ordering = users.column(this.colId());
        if (sortKey != null) {
            switch (sortKey) {
                case email: {
                    ordering = users.column(this.colEmail());
                    break;
                }
                case loginName: {
                    ordering = users.column(this.colName());
                    break;
                }
                case fullName: {
                    ordering = this.getUserFullNameExpression(users);
                    break;
                }
                case lastLogin: {
                    ordering = users.column(this.colLastLogin());
                    break;
                }
                case orgUnit: {
                    ordering = users.column(this.colOu());
                    break;
                }
                case activated: {
                    ordering = this.getUserActivatedExpression(users);
                    break;
                }
                case flagStatus: {
                    ordering = this.getUserFlagExpression(users, searchParams.getSortFlags());
                    break;
                }
            }
        }
        return ordering;
    }

    protected String getUserActivatedExpression(CmsSelectQuery.TableAlias users) {
        return "MOD(" + users.column(this.colFlags()) + ", 2)";
    }

    protected String getUserFlagExpression(CmsSelectQuery.TableAlias users, int flags) {
        return users.column(this.colFlags()) + " & " + flags;
    }

    protected String getUserFullNameExpression(CmsSelectQuery.TableAlias users) {
        String template = this.generateTrim(this.generateConcat("COALESCE(%1$s, '')", "' '", "COALESCE(%2$s, '')", "' ('", "%3$s", "')'"));
        return String.format(template, users.column(this.colFirstName()), users.column(this.colLastName()), users.column(this.colName()));
    }

    protected CmsPair<String, List<Object>> makePaged(CmsSelectQuery select, CmsUserSearchParameters params) {
        CmsPagingQuery paging = new CmsPagingQuery(select);
        paging.setUseWindowFunctions(this.useWindowFunctionsForPaging());
        int page = params.getPage();
        int pageSize = params.getPageSize();
        paging.setNameSubquery(this.shouldNameSubqueries());
        paging.setPaging(pageSize, page);
        CmsStatementBuilder builder = new CmsStatementBuilder();
        paging.visit(builder);
        return CmsPair.create(builder.getQuery(), builder.getParameters());
    }

    protected boolean shouldNameSubqueries() {
        return false;
    }

    protected String tabGroups() {
        return "CMS_GROUPS";
    }

    protected String tabGroupUsers() {
        return "CMS_GROUPUSERS";
    }

    protected String tabUsers() {
        return "CMS_USERS";
    }

    protected boolean useWindowFunctionsForPaging() {
        return false;
    }

    protected String wrapLower(String expr, boolean caseInsensitive) {
        return caseInsensitive ? "LOWER(" + expr + ")" : expr;
    }
}

