/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.oracle;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbContext;
import org.opencms.db.generic.Messages;
import org.opencms.main.CmsLog;

public class CmsSqlManager
extends org.opencms.db.generic.CmsSqlManager {
    private static final Log LOG = CmsLog.getLog(CmsSqlManager.class);
    private static final String QUERY_PROPERTIES = "org/opencms/db/oracle/query.properties";

    public CmsSqlManager() {
        this.loadQueryProperties(QUERY_PROPERTIES);
    }

    public static synchronized void closeAllInTransaction(org.opencms.db.generic.CmsSqlManager sqlManager, CmsDbContext dbc, Connection con, PreparedStatement stmnt, ResultSet res, PreparedStatement commit, boolean wasInTransaction) {
        block20: {
            block17: {
                block16: {
                    if (dbc == null) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_NULL_DB_CONTEXT_0"));
                    }
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (SQLException exc) {
                            if (!LOG.isDebugEnabled()) break block16;
                            LOG.debug((Object)exc.getLocalizedMessage(), (Throwable)exc);
                        }
                    }
                }
                if (commit != null) {
                    try {
                        commit.close();
                    }
                    catch (SQLException exc) {
                        if (!LOG.isDebugEnabled()) break block17;
                        LOG.debug((Object)exc.getLocalizedMessage(), (Throwable)exc);
                    }
                }
            }
            if (!wasInTransaction) {
                block19: {
                    if (stmnt != null) {
                        block18: {
                            try {
                                PreparedStatement rollback = sqlManager.getPreparedStatement(con, "C_ROLLBACK");
                                rollback.execute();
                                rollback.close();
                            }
                            catch (SQLException se) {
                                if (!LOG.isDebugEnabled()) break block18;
                                LOG.debug((Object)se.getLocalizedMessage(), (Throwable)se);
                            }
                        }
                        try {
                            stmnt.close();
                        }
                        catch (SQLException exc) {
                            if (!LOG.isDebugEnabled()) break block19;
                            LOG.debug((Object)exc.getLocalizedMessage(), (Throwable)exc);
                        }
                    }
                }
                if (con != null) {
                    try {
                        con.setAutoCommit(true);
                        con.close();
                    }
                    catch (SQLException se) {
                        if (!LOG.isDebugEnabled()) break block20;
                        LOG.debug((Object)se.getLocalizedMessage(), (Throwable)se);
                    }
                }
            }
        }
    }

    @Override
    public byte[] getBytes(ResultSet res, String attributeName) throws SQLException {
        Blob blob = res.getBlob(attributeName);
        return blob.getBytes(1L, (int)blob.length());
    }
}

