/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.urlname;

import java.util.Comparator;
import org.opencms.util.CmsUUID;

public class CmsUrlNameMappingEntry {
    public static final int MAPPING_STATUS_NEW = 0;
    public static final int MAPPING_STATUS_PUBLISHED = 1;
    public static final int MAPPING_STATUS_REPLACE_ON_PUBLISH = 2;
    public static final int MAPPING_STATUS_REPLACE_ON_PUBLISH_PUBLISHED = 3;
    protected long m_dateChanged;
    protected String m_locale;
    protected String m_name;
    protected int m_state;
    protected CmsUUID m_structureId;

    public CmsUrlNameMappingEntry(String name, CmsUUID structureId, int state, long dateChanged, String locale) {
        this.m_name = name;
        this.m_structureId = structureId;
        this.m_state = state;
        this.m_dateChanged = dateChanged;
        this.m_locale = locale;
    }

    public long getDateChanged() {
        return this.m_dateChanged;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public String getName() {
        return this.m_name;
    }

    public int getState() {
        return this.m_state;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(CmsUrlNameMappingEntry.class.getSimpleName());
        buf.append(": ");
        buf.append(this.m_name);
        buf.append(",  ");
        buf.append(this.m_structureId.toString());
        buf.append(", ");
        buf.append(this.m_state);
        buf.append(", ");
        buf.append(this.m_dateChanged);
        buf.append(", ");
        buf.append(this.m_locale);
        buf.append("]");
        return buf.toString();
    }

    public static class DateComparator
    implements Comparator<CmsUrlNameMappingEntry> {
        @Override
        public int compare(CmsUrlNameMappingEntry o1, CmsUrlNameMappingEntry o2) {
            long date1 = o1.m_dateChanged;
            long date2 = o2.m_dateChanged;
            if (date1 < date2) {
                return -1;
            }
            if (date2 < date1) {
                return 1;
            }
            return o1.m_name.compareTo(o2.m_name);
        }
    }
}

