/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.userpublishlist;

import org.opencms.db.log.CmsLogEntry;
import org.opencms.db.userpublishlist.A_CmsLogPublishListConverter;
import org.opencms.util.CmsUUID;

public class CmsLogPublishListConverterCurrentUser
extends A_CmsLogPublishListConverter {
    @Override
    public void add(CmsLogEntry entry) {
        CmsUUID structureId = entry.getStructureId();
        CmsUUID userId = entry.getUserId();
        if (structureId == null || userId == null) {
            return;
        }
        switch (entry.getType()) {
            case RESOURCE_NEW_DELETED: 
            case RESOURCE_PUBLISHED_DELETED: {
                this.getEntry(structureId).setRemoveAll();
                break;
            }
            case RESOURCE_HIDDEN: 
            case RESOURCE_PUBLISHED_MODIFIED: 
            case RESOURCE_PUBLISHED_NEW: 
            case RESOURCE_CHANGES_UNDONE: {
                this.getEntry(structureId).addRemove(userId);
                break;
            }
            default: {
                this.getEntry(structureId).addUpdate(userId, entry.getDate());
            }
        }
    }
}

