/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsResourceState;
import org.opencms.db.CmsSecurityManager;
import org.opencms.db.log.CmsLogEntry;
import org.opencms.db.log.CmsLogFilter;
import org.opencms.db.urlname.CmsUrlNameMappingEntry;
import org.opencms.db.urlname.CmsUrlNameMappingFilter;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsLinkRewriter;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.Messages;
import org.opencms.file.history.CmsHistoryPrincipal;
import org.opencms.file.history.CmsHistoryProject;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsLocaleGroupService;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockFilter;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsAccessControlList;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.CmsSecurityException;
import org.opencms.security.I_CmsPermissionHandler;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.security.twofactor.CmsSecondFactorInfo;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.content.CmsNumberSuffixNameSequence;

public final class CmsObject {
    protected CmsRequestContext m_context;
    protected CmsSecurityManager m_securityManager;

    public CmsObject(CmsSecurityManager securityManager, CmsRequestContext context) {
        this.init(securityManager, context);
    }

    public void addRelationToResource(CmsResource resource, CmsResource target, String type) throws CmsException {
        this.createRelation(resource, target, type, false);
    }

    public void addRelationToResource(String resourceName, String targetPath, String type) throws CmsException {
        this.createRelation(resourceName, targetPath, type, false);
    }

    public String addSiteRoot(String resourcename) {
        return this.m_context.addSiteRoot(resourcename);
    }

    public void addUserToGroup(String username, String groupname) throws CmsException {
        this.m_securityManager.addUserToGroup(this.m_context, username, groupname, false);
    }

    public void adjustLinks(List<String> sourceFiles, String targetParentFolder) throws CmsException {
        CmsObject cms = OpenCms.initCmsObject(this);
        cms.getRequestContext().setSiteRoot("");
        ArrayList<String> rootSourceFiles = new ArrayList<String>();
        for (String sourceFile : sourceFiles) {
            rootSourceFiles.add(this.addSiteRoot(sourceFile));
        }
        String rootTargetParentFolder = this.addSiteRoot(targetParentFolder);
        CmsLinkRewriter rewriter = new CmsLinkRewriter(cms, rootSourceFiles, rootTargetParentFolder);
        rewriter.rewriteLinks();
    }

    public void adjustLinks(Map<String, String> sourceTargetMap, String targetParentFolder) throws CmsException {
        CmsObject cms = OpenCms.initCmsObject(this);
        cms.getRequestContext().setSiteRoot("");
        ArrayList<CmsPair<String, String>> sourcesAndTargets = new ArrayList<CmsPair<String, String>>();
        for (Map.Entry<String, String> entry : sourceTargetMap.entrySet()) {
            String rootSource = this.addSiteRoot(entry.getKey());
            String rootTarget = this.addSiteRoot(entry.getValue());
            sourcesAndTargets.add(CmsPair.create(rootSource, rootTarget));
        }
        String rootTargetParentFolder = this.addSiteRoot(targetParentFolder);
        CmsLinkRewriter rewriter = new CmsLinkRewriter(cms, rootTargetParentFolder, sourcesAndTargets);
        rewriter.rewriteLinks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustLinks(String sourceFolder, String targetFolder) throws CmsException {
        String rootSourceFolder = this.addSiteRoot(sourceFolder);
        String rootTargetFolder = this.addSiteRoot(targetFolder);
        String siteRoot = this.getRequestContext().getSiteRoot();
        this.getRequestContext().setSiteRoot("");
        try {
            CmsLinkRewriter linkRewriter = new CmsLinkRewriter(this, rootSourceFolder, rootTargetFolder);
            linkRewriter.rewriteLinks();
        }
        finally {
            this.getRequestContext().setSiteRoot(siteRoot);
        }
    }

    public void chacc(String resourceName, String principalType, String principalName, int allowedPermissions, int deniedPermissions, int flags) throws CmsException {
        CmsResource res = this.readResource(resourceName, CmsResourceFilter.ALL);
        CmsAccessControlEntry acEntry = null;
        try {
            I_CmsPrincipal principal = CmsPrincipal.readPrincipal(this, principalType, principalName);
            acEntry = new CmsAccessControlEntry(res.getResourceId(), principal.getId(), allowedPermissions, deniedPermissions, flags);
            acEntry.setFlagsForPrincipal(principal);
        }
        catch (CmsDbEntryNotFoundException e) {
            if (principalName.equalsIgnoreCase("ALL_OTHERS")) {
                acEntry = new CmsAccessControlEntry(res.getResourceId(), CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID, allowedPermissions, deniedPermissions, flags);
                acEntry.setFlags(128);
            }
            if (principalName.equalsIgnoreCase("OVERWRITE_ALL")) {
                acEntry = new CmsAccessControlEntry(res.getResourceId(), CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID, allowedPermissions, deniedPermissions, flags);
                acEntry.setFlags(256);
            }
            if (principalType.equalsIgnoreCase("ROLE")) {
                this.m_securityManager.checkRoleForResource(this.m_context, CmsRole.VFS_MANAGER, res);
                CmsRole role = CmsRole.valueOfRoleName(principalName);
                if (role == null) {
                    throw e;
                }
                acEntry = new CmsAccessControlEntry(res.getResourceId(), role.getId(), allowedPermissions, deniedPermissions, flags);
                acEntry.setFlags(512);
            }
            throw e;
        }
        this.m_securityManager.writeAccessControlEntry(this.m_context, res, acEntry);
    }

    public void chacc(String resourceName, String principalType, String principalName, String permissionString) throws CmsException {
        CmsResource res = this.readResource(resourceName, CmsResourceFilter.ALL);
        CmsAccessControlEntry acEntry = null;
        try {
            I_CmsPrincipal principal = CmsPrincipal.readPrincipal(this, principalType, principalName);
            acEntry = new CmsAccessControlEntry(res.getResourceId(), principal.getId(), permissionString);
            acEntry.setFlagsForPrincipal(principal);
        }
        catch (CmsDbEntryNotFoundException e) {
            if (principalName.equalsIgnoreCase("ALL_OTHERS")) {
                acEntry = new CmsAccessControlEntry(res.getResourceId(), CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID, permissionString);
                acEntry.setFlags(128);
            }
            if (principalName.equalsIgnoreCase("OVERWRITE_ALL")) {
                acEntry = new CmsAccessControlEntry(res.getResourceId(), CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID, permissionString);
                acEntry.setFlags(256);
            }
            if (principalType.equalsIgnoreCase("ROLE")) {
                this.m_securityManager.checkRoleForResource(this.m_context, CmsRole.VFS_MANAGER, res);
                CmsRole role = CmsRole.valueOfRoleName(principalName);
                if (role == null) {
                    throw e;
                }
                acEntry = new CmsAccessControlEntry(res.getResourceId(), role.getId(), permissionString);
                acEntry.setFlags(512);
            }
            throw e;
        }
        this.m_securityManager.writeAccessControlEntry(this.m_context, res, acEntry);
    }

    public void changeLock(CmsResource resource) throws CmsException {
        this.getResourceType(resource).changeLock(this, this.m_securityManager, resource);
    }

    public void changeLock(String resourcename) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        this.changeLock(resource);
    }

    public List<CmsResource> changeResourcesInFolderWithProperty(String resourcename, String property, String oldValue, String newValue, boolean recursive) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        return this.m_securityManager.changeResourcesInFolderWithProperty(this.m_context, resource, property, oldValue, newValue, recursive);
    }

    public void checkLoginUser(String userName, String password) throws CmsException {
        this.m_securityManager.checkLogin(this.m_context, userName, password, this.m_context.getRemoteAddress());
    }

    public void chflags(String resourcename, int flags) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).chflags(this, this.m_securityManager, resource, flags);
    }

    public void chtype(CmsResource resource, I_CmsResourceType type) throws CmsException {
        this.getResourceType(resource).chtype(this, this.m_securityManager, resource, type);
    }

    public void chtype(String resourcename, I_CmsResourceType type) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).chtype(this, this.m_securityManager, resource, type);
    }

    @Deprecated
    public void chtype(String resourcename, int type) throws CmsException {
        this.chtype(resourcename, this.getResourceType(type));
    }

    public void copyResource(String source, String destination) throws CmsException, CmsIllegalArgumentException {
        this.copyResource(source, destination, CmsResource.COPY_PRESERVE_SIBLING);
    }

    public void copyResource(String source, String destination, CmsResource.CmsResourceCopyMode siblingMode) throws CmsException, CmsIllegalArgumentException {
        CmsResource resource = this.readResource(source, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).copyResource(this, this.m_securityManager, resource, destination, siblingMode);
    }

    public void copyResourceToProject(CmsResource resource) throws CmsException {
        this.getResourceType(resource).copyResourceToProject(this, this.m_securityManager, resource);
    }

    public void copyResourceToProject(String resourcename) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        this.copyResourceToProject(resource);
    }

    public int countLockedResources(CmsUUID id) throws CmsException {
        return this.m_securityManager.countLockedResources(this.m_context, id);
    }

    public void cpacc(String sourceName, String destName) throws CmsException {
        CmsResource source = this.readResource(sourceName);
        CmsResource dest = this.readResource(destName);
        this.m_securityManager.copyAccessControlEntries(this.m_context, source, dest);
    }

    public CmsGroup createGroup(String groupFqn, String description, int flags, String parent) throws CmsException {
        return this.m_securityManager.createGroup(this.m_context, groupFqn, description, flags, parent);
    }

    public CmsProject createProject(String name, String description, String groupname, String managergroupname) throws CmsException {
        return this.m_securityManager.createProject(this.m_context, name, description, groupname, managergroupname, CmsProject.PROJECT_TYPE_NORMAL);
    }

    public CmsProject createProject(String name, String description, String groupname, String managergroupname, CmsProject.CmsProjectType projecttype) throws CmsException {
        return this.m_securityManager.createProject(this.m_context, name, description, groupname, managergroupname, projecttype);
    }

    public CmsPropertyDefinition createPropertyDefinition(String name) throws CmsException {
        return this.m_securityManager.createPropertyDefinition(this.m_context, name);
    }

    public CmsResource createResource(String sitePath, CmsResource resource, byte[] content, List<CmsProperty> properties) throws CmsException {
        resource.setUserLastModified(this.getRequestContext().getCurrentUser().getId());
        resource.setDateLastModified(System.currentTimeMillis());
        resource.setState(CmsResource.STATE_NEW);
        return this.m_securityManager.createResource(this.m_context, this.m_context.addSiteRoot(sitePath), resource, content, properties);
    }

    public CmsResource createResource(String resourcename, I_CmsResourceType type) throws CmsException, CmsIllegalArgumentException {
        return this.createResource(resourcename, type, new byte[0], new ArrayList<CmsProperty>(0));
    }

    public CmsResource createResource(String resourcename, I_CmsResourceType type, byte[] content, List<CmsProperty> properties) throws CmsException, CmsIllegalArgumentException {
        return type.createResource(this, this.m_securityManager, resourcename, content, properties);
    }

    @Deprecated
    public CmsResource createResource(String resourcename, int type) throws CmsException, CmsIllegalArgumentException {
        return this.createResource(resourcename, this.getResourceType(type), new byte[0], new ArrayList<CmsProperty>(0));
    }

    @Deprecated
    public CmsResource createResource(String resourcename, int type, byte[] content, List<CmsProperty> properties) throws CmsException, CmsIllegalArgumentException {
        return this.createResource(resourcename, this.getResourceType(type), content, properties);
    }

    public CmsResource createSibling(String source, String destination, List<CmsProperty> properties) throws CmsException {
        CmsResource resource = this.readResource(source, CmsResourceFilter.IGNORE_EXPIRATION);
        return this.getResourceType(resource).createSibling(this, this.m_securityManager, resource, destination, properties);
    }

    public CmsProject createTempfileProject() throws CmsException {
        return this.m_securityManager.createTempfileProject(this.m_context);
    }

    public CmsUser createUser(String userFqn, String password, String description, Map<String, Object> additionalInfos) throws CmsException {
        return this.m_securityManager.createUser(this.m_context, userFqn, password, description, additionalInfos);
    }

    public void deleteAllStaticExportPublishedResources(int linkType) throws CmsException {
        this.m_securityManager.deleteAllStaticExportPublishedResources(this.m_context, linkType);
    }

    public void deleteGroup(CmsUUID groupId, CmsUUID replacementId) throws CmsException {
        this.m_securityManager.deleteGroup(this.m_context, groupId, replacementId);
    }

    public void deleteGroup(String group) throws CmsException {
        this.m_securityManager.deleteGroup(this.m_context, group);
    }

    public void deleteHistoricalVersions(int versionsToKeep, int versionsDeleted, long timeDeleted, I_CmsReport report) throws CmsException {
        this.m_securityManager.deleteHistoricalVersions(this.m_context, versionsToKeep, versionsDeleted, timeDeleted, report);
    }

    public void deleteLogEntries(CmsLogFilter filter) throws CmsException {
        this.m_securityManager.deleteLogEntries(this.m_context, filter);
    }

    public void deleteProject(CmsUUID id) throws CmsException {
        this.m_securityManager.deleteProject(this.m_context, id);
    }

    public void deletePropertyDefinition(String name) throws CmsException {
        this.m_securityManager.deletePropertyDefinition(this.m_context, name);
    }

    public void deleteRelationsFromResource(CmsResource resource, CmsRelationFilter filter) throws CmsException {
        this.m_securityManager.deleteRelationsForResource(this.m_context, resource, filter);
    }

    public void deleteRelationsFromResource(String resourceName, CmsRelationFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourceName, CmsResourceFilter.ALL);
        this.m_securityManager.deleteRelationsForResource(this.m_context, resource, filter);
    }

    public void deleteResource(CmsResource res, CmsResource.CmsResourceDeleteMode deletePreserveSiblings) throws CmsException {
        this.getResourceType(res).deleteResource(this, this.m_securityManager, res, deletePreserveSiblings);
    }

    public void deleteResource(String resourcename, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(resourcename)) {
            throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_DELETE_RESOURCE_1", resourcename));
        }
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).deleteResource(this, this.m_securityManager, resource, siblingMode);
    }

    public void deleteStaticExportPublishedResource(String resourceName, int linkType, String linkParameter) throws CmsException {
        this.m_securityManager.deleteStaticExportPublishedResource(this.m_context, resourceName, linkType, linkParameter);
    }

    public void deleteUser(CmsUUID userId) throws CmsException {
        this.m_securityManager.deleteUser(this.m_context, userId);
    }

    public void deleteUser(CmsUUID userId, CmsUUID replacementId) throws CmsException {
        this.m_securityManager.deleteUser(this.m_context, userId, replacementId);
    }

    public void deleteUser(String username) throws CmsException {
        this.m_securityManager.deleteUser(this.m_context, username);
    }

    public boolean existsResource(CmsUUID structureId) {
        return this.existsResource(structureId, CmsResourceFilter.DEFAULT);
    }

    public boolean existsResource(CmsUUID structureId, CmsResourceFilter filter) {
        return this.m_securityManager.existsResource(this.m_context, structureId, filter);
    }

    public boolean existsResource(String resourcename) {
        return this.existsResource(resourcename, CmsResourceFilter.DEFAULT);
    }

    public boolean existsResource(String resourcename, CmsResourceFilter filter) {
        return this.m_securityManager.existsResource(this.m_context, this.addSiteRoot(resourcename), filter);
    }

    public List<CmsAccessControlEntry> getAccessControlEntries(String resourceName) throws CmsException {
        return this.getAccessControlEntries(resourceName, true);
    }

    public List<CmsAccessControlEntry> getAccessControlEntries(String resourceName, boolean getInherited) throws CmsException {
        CmsResource res = this.readResource(resourceName, CmsResourceFilter.ALL);
        return this.m_securityManager.getAccessControlEntries(this.m_context, res, getInherited);
    }

    public CmsAccessControlList getAccessControlList(String resourceName) throws CmsException {
        return this.getAccessControlList(resourceName, false);
    }

    public CmsAccessControlList getAccessControlList(String resourceName, boolean inheritedOnly) throws CmsException {
        CmsResource res = this.readResource(resourceName, CmsResourceFilter.ALL);
        return this.m_securityManager.getAccessControlList(this.m_context, res, inheritedOnly);
    }

    public List<CmsAccessControlEntry> getAllAccessControlEntries() throws CmsException {
        return this.m_securityManager.getAllAccessControlEntries(this.m_context);
    }

    public List<CmsHistoryProject> getAllHistoricalProjects() throws CmsException {
        return this.m_securityManager.getAllHistoricalProjects(this.m_context);
    }

    public List<String> getAllUrlNames(CmsUUID id) throws CmsException {
        return this.m_securityManager.readAllUrlNameMappingEntries(this.m_context, id);
    }

    public List<CmsResource> getBlockingLockedResources(CmsResource resource) throws CmsException {
        if (resource.isFolder()) {
            CmsLockFilter blockingFilter = CmsLockFilter.FILTER_NON_INHERITED;
            blockingFilter = blockingFilter.filterNotLockableByUser(this.getRequestContext().getCurrentUser());
            return this.getLockedResources(resource, blockingFilter);
        }
        return Collections.emptyList();
    }

    public List<CmsResource> getBlockingLockedResources(String resourceName) throws CmsException {
        CmsResource resource = this.readResource(resourceName);
        return this.getBlockingLockedResources(resource);
    }

    public List<CmsGroup> getChildren(String groupname, boolean includeSubChildren) throws CmsException {
        return this.m_securityManager.getChildren(this.m_context, groupname, includeSubChildren);
    }

    public String getDetailName(CmsResource res, Locale locale, List<Locale> defaultLocales) throws CmsException {
        String urlName = this.readBestUrlName(res.getStructureId(), locale, defaultLocales);
        if (urlName == null) {
            urlName = res.getStructureId().toString();
        }
        return urlName;
    }

    public List<CmsResource> getFilesInFolder(String resourcename) throws CmsException {
        return this.getFilesInFolder(resourcename, CmsResourceFilter.DEFAULT);
    }

    public List<CmsResource> getFilesInFolder(String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.readChildResources(this.m_context, resource, filter, false, true);
    }

    public List<CmsGroup> getGroupsOfUser(String username, boolean directGroupsOnly) throws CmsException {
        return this.getGroupsOfUser(username, directGroupsOnly, true);
    }

    public List<CmsGroup> getGroupsOfUser(String username, boolean directGroupsOnly, boolean includeOtherOus) throws CmsException {
        return this.getGroupsOfUser(username, directGroupsOnly, includeOtherOus, this.m_context.getRemoteAddress());
    }

    public List<CmsGroup> getGroupsOfUser(String username, boolean directGroupsOnly, boolean includeOtherOus, String remoteAddress) throws CmsException {
        return this.m_securityManager.getGroupsOfUser(this.m_context, username, includeOtherOus ? "" : CmsOrganizationalUnit.getParentFqn(username), includeOtherOus, false, directGroupsOnly, remoteAddress);
    }

    public CmsLocaleGroupService getLocaleGroupService() {
        return new CmsLocaleGroupService(this);
    }

    public CmsLock getLock(CmsResource resource) throws CmsException {
        return this.m_securityManager.getLock(this.m_context, resource);
    }

    public CmsLock getLock(String resourcename) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.getLock(resource);
    }

    public List<CmsResource> getLockedResources(CmsResource resource, CmsLockFilter filter) throws CmsException {
        return this.m_securityManager.getLockedResourcesObjects(this.m_context, resource, filter);
    }

    public List<String> getLockedResources(String resourceName, CmsLockFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourceName, CmsResourceFilter.ALL);
        return this.m_securityManager.getLockedResources(this.m_context, resource, filter);
    }

    public List<CmsResource> getLockedResourcesWithCache(CmsResource resource, CmsLockFilter filter, Map<String, CmsResource> cache) throws CmsException {
        return this.m_securityManager.getLockedResourcesObjectsWithCache(this.m_context, resource, filter, cache);
    }

    public List<CmsLogEntry> getLogEntries(CmsLogFilter filter) throws CmsException {
        return this.m_securityManager.getLogEntries(this.m_context, filter);
    }

    public String getLostAndFoundName(String resourcename) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.moveToLostAndFound(this.m_context, resource, true);
    }

    public CmsGroup getParent(String groupname) throws CmsException {
        return this.m_securityManager.getParent(this.m_context, groupname);
    }

    public CmsPermissionSet getPermissions(String resourceName) throws CmsException {
        return this.getPermissions(resourceName, this.m_context.getCurrentUser().getName());
    }

    public CmsPermissionSet getPermissions(String resourceName, String userName) throws CmsException {
        CmsResource resource = this.readResource(resourceName, CmsResourceFilter.ALL);
        CmsUser user = this.readUser(userName);
        return this.m_securityManager.getPermissions(this.m_context, resource, user);
    }

    public List<CmsRelation> getRelationsForResource(CmsResource resource, CmsRelationFilter filter) throws CmsException {
        return this.m_securityManager.getRelationsForResource(this.m_context, resource, filter);
    }

    public List<CmsRelation> getRelationsForResource(String resourceName, CmsRelationFilter filter) throws CmsException {
        return this.getRelationsForResource(this.readResource(resourceName, CmsResourceFilter.ALL), filter);
    }

    public CmsRequestContext getRequestContext() {
        return this.m_context;
    }

    public Set<CmsResource> getResourcesForPrincipal(CmsUUID principalId, CmsPermissionSet permissions, boolean includeAttr) throws CmsException {
        return this.m_securityManager.getResourcesForPrincipal(this.getRequestContext(), principalId, permissions, includeAttr);
    }

    public List<CmsResource> getResourcesInFolder(String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.readChildResources(this.m_context, resource, filter, true, true);
    }

    public String getSitePath(CmsResource resource) {
        return this.m_context.getSitePath(resource);
    }

    public List<CmsResource> getSubFolders(String resourcename) throws CmsException {
        return this.getSubFolders(resourcename, CmsResourceFilter.DEFAULT);
    }

    public List<CmsResource> getSubFolders(String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.readChildResources(this.m_context, resource, filter, true, false);
    }

    public List<String> getUrlNamesForAllLocales(CmsUUID id) throws CmsException {
        return this.m_securityManager.readUrlNamesForAllLocales(this.m_context, id);
    }

    public List<CmsUser> getUsersOfGroup(String groupname) throws CmsException {
        return this.getUsersOfGroup(groupname, true);
    }

    public List<CmsUser> getUsersOfGroup(String groupname, boolean includeOtherOus) throws CmsException {
        return this.m_securityManager.getUsersOfGroup(this.m_context, groupname, includeOtherOus, true, false);
    }

    public boolean hasPermissions(CmsResource resource, CmsPermissionSet requiredPermissions) throws CmsException {
        return this.m_securityManager.hasPermissions(this.m_context, resource, requiredPermissions, true, CmsResourceFilter.ALL).isAllowed();
    }

    public boolean hasPermissions(CmsResource resource, CmsPermissionSet requiredPermissions, boolean checkLock, CmsResourceFilter filter) throws CmsException {
        return I_CmsPermissionHandler.PERM_ALLOWED == this.m_securityManager.hasPermissions(this.m_context, resource, requiredPermissions, checkLock, filter);
    }

    public void importAccessControlEntries(CmsResource resource, List<CmsAccessControlEntry> acEntries) throws CmsException {
        this.m_securityManager.importAccessControlEntries(this.m_context, resource, acEntries);
    }

    public void importRelation(String resourceName, String targetPath, String relationType) throws CmsException {
        this.createRelation(resourceName, targetPath, relationType, true);
    }

    public CmsResource importResource(String resourcename, CmsResource resource, byte[] content, List<CmsProperty> properties) throws CmsException {
        return this.getResourceType(resource).importResource(this, this.m_securityManager, null, resourcename, resource, content, properties);
    }

    public CmsResource importResource(String resourcename, I_CmsReport report, CmsResource resource, byte[] content, List<CmsProperty> properties) throws CmsException {
        return this.getResourceType(resource).importResource(this, this.m_securityManager, report, resourcename, resource, content, properties);
    }

    public CmsUser importUser(String id, String name, String password, String firstname, String lastname, String email, int flags, long dateCreated, Map<String, Object> additionalInfos) throws CmsException {
        return this.m_securityManager.importUser(this.m_context, id, name, password, firstname, lastname, email, flags, dateCreated, additionalInfos);
    }

    public int incrementCounter(String name) throws CmsException {
        return this.m_securityManager.incrementCounter(this.m_context, name);
    }

    public boolean isInsideCurrentProject(String resourcename) {
        return this.m_securityManager.isInsideCurrentProject(this.m_context, this.addSiteRoot(resourcename));
    }

    public boolean isManagerOfProject() {
        return this.m_securityManager.isManagerOfProject(this.m_context);
    }

    public void lockResource(CmsResource resource) throws CmsException {
        this.getResourceType(resource).lockResource(this, this.m_securityManager, resource, CmsLockType.EXCLUSIVE);
    }

    public void lockResource(String resourcename) throws CmsException {
        this.lockResource(resourcename, CmsLockType.EXCLUSIVE);
    }

    public void lockResourceShallow(CmsResource resource) throws CmsException {
        this.getResourceType(resource).lockResource(this, this.m_securityManager, resource, CmsLockType.SHALLOW);
    }

    public void lockResourceTemporary(CmsResource resource) throws CmsException {
        this.getResourceType(resource).lockResource(this, this.m_securityManager, resource, CmsLockType.TEMPORARY);
    }

    public void lockResourceTemporary(String resourcename) throws CmsException {
        this.lockResource(resourcename, CmsLockType.TEMPORARY);
    }

    public String loginUser(String username, String password) throws CmsException {
        return this.loginUser(username, password, null, this.m_context.getRemoteAddress());
    }

    public String loginUser(String username, String password, CmsSecondFactorInfo code) throws CmsException {
        return this.loginUser(username, password, code, this.m_context.getRemoteAddress());
    }

    public String loginUser(String username, String password, CmsSecondFactorInfo code, String remoteAddress) throws CmsException {
        CmsUser newUser = this.m_securityManager.loginUser(this.m_context, username, password, code, remoteAddress);
        CmsProject newProject = this.m_securityManager.readProject(CmsProject.ONLINE_PROJECT_ID);
        this.m_context.switchUser(newUser, newProject, newUser.getOuFqn());
        this.init(this.m_securityManager, this.m_context);
        this.fireEvent(1, newUser);
        return newUser.getName();
    }

    public String loginUser(String username, String password, String remoteAddress) throws CmsException {
        return this.loginUser(username, password, null, remoteAddress);
    }

    public I_CmsPrincipal lookupPrincipal(CmsUUID principalId) {
        return this.m_securityManager.lookupPrincipal(this.m_context, principalId);
    }

    public I_CmsPrincipal lookupPrincipal(String principalName) {
        return this.m_securityManager.lookupPrincipal(this.m_context, principalName);
    }

    public void moveResource(String source, String destination) throws CmsException {
        CmsResource resource = this.readResource(source, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).moveResource(this, this.m_securityManager, resource, destination);
    }

    public String moveToLostAndFound(String resourcename) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.moveToLostAndFound(this.m_context, resource, false);
    }

    public List<I_CmsHistoryResource> readAllAvailableVersions(CmsResource resource) throws CmsException {
        return this.m_securityManager.readAllAvailableVersions(this.m_context, resource);
    }

    public List<I_CmsHistoryResource> readAllAvailableVersions(String resourceName) throws CmsException {
        CmsResource resource = this.readResource(resourceName, CmsResourceFilter.ALL);
        return this.m_securityManager.readAllAvailableVersions(this.m_context, resource);
    }

    public List<CmsPropertyDefinition> readAllPropertyDefinitions() throws CmsException {
        return this.m_securityManager.readAllPropertyDefinitions(this.m_context);
    }

    public CmsFolder readAncestor(String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.readAncestor(this.m_context, resource, filter);
    }

    public CmsFolder readAncestor(String resourcename, int type) throws CmsException {
        return this.readAncestor(resourcename, CmsResourceFilter.requireType(type));
    }

    public String readBestUrlName(CmsUUID id, Locale locale, List<Locale> defaultLocales) throws CmsException {
        return this.m_securityManager.readBestUrlName(this.m_context, id, locale, defaultLocales);
    }

    public CmsResource readDefaultFile(CmsResource folderResource, CmsResourceFilter resourceFilter) throws CmsSecurityException {
        return this.m_securityManager.readDefaultFile(this.m_context, folderResource, resourceFilter);
    }

    public CmsResource readDefaultFile(String resourceNameOrID) throws CmsException, CmsSecurityException {
        return this.readDefaultFile(resourceNameOrID, CmsResourceFilter.DEFAULT);
    }

    public CmsResource readDefaultFile(String resourceNameOrID, CmsResourceFilter filter) throws CmsException, CmsSecurityException {
        CmsResource resource = CmsUUID.isValidUUID(resourceNameOrID) ? this.readResource(new CmsUUID(resourceNameOrID), filter) : this.readResource(resourceNameOrID, filter);
        return this.m_securityManager.readDefaultFile(this.m_context, resource, filter);
    }

    public List<I_CmsHistoryResource> readDeletedResources(String resourcename, boolean readTree) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.readDeletedResources(this.m_context, resource, readTree);
    }

    public CmsFile readFile(CmsResource resource) throws CmsException {
        CmsFile file;
        if (resource instanceof CmsFile && (file = (CmsFile)resource).getContents() != null && file.getContents().length > 0) {
            return file;
        }
        return this.m_securityManager.readFile(this.m_context, resource);
    }

    public CmsFile readFile(String resourcename) throws CmsException {
        return this.readFile(resourcename, CmsResourceFilter.DEFAULT);
    }

    public CmsFile readFile(String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourcename, filter);
        return this.readFile(resource);
    }

    public CmsFolder readFolder(String resourcename) throws CmsException {
        return this.readFolder(resourcename, CmsResourceFilter.DEFAULT);
    }

    public CmsFolder readFolder(String resourcename, CmsResourceFilter filter) throws CmsException {
        return this.m_securityManager.readFolder(this.m_context, this.addSiteRoot(resourcename), filter);
    }

    public CmsGroup readGroup(CmsProject project) {
        return this.m_securityManager.readGroup(this.m_context, project);
    }

    public CmsGroup readGroup(CmsUUID groupId) throws CmsException {
        return this.m_securityManager.readGroup(this.m_context, groupId);
    }

    public CmsGroup readGroup(String groupName) throws CmsException {
        return this.m_securityManager.readGroup(this.m_context, groupName);
    }

    public CmsHistoryPrincipal readHistoryPrincipal(CmsUUID principalId) throws CmsException {
        return this.m_securityManager.readHistoricalPrincipal(this.m_context, principalId);
    }

    public CmsHistoryProject readHistoryProject(CmsUUID projectId) throws CmsException {
        return this.m_securityManager.readHistoryProject(this.m_context, projectId);
    }

    public CmsHistoryProject readHistoryProject(int publishTag) throws CmsException {
        return this.m_securityManager.readHistoryProject(this.m_context, publishTag);
    }

    public List<CmsProperty> readHistoryPropertyObjects(I_CmsHistoryResource resource) throws CmsException {
        return this.m_securityManager.readHistoryPropertyObjects(this.m_context, resource);
    }

    public CmsUUID readIdForUrlName(String name) throws CmsException {
        if (CmsUUID.isValidUUID(name)) {
            return new CmsUUID(name);
        }
        return this.m_securityManager.readIdForUrlName(this.m_context, name);
    }

    public CmsGroup readManagerGroup(CmsProject project) {
        return this.m_securityManager.readManagerGroup(this.m_context, project);
    }

    public CmsUser readOwner(CmsProject project) throws CmsException {
        return this.m_securityManager.readOwner(this.m_context, project);
    }

    public CmsResource readParentFolder(CmsUUID structureId) throws CmsException {
        return this.m_securityManager.readParentFolder(this.m_context, structureId);
    }

    public List<CmsResource> readPath(CmsResource resource, CmsResourceFilter filter) throws CmsException {
        return this.m_securityManager.readPath(this.m_context, resource.getRootPath(), filter);
    }

    public List<CmsResource> readPath(String path, CmsResourceFilter filter) throws CmsException {
        return this.m_securityManager.readPath(this.m_context, this.addSiteRoot(path), filter);
    }

    public CmsProject readProject(CmsUUID id) throws CmsException {
        return this.m_securityManager.readProject(id);
    }

    public CmsProject readProject(String name) throws CmsException {
        return this.m_securityManager.readProject(name);
    }

    public List<String> readProjectResources(CmsProject project) throws CmsException {
        return this.m_securityManager.readProjectResources(this.m_context, project);
    }

    public List<CmsResource> readProjectView(CmsUUID projectId, CmsResourceState state) throws CmsException {
        return this.m_securityManager.readProjectView(this.m_context, projectId, state);
    }

    public CmsPropertyDefinition readPropertyDefinition(String name) throws CmsException {
        return this.m_securityManager.readPropertyDefinition(this.m_context, name);
    }

    public CmsProperty readPropertyObject(CmsResource resource, String property, boolean search) throws CmsException {
        return this.m_securityManager.readPropertyObject(this.m_context, resource, property, search);
    }

    public CmsProperty readPropertyObject(CmsResource resource, String property, boolean search, Locale locale) throws CmsException {
        return this.m_securityManager.readPropertyObject(this.m_context, resource, property, search, locale);
    }

    public CmsProperty readPropertyObject(String resourcePath, String property, boolean search) throws CmsException {
        CmsResource resource = this.readResource(resourcePath, CmsResourceFilter.ALL);
        return this.m_securityManager.readPropertyObject(this.m_context, resource, property, search);
    }

    public CmsProperty readPropertyObject(String resourcePath, String property, boolean search, Locale locale) throws CmsException {
        CmsResource resource = this.readResource(resourcePath, CmsResourceFilter.ALL);
        return this.m_securityManager.readPropertyObject(this.m_context, resource, property, search, locale);
    }

    public List<CmsProperty> readPropertyObjects(CmsResource resource, boolean search) throws CmsException {
        return this.m_securityManager.readPropertyObjects(this.m_context, resource, search);
    }

    public List<CmsProperty> readPropertyObjects(String resourcePath, boolean search) throws CmsException {
        CmsResource resource = this.readResource(resourcePath, CmsResourceFilter.ALL);
        return this.m_securityManager.readPropertyObjects(this.m_context, resource, search);
    }

    public List<CmsPublishedResource> readPublishedResources(CmsUUID publishHistoryId) throws CmsException {
        return this.m_securityManager.readPublishedResources(this.m_context, publishHistoryId);
    }

    public List<CmsRelation> readRelations(CmsRelationFilter filter) throws CmsException {
        return this.m_securityManager.getRelationsForResource(this.m_context, null, filter);
    }

    public CmsResource readResource(CmsUUID structureID) throws CmsException {
        return this.readResource(structureID, CmsResourceFilter.DEFAULT);
    }

    public CmsResource readResource(CmsUUID structureID, CmsResourceFilter filter) throws CmsException {
        return this.m_securityManager.readResource(this.m_context, structureID, filter);
    }

    public I_CmsHistoryResource readResource(CmsUUID structureID, int version) throws CmsException, CmsVfsResourceNotFoundException {
        CmsResource resource = this.readResource(structureID, CmsResourceFilter.ALL);
        return this.m_securityManager.readResource(this.m_context, resource, version);
    }

    public CmsResource readResource(String resourcename) throws CmsException {
        return this.readResource(resourcename, CmsResourceFilter.DEFAULT);
    }

    public CmsResource readResource(String resourcename, CmsResourceFilter filter) throws CmsException {
        return this.m_securityManager.readResource(this.m_context, this.addSiteRoot(resourcename), filter);
    }

    public List<CmsResource> readResources(CmsResource resource, CmsResourceFilter filter, boolean readTree) throws CmsException {
        if (readTree) {
            return this.m_securityManager.readResources(this.m_context, resource, filter, readTree);
        }
        return this.m_securityManager.readChildResources(this.m_context, resource, filter, true, true);
    }

    public List<CmsResource> readResources(String resourcename, CmsResourceFilter filter) throws CmsException {
        return this.readResources(resourcename, filter, true);
    }

    public List<CmsResource> readResources(String resourcename, CmsResourceFilter filter, boolean readTree) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        return this.m_securityManager.readResources(this.m_context, resource, filter, readTree);
    }

    public List<CmsResource> readResourcesWithProperty(String propertyDefinition) throws CmsException {
        return this.readResourcesWithProperty("/", propertyDefinition);
    }

    public List<CmsResource> readResourcesWithProperty(String path, String propertyDefinition) throws CmsException {
        return this.readResourcesWithProperty(path, propertyDefinition, null);
    }

    public List<CmsResource> readResourcesWithProperty(String path, String propertyDefinition, String value) throws CmsException {
        CmsResource resource = this.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
        return this.m_securityManager.readResourcesWithProperty(this.m_context, resource, propertyDefinition, value, CmsResourceFilter.ALL);
    }

    public List<CmsResource> readResourcesWithProperty(String path, String propertyDefinition, String value, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
        return this.m_securityManager.readResourcesWithProperty(this.m_context, resource, propertyDefinition, value, filter);
    }

    public Set<I_CmsPrincipal> readResponsiblePrincipals(CmsResource resource) throws CmsException {
        return this.m_securityManager.readResponsiblePrincipals(this.m_context, resource);
    }

    public Set<CmsUser> readResponsibleUsers(CmsResource resource) throws CmsException {
        return this.m_securityManager.readResponsibleUsers(this.m_context, resource);
    }

    public List<CmsResource> readSiblings(CmsResource resource, CmsResourceFilter filter) throws CmsException {
        return this.m_securityManager.readSiblings(this.m_context, resource, filter);
    }

    public List<CmsResource> readSiblings(String resourcename, CmsResourceFilter filter) throws CmsException {
        CmsResource resource = this.readResource(resourcename, filter);
        return this.readSiblings(resource, filter);
    }

    public List<CmsResource> readSiblingsForResourceId(CmsUUID resourceId, CmsResourceFilter filter) throws CmsException {
        CmsResource pseudoResource = new CmsResource(null, resourceId, null, 0, false, 0, null, null, 0L, null, 0L, null, 0L, 0L, 0, 0, 0L, 0);
        return this.readSiblings(pseudoResource, filter);
    }

    public String readStaticExportPublishedResourceParameters(String rfsName) throws CmsException {
        return this.m_securityManager.readStaticExportPublishedResourceParameters(this.m_context, rfsName);
    }

    public List<String> readStaticExportResources(int parameterResources, long timestamp) throws CmsException {
        return this.m_securityManager.readStaticExportResources(this.m_context, parameterResources, timestamp);
    }

    public List<CmsUrlNameMappingEntry> readUrlNameMappings(CmsUrlNameMappingFilter filter) throws CmsException {
        return this.m_securityManager.readUrlNameMappings(this.m_context, filter);
    }

    public List<String> readUrlNamesForAllLocales(CmsUUID structureId) throws CmsException {
        List<String> detailNames = this.m_securityManager.readUrlNamesForAllLocales(this.m_context, structureId);
        if (detailNames.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(structureId.toString());
            return result;
        }
        return detailNames;
    }

    public CmsUser readUser(CmsUUID userId) throws CmsException {
        return this.m_securityManager.readUser(this.m_context, userId);
    }

    public CmsUser readUser(String username) throws CmsException {
        return this.m_securityManager.readUser(this.m_context, username);
    }

    public CmsUser readUser(String username, String password) throws CmsException {
        return this.m_securityManager.readUser(this.m_context, username, password);
    }

    public void removeResourceFromProject(String resourcename) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        this.getResourceType(resource).removeResourceFromProject(this, this.m_securityManager, resource);
    }

    public void removeUserFromGroup(String username, String groupname) throws CmsException {
        this.m_securityManager.removeUserFromGroup(this.m_context, username, groupname, false);
    }

    public void renameResource(String source, String destination) throws CmsException {
        this.moveResource(source, destination);
    }

    public void replaceResource(String resourcename, I_CmsResourceType type, byte[] content, List<CmsProperty> properties) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).replaceResource(this, this.m_securityManager, resource, type, content, properties);
    }

    @Deprecated
    public void replaceResource(String resourcename, int type, byte[] content, List<CmsProperty> properties) throws CmsException {
        this.replaceResource(resourcename, this.getResourceType(type), content, properties);
    }

    public void restoreDeletedResource(CmsUUID structureId) throws CmsException {
        this.m_securityManager.restoreDeletedResource(this.m_context, structureId);
    }

    public void restoreResourceVersion(CmsUUID structureId, int version) throws CmsException {
        CmsResource resource = this.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).restoreResource(this, this.m_securityManager, resource, version);
    }

    public void rmacc(String resourceName, String principalType, String principalName) throws CmsException {
        CmsResource res = this.readResource(resourceName, CmsResourceFilter.ALL);
        if (CmsUUID.isValidUUID(principalName)) {
            this.m_securityManager.removeAccessControlEntry(this.m_context, res, new CmsUUID(principalName));
        } else if ("ALL_OTHERS".equals(principalName)) {
            this.m_securityManager.removeAccessControlEntry(this.m_context, res, CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID);
        } else if ("OVERWRITE_ALL".equals(principalName)) {
            this.m_securityManager.removeAccessControlEntry(this.m_context, res, CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID);
        } else {
            try {
                I_CmsPrincipal principal = CmsPrincipal.readPrincipal(this, principalType, principalName);
                this.m_securityManager.removeAccessControlEntry(this.m_context, res, principal.getId());
            }
            catch (CmsDbEntryNotFoundException e) {
                CmsRole role = CmsRole.valueOfRoleName(principalName);
                if (role == null) {
                    throw e;
                }
                this.m_securityManager.removeAccessControlEntry(this.m_context, res, role.getId());
            }
        }
    }

    public void setDateExpired(CmsResource resource, long dateExpired, boolean recursive) throws CmsException {
        this.getResourceType(resource).setDateExpired(this, this.m_securityManager, resource, dateExpired, recursive);
    }

    public void setDateExpired(String resourcename, long dateExpired, boolean recursive) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.setDateExpired(resource, dateExpired, recursive);
    }

    public void setDateLastModified(String resourcename, long dateLastModified, boolean recursive) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).setDateLastModified(this, this.m_securityManager, resource, dateLastModified, recursive);
    }

    public void setDateReleased(CmsResource resource, long dateReleased, boolean recursive) throws CmsException {
        this.getResourceType(resource).setDateReleased(this, this.m_securityManager, resource, dateReleased, recursive);
    }

    public void setDateReleased(String resourcename, long dateReleased, boolean recursive) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.setDateReleased(resource, dateReleased, recursive);
    }

    public void setParentGroup(String groupName, String parentGroupName) throws CmsException {
        this.m_securityManager.setParentGroup(this.m_context, groupName, parentGroupName);
    }

    public void setPassword(String username, String newPassword) throws CmsException {
        this.m_securityManager.setPassword(this.m_context, username, newPassword);
    }

    public void setPassword(String username, String oldPassword, CmsSecondFactorInfo secondFactor, String newPassword) throws CmsException {
        this.m_securityManager.resetPassword(this.m_context, username, oldPassword, secondFactor, newPassword);
    }

    public void setPassword(String username, String oldPassword, String newPassword) throws CmsException {
        this.m_securityManager.resetPassword(this.m_context, username, oldPassword, null, newPassword);
    }

    public void setRestricted(CmsResource res, String groupName, boolean restricted) throws CmsException {
        this.m_securityManager.setRestricted(this.m_context, res, this.readGroup(groupName), restricted);
    }

    public AutoCloseable tempChangeSiteRoot(String siteRoot) {
        String oldSiteRoot = this.m_context.getSiteRoot();
        this.m_context.setSiteRoot(siteRoot);
        return () -> this.m_context.setSiteRoot(oldSiteRoot);
    }

    public void undeleteResource(String resourcename, boolean recursive) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        this.getResourceType(resource).undelete(this, this.m_securityManager, resource, recursive);
    }

    public void undoChanges(String resourcename, CmsResource.CmsResourceUndoMode mode) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        this.getResourceType(resource).undoChanges(this, this.m_securityManager, resource, mode);
    }

    public void unlockProject(CmsUUID id) throws CmsException {
        this.m_securityManager.unlockProject(this.m_context, id);
    }

    public void unlockResource(CmsResource resource) throws CmsException {
        this.getResourceType(resource).unlockResource(this, this.m_securityManager, resource);
    }

    public void unlockResource(String resourcename) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        this.getResourceType(resource).unlockResource(this, this.m_securityManager, resource);
    }

    public void updateLastLoginDate(CmsUser user) throws CmsRoleViolationException, CmsException {
        this.m_securityManager.updateLastLoginDate(this.m_context, user);
    }

    public boolean userInGroup(String username, String groupname) throws CmsException {
        return this.m_securityManager.userInGroup(this.m_context, username, groupname);
    }

    public void validatePassword(String password) throws CmsSecurityException {
        this.m_securityManager.validatePassword(password);
    }

    public CmsFile writeFile(CmsFile resource) throws CmsException {
        return this.getResourceType(resource).writeFile(this, this.m_securityManager, resource);
    }

    public void writeGroup(CmsGroup group) throws CmsException {
        this.m_securityManager.writeGroup(this.m_context, group);
    }

    public void writeHistoryProject(int publishTag, long publishDate) throws CmsException {
        this.m_securityManager.writeHistoryProject(this.m_context, publishTag, publishDate);
    }

    public void writeProject(CmsProject project) throws CmsException {
        this.m_securityManager.writeProject(this.m_context, project);
    }

    public void writeProjectLastModified(CmsResource resource, CmsProject project) throws CmsException {
        this.m_securityManager.writeResourceProjectLastModified(this.getRequestContext(), resource, project);
    }

    public void writePropertyObject(String resourcename, CmsProperty property) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).writePropertyObject(this, this.m_securityManager, resource, property);
    }

    public void writePropertyObjects(CmsResource res, List<CmsProperty> properties) throws CmsException {
        this.getResourceType(res).writePropertyObjects(this, this.m_securityManager, res, properties);
    }

    public void writePropertyObjects(String resourcename, List<CmsProperty> properties) throws CmsException {
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
        this.getResourceType(resource).writePropertyObjects(this, this.m_securityManager, resource, properties);
    }

    public void writeResource(CmsResource resource) throws CmsException {
        this.m_securityManager.writeResource(this.m_context, resource);
    }

    public void writeStaticExportPublishedResource(String resourceName, int linkType, String linkParameter, long timestamp) throws CmsException {
        this.m_securityManager.writeStaticExportPublishedResource(this.m_context, resourceName, linkType, linkParameter, timestamp);
    }

    public String writeUrlNameMapping(Iterator<String> nameSeq, CmsUUID structureId, String locale, boolean replaceOnPublish) throws CmsException {
        return this.m_securityManager.writeUrlNameMapping(this.m_context, nameSeq, structureId, locale, replaceOnPublish);
    }

    public String writeUrlNameMapping(String name, CmsUUID structureId, String locale, boolean replaceOnPublish) throws CmsException {
        return this.writeUrlNameMapping(new CmsNumberSuffixNameSequence(name, false), structureId, locale, replaceOnPublish);
    }

    public void writeUser(CmsUser user) throws CmsException {
        this.m_securityManager.writeUser(this.m_context, user);
    }

    private void createRelation(CmsResource resource, CmsResource target, String relationType, boolean importCase) throws CmsException {
        CmsRelationType type = CmsRelationType.valueOf(relationType);
        this.m_securityManager.addRelationToResource(this.m_context, resource, target, type, importCase);
    }

    private void createRelation(String resourceName, String targetPath, String relationType, boolean importCase) throws CmsException {
        CmsResource resource = this.readResource(resourceName, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsResource target = this.readResource(targetPath, CmsResourceFilter.IGNORE_EXPIRATION);
        this.createRelation(resource, target, relationType, importCase);
    }

    private void fireEvent(int type, Object data) {
        OpenCms.fireCmsEvent(type, Collections.singletonMap("data", data));
    }

    private I_CmsResourceType getResourceType(CmsResource resource) {
        return OpenCms.getResourceManager().getResourceType(resource);
    }

    private I_CmsResourceType getResourceType(int resourceType) throws CmsException {
        return OpenCms.getResourceManager().getResourceType(resourceType);
    }

    private void init(CmsSecurityManager securityManager, CmsRequestContext context) {
        this.m_securityManager = securityManager;
        this.m_context = context;
    }

    private void lockResource(String resourcename, CmsLockType type) throws CmsException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(resourcename)) {
            throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_LOCK_RESOURCE_1", resourcename));
        }
        CmsResource resource = this.readResource(resourcename, CmsResourceFilter.ALL);
        this.getResourceType(resource).lockResource(this, this.m_securityManager, resource, type);
    }
}

