/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.Messages;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.util.CmsResourceTranslator;
import org.opencms.util.CmsUUID;

public final class CmsRequestContext {
    public static final String ATTRIBUTE_ADE_CONTEXT_PATH = CmsRequestContext.class.getName() + ".ADE_CONTEXT_PATH";
    public static final String ATTRIBUTE_EDITOR = CmsRequestContext.class.getName() + ".ATTRIBUTE_EDITOR";
    public static final String ATTRIBUTE_FULLLINKS = CmsRequestContext.class.getName() + ".ATTRIBUTE_FULLLINKS";
    public static final String ATTRIBUTE_MODEL = CmsRequestContext.class.getName() + ".ATTRIBUTE_MODEL";
    public static final String ATTRIBUTE_NEW_RESOURCE_LOCALE = CmsRequestContext.class.getName() + ".NEW_RESOURCE_LOCALE";
    private Map<String, Object> m_attributeMap;
    private CmsProject m_currentProject;
    private CmsResource m_detailResource;
    private CmsResourceTranslator m_directoryTranslator;
    private String m_encoding;
    private CmsResourceTranslator m_fileTranslator;
    private boolean m_forceAbsoluteLinks;
    private boolean m_isSecureRequest;
    private Locale m_locale;
    private String m_ouFqn;
    private String m_remoteAddr;
    private CmsSiteMatcher m_requestMatcher;
    private long m_requestTime;
    private String m_siteRoot;
    private boolean m_updateSession = true;
    private String m_uri;
    private CmsUser m_user;

    public CmsRequestContext(CmsUser user, CmsProject project, String requestedUri, CmsSiteMatcher requestMatcher, String siteRoot, boolean isSecureRequest, Locale locale, String encoding, String remoteAddr, long requestTime, CmsResourceTranslator directoryTranslator, CmsResourceTranslator fileTranslator, String ouFqn, boolean forceAbsoluteLinks) {
        this.m_user = user;
        this.m_currentProject = project;
        this.m_uri = requestedUri;
        this.m_requestMatcher = requestMatcher;
        this.m_isSecureRequest = isSecureRequest;
        this.setSiteRoot(siteRoot);
        this.m_locale = locale;
        this.m_encoding = encoding;
        this.m_remoteAddr = remoteAddr;
        this.m_requestTime = requestTime;
        this.m_directoryTranslator = directoryTranslator;
        this.m_fileTranslator = fileTranslator;
        this.setOuFqn(ouFqn);
        this.m_forceAbsoluteLinks = forceAbsoluteLinks;
    }

    public static String getAdjustedSiteRoot(String siteRoot, String resourcename) {
        if (resourcename.startsWith("/system/") || OpenCms.getSiteManager().startsWithShared(resourcename) || resourcename.startsWith("/sites/") && !resourcename.startsWith(siteRoot)) {
            return "";
        }
        return siteRoot;
    }

    public String addSiteRoot(String resourcename) {
        return this.addSiteRoot(this.m_siteRoot, resourcename);
    }

    public String addSiteRoot(String siteRoot, String resourcename) {
        if (resourcename == null || siteRoot == null) {
            return null;
        }
        siteRoot = CmsRequestContext.getAdjustedSiteRoot(siteRoot, resourcename);
        StringBuffer result = new StringBuffer(128);
        result.append(siteRoot);
        if (!(siteRoot.length() != 0 && siteRoot.charAt(siteRoot.length() - 1) == '/' || resourcename.length() != 0 && resourcename.charAt(0) == '/')) {
            result.append('/');
        }
        result.append(resourcename);
        return this.m_directoryTranslator.translateResource(result.toString());
    }

    @Deprecated
    public CmsProject currentProject() {
        return this.getCurrentProject();
    }

    @Deprecated
    public CmsUser currentUser() {
        return this.getCurrentUser();
    }

    public String getAdjustedSiteRoot(String resourcename) {
        return CmsRequestContext.getAdjustedSiteRoot(this.m_siteRoot, resourcename);
    }

    public Object getAttribute(String attributeName) {
        if (this.m_attributeMap == null) {
            return null;
        }
        return this.m_attributeMap.get(attributeName);
    }

    public CmsProject getCurrentProject() {
        return this.m_currentProject;
    }

    public CmsUser getCurrentUser() {
        return this.m_user;
    }

    public CmsUUID getDetailContentId() {
        if (this.m_detailResource == null) {
            return null;
        }
        return this.m_detailResource.getStructureId();
    }

    public CmsResource getDetailResource() {
        return this.m_detailResource;
    }

    public CmsResourceTranslator getDirectoryTranslator() {
        return this.m_directoryTranslator;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public CmsResourceTranslator getFileTranslator() {
        return this.m_fileTranslator;
    }

    public String getFolderUri() {
        return CmsResource.getFolderPath(this.m_uri);
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getOuFqn() {
        return this.m_ouFqn;
    }

    public String getRemoteAddress() {
        return this.m_remoteAddr;
    }

    public CmsSiteMatcher getRequestMatcher() {
        return this.m_requestMatcher;
    }

    public long getRequestTime() {
        return this.m_requestTime;
    }

    public String getRootUri() {
        return this.addSiteRoot(this.m_siteRoot, this.m_uri);
    }

    public String getSitePath(CmsResource resource) {
        return this.removeSiteRoot(resource.getRootPath());
    }

    public String getSiteRoot() {
        return this.m_siteRoot;
    }

    public String getUri() {
        return this.m_uri;
    }

    public boolean isForceAbsoluteLinks() {
        return this.m_forceAbsoluteLinks;
    }

    public boolean isOnlineOrEditDisabled() {
        if (this.getCurrentProject().isOnlineProject()) {
            return true;
        }
        Object directEdit = this.getAttribute("__disableDirectEdit");
        return Boolean.TRUE.equals(directEdit);
    }

    public boolean isSecureRequest() {
        return this.m_isSecureRequest;
    }

    public boolean isUpdateSessionEnabled() {
        return this.m_updateSession;
    }

    public Object removeAttribute(String key) {
        if (this.m_attributeMap != null) {
            return this.m_attributeMap.remove(key);
        }
        return null;
    }

    public String removeSiteRoot(String resourcename) {
        String siteRoot = CmsRequestContext.getAdjustedSiteRoot(this.m_siteRoot, resourcename);
        if (siteRoot == this.m_siteRoot && resourcename.startsWith(siteRoot) && (resourcename.length() == siteRoot.length() || resourcename.charAt(siteRoot.length()) == '/')) {
            resourcename = resourcename.substring(siteRoot.length());
        }
        if (resourcename.length() == 0) {
            resourcename = "/";
        }
        return resourcename;
    }

    public void setAttribute(String key, Object value) {
        if (this.m_attributeMap == null) {
            this.m_attributeMap = new Hashtable<String, Object>();
        }
        this.m_attributeMap.put(key, value);
    }

    public CmsProject setCurrentProject(CmsProject project) {
        if (project != null) {
            this.m_currentProject = project;
        }
        return this.m_currentProject;
    }

    public void setDetailResource(CmsResource detailResource) {
        this.m_detailResource = detailResource;
    }

    public void setEncoding(String encoding) {
        this.m_encoding = encoding;
    }

    public void setForceAbsoluteLinks(boolean forceAbsoluteLinks) {
        this.m_forceAbsoluteLinks = forceAbsoluteLinks;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOuFqn(String ouFqn) {
        String userOu = CmsOrganizationalUnit.getParentFqn(this.m_user.getName());
        if (ouFqn != null) {
            if (!ouFqn.startsWith(userOu) && (!ouFqn.startsWith("/") || !ouFqn.substring(1).startsWith(userOu))) throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_ORGUNIT_2", ouFqn, userOu));
            this.m_ouFqn = ouFqn;
        } else {
            this.m_ouFqn = userOu;
        }
        this.m_ouFqn = CmsOrganizationalUnit.removeLeadingSeparator(this.m_ouFqn);
    }

    public void setRequestTime(long time) {
        this.m_requestTime = time;
    }

    public void setSecureRequest(boolean secureRequest) {
        this.m_isSecureRequest = secureRequest;
    }

    public void setSiteRoot(String root) {
        this.m_siteRoot = root.endsWith("/") ? root.substring(0, root.length() - 1) : root;
    }

    public void setUpdateSessionEnabled(boolean value) {
        this.m_updateSession = value;
    }

    public void setUri(String value) {
        this.m_uri = value;
    }

    protected void switchUser(CmsUser user, CmsProject project, String ouFqn) {
        this.m_user = user;
        this.m_currentProject = project;
        this.setOuFqn(ouFqn);
    }
}

