/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.CmsCollectorPublishListHelper;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.CmsCollectorData;
import org.opencms.file.collectors.CmsDefaultPostCreateHandler;
import org.opencms.file.collectors.I_CmsCollectorPostCreateHandler;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.file.collectors.Messages;
import org.opencms.gwt.shared.I_CmsContentLoadCollectorInfo;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public abstract class A_CmsResourceCollector
implements I_CmsResourceCollector {
    public static final String SEPARATOR_TEMPLATEFILE = "::";
    private static final Log LOG = CmsLog.getLog(A_CmsResourceCollector.class);
    protected int m_order;
    private String m_defaultCollectorName;
    private String m_defaultCollectorParam;
    private int m_hashcode = this.getClass().getName().hashCode();

    public static String createResourceForCollector(CmsObject cms, String newLink, Locale locale, String referenceResource, String modelFile, String mode, String postCreateHandler) throws CmsException {
        int typeId;
        String templateFileName;
        String param;
        int pos = newLink.indexOf(124);
        String collectorName = newLink.substring(0, pos);
        String collectorParams = newLink.substring(pos + 1);
        if ((pos = collectorParams.indexOf(SEPARATOR_TEMPLATEFILE)) != -1) {
            param = collectorParams.substring(0, pos);
            templateFileName = collectorParams.substring(pos + SEPARATOR_TEMPLATEFILE.length());
        } else {
            param = collectorParams;
            templateFileName = referenceResource;
        }
        I_CmsResourceCollector collector = OpenCms.getResourceManager().getContentCollector(collectorName);
        String newFileName = "";
        CmsResource templateResource = cms.readResource(templateFileName, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsXmlContent newContent = null;
        CmsObject cloneCms = OpenCms.initCmsObject(cms);
        cloneCms.getRequestContext().setRequestTime(Long.MIN_VALUE);
        if (!templateResource.isFolder()) {
            typeId = templateResource.getTypeId();
            CmsFile templateFile = cms.readFile(templateResource);
            CmsXmlContent template = CmsXmlContentFactory.unmarshal(cloneCms, templateFile);
            newContent = CmsXmlContentFactory.createDocument(cms, locale, template.getEncoding(), template.getContentDefinition());
        } else {
            typeId = collector.getCreateTypeId(cloneCms, collectorName, collectorParams);
        }
        newFileName = collector.getCreateLink(cms, collectorName, param);
        boolean isCopy = StringUtils.equalsIgnoreCase((CharSequence)mode, (CharSequence)"copy");
        if (isCopy) {
            modelFile = referenceResource;
        }
        boolean useModelFile = false;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(modelFile)) {
            cms.getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_MODEL, modelFile);
            useModelFile = true;
        }
        cms.createResource(newFileName, typeId);
        CmsFile newFile = cms.readFile(newFileName, CmsResourceFilter.ALL);
        if (!useModelFile && newContent != null) {
            newFile.setContents(newContent.marshal());
            cloneCms.writeFile(newFile);
        }
        CmsPair<String, String> handlerParameter = I_CmsCollectorPostCreateHandler.splitClassAndConfig(postCreateHandler);
        I_CmsCollectorPostCreateHandler handler = A_CmsResourceCollector.getPostCreateHandler(handlerParameter.getFirst());
        handler.onCreate(cms, newFile, isCopy, handlerParameter.getSecond());
        return newFileName;
    }

    public static I_CmsCollectorPostCreateHandler getPostCreateHandler(String className) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(className)) {
            return new CmsDefaultPostCreateHandler();
        }
        try {
            Class<?> handlerClass = Class.forName(className);
            if (I_CmsCollectorPostCreateHandler.class.isAssignableFrom(handlerClass)) {
                I_CmsCollectorPostCreateHandler handler = (I_CmsCollectorPostCreateHandler)handlerClass.newInstance();
                return handler;
            }
            LOG.error((Object)("Post-create handler class does not implement I_CmsPostCreateHandler: '" + className + "'"));
            return new CmsDefaultPostCreateHandler();
        }
        catch (Exception e) {
            LOG.error((Object)("Problem using post-create handler: '" + className + "'," + e.getLocalizedMessage()), (Throwable)e);
            return new CmsDefaultPostCreateHandler();
        }
    }

    @Override
    public int compareTo(I_CmsResourceCollector obj) {
        if (obj == this) {
            return 0;
        }
        return this.getOrder() - obj.getOrder();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof I_CmsResourceCollector) {
            return this.getClass().getName().equals(obj.getClass().getName());
        }
        return false;
    }

    @Override
    public String getCreateLink(CmsObject cms) throws CmsException, CmsDataAccessException {
        this.checkParams();
        return this.getCreateLink(cms, this.getDefaultCollectorName(), this.getDefaultCollectorParam());
    }

    @Override
    public String getCreateParam(CmsObject cms) throws CmsDataAccessException {
        this.checkParams();
        return this.getCreateParam(cms, this.getDefaultCollectorName(), this.getDefaultCollectorParam());
    }

    @Override
    public int getCreateTypeId(CmsObject cms, String collectorName, String param) throws CmsException {
        return -1;
    }

    @Override
    public String getDefaultCollectorName() {
        return this.m_defaultCollectorName;
    }

    @Override
    public String getDefaultCollectorParam() {
        return this.m_defaultCollectorParam;
    }

    @Override
    public int getOrder() {
        return this.m_order;
    }

    @Override
    public Set<CmsResource> getPublishResources(CmsObject cms, I_CmsContentLoadCollectorInfo info) throws CmsException {
        int collectorLimit = NumberUtils.toInt((String)OpenCms.getADEManager().getParameters(cms).get("collectorPublishListLimit"), (int)200);
        CmsCollectorPublishListHelper helper = new CmsCollectorPublishListHelper(cms, info, collectorLimit);
        return helper.getPublishListFiles();
    }

    @Override
    public List<CmsResource> getResults(CmsObject cms) throws CmsDataAccessException, CmsException {
        this.checkParams();
        return this.getResults(cms, this.getDefaultCollectorName(), this.getDefaultCollectorParam());
    }

    public int hashCode() {
        return this.m_hashcode;
    }

    @Override
    public void setDefaultCollectorName(String collectorName) {
        this.m_defaultCollectorName = collectorName;
    }

    @Override
    public void setDefaultCollectorParam(String param) {
        this.m_defaultCollectorParam = param;
    }

    @Override
    public void setOrder(int order) {
        this.m_order = order;
    }

    protected void checkParams() {
        if (this.m_defaultCollectorName == null || this.m_defaultCollectorParam == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_COLLECTOR_DEFAULTS_INVALID_2", this.m_defaultCollectorName, this.m_defaultCollectorParam));
        }
    }

    protected String getCreateInFolder(CmsObject cms, CmsCollectorData data) throws CmsException {
        return OpenCms.getResourceManager().getNameGenerator().getNewFileName(cms, data.getFileName(), 4);
    }

    protected String getCreateInFolder(CmsObject cms, String param) throws CmsException {
        return this.getCreateInFolder(cms, new CmsCollectorData(param));
    }

    protected List<CmsResource> shrinkToFit(List<CmsResource> result, int maxSize) {
        if (maxSize > 0 && result.size() > maxSize) {
            result = result.subList(0, maxSize);
        }
        return result;
    }

    protected List<CmsResource> shrinkToFit(List<CmsResource> result, int maxSize, int explicitNumResults) {
        return this.shrinkToFit(result, explicitNumResults > 0 ? explicitNumResults : maxSize);
    }
}

