/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.history;

import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.main.CmsException;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsUUID;

public class CmsHistoryProject
extends CmsProject {
    private long m_datePublished;
    private List<String> m_projectResources;
    private int m_publishTag;
    private CmsUUID m_userPublished;

    public CmsHistoryProject(int publishTag, CmsUUID projectId, String name, String description, CmsUUID ownerId, CmsUUID groupId, CmsUUID managerGroupId, long dateCreated, CmsProject.CmsProjectType type, long datePublished, CmsUUID userPublished, List<String> projectResources) {
        super(projectId, name, description, ownerId, groupId, managerGroupId, 0, dateCreated, type);
        this.m_publishTag = publishTag;
        this.m_datePublished = datePublished;
        this.m_userPublished = userPublished;
        this.m_projectResources = projectResources;
    }

    @Override
    public Object clone() {
        return new CmsHistoryProject(this.m_publishTag, this.getUuid(), this.getName(), this.getDescription(), this.getOwnerId(), this.getGroupId(), this.getManagerGroupId(), this.getDateCreated(), this.getType(), this.m_datePublished, this.m_userPublished, this.m_projectResources);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsHistoryProject) {
            return ((CmsHistoryProject)obj).getUuid().equals(this.getUuid());
        }
        return false;
    }

    public String getGroupManagersName(CmsObject cms) {
        try {
            return CmsPrincipal.readPrincipalIncludingHistory(cms, this.getManagerGroupId()).getName();
        }
        catch (CmsException e) {
            return this.getManagerGroupId().toString();
        }
    }

    public String getGroupUsersName(CmsObject cms) {
        try {
            return CmsPrincipal.readPrincipalIncludingHistory(cms, this.getGroupId()).getName();
        }
        catch (CmsException e) {
            return this.getGroupId().toString();
        }
    }

    public String getOwnerName(CmsObject cms) {
        try {
            return CmsPrincipal.readPrincipalIncludingHistory(cms, this.getOwnerId()).getName();
        }
        catch (CmsException e) {
            return this.getOwnerId().toString();
        }
    }

    public List<String> getProjectResources() {
        return this.m_projectResources;
    }

    public CmsUUID getPublishedBy() {
        return this.m_userPublished;
    }

    public String getPublishedByName(CmsObject cms) {
        try {
            return CmsPrincipal.readPrincipalIncludingHistory(cms, this.getPublishedBy()).getName();
        }
        catch (CmsException e) {
            return this.getPublishedBy().toString();
        }
    }

    public long getPublishingDate() {
        return this.m_datePublished;
    }

    public int getPublishTag() {
        return this.m_publishTag;
    }

    @Override
    public int hashCode() {
        return Long.valueOf(this.m_datePublished).hashCode();
    }

    public void setProjectResources(List<String> projectResources) {
        this.m_projectResources = projectResources;
    }
}

