/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.wrapper;

import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.wrapper.A_CmsResourceWrapper;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;

public class CmsResourceWrapperReplaceDeleted
extends A_CmsResourceWrapper {
    @Override
    public CmsResource createResource(CmsObject cms, String resourcename, int type, byte[] content, List<CmsProperty> properties) throws CmsException, CmsIllegalArgumentException {
        try {
            CmsResource resource = cms.readResource(resourcename, CmsResourceFilter.ALL);
            if (!resource.getState().isDeleted()) {
                return null;
            }
            CmsLock lock = cms.getLock(resource);
            if (lock.isUnlocked()) {
                cms.lockResourceTemporary(resourcename);
            }
            cms.undeleteResource(resourcename, false);
            cms.replaceResource(resourcename, type, content, properties);
            CmsResource result = cms.readResource(resourcename);
            return result;
        }
        catch (CmsVfsResourceNotFoundException e) {
            return null;
        }
    }

    @Override
    public boolean isWrappedResource(CmsObject cms, CmsResource res) {
        return false;
    }
}

