/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opencms.gwt.shared.CmsClientVariantInfo;
import org.opencms.util.CmsDefaultSet;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsTemplateContextInfo
implements IsSerializable {
    public static final String DUMMY_ELEMENT_MARKER = "cmsTemplateContextDummyMarker";
    public static final String EMPTY_VALUE = "none";
    public static final String SETTING = "templateContexts";
    private Map<String, CmsDefaultSet<String>> m_allowedContextMap;
    private Map<String, Map<String, CmsClientVariantInfo>> m_clientVariantInfo = new LinkedHashMap<String, Map<String, CmsClientVariantInfo>>();
    private Map<String, String> m_contextLabels = new LinkedHashMap<String, String>();
    private String m_contextProvider;
    private String m_defaultLabel;
    private String m_cookieName;
    private String m_currentContext;
    private String m_menuLabel;
    private String m_selectedContext;
    private CmsXmlContentProperty m_settingDefinition;
    private boolean m_shouldShowElementTemplateContextSelection;

    public Map<String, CmsDefaultSet<String>> getAllowedContexts() {
        return this.m_allowedContextMap;
    }

    public Map<String, CmsClientVariantInfo> getClientVariants(String context) {
        return this.m_clientVariantInfo.get(context);
    }

    public Map<String, String> getContextLabels() {
        return this.m_contextLabels;
    }

    public String getContextProvider() {
        return this.m_contextProvider;
    }

    public String getCookieName() {
        return this.m_cookieName;
    }

    public String getCurrentContext() {
        return this.m_currentContext;
    }

    public String getDefaultLabel() {
        return this.m_defaultLabel;
    }

    public String getMenuLabel() {
        return this.m_menuLabel;
    }

    public String getSelectedContext() {
        return this.m_selectedContext;
    }

    public CmsXmlContentProperty getSettingDefinition() {
        return this.m_settingDefinition;
    }

    public boolean hasClientVariants(String context) {
        return this.m_clientVariantInfo.containsKey(context);
    }

    public void setAllowedContexts(Map<String, CmsDefaultSet<String>> allowedContextMap) {
        this.m_allowedContextMap = allowedContextMap;
    }

    public void setClientVariant(String context, String variant, CmsClientVariantInfo info) {
        if (!this.m_clientVariantInfo.containsKey(context)) {
            LinkedHashMap variants = new LinkedHashMap();
            this.m_clientVariantInfo.put(context, variants);
        }
        this.m_clientVariantInfo.get(context).put(variant, info);
    }

    public void setContextLabels(Map<String, String> contextLabels) {
        this.m_contextLabels = contextLabels;
    }

    public void setContextProvider(String contextProvider) {
        this.m_contextProvider = contextProvider;
    }

    public void setCookieName(String cookieName) {
        this.m_cookieName = cookieName;
    }

    public void setCurrentContext(String context) {
        this.m_currentContext = context;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.m_defaultLabel = defaultLabel;
    }

    public void setMenuLabel(String label) {
        this.m_menuLabel = label;
    }

    public void setSelectedContext(String selectedContext) {
        this.m_selectedContext = selectedContext;
    }

    public void setSettingDefinition(CmsXmlContentProperty definition) {
        this.m_settingDefinition = definition;
    }

    public void setShouldShowElementTemplateContextSelection(boolean newValue) {
        this.m_shouldShowElementTemplateContextSelection = newValue;
    }

    public boolean shouldShowElementTemplateContextSelection() {
        return this.m_shouldShowElementTemplateContextSelection && this.hasMoreThanOneOption();
    }

    public boolean shouldShowTemplateContextContextMenuEntry() {
        return this.hasMoreThanOneOption();
    }

    private boolean hasMoreThanOneOption() {
        return this.m_currentContext != null;
    }
}

