/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsResourceBundleLoader;
import org.opencms.i18n.CmsVfsBundleManager;
import org.opencms.i18n.CmsVfsBundleParameters;
import org.opencms.i18n.CmsVfsResourceBundle;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public class CmsMessageToBundleIndex {
    private static final Log LOG = CmsLog.getLog(CmsMessageToBundleIndex.class);
    private Multimap<String, CmsVfsBundleParameters> m_map = HashMultimap.create();

    public CmsMessageToBundleIndex(Collection<String> bundleNames, Locale locale) {
        for (String bundleName : bundleNames) {
            try {
                ResourceBundle bundle = CmsResourceBundleLoader.getBundle(bundleName, locale);
                if (!(bundle instanceof CmsVfsResourceBundle)) continue;
                CmsVfsResourceBundle vfsBundle = (CmsVfsResourceBundle)bundle;
                CmsVfsBundleParameters parameters = vfsBundle.getParameters();
                for (String key : bundle.keySet()) {
                    this.m_map.put((Object)key, (Object)parameters);
                }
            }
            catch (MissingResourceException e) {
                LOG.debug((Object)("missing resource for " + bundleName + ":" + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static CmsMessageToBundleIndex read(CmsObject cms) throws CmsException {
        cms = OpenCms.initCmsObject(cms);
        cms.getRequestContext().setSiteRoot("");
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        for (String typeName : Arrays.asList("xmlvfsbundle", "propertyvfsbundle")) {
            try {
                I_CmsResourceType xmlType = OpenCms.getResourceManager().getResourceType(typeName);
                resources.addAll(cms.readResources("/", CmsResourceFilter.ALL.addRequireType(xmlType), true));
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        Set<String> bundleNames = resources.stream().map(res -> CmsVfsBundleManager.getNameAndLocale(res).getName()).collect(Collectors.toSet());
        CmsMessageToBundleIndex result = new CmsMessageToBundleIndex(bundleNames, cms.getRequestContext().getLocale());
        return result;
    }

    public Collection<String> getBundlesPathForKey(String key) {
        Collection params = this.m_map.get((Object)key);
        return params.stream().map(CmsVfsBundleParameters::getBasePath).collect(Collectors.toSet());
    }
}

