/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.I_CmsMessageBundle;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportHelper;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.I_CmsImport;
import org.opencms.importexport.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlUtils;

@Deprecated
public abstract class A_CmsImport
implements I_CmsImport {
    public static final String A_NAME = "name";
    public static final String A_TYPE = "type";
    public static final String N_ACCESS = "access";
    public static final String N_ACCESSCONTROL_ALLOWEDPERMISSIONS = "allowed";
    public static final String N_ACCESSCONTROL_DENIEDPERMISSIONS = "denied";
    public static final String N_ACCESSCONTROL_ENTRIES = "accesscontrol";
    public static final String N_ACCESSCONTROL_ENTRY = "accessentry";
    public static final String N_ACCESSCONTROL_PERMISSIONSET = "permissionset";
    public static final String N_ACCESSCONTROL_PRINCIPAL = "uuidprincipal";
    public static final String N_DATECREATED = "datecreated";
    public static final String N_DATEEXPIRED = "dateexpired";
    public static final String N_DATELASTMODIFIED = "datelastmodified";
    public static final String N_DATERELEASED = "datereleased";
    public static final String N_DEFAULTGROUP = "defaultgroup";
    public static final String N_DESCRIPTION = "description";
    public static final String N_DESTINATION = "destination";
    public static final String N_EMAIL = "email";
    public static final String N_FILE = "file";
    public static final String N_FIRSTNAME = "firstname";
    public static final String N_FLAGS = "flags";
    public static final String N_GROUPDATA = "groupdata";
    public static final String N_GROUPNAME = "groupname";
    public static final String N_ID = "id";
    public static final String N_LASTMODIFIED = "lastmodified";
    public static final String N_LASTNAME = "lastname";
    public static final String N_NAME = "name";
    public static final String N_ORGUNITDATA = "orgunitdata";
    public static final String N_PARENTGROUP = "parentgroup";
    public static final String N_PASSWORD = "password";
    public static final String N_PROPERTIES = "properties";
    public static final String N_PROPERTY = "property";
    public static final String N_PROPERTY_ATTRIB_TYPE = "type";
    public static final String N_PROPERTY_ATTRIB_TYPE_SHARED = "shared";
    public static final String N_RELATION = "relation";
    public static final String N_RELATION_ATTRIBUTE_ID = "id";
    public static final String N_RELATION_ATTRIBUTE_PATH = "path";
    public static final String N_RELATION_ATTRIBUTE_TYPE = "type";
    public static final String N_RELATIONS = "relations";
    public static final String N_SOURCE = "source";
    public static final String N_TAG_ADDRESS = "address";
    public static final String N_TYPE = "type";
    public static final String N_USER = "user";
    public static final String N_USERCREATED = "usercreated";
    public static final String N_USERDATA = "userdata";
    public static final String N_USERGROUPDATA = "usergroupdata";
    public static final String N_USERGROUPS = "usergroups";
    public static final String N_USERINFO = "userinfo";
    public static final String N_USERINFO_ENTRY = "entry";
    public static final String N_USERLASTMODIFIED = "userlastmodified";
    public static final String N_UUIDRESOURCE = "uuidresource";
    public static final String N_UUIDSTRUCTURE = "uuidstructure";
    public static final String N_VALUE = "value";
    public static final String RESOURCE_TYPE_LEGACY_PAGE_NAME = "page";
    protected static final int RESOURCE_TYPE_LINK_ID = 1024;
    protected static final String RESOURCE_TYPE_LINK_NAME = "link";
    protected static final int RESOURCE_TYPE_NEWPAGE_ID = 9;
    protected static final String RESOURCE_TYPE_NEWPAGE_NAME = "newpage";
    private static final Log LOG = CmsLog.getLog(A_CmsImport.class);
    protected CmsObject m_cms;
    protected boolean m_convertToXmlPage;
    protected Document m_docXml;
    protected Stack<Map<String, String>> m_groupsToCreate;
    protected String m_importPath;
    protected File m_importResource;
    protected ZipFile m_importZip;
    protected Map<String, List<CmsProperty>> m_linkPropertyStorage;
    protected Map<String, String> m_linkStorage;
    protected I_CmsReport m_report;
    protected I_CmsMessageBundle m_userMessages;

    public String convertDigestEncoding(String value) {
        byte[] data = new byte[value.length() / 2];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(Integer.parseInt(value.substring(i * 2, i * 2 + 2), 16) - 128);
        }
        return new String(Base64.encodeBase64((byte[])data));
    }

    public String getChildElementTextValue(Element parentElement, String elementName) {
        try {
            Element childElement = (Element)parentElement.selectNodes("./" + elementName).get(0);
            return childElement.getTextTrim();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matches(CmsImportParameters parameters) throws CmsImportExportException {
        CmsImportHelper helper = new CmsImportHelper(parameters);
        try {
            helper.openFile();
            Document docXml = CmsXmlUtils.unmarshalHelper(helper.getFileBytes("manifest.xml"), null, false);
            boolean bl = this.getVersion() == Integer.parseInt(((Element)docXml.selectNodes("//export_version").get(0)).getTextTrim());
            return bl;
        }
        catch (IOException e) {
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_OPENING_ZIP_ARCHIVE_1", parameters.getPath());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        finally {
            helper.closeFile();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkImmutable(String translatedName, List<String> immutableResources) {
        boolean resourceNotImmutable = true;
        if (immutableResources.contains(translatedName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_RESOURCENAME_IMMUTABLE_1", translatedName));
            }
            String storedSiteRoot = this.m_cms.getRequestContext().getSiteRoot();
            try {
                this.m_cms.getRequestContext().setSiteRoot("/");
                this.m_cms.readResource(translatedName);
                resourceNotImmutable = false;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_IMMUTABLE_FLAG_SET_1", translatedName));
                }
            }
            catch (CmsException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ERROR_ON_TEST_IMMUTABLE_1", translatedName), (Throwable)e);
                }
            }
            finally {
                this.m_cms.getRequestContext().setSiteRoot(storedSiteRoot);
            }
        }
        return resourceNotImmutable;
    }

    protected void cleanUp() {
        this.m_importResource = null;
        this.m_importZip = null;
        this.m_report = null;
        this.m_linkStorage = null;
        this.m_linkPropertyStorage = null;
        this.m_groupsToCreate = null;
        this.m_cms = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertPointerToSiblings() {
        try {
            int linksSize = this.m_linkStorage.size();
            int i = 0;
            for (Map.Entry<String, String> entry : this.m_linkStorage.entrySet()) {
                String key = entry.getKey();
                String link = entry.getValue();
                List<CmsProperty> properties = this.m_linkPropertyStorage.get(key);
                CmsProperty.setAutoCreatePropertyDefinitions(properties, true);
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(++i), String.valueOf(linksSize)), 3);
                this.m_report.print(Messages.get().container("RPT_CONVERT_LINK_0"), 3);
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", key + " "));
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                try {
                    if (link.startsWith("/")) {
                        CmsResource target = this.m_cms.readResource(link);
                        CmsResource resource = new CmsResource(new CmsUUID(), target.getResourceId(), key, target.getTypeId(), target.isFolder(), 0, this.m_cms.getRequestContext().getCurrentProject().getUuid(), CmsResource.STATE_NEW, target.getDateCreated(), target.getUserCreated(), target.getDateLastModified(), target.getUserLastModified(), 0L, Long.MAX_VALUE, 1, 0, target.getDateContent(), 0);
                        this.m_cms.importResource(key, resource, null, properties);
                        this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                        if (!LOG.isInfoEnabled()) continue;
                        LOG.info((Object)Messages.get().getBundle().key("LOG_CONVERT_LINK_DOTS_OK_3", String.valueOf(i), String.valueOf(linksSize), key));
                        continue;
                    }
                    int pointerId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePointer.getStaticTypeName()).getTypeId();
                    this.m_cms.createResource(key, pointerId, link.getBytes(), properties);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)Messages.get().getBundle().key("LOG_CONVERT_LINK_OK_3", String.valueOf(i), String.valueOf(linksSize), key));
                }
                catch (CmsException e) {
                    this.m_report.println();
                    this.m_report.print(Messages.get().container("RPT_CONVERT_LINK_NOTFOUND_1", link), 1);
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)Messages.get().getBundle().key("ERR_IMPORTEXPORT_LINK_CONVERSION_FAILED_2", key, link), (Throwable)e);
                }
            }
        }
        finally {
            if (this.m_linkStorage != null) {
                this.m_linkStorage.clear();
            }
            this.m_linkStorage = null;
            if (this.m_linkPropertyStorage != null) {
                this.m_linkPropertyStorage.clear();
            }
            this.m_linkPropertyStorage = null;
        }
    }

    protected byte[] getFileBytes(String filename) {
        try {
            if (this.m_importZip != null) {
                ZipEntry entry = this.m_importZip.getEntry(filename);
                if (entry == null && filename.startsWith("/")) {
                    entry = this.m_importZip.getEntry(filename.substring(1));
                }
                if (entry == null) {
                    throw new ZipException(Messages.get().getBundle().key("LOG_IMPORTEXPORT_FILE_NOT_FOUND_IN_ZIP_1", filename));
                }
                InputStream stream = this.m_importZip.getInputStream(entry);
                int size = Long.valueOf(entry.getSize()).intValue();
                return CmsFileUtil.readFully(stream, size);
            }
            File file = new File(this.m_importResource, filename);
            return CmsFileUtil.readFile(file);
        }
        catch (FileNotFoundException fnfe) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_IMPORTEXPORT_FILE_NOT_FOUND_1", filename), (Throwable)fnfe);
            }
            this.m_report.println(fnfe);
        }
        catch (IOException ioe) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_IMPORTEXPORT_ERROR_READING_FILE_1", filename), (Throwable)ioe);
            }
            this.m_report.println(ioe);
        }
        return "".getBytes();
    }

    protected CmsAccessControlEntry getImportAccessControlEntry(CmsResource res, String id, String allowed, String denied, String flags) {
        return new CmsAccessControlEntry(res.getResourceId(), new CmsUUID(id), Integer.parseInt(allowed), Integer.parseInt(denied), Integer.parseInt(flags));
    }

    protected Locale getLocale(String destination, List<CmsProperty> properties) {
        String localeName = CmsProperty.get("locale", properties).getValue();
        if (localeName != null) {
            return OpenCms.getLocaleManager().getAvailableLocales(localeName).get(0);
        }
        return OpenCms.getLocaleManager().getDefaultLocales(this.m_cms, CmsResource.getParentFolder(destination)).get(0);
    }

    protected void importAccessControlEntries(CmsResource resource, List<CmsAccessControlEntry> aceList) {
        if (aceList.size() == 0) {
            return;
        }
        try {
            this.m_cms.importAccessControlEntries(resource, aceList);
        }
        catch (CmsException exc) {
            this.m_report.println(Messages.get().container("RPT_IMPORT_ACL_DATA_FAILED_0"), 1);
        }
    }

    protected void importGroup(String name, String description, String flags, String parentgroupName) throws CmsImportExportException {
        if (description == null) {
            description = "";
        }
        CmsGroup parentGroup = null;
        try {
            if (CmsStringUtil.isNotEmpty(parentgroupName)) {
                try {
                    parentGroup = this.m_cms.readGroup(parentgroupName);
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
            }
            if (CmsStringUtil.isNotEmpty(parentgroupName) && parentGroup == null) {
                HashMap<String, String> groupData = new HashMap<String, String>();
                groupData.put("name", name);
                groupData.put(N_DESCRIPTION, description);
                groupData.put(N_FLAGS, flags);
                groupData.put(N_PARENTGROUP, parentgroupName);
                this.m_groupsToCreate.push(groupData);
            } else {
                try {
                    this.m_report.print(Messages.get().container("RPT_IMPORT_GROUP_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", name));
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    this.m_cms.createGroup(name, description, Integer.parseInt(flags), parentgroupName);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                }
                catch (CmsException exc) {
                    this.m_report.println(Messages.get().container("RPT_NOT_CREATED_0"), 4);
                }
            }
        }
        catch (Exception e) {
            this.m_report.println(e);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_GROUP_1", name);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
    }

    protected void importGroups() throws CmsImportExportException {
        try {
            String parentgroup;
            String flags;
            String description;
            String name;
            List groupNodes = this.m_docXml.selectNodes("//groupdata");
            for (int i = 0; i < groupNodes.size(); ++i) {
                Element currentElement = (Element)groupNodes.get(i);
                name = this.getChildElementTextValue(currentElement, "name");
                name = OpenCms.getImportExportManager().translateGroup(name);
                description = this.getChildElementTextValue(currentElement, N_DESCRIPTION);
                flags = this.getChildElementTextValue(currentElement, N_FLAGS);
                parentgroup = this.getChildElementTextValue(currentElement, N_PARENTGROUP);
                if (parentgroup != null && parentgroup.length() > 0) {
                    parentgroup = OpenCms.getImportExportManager().translateGroup(parentgroup);
                }
                this.importGroup(name, description, flags, parentgroup);
            }
            while (!this.m_groupsToCreate.empty()) {
                Stack<Map<String, String>> tempStack = this.m_groupsToCreate;
                this.m_groupsToCreate = new Stack();
                while (tempStack.size() > 0) {
                    Map<String, String> groupdata = tempStack.pop();
                    name = groupdata.get("name");
                    description = groupdata.get(N_DESCRIPTION);
                    flags = groupdata.get(N_FLAGS);
                    parentgroup = groupdata.get(N_PARENTGROUP);
                    this.importGroup(name, description, flags, parentgroup);
                }
            }
        }
        catch (CmsImportExportException e) {
            throw e;
        }
        catch (Exception e) {
            this.m_report.println(e);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_GROUPS_0");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
    }

    protected void importUser(String name, String flags, String password, String firstname, String lastname, String email, long dateCreated, Map<String, Object> userInfo, List<String> userGroups) throws CmsImportExportException {
        String id = new CmsUUID().toString();
        try {
            try {
                this.m_report.print(Messages.get().container("RPT_IMPORT_USER_0"), 3);
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", name));
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                this.m_cms.importUser(id, name, password, firstname, lastname, email, Integer.parseInt(flags), dateCreated, userInfo);
                for (int i = 0; i < userGroups.size(); ++i) {
                    String groupName = userGroups.get(i);
                    try {
                        CmsGroup group = this.m_cms.readGroup(groupName);
                        if (group.isVirtual() || group.isRole()) {
                            CmsRole role = CmsRole.valueOf(group);
                            OpenCms.getRoleManager().addUserToRole(this.m_cms, role, name);
                            continue;
                        }
                        this.m_cms.addUserToGroup(name, groupName);
                        continue;
                    }
                    catch (CmsException exc) {
                        this.m_report.println(Messages.get().container("RPT_USER_COULDNT_BE_ADDED_TO_GROUP_2", name, groupName), 1);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)exc.getLocalizedMessage(), (Throwable)exc);
                    }
                }
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            }
            catch (CmsException exc) {
                this.m_report.println(Messages.get().container("RPT_NOT_CREATED_0"), 4);
            }
        }
        catch (Exception e) {
            this.m_report.println(e);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_USER_1", name);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
    }

    protected void importUsers() throws CmsImportExportException {
        Map<String, Object> userInfo = null;
        try {
            List userNodes = this.m_docXml.selectNodes("//userdata");
            for (int i = 0; i < userNodes.size(); ++i) {
                Element currentElement = (Element)userNodes.get(i);
                String name = this.getChildElementTextValue(currentElement, "name");
                name = OpenCms.getImportExportManager().translateUser(name);
                String pwd = this.getChildElementTextValue(currentElement, N_PASSWORD);
                String password = new String(Base64.decodeBase64((byte[])pwd.trim().getBytes()));
                String description = this.getChildElementTextValue(currentElement, N_DESCRIPTION);
                String flags = this.getChildElementTextValue(currentElement, N_FLAGS);
                String firstname = this.getChildElementTextValue(currentElement, N_FIRSTNAME);
                String lastname = this.getChildElementTextValue(currentElement, N_LASTNAME);
                String email = this.getChildElementTextValue(currentElement, N_EMAIL);
                String address = this.getChildElementTextValue(currentElement, N_TAG_ADDRESS);
                String defaultGroup = this.getChildElementTextValue(currentElement, N_DEFAULTGROUP);
                String infoNode = this.getChildElementTextValue(currentElement, N_USERINFO);
                try {
                    byte[] value = this.getFileBytes(infoNode);
                    ByteArrayInputStream bin = new ByteArrayInputStream(value);
                    ObjectInputStream oin = new ObjectInputStream(bin);
                    userInfo = (Map)oin.readObject();
                }
                catch (IOException ioex) {
                    this.m_report.println(ioex);
                }
                catch (ClassCastException ccex) {
                    this.m_report.println(ccex);
                }
                catch (ClassNotFoundException cnfex) {
                    this.m_report.println(cnfex);
                }
                if (userInfo == null) {
                    userInfo = new HashMap();
                }
                List groupNodes = currentElement.selectNodes("*/groupname");
                ArrayList<String> userGroups = new ArrayList<String>();
                for (int j = 0; j < groupNodes.size(); ++j) {
                    Element currentGroup = (Element)groupNodes.get(j);
                    String userInGroup = this.getChildElementTextValue(currentGroup, "name");
                    userInGroup = OpenCms.getImportExportManager().translateGroup(userInGroup);
                    userGroups.add(userInGroup);
                }
                if (CmsStringUtil.isNotEmpty(defaultGroup)) {
                    userInfo.put("USER_DEFAULTGROUP", defaultGroup);
                }
                if (description != null) {
                    userInfo.put("USER_DESCRIPTION", description);
                }
                if (address != null) {
                    userInfo.put("USER_ADDRESS", address);
                }
                this.importUser(name, flags, password, firstname, lastname, email, 0L, userInfo, userGroups);
            }
        }
        catch (CmsImportExportException e) {
            throw e;
        }
        catch (Exception e) {
            this.m_report.println(e);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_USERS_0");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
    }

    protected void initialize() {
        this.m_groupsToCreate = new Stack();
    }

    protected List<CmsProperty> readPropertiesFromManifest(Element parentElement, List<String> ignoredPropertyKeys) {
        HashMap<String, CmsProperty> properties = new HashMap<String, CmsProperty>();
        CmsProperty property = null;
        List propertyElements = parentElement.selectNodes("./properties/property");
        Element propertyElement = null;
        String key = null;
        String value = null;
        Attribute attrib = null;
        int n = propertyElements.size();
        for (int i = 0; i < n; ++i) {
            propertyElement = (Element)propertyElements.get(i);
            key = this.getChildElementTextValue(propertyElement, "name");
            if (key == null || ignoredPropertyKeys.contains(key)) continue;
            property = (CmsProperty)properties.get(key);
            if (property == null) {
                property = new CmsProperty();
                property.setName(key);
                property.setAutoCreatePropertyDefinition(true);
                properties.put(key, property);
            }
            if ((value = this.getChildElementTextValue(propertyElement, N_VALUE)) == null) {
                value = "";
            }
            if ((attrib = propertyElement.attribute("type")) != null && attrib.getValue().equals(N_PROPERTY_ATTRIB_TYPE_SHARED)) {
                property.setResourceValue(value);
                continue;
            }
            property.setStructureValue(value);
        }
        return new ArrayList<CmsProperty>(properties.values());
    }
}

