/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;

public class CmsJspNavBuilder {
    public static final String NAVIGATION_LEVEL_FOLDER = "##navigation_level_folder##";
    private static final Log LOG = CmsLog.getLog(CmsJspNavBuilder.class);
    protected CmsObject m_cms;
    protected Locale m_locale;
    protected String m_requestUri;
    protected String m_requestUriFolder;

    public CmsJspNavBuilder() {
    }

    public CmsJspNavBuilder(CmsObject cms) {
        this.init(cms, null);
    }

    public CmsJspNavBuilder(CmsObject cms, Locale locale) {
        this.init(cms, locale);
    }

    @Deprecated
    public static String getDefaultFile(CmsObject cms, String folder) {
        if (folder.endsWith("/")) {
            try {
                CmsResource defaultFile = cms.readDefaultFile(folder);
                if (defaultFile != null) {
                    return cms.getSitePath(defaultFile);
                }
            }
            catch (CmsException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return folder;
        }
        return null;
    }

    @Deprecated
    public static List<CmsJspNavElement> getNavigationForFolder(CmsObject cms, String folder) {
        return new CmsJspNavBuilder(cms).getNavigationForFolder(folder);
    }

    @Deprecated
    public static List<CmsJspNavElement> getNavigationForFolder(CmsObject cms, String folder, int level) {
        return new CmsJspNavBuilder(cms).getNavigationForFolder(folder, level);
    }

    @Deprecated
    public static CmsJspNavElement getNavigationForResource(CmsObject cms, String resource) {
        return new CmsJspNavBuilder(cms).getNavigationForResource(resource);
    }

    @Deprecated
    public static List<CmsJspNavElement> getNavigationTreeForFolder(CmsObject cms, String folder, int startlevel, int endlevel) {
        return new CmsJspNavBuilder(cms).getNavigationTreeForFolder(folder, startlevel, endlevel);
    }

    @Deprecated
    public static List<CmsJspNavElement> getSiteNavigation(CmsObject cms, String folder, int endLevel) {
        return new CmsJspNavBuilder(cms).getSiteNavigation(folder, endLevel);
    }

    public static boolean isNavLevelFolder(CmsObject cms, CmsResource resource) {
        I_CmsResourceType type;
        if (resource.isFolder() && "folder".equals((type = OpenCms.getResourceManager().getResourceType(resource)).getTypeName())) {
            try {
                CmsProperty prop = cms.readPropertyObject(resource, "default-file", false);
                return !prop.isNullProperty() && NAVIGATION_LEVEL_FOLDER.equals(prop.getValue());
            }
            catch (CmsException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public List<CmsJspNavElement> getNavigationBreadCrumb() {
        return this.getNavigationBreadCrumb(this.m_requestUriFolder, 0, -1, true);
    }

    public List<CmsJspNavElement> getNavigationBreadCrumb(int startlevel, boolean currentFolder) {
        return this.getNavigationBreadCrumb(this.m_requestUriFolder, startlevel, -1, currentFolder);
    }

    public List<CmsJspNavElement> getNavigationBreadCrumb(int startlevel, int endlevel) {
        return this.getNavigationBreadCrumb(this.m_requestUriFolder, startlevel, endlevel, true);
    }

    public List<CmsJspNavElement> getNavigationBreadCrumb(String folder, int startlevel, int endlevel, boolean currentFolder) {
        ArrayList<CmsJspNavElement> result = new ArrayList<CmsJspNavElement>();
        int level = CmsResource.getPathLevel(folder);
        if (!currentFolder) {
            --level;
        }
        if (level < endlevel || endlevel == -1) {
            endlevel = level;
        }
        if (startlevel < 0 && (startlevel = endlevel + startlevel + 1) < 0) {
            startlevel = 0;
        }
        for (int i = startlevel; i <= endlevel; ++i) {
            String navFolder = CmsResource.getPathPart(folder, i);
            CmsJspNavElement e = this.getNavigationForResource(navFolder);
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    public List<CmsJspNavElement> getNavigationForFolder() {
        return this.getNavigationForFolder(this.m_requestUriFolder);
    }

    public List<CmsJspNavElement> getNavigationForFolder(int level) {
        return this.getNavigationForFolder(this.m_requestUriFolder, level);
    }

    public List<CmsJspNavElement> getNavigationForFolder(String folder) {
        return this.getNavigationForFolder(folder, Visibility.navigation, CmsResourceFilter.DEFAULT);
    }

    public List<CmsJspNavElement> getNavigationForFolder(String folder, int level) {
        folder = CmsResource.getFolderPath(folder);
        if (level == 0) {
            return this.getNavigationForFolder("/");
        }
        String navfolder = CmsResource.getPathPart(folder, level);
        if (navfolder != null) {
            return this.getNavigationForFolder(navfolder);
        }
        return Collections.emptyList();
    }

    public List<CmsJspNavElement> getNavigationForFolder(String folder, Visibility visibility, CmsResourceFilter resourceFilter) {
        folder = CmsFileUtil.removeTrailingSeparator(folder);
        ArrayList<CmsJspNavElement> result = new ArrayList<CmsJspNavElement>();
        List<CmsResource> resources = null;
        try {
            resources = this.m_cms.getResourcesInFolder(folder, resourceFilter);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (resources == null) {
            return Collections.emptyList();
        }
        boolean includeAll = visibility == Visibility.all;
        boolean includeHidden = visibility == Visibility.includeHidden;
        for (CmsResource r : resources) {
            CmsJspNavElement element = this.getNavigationForResource(this.m_cms.getSitePath(r), resourceFilter);
            if (element == null || !includeAll && (!element.isInNavigation() || !includeHidden && element.isHiddenNavigationEntry())) continue;
            element.setNavContext(new NavContext(this, visibility, resourceFilter));
            result.add(element);
        }
        Collections.sort(result);
        return result;
    }

    public CmsJspNavElement getNavigationForResource() {
        return this.getNavigationForResource(this.m_requestUri);
    }

    public CmsJspNavElement getNavigationForResource(String sitePath) {
        CmsJspNavElement result = this.getNavigationForResource(sitePath, CmsResourceFilter.DEFAULT, false);
        if (result != null && result.getNavContext() == null) {
            result.setNavContext(new NavContext(this, Visibility.navigation, CmsResourceFilter.DEFAULT));
        }
        return result;
    }

    public CmsJspNavElement getNavigationForResource(String sitePath, CmsResourceFilter reourceFilter) {
        return this.getNavigationForResource(sitePath, reourceFilter, false);
    }

    public List<CmsJspNavElement> getNavigationTreeForFolder(int startlevel, int endlevel) {
        return this.getNavigationTreeForFolder(this.m_requestUriFolder, startlevel, endlevel);
    }

    public List<CmsJspNavElement> getNavigationTreeForFolder(String folder, int startlevel, int endlevel) {
        folder = CmsResource.getFolderPath(folder);
        if (endlevel < startlevel) {
            return Collections.emptyList();
        }
        int currentlevel = CmsResource.getPathLevel(folder);
        if (currentlevel < endlevel) {
            endlevel = currentlevel;
        }
        if (startlevel == endlevel) {
            return this.getNavigationForFolder(CmsResource.getPathPart(folder, startlevel), startlevel);
        }
        ArrayList<CmsJspNavElement> result = new ArrayList<CmsJspNavElement>();
        float parentcount = 0.0f;
        for (int i = startlevel; i <= endlevel; ++i) {
            String currentfolder = CmsResource.getPathPart(folder, i);
            List<CmsJspNavElement> entries = this.getNavigationForFolder(currentfolder);
            if (parentcount > 0.0f) {
                for (CmsJspNavElement e : entries) {
                    e.setNavPosition(e.getNavPosition() + parentcount);
                }
            }
            result.addAll(entries);
            Collections.sort(result);
            float pos = 0.0f;
            int count = 0;
            String nextfolder = CmsResource.getPathPart(folder, i + 1);
            parentcount = 0.0f;
            for (CmsJspNavElement e : result) {
                pos = 10000 * ++count;
                e.setNavPosition(pos);
                if (!e.getResourceName().startsWith(nextfolder)) continue;
                parentcount = pos;
            }
            if (parentcount != 0.0f) continue;
            parentcount = pos;
        }
        return result;
    }

    public List<CmsJspNavElement> getSiteNavigation() {
        return this.getSiteNavigation("/", Visibility.navigation, -1);
    }

    public List<CmsJspNavElement> getSiteNavigation(String folder, int endLevel) {
        return this.getSiteNavigation(folder, Visibility.navigation, endLevel);
    }

    public List<CmsJspNavElement> getSiteNavigation(String folder, Visibility visibility, int endLevel) {
        folder = CmsFileUtil.addTrailingSeparator(folder);
        boolean noLimit = false;
        if (endLevel < 0) {
            noLimit = true;
        }
        ArrayList<CmsJspNavElement> list = new ArrayList<CmsJspNavElement>();
        List<CmsJspNavElement> curnav = this.getNavigationForFolder(folder, visibility, CmsResourceFilter.DEFAULT);
        for (CmsJspNavElement ne : curnav) {
            list.add(ne);
            if (!ne.isFolderLink() && !ne.isNavigationLevel() || !noLimit && ne.getNavTreeLevel() >= endLevel) continue;
            List<CmsJspNavElement> subnav = this.getSiteNavigation(this.m_cms.getSitePath(ne.getResource()), visibility, endLevel);
            list.addAll(subnav);
        }
        return list;
    }

    public void init(CmsObject cms) {
        this.init(cms, null, cms.getRequestContext().getUri());
    }

    public void init(CmsObject cms, Locale locale) {
        this.init(cms, locale, cms.getRequestContext().getUri());
    }

    public void init(CmsObject cms, Locale locale, String requestUri) {
        this.m_cms = cms;
        this.m_locale = locale;
        this.m_requestUri = requestUri;
        this.m_requestUriFolder = CmsResource.getFolderPath(this.m_requestUri);
    }

    private List<CmsJspNavElement> getNavigationForFolder(String folder, boolean includeInvisible, CmsResourceFilter resourceFilter, boolean shallow) {
        List<CmsResource> resources;
        folder = CmsResource.getFolderPath(folder);
        ArrayList<CmsJspNavElement> result = new ArrayList<CmsJspNavElement>();
        try {
            resources = this.m_cms.getResourcesInFolder(folder, resourceFilter);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        for (CmsResource r : resources) {
            CmsJspNavElement element = this.getNavigationForResource(this.m_cms.getSitePath(r), resourceFilter, shallow);
            if (element == null || !includeInvisible && !element.isInNavigation()) continue;
            result.add(element);
        }
        Collections.sort(result);
        return result;
    }

    private CmsJspNavElement getNavigationForResource(String sitePath, CmsResourceFilter resourceFilter, boolean shallow) {
        Map<String, String> propertiesMap;
        CmsResource resource;
        int level;
        block9: {
            level = CmsResource.getPathLevel((String)sitePath);
            if (((String)sitePath).endsWith("/")) {
                --level;
            }
            try {
                List<CmsJspNavElement> subElements;
                resource = this.m_cms.readResource((String)sitePath, resourceFilter);
                List<CmsProperty> properties = this.m_cms.readPropertyObjects(resource, false);
                propertiesMap = CmsProperty.toMap(properties);
                if (!resource.isFolder()) break block9;
                if (resourceFilter.equals(CmsResourceFilter.DEFAULT) && !NAVIGATION_LEVEL_FOLDER.equals(propertiesMap.get("default-file"))) {
                    try {
                        CmsResource defaultFile = this.m_cms.readDefaultFile(resource, resourceFilter);
                        if (defaultFile != null && !defaultFile.isReleasedAndNotExpired(this.m_cms.getRequestContext().getRequestTime())) {
                            return null;
                        }
                    }
                    catch (CmsException defaultFile) {
                        // empty catch block
                    }
                }
                if (!((String)sitePath).endsWith("/")) {
                    sitePath = (String)sitePath + "/";
                }
                if (!shallow && NAVIGATION_LEVEL_FOLDER.equals(propertiesMap.get("default-file")) && !(subElements = this.getNavigationForFolder((String)sitePath, false, resourceFilter, true)).isEmpty()) {
                    CmsJspNavElement subElement = subElements.get(0);
                    subElement = this.getNavigationForResource(subElement.getSitePath(), resourceFilter, false);
                    sitePath = subElement.getSitePath();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }
        return new CmsJspNavElement((String)sitePath, resource, propertiesMap, level, this.m_locale);
    }

    public static enum Visibility {
        all,
        includeHidden,
        navigation;

    }

    public static class NavContext {
        private CmsResourceFilter m_filter;
        private CmsJspNavBuilder m_navBuilder;
        private Visibility m_visibility;

        public NavContext(CmsJspNavBuilder navBuilder, Visibility visibility, CmsResourceFilter filter) {
            this.m_visibility = visibility;
            this.m_filter = filter;
            this.m_navBuilder = navBuilder;
        }

        public CmsResourceFilter getFilter() {
            return this.m_filter;
        }

        public CmsJspNavBuilder getNavBuilder() {
            return this.m_navBuilder;
        }

        public Visibility getVisibility() {
            return this.m_visibility;
        }
    }
}

